/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Iterables;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCost;
import forge.ai.SpellAbilityAi;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardPredicates;
import forge.game.card.CounterEnumType;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerPredicates;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetRestrictions;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;

public class LifeSetAi
extends SpellAbilityAi {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        int amount;
        int myLife = ai.getLife();
        PlayerCollection targetableOpps = ai.getOpponents().filter(PlayerPredicates.isTargetableBy(sa));
        Player opponent = targetableOpps.max(PlayerPredicates.compareByLife());
        int hlife = opponent == null ? 0 : opponent.getLife();
        String amountStr = sa.getParam("LifeAmount");
        if (ai.getGame().getPhaseHandler().getPhase().isBefore(PhaseType.MAIN2) && !sa.hasParam("ActivationPhases")) {
            return false;
        }
        if (sa.hasParam("Redistribute")) {
            return false;
        }
        if (amountStr.equals("X") && sa.getSVar(amountStr).equals("Count$xPaid")) {
            int xPay = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
            sa.setXManaCostPaid(xPay);
            amount = xPay;
        } else {
            amount = AbilityUtils.calculateAmount(sa.getHostCard(), amountStr, sa);
        }
        boolean chance = (double)MyRandom.getRandom().nextFloat() <= Math.pow(0.6667, sa.getActivationsThisTurn());
        TargetRestrictions tgt = sa.getTargetRestrictions();
        if (tgt != null) {
            sa.resetTargets();
            if (tgt.canOnlyTgtOpponent()) {
                if (opponent == null) return false;
                if (amount > hlife) return false;
                if (!opponent.canLoseLife()) {
                    return false;
                }
                sa.getTargets().add(opponent);
            } else if (amount > myLife && myLife <= 10 && ai.canGainLife()) {
                sa.getTargets().add(ai);
            } else if (hlife > amount) {
                sa.getTargets().add(opponent);
            } else {
                if (amount <= myLife) return false;
                if (!ai.canGainLife()) return false;
                sa.getTargets().add(ai);
            }
        } else {
            if (sa.getParam("Defined").equals("Player")) {
                if (amount == 0) {
                    return false;
                }
                if (myLife > amount) {
                    if (myLife < 5) return false;
                    if (myLife - amount > hlife - amount) {
                        return false;
                    }
                }
            }
            if (amount <= myLife) {
                return false;
            }
        }
        if (myLife < 3 && amount > myLife && ai.canGainLife()) {
            return true;
        }
        if (!((double)MyRandom.getRandom().nextFloat() < 0.6667)) return false;
        if (!chance) return false;
        return true;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        int amount;
        int myLife = ai.getLife();
        PlayerCollection targetableOpps = ai.getOpponents().filter(PlayerPredicates.isTargetableBy(sa));
        Player opponent = targetableOpps.max(PlayerPredicates.compareByLife());
        int hlife = opponent == null ? 0 : opponent.getLife();
        Card source = sa.getHostCard();
        String sourceName = ComputerUtilAbility.getAbilitySourceName(sa);
        if (sa.hasParam("Redistribute")) {
            return mandatory;
        }
        String amountStr = sa.getParam("LifeAmount");
        if (amountStr.equals("X") && sa.getSVar(amountStr).equals("Count$xPaid")) {
            int xPay = ComputerUtilCost.getMaxXValue(sa, ai, true);
            sa.setXManaCostPaid(xPay);
            amount = xPay;
        } else {
            amount = AbilityUtils.calculateAmount(source, amountStr, sa);
        }
        if (amount == 0 && "TargetedPlayer$StartingLife/HalfDown".equals(source.getSVar(amountStr))) {
            return this.doHalfStartingLifeLogic(ai, opponent, sa) || mandatory;
        }
        if (sourceName.equals("Eternity Vessel") && (Iterables.any(ai.getOpponents().getCardsIn(ZoneType.Battlefield), CardPredicates.nameEquals("Vampire Hexmage")) || source.getCounters(CounterEnumType.CHARGE) == 0)) {
            return false;
        }
        TargetRestrictions tgt = sa.getTargetRestrictions();
        if (tgt != null) {
            sa.resetTargets();
            if (tgt.canOnlyTgtOpponent()) {
                if (opponent == null) {
                    return false;
                }
                sa.getTargets().add(opponent);
            } else if (amount > myLife && myLife <= 10) {
                sa.getTargets().add(ai);
            } else if (hlife > amount) {
                sa.getTargets().add(opponent);
            } else if (amount > myLife || mandatory) {
                sa.getTargets().add(ai);
            } else {
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean doHalfStartingLifeLogic(Player ai, Player opponent, SpellAbility sa) {
        int aiAmount = ai.getStartingLife() / 2;
        int oppAmount = opponent == null ? 0 : opponent.getStartingLife() / 2;
        int aiLife = ai.getLife();
        int oppLife = opponent == null ? 0 : opponent.getLife();
        sa.resetTargets();
        TargetRestrictions tgt = sa.getTargetRestrictions();
        if (tgt == null) return true;
        if (tgt.canOnlyTgtOpponent()) {
            if (oppLife <= oppAmount) return false;
            sa.getTargets().add(opponent);
            return true;
        } else if (aiAmount > ai.getLife() && aiLife < 5) {
            sa.getTargets().add(ai);
            return true;
        } else if (oppLife > oppAmount) {
            sa.getTargets().add(opponent);
            return true;
        } else {
            if (aiAmount <= aiLife) return false;
            sa.getTargets().add(ai);
        }
        return true;
    }
}

