/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.AiAttackController;
import forge.ai.AiProps;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCombat;
import forge.ai.PlayerControllerAi;
import forge.ai.SpellAbilityAi;
import forge.game.Game;
import forge.game.card.Card;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.MagicStack;
import forge.util.MyRandom;

public class LifeExchangeVariantAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        Card source = sa.getHostCard();
        String sourceName = ComputerUtilAbility.getAbilitySourceName(sa);
        Game game = ai.getGame();
        if ("Tree of Redemption".equals(sourceName)) {
            if (!ai.canGainLife()) {
                return false;
            }
            if (game.isCardInPlay("Rain of Gore") || game.isCardInPlay("Sulfuric Vortex")) {
                return false;
            }
            for (Player op : ai.getOpponents()) {
                if (!op.isCardInPlay("Tainted Remedy")) continue;
                return false;
            }
            if (ComputerUtil.waitForBlocking(sa) || ai.getLife() + 1 >= source.getNetToughness() || ai.getLife() > 5 && !ComputerUtilCombat.lifeInSeriousDanger(ai, ai.getGame().getCombat())) {
                return false;
            }
        } else {
            if ("Tree of Perdition".equals(sourceName)) {
                boolean shouldDo = false;
                if (ComputerUtil.waitForBlocking(sa)) {
                    return false;
                }
                for (Player op : ai.getOpponents()) {
                    if (!op.canBeTargetedBy(sa) || !op.canLoseLife()) continue;
                    if (op.getLife() > source.getNetToughness()) {
                        shouldDo = true;
                    } else {
                        if (!op.canGainLife()) continue;
                        if (ai.isCardInPlay("Tainted Remedy")) {
                            shouldDo = true;
                        } else {
                            for (Player ally : ai.getAllies()) {
                                if (!ally.isCardInPlay("Tainted Remedy") || !op.isOpponentOf(ally)) continue;
                                shouldDo = true;
                            }
                        }
                    }
                    if (!shouldDo) continue;
                    sa.getTargets().add(op);
                    break;
                }
                return shouldDo;
            }
            if ("Evra, Halcyon Witness".equals(sourceName)) {
                int aiLife = ai.getLife();
                if (game.getCombat() != null && game.getPhaseHandler().is(PhaseType.COMBAT_DECLARE_BLOCKERS) && game.getCombat().isAttacking(source) && source.getNetPower() > 0 && source.getNetPower() < aiLife) {
                    Player def = game.getCombat().getDefenderPlayerByAttacker(source);
                    if (game.getCombat().isUnblocked(source) && def.canLoseLife() && aiLife >= def.getLife() && source.getNetPower() < def.getLife()) {
                        return true;
                    }
                    if (ai.getController().isAI() && aiLife > source.getNetPower() && source.hasKeyword(Keyword.LIFELINK)) {
                        int lifeInDanger;
                        int dangerMin = ((PlayerControllerAi)ai.getController()).getAi().getIntProperty(AiProps.AI_IN_DANGER_THRESHOLD);
                        int dangerMax = ((PlayerControllerAi)ai.getController()).getAi().getIntProperty(AiProps.AI_IN_DANGER_MAX_THRESHOLD);
                        int dangerDiff = dangerMax - dangerMin;
                        int n = lifeInDanger = dangerDiff <= 0 ? dangerMin : MyRandom.getRandom().nextInt(dangerDiff) + dangerMin;
                        if (source.getNetPower() >= lifeInDanger && ai.canGainLife() && ComputerUtil.lifegainPositive(ai, source)) {
                            return true;
                        }
                    }
                }
                if (source.getNetPower() > aiLife) {
                    SpellAbility saTop;
                    if (!ai.canGainLife()) {
                        return false;
                    }
                    if (ComputerUtilCombat.lifeInSeriousDanger(ai, game.getCombat())) {
                        return true;
                    }
                    MagicStack stack = game.getStack();
                    if (!stack.isEmpty() && ComputerUtil.predictDamageFromSpell(saTop = stack.peekAbility(), ai) >= aiLife) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        Player opp = AiAttackController.choosePreferredDefenderPlayer(ai);
        if (sa.usesTargeting()) {
            sa.resetTargets();
            if (sa.canTarget(opp) && (mandatory || ai.getLife() < opp.getLife())) {
                sa.getTargets().add(opp);
            } else {
                return false;
            }
        }
        return true;
    }
}

