/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Iterables;
import forge.ai.ComputerUtil;
import forge.ai.SpellAbilityAi;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CounterEnumType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import java.util.Map;

public class LegendaryRuleAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player aiPlayer, SpellAbility sa) {
        return false;
    }

    @Override
    public Card chooseSingleCard(Player ai, SpellAbility sa, Iterable<Card> options, boolean isOptional, Player targetedPlayer, Map<String, Object> params) {
        CardCollection legends = new CardCollection(options);
        CardCollection badOptions = ComputerUtil.choosePermanentsToSacrifice(ai, legends, legends.size() - 1, sa, false, false);
        legends.removeAll(badOptions);
        Card firstOption = Iterables.getFirst(legends, null);
        boolean choosingFromPlanewalkers = firstOption.isPlaneswalker();
        if (choosingFromPlanewalkers) {
            // empty if block
        }
        if (firstOption.getName().equals("Dark Depths")) {
            Card best = firstOption;
            for (Card c : options) {
                if (c.getCounters(CounterEnumType.ICE) >= best.getCounters(CounterEnumType.ICE)) continue;
                best = c;
            }
            return best;
        }
        if (firstOption.getCounters(CounterEnumType.KI) > 0) {
            Card best = firstOption;
            for (Card c : options) {
                if (c.getCounters(CounterEnumType.KI) <= best.getCounters(CounterEnumType.KI)) continue;
                best = c;
            }
            return best;
        }
        return firstOption;
    }
}

