/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.SpellAbilityAi;
import forge.game.Game;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;

public class GoadAi
extends SpellAbilityAi {
    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        Card source = sa.getHostCard();
        Game game = source.getGame();
        if (sa.usesTargeting()) {
            CardCollection list = CardLists.getTargetableCards(game.getCardsIn(ZoneType.Battlefield), sa);
            if (list.isEmpty()) {
                return false;
            }
            if (game.getPlayers().size() > 2) {
                CardCollection betterList = CardLists.filter((Iterable<Card>)list, c -> {
                    if (ComputerUtilCard.isUselessCreature(ai, c)) {
                        return false;
                    }
                    if (c.isGoadedBy(ai)) {
                        return false;
                    }
                    for (Player o : ai.getOpponents()) {
                        if (!ComputerUtilCombat.canAttackNextTurn(c, o)) continue;
                        return true;
                    }
                    return false;
                });
                if (!betterList.isEmpty()) {
                    list = betterList;
                    sa.getTargets().add(ComputerUtilCard.getBestCreatureAI(list));
                    return true;
                }
            } else {
                CardCollection betterList = CardLists.filter((Iterable<Card>)list, c -> {
                    if (ComputerUtilCard.isUselessCreature(ai, c)) {
                        return false;
                    }
                    if (c.isGoadedBy(ai)) {
                        return false;
                    }
                    return ComputerUtilCard.canBeBlockedProfitably(ai, c, false);
                });
                if (!betterList.isEmpty()) {
                    list = betterList;
                    sa.getTargets().add(ComputerUtilCard.getBestCreatureAI(list));
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        if (this.checkApiLogic(ai, sa)) {
            return true;
        }
        if (!mandatory) {
            return false;
        }
        if (sa.usesTargeting()) {
            if (sa.getTargetRestrictions().canTgtPlayer()) {
                for (Player opp : ai.getOpponents()) {
                    if (!sa.canTarget(opp)) continue;
                    sa.getTargets().add(opp);
                    return true;
                }
                if (sa.canTarget(ai)) {
                    sa.getTargets().add(ai);
                    return true;
                }
            } else {
                CardCollection list = CardLists.getTargetableCards(ai.getGame().getCardsIn(ZoneType.Battlefield), sa);
                if (list.isEmpty()) {
                    return false;
                }
                sa.getTargets().add(ComputerUtilCard.getWorstCreatureAI(list));
                return true;
            }
        }
        return false;
    }
}

