/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.SpellAbilityAi;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.combat.CombatUtil;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.spellability.SpellAbility;
import java.util.Map;

public final class EncodeAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player aiPlayer, SpellAbility sa) {
        return true;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        return true;
    }

    @Override
    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        return this.chooseCard(player, player.getCreaturesInPlay(), true) != null;
    }

    @Override
    public Card chooseSingleCard(Player ai, SpellAbility sa, Iterable<Card> options, boolean isOptional, Player targetedPlayer, Map<String, Object> params) {
        return this.chooseCard(ai, options, isOptional);
    }

    private Card chooseCard(Player ai, Iterable<Card> list, boolean isOptional) {
        Card choice = null;
        CardCollection attackers = CardLists.filter(list, ComputerUtilCombat::canAttackNextTurn);
        CardCollection unblockables = CardLists.filter((Iterable<Card>)attackers, c -> {
            boolean canAttackOpponent = false;
            for (Player opp : ai.getOpponents()) {
                if (!CombatUtil.canAttack(c, opp) || CombatUtil.canBeBlocked(c, null, opp)) continue;
                canAttackOpponent = true;
                break;
            }
            return canAttackOpponent;
        });
        if (!unblockables.isEmpty()) {
            choice = ComputerUtilCard.getBestAI(unblockables);
        } else if (!attackers.isEmpty()) {
            choice = ComputerUtilCard.getBestAI(attackers);
        } else if (!isOptional) {
            choice = ComputerUtilCard.getBestAI(list);
        }
        return choice;
    }
}

