/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import forge.ai.AiCardMemory;
import forge.ai.AiController;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.ComputerUtilMana;
import forge.ai.PlayerControllerAi;
import forge.ai.SpecialCardAi;
import forge.ai.SpellAbilityAi;
import forge.ai.SpellApiToAi;
import forge.ai.ability.FightAi;
import forge.ai.ability.FogAi;
import forge.game.CardTraitBase;
import forge.game.CardTraitPredicates;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardUtil;
import forge.game.combat.Combat;
import forge.game.combat.CombatUtil;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementLayer;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.game.spellability.TargetRestrictions;
import forge.game.zone.MagicStack;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EffectAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        TargetRestrictions tgt;
        Game game = ai.getGame();
        boolean randomReturn = (double)MyRandom.getRandom().nextFloat() <= 0.6667;
        String logic = "";
        if (sa.hasParam("AILogic")) {
            logic = sa.getParam("AILogic");
            PhaseHandler phase = game.getPhaseHandler();
            if (logic.equals("BeginningOfOppTurn")) {
                if (!phase.getPlayerTurn().isOpponentOf(ai) || phase.getPhase().isAfter(PhaseType.DRAW)) {
                    return false;
                }
                randomReturn = true;
            } else if (logic.equals("EndOfOppTurn")) {
                if (!phase.getPlayerTurn().isOpponentOf(ai) || phase.getPhase().isBefore(PhaseType.END_OF_TURN)) {
                    return false;
                }
                randomReturn = true;
            } else if (logic.equals("KeepOppCreatsLandsTapped")) {
                for (Player opp : ai.getOpponents()) {
                    boolean worthHolding = false;
                    CardCollection oppCreatsLands = CardLists.filter((Iterable<Card>)opp.getCardsIn(ZoneType.Battlefield), Predicates.or(CardPredicates.Presets.LANDS, CardPredicates.Presets.CREATURES));
                    CardCollection oppCreatsLandsTapped = CardLists.filter((Iterable<Card>)oppCreatsLands, CardPredicates.Presets.TAPPED);
                    if (oppCreatsLandsTapped.size() >= 3 || oppCreatsLands.size() == oppCreatsLandsTapped.size()) {
                        worthHolding = true;
                    }
                    if (!worthHolding) {
                        return false;
                    }
                    randomReturn = true;
                }
            } else {
                if (logic.equals("RestrictBlocking")) {
                    if (!phase.isPlayerTurn(ai) || phase.getPhase().isBefore(PhaseType.COMBAT_BEGIN) || phase.getPhase().isAfter(PhaseType.COMBAT_DECLARE_ATTACKERS)) {
                        return false;
                    }
                    if (sa.getPayCosts().getTotalMana().countX() > 0 && sa.getHostCard().getSVar("X").equals("Count$xPaid")) {
                        int xPay = ComputerUtilMana.determineLeftoverMana(sa, ai, sa.isTrigger()) / 2;
                        if (xPay == 0) {
                            return false;
                        }
                        sa.setXManaCostPaid(xPay);
                    }
                    Player opp = ai.getStrongestOpponent();
                    CardCollection possibleAttackers = ai.getCreaturesInPlay();
                    CardCollection possibleBlockers = opp.getCreaturesInPlay();
                    possibleBlockers = CardLists.filter((Iterable<Card>)possibleBlockers, CardPredicates.Presets.UNTAPPED);
                    Combat combat = game.getCombat();
                    int oppLife = opp.getLife();
                    int potentialDmg = 0;
                    ArrayList<Card> currentAttackers = new ArrayList<Card>();
                    if (possibleBlockers.isEmpty()) {
                        return false;
                    }
                    for (Card creat : possibleAttackers) {
                        if (CombatUtil.canAttack(creat, opp) && possibleBlockers.size() > 1 && (potentialDmg += creat.getCurrentPower()) >= oppLife) {
                            return true;
                        }
                        if (combat == null || !combat.isAttacking(creat)) continue;
                        currentAttackers.add(creat);
                    }
                    return currentAttackers.size() > possibleBlockers.size();
                }
                if (logic.equals("Fog")) {
                    FogAi fogAi = new FogAi();
                    if (!fogAi.canPlayAI(ai, sa)) {
                        return false;
                    }
                    TargetRestrictions tgt2 = sa.getTargetRestrictions();
                    if (tgt2 != null) {
                        sa.resetTargets();
                        if (tgt2.canOnlyTgtOpponent()) {
                            boolean canTgt = false;
                            for (Player opp2 : ai.getOpponents()) {
                                if (!sa.canTarget(opp2)) continue;
                                sa.getTargets().add(opp2);
                                canTgt = true;
                                break;
                            }
                            if (!canTgt) {
                                return false;
                            }
                        } else {
                            CardCollection list = game.getCombat().getAttackers();
                            Card target = ComputerUtilCard.getBestCreatureAI(list = CardLists.getTargetableCards(list, sa));
                            if (target == null) {
                                return false;
                            }
                            sa.getTargets().add(target);
                        }
                    }
                    randomReturn = true;
                } else if (logic.equals("ChainVeil")) {
                    if (!phase.isPlayerTurn(ai) || !phase.getPhase().equals((Object)PhaseType.MAIN2) || ai.getPlaneswalkersInPlay().isEmpty()) {
                        return false;
                    }
                    randomReturn = true;
                } else if (logic.equals("WillCastCreature") && ai.isAI()) {
                    AiController aic = ((PlayerControllerAi)ai.getController()).getAi();
                    SpellAbility saCreature = aic.predictSpellToCastInMain2(ApiType.PermanentNoncreature);
                    randomReturn = saCreature != null;
                } else if (logic.equals("Always")) {
                    randomReturn = true;
                } else if (logic.equals("Main1")) {
                    if (phase.getPhase().isBefore(PhaseType.MAIN1)) {
                        return false;
                    }
                    randomReturn = true;
                } else if (logic.equals("Main2")) {
                    if (phase.getPhase().isBefore(PhaseType.MAIN2)) {
                        return false;
                    }
                    randomReturn = true;
                } else {
                    if (logic.equals("Evasion")) {
                        if (!phase.isPlayerTurn(ai)) {
                            return false;
                        }
                        boolean shouldPlay = false;
                        CardCollection comp = ai.getCreaturesInPlay();
                        for (Player opp : ai.getOpponents()) {
                            CardCollection attackers;
                            CardCollection human = opp.getCreaturesInPlay();
                            if ((comp = CardLists.filter((Iterable<Card>)comp, c -> CombatUtil.canAttack(c, opp))).size() < 2 || (human = CardLists.filter((Iterable<Card>)human, arg_0 -> EffectAi.lambda$canPlayAI$1(attackers = comp, arg_0))).isEmpty()) continue;
                            shouldPlay = true;
                            break;
                        }
                        return shouldPlay;
                    }
                    if (logic.equals("RedirectSpellDamageFromPlayer")) {
                        if (game.getStack().isEmpty()) {
                            return false;
                        }
                        boolean threatened = false;
                        for (SpellAbilityStackInstance stackInst : game.getStack()) {
                            SpellAbility saTargeting;
                            SpellAbility stackSpellAbility;
                            if (!stackInst.isSpell() || (stackSpellAbility = stackInst.getSpellAbility()).getApi() != ApiType.DealDamage || (saTargeting = stackSpellAbility.getSATargetingPlayer()) == null || !Iterables.contains(saTargeting.getTargets().getTargetPlayers(), ai)) continue;
                            threatened = true;
                        }
                        randomReturn = threatened;
                    } else {
                        if (logic.equals("Prevent")) {
                            ApiType type;
                            if (game.getStack().isEmpty()) {
                                return false;
                            }
                            SpellAbility saTop = game.getStack().peekAbility();
                            Card host = saTop.getHostCard();
                            if (saTop.getActivatingPlayer() != ai && host.canDamagePrevented(false) && (host.isInstant() || host.isSorcery()) && !host.hasKeyword("Prevent all damage that would be dealt by CARDNAME.") && ((type = saTop.getApi()) == ApiType.DealDamage || type == ApiType.DamageAll)) {
                                sa.getTargets().add(saTop);
                                return true;
                            }
                            return false;
                        }
                        if (logic.equals("NoGain")) {
                            Combat combat;
                            Player attackingPlayer;
                            SpellAbility topStack;
                            Player activator;
                            if (!game.getStack().isEmpty() && (activator = (topStack = game.getStack().peekAbility()).getActivatingPlayer()).isOpponentOf(ai) && activator.canGainLife()) {
                                while (topStack != null) {
                                    if (topStack.getApi() == ApiType.GainLife) {
                                        if ("You".equals(topStack.getParam("Defined")) || topStack.isTargeting(activator) || !topStack.usesTargeting() && !topStack.hasParam("Defined")) {
                                            return true;
                                        }
                                    } else if (topStack.getApi() == ApiType.DealDamage && topStack.getHostCard().hasKeyword(Keyword.LIFELINK)) {
                                        Card host = topStack.getHostCard();
                                        for (GameEntity target : topStack.getTargets().getTargetEntities()) {
                                            if (ComputerUtilCombat.predictDamageTo(target, AbilityUtils.calculateAmount(host, topStack.getParam("NumDmg"), topStack), host, false) <= 0) continue;
                                            return true;
                                        }
                                    }
                                    topStack = topStack.getSubAbility();
                                }
                            }
                            return game.getPhaseHandler().is(PhaseType.COMBAT_DECLARE_BLOCKERS) && (attackingPlayer = (combat = ai.getGame().getCombat()).getAttackingPlayer()).isOpponentOf(ai) && attackingPlayer.canGainLife() && ComputerUtilCombat.checkAttackerLifelinkDamage(combat) > 0;
                        }
                        if (logic.equals("NonCastCreature")) {
                            SpellAbility topStack;
                            Player activator;
                            if (!game.getStack().isEmpty() && (activator = (topStack = game.getStack().peekAbility()).getActivatingPlayer()).isOpponentOf(ai)) {
                                boolean changeZone = topStack.getApi() == ApiType.ChangeZone || topStack.getApi() == ApiType.ChangeZoneAll;
                                boolean toBattlefield = "Battlefield".equals(topStack.getParam("Destination"));
                                boolean reanimator = "true".equalsIgnoreCase(topStack.getSVar("IsReanimatorCard"));
                                if (changeZone && (toBattlefield || reanimator) && ("Creature".equals(topStack.getParam("ChangeType")) || topStack.getParamOrDefault("Defined", "").contains("Creature"))) {
                                    return true;
                                }
                            }
                            return false;
                        }
                        if (logic.equals("Fight")) {
                            return FightAi.canFightAi(ai, sa, 0, 0);
                        }
                        if (logic.equals("Pump")) {
                            sa.resetTargets();
                            CardCollection options = CardUtil.getValidCardsToTarget(sa);
                            options = CardLists.filterControlledBy(options, ai);
                            if (sa.getPayCosts().hasTapCost()) {
                                options.remove(sa.getHostCard());
                            }
                            if (!options.isEmpty() && phase.isPlayerTurn(ai) && phase.getPhase().isBefore(PhaseType.COMBAT_DECLARE_BLOCKERS)) {
                                sa.getTargets().add(ComputerUtilCard.getBestCreatureAI(options));
                                return true;
                            }
                            return false;
                        }
                        if (logic.equals("Burn")) {
                            AbilitySub burn = sa.getSubAbility();
                            return SpellApiToAi.Converter.get(burn.getApi()).canPlayAIWithSubs(ai, burn);
                        }
                        if (logic.equals("YawgmothsWill")) {
                            return SpecialCardAi.YawgmothsWill.consider(ai, sa);
                        }
                        if (logic.startsWith("NeedCreatures")) {
                            if (ai.getCreaturesInPlay().isEmpty()) {
                                return false;
                            }
                            if (logic.contains(":")) {
                                String[] k = logic.split(":");
                                int i = Integer.parseInt(k[1]);
                                return ai.getCreaturesInPlay().size() >= i;
                            }
                            return true;
                        }
                        if (logic.equals("ReplaySpell")) {
                            CardCollection list = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(ZoneType.Graveyard), sa.getTargetRestrictions().getValidTgts(), ai, sa.getHostCard(), (CardTraitBase)sa);
                            if (!ComputerUtil.targetPlayableSpellCard(ai, list, sa, false, false)) {
                                return false;
                            }
                        } else {
                            if (logic.equals("PeaceTalks")) {
                                Player nextPlayer = game.getNextPlayerAfter(ai);
                                if (nextPlayer.getCreaturesInPlay().isEmpty()) {
                                    return false;
                                }
                                if (!phase.is(PhaseType.MAIN2)) {
                                    return false;
                                }
                                return randomReturn;
                            }
                            if (logic.equals("Bribe")) {
                                Card host = sa.getHostCard();
                                Combat combat = game.getCombat();
                                if (combat != null && combat.isAttacking(host, ai) && !combat.isBlocked(host) && phase.is(PhaseType.COMBAT_DECLARE_BLOCKERS) && !AiCardMemory.isRememberedCard(ai, host, AiCardMemory.MemorySet.ACTIVATED_THIS_TURN)) {
                                    AiCardMemory.rememberCard(ai, host, AiCardMemory.MemorySet.ACTIVATED_THIS_TURN);
                                    return true;
                                }
                                return false;
                            }
                            if (logic.equals("CantRegenerate")) {
                                if (sa.usesTargeting()) {
                                    CardCollection list = CardLists.getTargetableCards(ai.getOpponents().getCardsIn(ZoneType.Battlefield), sa);
                                    if ((list = CardLists.filter(list, CardPredicates.Presets.CAN_BE_DESTROYED, input -> {
                                        Map<AbilityKey, Object> runParams = AbilityKey.mapFromAffected(input);
                                        runParams.put(AbilityKey.Regeneration, true);
                                        List<ReplacementEffect> repDestoryList = game.getReplacementHandler().getReplacementList(ReplacementType.Destroy, runParams, ReplacementLayer.Other);
                                        if (repDestoryList.isEmpty() || Iterables.any(repDestoryList, Predicates.not(CardTraitPredicates.hasParam("Regeneration")))) {
                                            return false;
                                        }
                                        return this.cantRegenerateCheckCombat((Card)input) || this.cantRegenerateCheckStack((Card)input);
                                    })).isEmpty()) {
                                        return false;
                                    }
                                    sa.getTargets().add(ComputerUtilCard.getBestAI(list));
                                    return true;
                                }
                                if (sa.getParent() != null) {
                                    return true;
                                }
                                if ("Self".equals(sa.getParam("RememberObjects"))) {
                                    Card host = sa.getHostCard();
                                    if (!host.canBeDestroyed()) {
                                        return false;
                                    }
                                    Map<AbilityKey, Object> runParams = AbilityKey.mapFromAffected(sa.getHostCard());
                                    runParams.put(AbilityKey.Regeneration, true);
                                    List<ReplacementEffect> repDestoryList = game.getReplacementHandler().getReplacementList(ReplacementType.Destroy, runParams, ReplacementLayer.Other);
                                    if (repDestoryList.isEmpty() || Iterables.any(repDestoryList, Predicates.not(CardTraitPredicates.hasParam("Regeneration")))) {
                                        return false;
                                    }
                                    return this.cantRegenerateCheckCombat(host) || this.cantRegenerateCheckStack(host);
                                }
                            }
                        }
                    }
                }
            }
        } else {
            return false;
        }
        if ("False".equals(sa.getParam("Stackable"))) {
            String name = sa.getParam("Name");
            if (name == null) {
                name = sa.getHostCard().getName() + "'s Effect";
            }
            if (sa.getActivatingPlayer().isCardInCommand(name)) {
                return false;
            }
        }
        if ((tgt = sa.getTargetRestrictions()) != null && tgt.canTgtPlayer()) {
            sa.resetTargets();
            if (tgt.canOnlyTgtOpponent() || logic.equals("BeginningOfOppTurn")) {
                boolean canTgt = false;
                for (Player opp : ai.getOpponents()) {
                    if (!sa.canTarget(opp)) continue;
                    sa.getTargets().add(opp);
                    canTgt = true;
                    break;
                }
                return canTgt;
            }
            sa.getTargets().add(ai);
        }
        return randomReturn;
    }

    @Override
    protected boolean doTriggerAINoCost(Player aiPlayer, SpellAbility sa, boolean mandatory) {
        if (sa.hasParam("AILogic") && this.canPlayAI(aiPlayer, sa)) {
            return true;
        }
        if (sa.usesTargeting() && !sa.getTargetRestrictions().canTgtPlayer()) {
            CardCollection oppPerms = CardLists.getValidCards((Iterable<Card>)aiPlayer.getOpponents().getCardsIn(sa.getTargetRestrictions().getZone()), sa.getTargetRestrictions().getValidTgts(), aiPlayer, sa.getHostCard(), (CardTraitBase)sa);
            if (!(oppPerms = CardLists.filter((Iterable<Card>)oppPerms, sa::canTarget)).isEmpty()) {
                sa.resetTargets();
                sa.getTargets().add(ComputerUtilCard.getBestAI(oppPerms));
                return true;
            }
            if (mandatory) {
                CardCollection aiPerms = CardLists.getValidCards((Iterable<Card>)aiPlayer.getCardsIn(sa.getTargetRestrictions().getZone()), sa.getTargetRestrictions().getValidTgts(), aiPlayer, sa.getHostCard(), (CardTraitBase)sa);
                if (!(aiPerms = CardLists.filter((Iterable<Card>)aiPerms, sa::canTarget)).isEmpty()) {
                    sa.resetTargets();
                    sa.getTargets().add(ComputerUtilCard.getWorstAI(aiPerms));
                    return true;
                }
            }
            return false;
        }
        return super.doTriggerAINoCost(aiPlayer, sa, mandatory);
    }

    protected boolean cantRegenerateCheckCombat(Card host) {
        Game game = host.getGame();
        if (!game.getPhaseHandler().inCombat()) {
            return false;
        }
        if (!game.getPhaseHandler().getPhase().isBefore(PhaseType.COMBAT_DAMAGE)) {
            return false;
        }
        Combat combat = game.getCombat();
        if (game.getPhaseHandler().isPlayerTurn(host.getController())) {
            if (!combat.isAttacking(host)) {
                return false;
            }
            return combat.isBlocked(host);
        }
        return combat.isBlocking(host);
    }

    protected boolean cantRegenerateCheckStack(Card host) {
        Game game = host.getGame();
        MagicStack stack = game.getStack();
        if (stack.isEmpty()) {
            return false;
        }
        SpellAbility stackSa = stack.peekAbility();
        if (stackSa == null) {
            return false;
        }
        SpellAbility subAbility = stackSa;
        while (subAbility != null) {
            String valid;
            ApiType apiType = subAbility.getApi();
            if (apiType == null) continue;
            if (ApiType.DestroyAll == apiType) {
                if (subAbility.hasParam("NoRegen")) {
                    return false;
                }
                if (subAbility.usesTargeting() && !Iterables.contains(subAbility.getTargets().getTargetPlayers(), host.getController())) {
                    return false;
                }
                valid = subAbility.getParamOrDefault("ValidCards", "");
                if (valid.contains("X")) {
                    valid = TextUtil.fastReplace(valid, "X", Integer.toString(AbilityUtils.calculateAmount(subAbility.getHostCard(), "X", subAbility)));
                }
                if (host.isValid(valid.split(","), subAbility.getActivatingPlayer(), subAbility.getHostCard(), (CardTraitBase)subAbility)) {
                    return true;
                }
                CardCollectionView list = game.getCardsIn(ZoneType.Battlefield);
                if (subAbility.usesTargeting()) {
                    list = CardLists.filterControlledBy((Iterable<Card>)list, new PlayerCollection(subAbility.getTargets().getTargetPlayers()));
                }
                if ((list = AbilityUtils.filterListByType(list, valid, subAbility)).contains(host)) {
                    return true;
                }
            } else if (ApiType.Destroy == apiType) {
                if (subAbility.hasParam("NoRegen")) {
                    return false;
                }
                if (subAbility.hasParam("Sacrifice")) {
                    return false;
                }
                if (subAbility.usesTargeting() ? subAbility.getTargets().contains(host) : AbilityUtils.getDefinedObjects(subAbility.getHostCard(), subAbility.getParam("Defined"), subAbility).contains(host)) {
                    return true;
                }
                if (CardUtil.getRadiance(subAbility).contains(host)) {
                    return true;
                }
            } else if (ApiType.DamageAll == apiType) {
                if (!subAbility.hasParam("ValidCards") || (valid = subAbility.getParamOrDefault("ValidCards", "")).isEmpty()) continue;
                Card source = game.getChangeZoneLKIInfo(subAbility.getHostCard());
                if (source.isWitherDamage()) {
                    return false;
                }
                if (host.isValid(valid.split(","), subAbility.getActivatingPlayer(), subAbility.getHostCard(), (CardTraitBase)subAbility)) {
                    return true;
                }
                CardCollectionView list = game.getCardsIn(ZoneType.Battlefield);
                if (subAbility.usesTargeting()) {
                    list = CardLists.filterControlledBy((Iterable<Card>)list, new PlayerCollection(subAbility.getTargets().getTargetPlayers()));
                }
                if ((list = AbilityUtils.filterListByType(list, valid, subAbility)).contains(host)) {
                    return true;
                }
            } else if (ApiType.DealDamage == apiType) {
                CardCollection definedSources;
                if (subAbility.hasParam("CardChoices") || subAbility.hasParam("PlayerChoices") || (definedSources = AbilityUtils.getDefinedCards(subAbility.getHostCard(), subAbility.getParam("DamageSource"), subAbility)) == null || definedSources.isEmpty()) continue;
                boolean targeting = false;
                if (subAbility.usesTargeting()) {
                    if (subAbility.getTargets().contains(host)) {
                        targeting = true;
                    }
                } else if (AbilityUtils.getDefinedObjects(subAbility.getHostCard(), subAbility.getParam("Defined"), subAbility).contains(host)) {
                    targeting = true;
                }
                for (Card source : definedSources) {
                    Card sourceLKI = game.getChangeZoneLKIInfo(source);
                    if (sourceLKI.isWitherDamage()) {
                        return false;
                    }
                    if (subAbility.hasParam("RelativeTarget")) {
                        targeting = false;
                        if (AbilityUtils.getDefinedEntities(subAbility.getHostCard(), subAbility.getParam("Defined"), (CardTraitBase)subAbility).contains(host)) {
                            targeting = true;
                        }
                    }
                    if (!targeting) continue;
                    return true;
                }
                if (CardUtil.getRadiance(subAbility).contains(host)) {
                    return true;
                }
            }
            subAbility = subAbility.getSubAbility();
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$canPlayAI$1(List attackers, Card c) {
        return CombatUtil.canBlockAtLeastOne(c, attackers);
    }
}

