/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.SpellAbilityAi;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.util.MyRandom;

public class DrainManaAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        boolean randomReturn;
        Card source = sa.getHostCard();
        Player opp = ai.getWeakestOpponent();
        boolean bl = randomReturn = (double)MyRandom.getRandom().nextFloat() <= Math.pow(0.6667, sa.getActivationsThisTurn());
        if (!sa.usesTargeting()) {
            PlayerCollection defined = AbilityUtils.getDefinedPlayers(source, sa.getParam("Defined"), sa);
            if (!defined.contains(opp)) {
                return false;
            }
        } else {
            sa.resetTargets();
            sa.getTargets().add(opp);
        }
        return randomReturn;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        Player opp = ai.getWeakestOpponent();
        Card source = sa.getHostCard();
        if (!sa.usesTargeting()) {
            if (mandatory) {
                return true;
            }
            PlayerCollection defined = AbilityUtils.getDefinedPlayers(source, sa.getParam("Defined"), sa);
            return defined.contains(opp);
        }
        sa.resetTargets();
        sa.getTargets().add(opp);
        return true;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        Card source = sa.getHostCard();
        boolean randomReturn = true;
        if (!sa.usesTargeting()) {
            PlayerCollection defined = AbilityUtils.getDefinedPlayers(source, sa.getParam("Defined"), sa);
            if (defined.contains(ai)) {
                return false;
            }
        } else {
            sa.resetTargets();
            sa.getTargets().add(ai.getWeakestOpponent());
        }
        return randomReturn;
    }
}

