/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Iterables;
import forge.ai.AiAttackController;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.ComputerUtilCost;
import forge.ai.SpecialCardAi;
import forge.ai.SpellAbilityAi;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerPredicates;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.TextUtil;
import java.util.Map;

public class DigAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        SpellAbility root;
        boolean payXLogic;
        Game game = ai.getGame();
        Player opp = AiAttackController.choosePreferredDefenderPlayer(ai);
        Card host = sa.getHostCard();
        Player libraryOwner = ai;
        if (!this.willPayCosts(ai, sa, sa.getPayCosts(), host)) {
            return false;
        }
        if (sa.usesTargeting()) {
            sa.resetTargets();
            if (!sa.canTarget(opp)) {
                return false;
            }
            sa.getTargets().add(opp);
            libraryOwner = opp;
        }
        if (libraryOwner.getCardsIn(ZoneType.Library).isEmpty()) {
            return false;
        }
        if ("Never".equals(sa.getParam("AILogic"))) {
            return false;
        }
        if ("AtOppEOT".equals(sa.getParam("AILogic")) && (game.getPhaseHandler().getNextTurn() != ai || !game.getPhaseHandler().is(PhaseType.END_OF_TURN))) {
            return false;
        }
        if (sa.hasParam("DestinationZone2") && !"Library".equals(sa.getParam("DestinationZone2"))) {
            int numToDig = AbilityUtils.calculateAmount(host, sa.getParam("DigNum"), sa);
            if (libraryOwner == ai && ai.getCardsIn(ZoneType.Library).size() <= numToDig + 2) {
                return false;
            }
        }
        if (game.getPhaseHandler().getPhase().isBefore(PhaseType.MAIN2) && !sa.hasParam("ActivationPhases") && !sa.hasParam("DestinationZone") && !ComputerUtil.castSpellInMain1(ai, sa)) {
            return false;
        }
        String num = sa.getParam("DigNum");
        boolean bl = payXLogic = sa.hasParam("AILogic") && sa.getParam("AILogic").startsWith("PayX");
        if ((num != null && num.equals("X") && sa.getSVar(num).equals("Count$xPaid") || payXLogic) && (root = sa.getRootAbility()).getXManaCostPaid() == null) {
            int numCards;
            int manaToSave = 0;
            if (sa.hasParam("AILogic") && sa.getParam("AILogic").startsWith("PayXButSaveMana")) {
                manaToSave = Integer.parseInt(TextUtil.split(sa.getParam("AILogic"), '.')[1]);
            }
            if ((numCards = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger()) - manaToSave) <= 0) {
                return false;
            }
            root.setXManaCostPaid(numCards);
        }
        if (DigAi.playReusable(ai, sa)) {
            return true;
        }
        if (!(game.getPhaseHandler().getNextTurn().equals(ai) && !game.getPhaseHandler().getPhase().isBefore(PhaseType.END_OF_TURN) || sa.hasParam("PlayerTurn") || DigAi.isSorcerySpeed(sa, ai) || ai.getCardsIn(ZoneType.Hand).size() <= 1 && !game.getPhaseHandler().getPhase().isBefore(PhaseType.DRAW) || ComputerUtil.activateForCost(sa, ai))) {
            return false;
        }
        if ("MadSarkhanDigDmg".equals(sa.getParam("AILogic"))) {
            return SpecialCardAi.SarkhanTheMad.considerDig(ai, sa);
        }
        return !ComputerUtil.preventRunAwayActivations(sa);
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player aiPlayer) {
        return this.canPlayAI(aiPlayer, sa);
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        SpellAbility root = sa.getRootAbility();
        PlayerCollection targetableOpps = ai.getOpponents().filter(PlayerPredicates.isTargetableBy(sa));
        Player opp = targetableOpps.min(PlayerPredicates.compareByLife());
        if (sa.usesTargeting()) {
            sa.resetTargets();
            if (mandatory && opp != null) {
                sa.getTargets().add(opp);
            } else if (mandatory && sa.canTarget(ai)) {
                sa.getTargets().add(ai);
            }
        }
        if (sa.hasParam("AILogic") && sa.getParam("AILogic").startsWith("PayXButSaveMana")) {
            int manaToSave = Integer.parseInt(TextUtil.split(sa.getParam("AILogic"), '.')[1]);
            int numCards = ComputerUtilCost.getMaxXValue(sa, ai, true) - manaToSave;
            if (numCards <= 0) {
                return mandatory;
            }
            root.setXManaCostPaid(numCards);
        }
        return true;
    }

    @Override
    public Card chooseSingleCard(Player ai, SpellAbility sa, Iterable<Card> valid, boolean isOptional, Player relatedPlayer, Map<String, Object> params) {
        if ("DigForCreature".equals(sa.getParam("AILogic"))) {
            CardCollection morphs;
            Card bestChoice = ComputerUtilCard.getBestCreatureAI(valid);
            if (bestChoice == null && !(morphs = CardLists.getKeyword(valid, Keyword.MORPH)).isEmpty()) {
                bestChoice = ComputerUtilCard.getBestAI(morphs);
            }
            return bestChoice != null ? bestChoice : ComputerUtilCard.getWorstAI(valid);
        }
        if ("EmulateScry".equals(sa.getParam("AILogic"))) {
            for (Card choice : valid) {
                if (!ComputerUtil.scryWillMoveCardToBottomOfLibrary(ai, choice)) continue;
                return choice;
            }
            return null;
        }
        if (sa.getActivatingPlayer().isOpponentOf(ai) && relatedPlayer.isOpponentOf(ai)) {
            return ComputerUtilCard.getWorstPermanentAI(valid, false, true, false, false);
        }
        return ComputerUtilCard.getBestAI(valid);
    }

    @Override
    public Player chooseSinglePlayer(Player ai, SpellAbility sa, Iterable<Player> options, Map<String, Object> params) {
        if (params != null && params.containsKey("Attacker")) {
            return (Player)ComputerUtilCombat.addAttackerToCombat(sa, (Card)params.get("Attacker"), options);
        }
        return Iterables.getFirst(options, null);
    }

    @Override
    protected GameEntity chooseSingleAttackableEntity(Player ai, SpellAbility sa, Iterable<GameEntity> options, Map<String, Object> params) {
        if (params != null && params.containsKey("Attacker")) {
            return ComputerUtilCombat.addAttackerToCombat(sa, (Card)params.get("Attacker"), options);
        }
        return super.chooseSingleAttackableEntity(ai, sa, options, params);
    }

    @Override
    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        Card topc = player.getZone(ZoneType.Library).get(0);
        if (sa.getHostCard() != null) {
            if (ComputerUtilAbility.getAbilitySourceName(sa).equals("Explorer's Scope")) {
                return true;
            }
            if ("AlwaysConfirm".equals(sa.getParam("AILogic"))) {
                return true;
            }
        }
        return topc.isInstant() || topc.isSorcery();
    }
}

