/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.AiController;
import forge.ai.AiPlayDecision;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilMana;
import forge.ai.PlayerControllerAi;
import forge.ai.SpellAbilityAi;
import forge.ai.SpellApiToAi;
import forge.card.mana.ManaCost;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.cost.Cost;
import forge.game.keyword.Keyword;
import forge.game.player.Player;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;

public class DelayedTriggerAi
extends SpellAbilityAi {
    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        if ("Always".equals(sa.getParam("AILogic"))) {
            return true;
        }
        SpellAbility trigsa = sa.getAdditionalAbility("Execute");
        if (trigsa == null) {
            return false;
        }
        trigsa.setActivatingPlayer(ai, true);
        if (trigsa instanceof AbilitySub) {
            return SpellApiToAi.Converter.get(trigsa.getApi()).chkDrawbackWithSubs(ai, (AbilitySub)trigsa);
        }
        return AiPlayDecision.WillPlay == ((PlayerControllerAi)ai.getController()).getAi().canPlaySa(trigsa);
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        SpellAbility trigsa = sa.getAdditionalAbility("Execute");
        if (trigsa == null) {
            return false;
        }
        AiController aic = ((PlayerControllerAi)ai.getController()).getAi();
        trigsa.setActivatingPlayer(ai, true);
        if (!sa.hasParam("OptionalDecider")) {
            return aic.doTrigger(trigsa, true);
        }
        return aic.doTrigger(trigsa, !sa.getParam("OptionalDecider").equals("You"));
    }

    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        String logic = sa.getParamOrDefault("AILogic", "");
        if (logic.equals("SpellCopy")) {
            ManaCost costSa = sa.getPayCosts().getTotalMana();
            int count = CardLists.count(ai.getCardsIn(ZoneType.Hand), c -> {
                if (!c.isInstant() && !c.isSorcery() || c.equals(sa.getHostCard())) {
                    return false;
                }
                for (SpellAbility ab : c.getSpellAbilities()) {
                    ManaCost costAb;
                    ManaCost total;
                    SpellAbility combinedAb;
                    AiPlayDecision decision;
                    if (ComputerUtilAbility.getAbilitySourceName(sa).equals(ComputerUtilAbility.getAbilitySourceName(ab)) || ab.hasParam("AINoRecursiveCheck") || "SpellCopy".equals(ab.getParam("AILogic")) && ab.getApi() == ApiType.DelayedTrigger || !ab.canPlay() || (decision = ((PlayerControllerAi)ai.getController()).getAi().canPlaySa(ab)) != AiPlayDecision.WillPlay && decision != AiPlayDecision.WaitForMain2 || !ComputerUtilMana.canPayManaCost(combinedAb = ab.copyWithDefinedCost(new Cost(total = ManaCost.combine(costSa, costAb = ab.getPayCosts().getTotalMana()), false)), ai, 0, true)) continue;
                    return true;
                }
                return false;
            });
            return count != 0;
        }
        if (logic.equals("NarsetRebound")) {
            int count = CardLists.count(ai.getCardsIn(ZoneType.Hand), c -> {
                if (!c.isInstant() && !c.isSorcery() || c.hasKeyword(Keyword.REBOUND)) {
                    return false;
                }
                for (SpellAbility ab : c.getSpellAbilities()) {
                    AiPlayDecision decision;
                    if (ComputerUtilAbility.getAbilitySourceName(sa).equals(ComputerUtilAbility.getAbilitySourceName(ab)) || ab.hasParam("AINoRecursiveCheck") || !ab.canPlay() || (decision = ((PlayerControllerAi)ai.getController()).getAi().canPlaySa(ab)) != AiPlayDecision.WillPlay && decision != AiPlayDecision.WaitForMain2 || !ComputerUtilMana.canPayManaCost(ab, ai, 0, true)) continue;
                    return true;
                }
                return false;
            });
            return count != 0;
        }
        if (logic.equals("SaveCreature")) {
            CardCollection ownCreatures = ai.getCreaturesInPlay();
            if (!(ownCreatures = CardLists.filter((Iterable<Card>)ownCreatures, card -> {
                if (ComputerUtilCard.isUselessCreature(ai, card)) {
                    return false;
                }
                return ComputerUtil.predictCreatureWillDieThisTurn(ai, card, sa);
            })).isEmpty()) {
                sa.getTargets().add(ComputerUtilCard.getBestAI(ownCreatures));
                return true;
            }
            return false;
        }
        SpellAbility trigsa = sa.getAdditionalAbility("Execute");
        if (trigsa == null) {
            return false;
        }
        trigsa.setActivatingPlayer(ai, true);
        return AiPlayDecision.WillPlay == ((PlayerControllerAi)ai.getController()).getAi().canPlaySa(trigsa);
    }
}

