/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.ai.AiAttackController;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCost;
import forge.ai.SpellAbilityAi;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardUtil;
import forge.game.combat.Combat;
import forge.game.cost.Cost;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetRestrictions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DebuffAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        Card source = sa.getHostCard();
        Game game = ai.getGame();
        if (!sa.usesTargeting() && !source.isInPlay()) {
            return false;
        }
        Cost cost = sa.getPayCosts();
        if (!ComputerUtilCost.checkCreatureSacrificeCost(ai, cost, source, sa)) {
            return false;
        }
        if (!ComputerUtilCost.checkLifeCost(ai, cost, source, 40, sa)) {
            return false;
        }
        if (!ComputerUtilCost.checkRemoveCounterCost(cost, source, sa)) {
            return false;
        }
        PhaseHandler ph = game.getPhaseHandler();
        if (!(!ph.getPhase().isBefore(PhaseType.COMBAT_DECLARE_ATTACKERS) && !ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_BLOCKERS) && game.getStack().isEmpty() || DebuffAi.isSorcerySpeed(sa, ai) || sa.hasParam("ActivationPhases"))) {
            return false;
        }
        if (!sa.usesTargeting()) {
            CardCollection cards = AbilityUtils.getDefinedCards(source, sa.getParam("Defined"), sa);
            Combat combat = game.getCombat();
            return Iterables.any(cards, c -> {
                if (c.getController().equals(sa.getActivatingPlayer()) || combat == null) {
                    return false;
                }
                if (!combat.isBlocking((Card)c) && !combat.isAttacking((Card)c)) {
                    return false;
                }
                return sa.hasParam("Keywords") && c.hasAnyKeyword(Arrays.asList(sa.getParam("Keywords").split(" & ")));
            });
        }
        return this.debuffTgtAI(ai, sa, sa.hasParam("Keywords") ? Arrays.asList(sa.getParam("Keywords").split(" & ")) : null, false);
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        if (sa.usesTargeting()) {
            return this.debuffTgtAI(ai, sa, sa.hasParam("Keywords") ? Arrays.asList(sa.getParam("Keywords").split(" & ")) : null, false);
        }
        return true;
    }

    private boolean debuffTgtAI(Player ai, SpellAbility sa, List<String> kws, boolean mandatory) {
        if (!mandatory && ai.getGame().getPhaseHandler().getPhase().isAfter(PhaseType.COMBAT_DECLARE_BLOCKERS)) {
            return false;
        }
        TargetRestrictions tgt = sa.getTargetRestrictions();
        sa.resetTargets();
        CardCollection list = this.getCurseCreatures(ai, sa, kws == null ? Lists.newArrayList() : kws);
        if (list.isEmpty()) {
            return mandatory && this.debuffMandatoryTarget(ai, sa, mandatory);
        }
        while (sa.canAddMoreTarget()) {
            Card t2 = null;
            if (list.isEmpty()) {
                if (sa.getTargets().size() >= tgt.getMinTargets(sa.getHostCard(), sa) && sa.getTargets().size() != 0) break;
                if (mandatory) {
                    return this.debuffMandatoryTarget(ai, sa, mandatory);
                }
                sa.resetTargets();
                return false;
            }
            t2 = ComputerUtilCard.getBestCreatureAI(list);
            sa.getTargets().add(t2);
            list.remove(t2);
        }
        return true;
    }

    private CardCollection getCurseCreatures(Player ai, SpellAbility sa, List<String> kws) {
        Player opp = AiAttackController.choosePreferredDefenderPlayer(ai);
        CardCollection list = CardLists.getTargetableCards(opp.getCreaturesInPlay(), sa);
        if (!list.isEmpty()) {
            list = CardLists.filter((Iterable<Card>)list, c -> c.hasAnyKeyword(kws));
        }
        return list;
    }

    private boolean debuffMandatoryTarget(Player ai, SpellAbility sa, boolean mandatory) {
        Card c;
        TargetRestrictions tgt = sa.getTargetRestrictions();
        List<Card> list = CardUtil.getValidCardsToTarget(sa);
        if (list.size() < tgt.getMinTargets(sa.getHostCard(), sa)) {
            sa.resetTargets();
            return false;
        }
        CardCollection pref = CardLists.filterControlledBy(list, ai.getOpponents());
        CardCollection forced = CardLists.filterControlledBy(list, ai);
        Card source = sa.getHostCard();
        while (sa.canAddMoreTarget() && !pref.isEmpty()) {
            c = ComputerUtilCard.getBestAI(pref);
            pref.remove(c);
            sa.getTargets().add(c);
        }
        while (!sa.isMinTargetChosen() && !forced.isEmpty()) {
            c = CardLists.getNotType(forced, "Creature").size() == 0 ? ComputerUtilCard.getWorstCreatureAI(forced) : ComputerUtilCard.getCheapestPermanentAI(forced, sa, false);
            forced.remove(c);
            sa.getTargets().add(c);
        }
        if (!sa.isMinTargetChosen()) {
            sa.resetTargets();
            return false;
        }
        return true;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        ArrayList<String> kws;
        List<String> list = kws = sa.hasParam("Keywords") ? Arrays.asList(sa.getParam("Keywords").split(" & ")) : new ArrayList<String>();
        if (!sa.usesTargeting()) {
            if (mandatory) {
                return true;
            }
        } else {
            return this.debuffTgtAI(ai, sa, kws, mandatory);
        }
        return true;
    }
}

