/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.ai.AiCardMemory;
import forge.ai.AiProps;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.ComputerUtilCost;
import forge.ai.PlayerControllerAi;
import forge.ai.SpecialAiLogic;
import forge.ai.SpecialCardAi;
import forge.ai.ability.CountersAi;
import forge.ai.ability.FightAi;
import forge.ai.ability.ProtectAi;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameObject;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.combat.Combat;
import forge.game.combat.CombatUtil;
import forge.game.cost.Cost;
import forge.game.cost.CostPart;
import forge.game.cost.CostPutCounter;
import forge.game.cost.CostRemoveCounter;
import forge.game.cost.CostSacrifice;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerPredicates;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetRestrictions;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import forge.util.MyRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CountersPutAi
extends CountersAi {
    @Override
    protected boolean willPayCosts(Player ai, SpellAbility sa, Cost cost, Card source) {
        String type = sa.getParam("CounterType");
        String aiLogic = sa.getParamOrDefault("AILogic", "");
        if (!super.willPayCosts(ai, sa, cost, source)) {
            return false;
        }
        for (CostPart part : cost.getCostParts()) {
            if (!(part instanceof CostRemoveCounter)) continue;
            CostRemoveCounter remCounter = (CostRemoveCounter)part;
            CounterType counterType = remCounter.counter;
            if (counterType.getName().equals(type) && !aiLogic.startsWith("MoveCounter")) {
                return false;
            }
            if (!(!part.payCostFromSource() ? counterType.is(CounterEnumType.P1P1) : counterType.is(CounterEnumType.P1P1) && source.getLethalDamage() <= 1)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean checkPhaseRestrictions(Player ai, SpellAbility sa, PhaseHandler ph) {
        Card source = sa.getHostCard();
        if (sa.isOutlast()) {
            if (ph.is(PhaseType.MAIN2, ai)) {
                float chance = 0.8f;
                if (ComputerUtilCard.doesSpecifiedCreatureBlock(ai, source)) {
                    return false;
                }
                return chance > MyRandom.getRandom().nextFloat();
            }
            return false;
        }
        if (sa.hasParam("LevelUp")) {
            if (ph.getPhase().isBefore(PhaseType.MAIN2)) {
                for (Card aura : source.getEnchantedBy()) {
                    if (!aura.getController().isOpponentOf(ai)) continue;
                    return false;
                }
            }
            int maxLevel = Integer.parseInt(sa.getParam("MaxLevel"));
            return source.getCounters(CounterEnumType.LEVEL) < maxLevel;
        }
        if ("CrawlingBarrens".equals(sa.getParam("AILogic"))) {
            return true;
        }
        return super.checkPhaseRestrictions(ai, sa, ph);
    }

    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        CardCollection creatsYouCtrl;
        List<Card> leastToughness;
        CardCollection prot;
        Cost abCost = sa.getPayCosts();
        Card source = sa.getHostCard();
        String sourceName = ComputerUtilAbility.getAbilitySourceName(sa);
        Card choice = null;
        String amountStr = sa.getParamOrDefault("CounterNum", "1");
        boolean divided = sa.isDividedAsYouChoose();
        String logic = sa.getParamOrDefault("AILogic", "");
        PhaseHandler ph = ai.getGame().getPhaseHandler();
        String[] types = sa.hasParam("CounterType") ? sa.getParam("CounterType").split(",") : sa.getParam("CounterTypes").split(",");
        String type = types[0];
        boolean isClockwork = "True".equals(sa.getParam("UpTo")) && "Self".equals(sa.getParam("Defined")) && "P1P0".equals(sa.getParam("CounterType")) && "Count$xPaid".equals(source.getSVar("X")) && sa.hasParam("MaxFromEffect");
        boolean playAggro = ((PlayerControllerAi)ai.getController()).getAi().getBooleanProperty(AiProps.PLAY_AGGRO);
        if ("ExistingCounter".equals(type)) {
            boolean eachExisting = sa.hasParam("EachExistingCounter");
            if (sa.usesTargeting()) {
                PlayerCollection oppList;
                PlayerCollection poisonList;
                sa.resetTargets();
                TargetRestrictions abTgt = sa.getTargetRestrictions();
                if (abTgt.canTgtPlayer() && !(poisonList = (oppList = ai.getOpponents().filter(PlayerPredicates.isTargetableBy(sa))).filter(PlayerPredicates.hasCounter(CounterEnumType.POISON, 9))).isEmpty()) {
                    sa.getTargets().add(poisonList.max(PlayerPredicates.compareByLife()));
                    return true;
                }
                if (abTgt.canTgtCreature()) {
                    CardCollection oppCreat = CardLists.getTargetableCards(ai.getOpponents().getCreaturesInPlay(), sa);
                    CardCollection oppCreatM1 = CardLists.filter((Iterable<Card>)oppCreat, CardPredicates.hasCounter(CounterEnumType.M1M1));
                    oppCreatM1 = CardLists.getNotKeyword((Iterable<Card>)oppCreatM1, Keyword.UNDYING);
                    Card best = ComputerUtilCard.getBestAI(oppCreatM1 = CardLists.filter((Iterable<Card>)oppCreatM1, input -> input.getNetToughness() <= 1 && input.canReceiveCounters(CounterType.get(CounterEnumType.M1M1))));
                    if (best != null) {
                        sa.getTargets().add(best);
                        return true;
                    }
                    CardCollection aiCreat = CardLists.getTargetableCards(ai.getCreaturesInPlay(), sa);
                    aiCreat = CardLists.filter((Iterable<Card>)aiCreat, CardPredicates.hasCounters());
                    best = ComputerUtilCard.getBestAI(aiCreat = CardLists.filter((Iterable<Card>)aiCreat, input -> {
                        for (CounterType counterType : input.getCounters().keySet()) {
                            if (ComputerUtil.isNegativeCounter(counterType, input) || !input.canReceiveCounters(counterType)) continue;
                            return true;
                        }
                        return false;
                    }));
                    if (best != null) {
                        sa.getTargets().add(best);
                        return true;
                    }
                }
                if (!(!sa.canTarget(ai) || ai.getCounters().isEmpty() || eachExisting && ai.getPoisonCounters() >= 5)) {
                    sa.getTargets().add(ai);
                    return true;
                }
            }
            return false;
        }
        if (ComputerUtil.preventRunAwayActivations(sa)) {
            return false;
        }
        if ("Never".equals(logic)) {
            return false;
        }
        if ("AlwaysWithNoTgt".equals(logic)) {
            return true;
        }
        if ("AristocratCounters".equals(logic)) {
            return SpecialAiLogic.doAristocratWithCountersLogic(ai, sa);
        }
        if ("PayEnergy".equals(logic)) {
            return true;
        }
        if ("PayEnergyConservatively".equals(logic)) {
            boolean onlyDefensive;
            boolean onlyInCombat = ai.getController().isAI() && ((PlayerControllerAi)ai.getController()).getAi().getBooleanProperty(AiProps.CONSERVATIVE_ENERGY_PAYMENT_ONLY_IN_COMBAT);
            boolean bl = onlyDefensive = ai.getController().isAI() && ((PlayerControllerAi)ai.getController()).getAi().getBooleanProperty(AiProps.CONSERVATIVE_ENERGY_PAYMENT_ONLY_DEFENSIVELY);
            if (playAggro) {
                return true;
            }
            if (ph.inCombat() && source != null) {
                if (ai.getGame().getCombat().isAttacking(source) && !onlyDefensive) {
                    return true;
                }
                if (ai.getGame().getCombat().isBlocking(source)) {
                    CardCollection blocked = ai.getGame().getCombat().getAttackersBlockedBy(source);
                    int totBlkPower = Aggregates.sum(blocked, Card::getNetPower);
                    int totBlkToughness = Aggregates.min(blocked, Card::getNetToughness);
                    int numActivations = ai.getCounters(CounterEnumType.ENERGY) / sa.getPayCosts().getCostEnergy().convertAmount();
                    if (source.getNetToughness() + numActivations > totBlkPower || source.getNetPower() + numActivations >= totBlkToughness) {
                        return true;
                    }
                }
            } else if (sa.getSubAbility() != null && "Self".equals(sa.getSubAbility().getParam("Defined")) && sa.getSubAbility().getParamOrDefault("KW", "").contains("Hexproof") && !AiCardMemory.isRememberedCard(ai, source, AiCardMemory.MemorySet.ANIMATED_THIS_TURN)) {
                if (ComputerUtil.predictThreatenedObjects(sa.getActivatingPlayer(), sa).contains(source)) {
                    AiCardMemory.rememberCard(ai, source, AiCardMemory.MemorySet.ACTIVATED_THIS_TURN);
                    return true;
                }
            } else if (ai.getCounters(CounterEnumType.ENERGY) > ComputerUtilCard.getMaxSAEnergyCostOnBattlefield(ai) + sa.getPayCosts().getCostEnergy().convertAmount() && !onlyInCombat) {
                return true;
            }
        } else if (logic.equals("MarkOppCreature")) {
            if (!ph.is(PhaseType.END_OF_TURN)) {
                return false;
            }
            CardCollection oppCreats = CardLists.filter(ai.getOpponents().getCreaturesInPlay(), Predicates.not(CardPredicates.hasCounter(CounterType.getType(type))), CardPredicates.isTargetableBy(sa));
            if (!oppCreats.isEmpty()) {
                Card bestCreat = ComputerUtilCard.getBestCreatureAI(oppCreats);
                sa.resetTargets();
                sa.getTargets().add(bestCreat);
                return true;
            }
        } else if (logic.equals("CheckDFC")) {
            if (!source.canTransform(null)) {
                return false;
            }
        } else {
            if (logic.startsWith("MoveCounter")) {
                return this.doMoveCounterLogic(ai, sa, ph);
            }
            if (logic.equals("CrawlingBarrens")) {
                boolean willActivate = SpecialCardAi.CrawlingBarrens.consider(ai, sa);
                if (willActivate && ph.getPhase().isBefore(PhaseType.MAIN2)) {
                    AiCardMemory.rememberCard(ai, source, AiCardMemory.MemorySet.HELD_MANA_SOURCES_FOR_MAIN2);
                }
                return willActivate;
            }
            if (logic.equals("ChargeToBestCMC")) {
                return this.doChargeToCMCLogic(ai, sa);
            }
            if (logic.equals("ChargeToBestOppControlledCMC")) {
                return this.doChargeToOppCtrlCMCLogic(ai, sa);
            }
            if (logic.equals("TheOneRing")) {
                return SpecialCardAi.TheOneRing.consider(ai, sa);
            }
        }
        if (!sa.metConditions() && sa.getSubAbility() == null) {
            return false;
        }
        if (sourceName.equals("Feat of Resistance") && !(prot = ProtectAi.getProtectCreatures(ai, sa.getSubAbility())).isEmpty()) {
            sa.getTargets().add((GameObject)prot.get(false));
            return true;
        }
        if (sa.hasParam("Bolster") && (leastToughness = Aggregates.listWithMin(creatsYouCtrl = ai.getCreaturesInPlay(), Card::getNetToughness)).isEmpty()) {
            return false;
        }
        if (sa.hasParam("Monstrosity") && source.isMonstrous()) {
            return false;
        }
        int amount = AbilityUtils.calculateAmount(source, amountStr, sa);
        if (amount == 0 && logic.equals("FromDiceRoll")) {
            amount = 1;
        }
        if (sa.hasParam("Adapt")) {
            Game game = ai.getGame();
            Combat combat = game.getCombat();
            if (!source.canReceiveCounters(CounterType.get(CounterEnumType.P1P1)) || source.getCounters(CounterEnumType.P1P1) > 0) {
                return false;
            }
            if (combat != null && ph.is(PhaseType.COMBAT_DECLARE_BLOCKERS)) {
                return this.doCombatAdaptLogic(source, amount, combat);
            }
        }
        if ("Fight".equals(logic) || "PowerDmg".equals(logic)) {
            int nPump = 0;
            if (type.equals("P1P1")) {
                nPump = amount;
            }
            return FightAi.canFightAi(ai, sa, nPump, nPump);
        }
        if (amountStr.equals("X")) {
            if (sa.getSVar(amountStr).equals("Count$xPaid")) {
                amount = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
                if (isClockwork) {
                    int maxCtrs;
                    int curCtrs = source.getCounters(CounterEnumType.P1P0);
                    if ((double)curCtrs > Math.ceil((double)(maxCtrs = Integer.parseInt(sa.getParam("MaxFromEffect"))) / 2.0)) {
                        return false;
                    }
                    if ((amount = Math.min(amount, maxCtrs - curCtrs)) <= 0) {
                        return false;
                    }
                }
                sa.setXManaCostPaid(amount);
            } else if ("ExiledCreatureFromGraveCMC".equals(logic) && (amount = Aggregates.max(CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Graveyard), CardPredicates.Presets.CREATURES), Card::getCMC).intValue()) > 0 && ai.getGame().getPhaseHandler().is(PhaseType.END_OF_TURN)) {
                return true;
            }
        }
        if (amount <= 0) {
            return false;
        }
        if ("Polukranos".equals(logic)) {
            boolean found = false;
            for (Trigger tr : source.getTriggers()) {
                SpellAbility oa;
                if (!tr.getMode().equals((Object)TriggerType.BecomeMonstrous) || (oa = tr.ensureAbility()) == null) continue;
                oa.setActivatingPlayer(ai, true);
                CardCollection targets = CardLists.getTargetableCards(ai.getOpponents().getCreaturesInPlay(), oa);
                if (!targets.isEmpty()) {
                    boolean canSurvive = false;
                    for (Card humanCreature : targets) {
                        if (FightAi.canKill(humanCreature, source, 0)) continue;
                        canSurvive = true;
                        break;
                    }
                    if (!canSurvive) {
                        return false;
                    }
                }
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        if ("AtOppEOT".equals(logic) && ph.is(PhaseType.END_OF_TURN) && ph.getNextTurn().equals(ai)) {
            return true;
        }
        boolean hasSacCost = abCost.hasSpecificCostType(CostSacrifice.class);
        boolean sacSelf = ComputerUtilCost.isSacrificeSelfCost(abCost);
        if (sa.usesTargeting()) {
            if (!ai.getGame().getStack().isEmpty() && !CountersPutAi.isSorcerySpeed(sa, ai) && sa.getMinTargets() < 2) {
                if (ComputerUtilCard.canPumpAgainstRemoval(ai, sa)) {
                    Card c2 = sa.getTargetCard();
                    if (sa.getTargets().size() > 1) {
                        sa.resetTargets();
                        sa.getTargets().add(c2);
                    }
                    sa.addDividedAllocation(c2, amount);
                    return true;
                }
                if (!hasSacCost) {
                    return false;
                }
            }
            sa.resetTargets();
            CardCollection list = sa.isCurse() ? ai.getOpponents().getCardsIn(ZoneType.Battlefield) : ComputerUtil.getSafeTargets(ai, sa, ai.getCardsIn(ZoneType.Battlefield));
            list = CardLists.filter((Iterable<Card>)list, c -> {
                if (sacSelf && c.equals(source)) {
                    return false;
                }
                if (hasSacCost && !ComputerUtil.shouldSacrificeThreatenedCard(ai, c, sa)) {
                    return false;
                }
                if ("NoCounterOfType".equals(sa.getParam("AILogic"))) {
                    for (String ctrType : types) {
                        if (c.getCounters(CounterType.getType(ctrType)) <= 0) continue;
                        return false;
                    }
                }
                return sa.canTarget((GameObject)c) && c.canReceiveCounters(CounterType.getType(type));
            });
            list = ComputerUtil.filterAITgts(sa, ai, list, false);
            if (abCost.hasSpecificCostType(CostSacrifice.class)) {
                Card sacTarget = ComputerUtil.getCardPreference(ai, source, "SacCost", list);
                list.remove(sacTarget);
            }
            if (list.size() < sa.getTargetRestrictions().getMinTargets(source, sa)) {
                return false;
            }
            if (list.isEmpty() && sa.isPwAbility() && sa.getPayCosts().hasOnlySpecificCostType(CostPutCounter.class) && sa.isTargetNumberValid() && sa.getTargets().size() == 0 && ai.getGame().getPhaseHandler().is(PhaseType.MAIN2, ai)) {
                return true;
            }
            if (sourceName.equals("Abzan Charm")) {
                ComputerUtilCard.sortByEvaluateCreature(list);
                for (int i = 1; i < amount + 1; ++i) {
                    int left = amount;
                    for (Card c3 : list) {
                        if (ComputerUtilCard.shouldPumpCard(ai, sa, c3, i, i, Lists.newArrayList())) {
                            sa.getTargets().add(c3);
                            sa.addDividedAllocation(c3, i);
                            left -= i;
                        }
                        if (left >= i && sa.getTargets().size() != sa.getMaxTargets()) continue;
                        sa.addDividedAllocation(sa.getTargets().getFirstTargetedCard(), left + i);
                        left = 0;
                        break;
                    }
                    if (left == 0) {
                        return true;
                    }
                    sa.resetTargets();
                }
                return false;
            }
            while (sa.canAddMoreTarget()) {
                if (list.isEmpty()) {
                    if (sa.isTargetNumberValid() && !sa.getTargets().isEmpty()) break;
                    sa.resetTargets();
                    return false;
                }
                if (sa.isCurse()) {
                    choice = CountersPutAi.chooseCursedTarget(list, type, amount, ai);
                } else if (type.equals("P1P1") && !CountersPutAi.isSorcerySpeed(sa, ai)) {
                    for (Card c4 : list) {
                        if (!ComputerUtilCard.shouldPumpCard(ai, sa, c4, amount, amount, Lists.newArrayList())) continue;
                        choice = c4;
                        break;
                    }
                    if (choice == null) {
                        choice = ComputerUtil.getKilledByTargeting(sa, CardLists.getTargetableCards(ai.getOpponents().getCreaturesInPlay(), sa));
                    }
                    if (choice == null) {
                        boolean increasesCharmOutcome = false;
                        if (sa.getRootAbility().getApi() == ApiType.Charm && source.getStaticAbilities().isEmpty()) {
                            ArrayList<AbilitySub> choices = Lists.newArrayList(sa.getRootAbility().getAdditionalAbilityList("Choices"));
                            choices.remove(sa);
                            boolean bl = increasesCharmOutcome = !((AbilitySub)choices.get(0)).getTargets().isEmpty();
                        }
                        if ((!source.isSpell() || increasesCharmOutcome || ph.getTurn() - source.getTurnInZone() >= source.getGame().getPlayers().size() * 2) && (abCost == null || abCost == Cost.Zero || ph.is(PhaseType.END_OF_TURN) && ph.getPlayerTurn().isOpponentOf(ai))) {
                            choice = CountersPutAi.chooseBoonTarget(list, type);
                        }
                    }
                } else {
                    choice = CountersPutAi.chooseBoonTarget(list, type);
                }
                if (choice == null) {
                    if (sa.isTargetNumberValid() && !sa.getTargets().isEmpty()) break;
                    sa.resetTargets();
                    return false;
                }
                list.remove(choice);
                sa.getTargets().add(choice);
                if (divided) {
                    sa.addDividedAllocation(choice, amount);
                    break;
                }
                choice = null;
            }
            if (sa.getTargets().isEmpty()) {
                return false;
            }
        } else {
            CardCollection cards = AbilityUtils.getDefinedCards(source, sa.getParam("Defined"), sa);
            if (cards.isEmpty() || ((Card)cards.get(0)).getController().isOpponentOf(ai) && !sa.isCurse()) {
                return false;
            }
            int currCounters = ((Card)cards.get(0)).getCounters(CounterType.get(type));
            if (!type.equals("P1P1") && !type.equals("M1M1") && !type.equals("ICE") && (double)MyRandom.getRandom().nextFloat() < 0.1 * (double)currCounters) {
                return false;
            }
            if (!(!type.equals("P1P1") || CountersPutAi.isSorcerySpeed(sa, ai) || hasSacCost || ph.getNextTurn() == ai && ph.is(PhaseType.END_OF_TURN) && abCost.isReusuableResource())) {
                return false;
            }
        }
        boolean immediately = ComputerUtil.playImmediately(ai, sa);
        if (abCost != null && !ComputerUtilCost.checkSacrificeCost(ai, abCost, source, sa, immediately)) {
            return false;
        }
        if (immediately) {
            return true;
        }
        if (!(type.equals("P1P1") || type.equals("M1M1") || sa.hasParam("ActivationPhases"))) {
            if (ph.getPhase().isBefore(PhaseType.MAIN2) && !ComputerUtil.castSpellInMain1(ai, sa)) {
                return false;
            }
            if (ph.isPlayerTurn(ai) && !CountersPutAi.isSorcerySpeed(sa, ai)) {
                return false;
            }
        }
        return !ComputerUtil.waitForBlocking(sa);
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        boolean isMandatoryTrigger;
        boolean chance = true;
        Game game = ai.getGame();
        Card choice = null;
        String type = sa.getParam("CounterType");
        String logic = sa.getParamOrDefault("AILogic", "");
        String amountStr = sa.getParamOrDefault("CounterNum", "1");
        boolean divided = sa.isDividedAsYouChoose();
        int amount = AbilityUtils.calculateAmount(sa.getHostCard(), amountStr, sa);
        boolean bl = isMandatoryTrigger = sa.isTrigger() && !sa.isOptionalTrigger() || sa.getRootAbility().isTrigger() && !sa.getRootAbility().isOptionalTrigger();
        if (sa.usesTargeting()) {
            CardCollection list = null;
            list = sa.isCurse() ? ai.getOpponents().getCardsIn(ZoneType.Battlefield) : new CardCollection(ai.getCardsIn(ZoneType.Battlefield));
            if ((list = CardLists.getTargetableCards(list, sa)).isEmpty() && isMandatoryTrigger) {
                list = CardLists.getTargetableCards(game.getCardsIn(ZoneType.Battlefield), sa);
            }
            sa.resetTargets();
            while (sa.canAddMoreTarget()) {
                if (list.isEmpty()) {
                    if (sa.isTargetNumberValid() && sa.getTargets().size() != 0) break;
                    sa.resetTargets();
                    return false;
                }
                if (sa.isCurse()) {
                    choice = CountersPutAi.chooseCursedTarget(list, type, amount, ai);
                } else {
                    CardCollection lands = CardLists.filter((Iterable<Card>)list, CardPredicates.Presets.LANDS);
                    SpellAbility animate = sa.findSubAbilityByType(ApiType.Animate);
                    choice = !lands.isEmpty() && animate != null ? ComputerUtilCard.getWorstLand(lands) : ("BoonCounterOnOppCreature".equals(logic) ? ComputerUtilCard.getWorstCreatureAI(list) : CountersPutAi.chooseBoonTarget(list, type));
                }
                if (choice == null) {
                    if (sa.isTargetNumberValid() && sa.getTargets().size() != 0) break;
                    sa.resetTargets();
                    return false;
                }
                list.remove(choice);
                sa.getTargets().add(choice);
                if (!divided) continue;
                sa.addDividedAllocation(choice, amount);
                break;
            }
        }
        return chance;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        String[] types;
        int amount;
        SpellAbility root = sa.getRootAbility();
        Card source = sa.getHostCard();
        String aiLogic = sa.getParamOrDefault("AILogic", "");
        boolean preferred = true;
        String amountStr = sa.getParamOrDefault("CounterNum", "1");
        boolean divided = sa.isDividedAsYouChoose();
        int left = amount = AbilityUtils.calculateAmount(source, amountStr, sa);
        String type = "";
        if (sa.hasParam("CounterType")) {
            types = sa.getParam("CounterType").split(",");
            type = types[0];
        } else if (sa.hasParam("CounterTypes")) {
            types = sa.getParam("CounterTypes").split(",");
            type = types[0];
        }
        if ("ChargeToBestCMC".equals(aiLogic)) {
            return this.doChargeToCMCLogic(ai, sa) || mandatory;
        }
        if ("ChargeToBestOppControlledCMC".equals(aiLogic)) {
            return this.doChargeToOppCtrlCMCLogic(ai, sa) || mandatory;
        }
        if (!sa.usesTargeting()) {
            if (amountStr.equals("X") && root.getXManaCostPaid() == null && source.getXManaCostPaid() == 0 && amount == 0 && sa.hasSVar(amountStr) && sa.getSVar(amountStr).equals("Count$xPaid")) {
                int payX = ComputerUtilCost.getMaxXValue(sa, ai, true);
                root.setXManaCostPaid(payX);
            }
            if (!mandatory) {
                // empty if block
            }
        } else if (sa.getTargetRestrictions().canOnlyTgtOpponent() && !sa.getTargetRestrictions().canTgtCreature()) {
            PlayerCollection playerList = new PlayerCollection(Iterables.filter(sa.getTargetRestrictions().getAllCandidates(sa, true, true), Player.class));
            if (playerList.isEmpty()) {
                return false;
            }
            Player choice = playerList.min(PlayerPredicates.compareByZoneSize(ZoneType.Battlefield, CardPredicates.Presets.CREATURES));
            if (choice != null) {
                sa.getTargets().add(choice);
            }
        } else {
            String logic = sa.getParam("AILogic");
            if ("Fight".equals(logic) || "PowerDmg".equals(logic)) {
                int nPump = 0;
                if (type.equals("P1P1")) {
                    nPump = amount;
                }
                if (FightAi.canFightAi(ai, sa, nPump, nPump)) {
                    return true;
                }
            }
            CardCollection list = sa.isCurse() ? ai.getOpponents().getCardsIn(ZoneType.Battlefield) : new CardCollection(ai.getCardsIn(ZoneType.Battlefield));
            list = CardLists.getTargetableCards(list, sa);
            list = ComputerUtil.filterAITgts(sa, ai, list, false);
            int totalTargets = list.size();
            sa.resetTargets();
            while (sa.canAddMoreTarget()) {
                if (mandatory) {
                    if ((list.isEmpty() || !preferred) && sa.isTargetNumberValid()) {
                        return true;
                    }
                    if (list.isEmpty() && preferred) {
                        list = CardLists.getTargetableCards(ai.getOpponents().getCardsIn(ZoneType.Battlefield), sa);
                        preferred = false;
                    }
                    if (list.isEmpty()) {
                        list = CardLists.getTargetableCards(ai.getCardsIn(ZoneType.Battlefield), sa);
                        preferred = false;
                    }
                }
                if (list.isEmpty()) {
                    return sa.isTargetNumberValid();
                }
                Card choice = null;
                if (sa.isCurse()) {
                    if (preferred) {
                        choice = CountersPutAi.chooseCursedTarget(list, type, amount, ai);
                        if (choice == null && mandatory) {
                            choice = Aggregates.random(list);
                        }
                    } else {
                        choice = type.equals("M1M1") ? ComputerUtilCard.getWorstCreatureAI(list) : Aggregates.random(list);
                    }
                } else if (preferred) {
                    choice = CountersPutAi.chooseBoonTarget(list = ComputerUtil.getSafeTargets(ai, sa, list), type);
                    if (choice == null && mandatory) {
                        choice = Aggregates.random(list);
                    }
                } else {
                    choice = type.equals("P1P1") ? ComputerUtilCard.getWorstCreatureAI(list) : Aggregates.random(list);
                }
                if (choice != null && divided) {
                    int alloc = Math.max(amount / totalTargets, 1);
                    if (sa.getTargets().size() == Math.min(totalTargets, sa.getMaxTargets()) - 1) {
                        sa.addDividedAllocation(choice, left);
                    } else {
                        sa.addDividedAllocation(choice, alloc);
                        left -= alloc;
                    }
                }
                if (choice != null) {
                    sa.getTargets().add(choice);
                    list.remove(choice);
                    continue;
                }
                list.clear();
            }
        }
        return true;
    }

    @Override
    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        Card source = sa.getHostCard();
        if (mode == PlayerActionConfirmMode.Tribute) {
            CardCollection creats = player.getCreaturesInPlay();
            String amountStr = sa.getParamOrDefault("CounterNum", "1");
            int tributeAmount = AbilityUtils.calculateAmount(source, amountStr, sa);
            boolean isHaste = source.hasKeyword(Keyword.HASTE);
            CardCollection threatening = CardLists.filter((Iterable<Card>)creats, c -> CombatUtil.canBlock(source, c, !isHaste) && (c.getNetToughness() > source.getNetPower() + tributeAmount || c.hasKeyword(Keyword.DEATHTOUCH)));
            if (!threatening.isEmpty()) {
                return true;
            }
            if (source.hasSVar("TributeAILogic")) {
                String logic = source.getSVar("TributeAILogic");
                if (logic.equals("Always")) {
                    return true;
                }
                if (logic.equals("Never")) {
                    return false;
                }
                if (logic.equals("CanBlockThisTurn")) {
                    CardCollection canBlock = CardLists.filter((Iterable<Card>)creats, c -> CombatUtil.canBlock(source, c) && (c.getNetToughness() > source.getNetPower() || c.hasKeyword(Keyword.DEATHTOUCH)));
                    if (!canBlock.isEmpty()) {
                        return false;
                    }
                } else {
                    if (logic.equals("DontControlCreatures")) {
                        return !creats.isEmpty();
                    }
                    if (logic.equals("OppHasCardsInHand")) {
                        return sa.getActivatingPlayer().getCardsIn(ZoneType.Hand).isEmpty();
                    }
                }
            }
        }
        return MyRandom.getRandom().nextBoolean();
    }

    @Override
    public Player chooseSinglePlayer(Player ai, SpellAbility sa, Iterable<Player> options, Map<String, Object> params) {
        ArrayList<Player> list = Lists.newArrayList(options);
        return Collections.min(list, PlayerPredicates.compareByLife());
    }

    @Override
    protected Card chooseSingleCard(Player ai, SpellAbility sa, Iterable<Card> options, boolean isOptional, Player targetedPlayer, Map<String, Object> params) {
        CardCollection notUseless;
        CardCollection mine;
        CardCollection opponents;
        CounterType m1m1 = CounterType.get(CounterEnumType.M1M1);
        CounterType p1p1 = CounterType.get(CounterEnumType.P1P1);
        if (!isOptional && Iterables.size(options) <= 1) {
            return Iterables.getFirst(options, null);
        }
        ArrayList<CounterType> types = Lists.newArrayList();
        if (params.containsKey("CounterType")) {
            types.add((CounterType)params.get("CounterType"));
        } else {
            for (String s2 : sa.getParam("CounterType").split(",")) {
                types.add(CounterType.getType(s2));
            }
        }
        String amountStr = sa.getParamOrDefault("CounterNum", "1");
        int amount = AbilityUtils.calculateAmount(sa.getHostCard(), amountStr, sa);
        boolean isCurse = sa.isCurse();
        if (isCurse && !(opponents = CardLists.filterControlledBy(options, ai.getOpponents())).isEmpty()) {
            CardCollection negative = CardLists.filter((Iterable<Card>)opponents, input -> {
                if (input.hasSVar("EndOfTurnLeavePlay")) {
                    return false;
                }
                if (ComputerUtilCard.isUselessCreature(ai, input)) {
                    return false;
                }
                for (CounterType type : types) {
                    if (type.is(CounterEnumType.M1M1) && amount >= input.getNetToughness()) {
                        return true;
                    }
                    if (!ComputerUtil.isNegativeCounter(type, input)) continue;
                    return true;
                }
                return false;
            });
            if (!negative.isEmpty()) {
                return ComputerUtilCard.getBestAI(negative);
            }
            if (!isOptional) {
                return ComputerUtilCard.getBestAI(opponents);
            }
        }
        if ((mine = CardLists.filterControlledBy(options, ai)).isEmpty()) {
            CardCollection ally = CardLists.filterControlledBy(options, ai.getAllies());
            if (!ally.isEmpty()) {
                return ComputerUtilCard.getBestAI(ally);
            }
            return isOptional ? null : ComputerUtilCard.getWorstAI(options);
        }
        CardCollection filtered = mine;
        CardCollection doNotHaveKeyword = new CardCollection();
        for (CounterType type : types) {
            if (!type.isKeywordCounter()) continue;
            doNotHaveKeyword.addAll(CardLists.getNotKeyword((Iterable<Card>)filtered, Keyword.smartValueOf(type.getName())));
        }
        if (doNotHaveKeyword.size() > 0) {
            filtered = doNotHaveKeyword;
        }
        if (!(notUseless = CardLists.filter((Iterable<Card>)filtered, input -> {
            if (input.hasSVar("EndOfTurnLeavePlay")) {
                return false;
            }
            return !ComputerUtilCard.isUselessCreature(ai, input);
        })).isEmpty()) {
            filtered = notUseless;
        }
        for (CounterType type : types) {
            CardCollection undying;
            if (p1p1.equals(type)) {
                CardCollection persist = CardLists.filter((Iterable<Card>)filtered, input -> {
                    if (!input.hasKeyword(Keyword.PERSIST)) {
                        return false;
                    }
                    return input.getCounters(m1m1) <= amount;
                });
                if (persist.isEmpty()) continue;
                filtered = persist;
                continue;
            }
            if (!m1m1.equals(type) || (undying = CardLists.filter((Iterable<Card>)filtered, input -> {
                if (!input.hasKeyword(Keyword.UNDYING)) {
                    return false;
                }
                return input.getCounters(p1p1) <= amount && input.getNetToughness() > amount;
            })).isEmpty()) continue;
            filtered = undying;
        }
        return ComputerUtilCard.getBestAI(filtered);
    }

    @Override
    public CounterType chooseCounterType(List<CounterType> options, SpellAbility sa, Map<String, Object> params) {
        Player ai = sa.getActivatingPlayer();
        GameEntity e = (GameEntity)params.get("Target");
        if (e instanceof Card) {
            Card c = (Card)e;
            if (c.getController().isOpponentOf(ai)) {
                if (options.contains(CounterType.get(CounterEnumType.M1M1)) && !c.hasKeyword(Keyword.UNDYING)) {
                    return CounterType.get(CounterEnumType.M1M1);
                }
                for (CounterType type : options) {
                    if (!ComputerUtil.isNegativeCounter(type, c)) continue;
                    return type;
                }
            } else {
                for (CounterType type : options) {
                    if (ComputerUtil.isNegativeCounter(type, c) || ComputerUtil.isUselessCounter(type, c)) continue;
                    return type;
                }
            }
        } else if (e instanceof Player) {
            Player p = (Player)e;
            if (p.isOpponentOf(ai)) {
                if (options.contains(CounterType.get(CounterEnumType.POISON))) {
                    return CounterType.get(CounterEnumType.POISON);
                }
            } else if (options.contains(CounterType.get(CounterEnumType.EXPERIENCE))) {
                return CounterType.get(CounterEnumType.EXPERIENCE);
            }
        }
        return Iterables.getFirst(options, null);
    }

    private boolean doMoveCounterLogic(Player ai, SpellAbility sa, PhaseHandler ph) {
        boolean threatened;
        int creatDiff = sa.getParam("AILogic").contains("IsCounterUser") ? 450 : 1;
        Combat combat = ai.getGame().getCombat();
        Card source = sa.getHostCard();
        boolean bl = threatened = ComputerUtil.predictThreatenedObjects(ai, null, true).contains(source) || combat != null && (combat.isBlocked(source) && ComputerUtilCombat.attackerWouldBeDestroyed(ai, source, combat) && !ComputerUtilCombat.willKillAtLeastOne(ai, source, combat) || combat.isBlocking(source) && ComputerUtilCombat.blockerWouldBeDestroyed(ai, source, combat) && !ComputerUtilCombat.willKillAtLeastOne(ai, source, combat));
        if (!(threatened || ph.is(PhaseType.END_OF_TURN) && ph.getNextTurn() == ai)) {
            return false;
        }
        CardCollection targets = CardLists.getTargetableCards(ai.getCreaturesInPlay(), sa);
        targets.remove(source);
        targets = CardLists.filter((Iterable<Card>)targets, card -> {
            boolean tgtThreatened = ComputerUtil.predictThreatenedObjects(ai, null, true).contains(card) || combat != null && (combat.isBlocked((Card)card) && ComputerUtilCombat.attackerWouldBeDestroyed(ai, card, combat) || combat.isBlocking((Card)card) && ComputerUtilCombat.blockerWouldBeDestroyed(ai, card, combat));
            return !tgtThreatened && (threatened || ComputerUtilCard.evaluateCreature(card, false, false) > ComputerUtilCard.evaluateCreature(source, false, false) + creatDiff);
        });
        Card bestTgt = ComputerUtilCard.getBestCreatureAI(targets);
        if (bestTgt != null) {
            sa.getTargets().add(bestTgt);
            return true;
        }
        return false;
    }

    private boolean doCombatAdaptLogic(Card source, int amount, Combat combat) {
        if (combat.isAttacking(source)) {
            if (!combat.isBlocked(source)) {
                return true;
            }
            for (Card blockedBy : combat.getBlockers(source)) {
                if (blockedBy.getNetToughness() <= source.getNetPower() || blockedBy.getNetToughness() > source.getNetPower() + amount) continue;
                return true;
            }
            int totBlkPower = Aggregates.sum(combat.getBlockers(source), Card::getNetPower);
            if (source.getNetToughness() <= totBlkPower && source.getNetToughness() + amount > totBlkPower) {
                return true;
            }
        } else if (combat.isBlocking(source)) {
            for (Card blocked : combat.getAttackersBlockedBy(source)) {
                if (blocked.getNetToughness() <= source.getNetPower() || blocked.getNetToughness() > source.getNetPower() + amount) continue;
                return true;
            }
            int totAtkPower = Aggregates.sum(combat.getAttackersBlockedBy(source), Card::getNetPower);
            if (source.getNetToughness() <= totAtkPower && source.getNetToughness() + amount > totAtkPower) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int chooseNumber(Player player, SpellAbility sa, int min2, int max, Map<String, Object> params) {
        if (sa.hasParam("ReadAhead")) {
            return 1;
        }
        return max;
    }

    private boolean doChargeToCMCLogic(Player ai, SpellAbility sa) {
        Card source = sa.getHostCard();
        CardCollection ownLib = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Library), CardPredicates.isType("Creature"));
        int numCtrs = source.getCounters(CounterEnumType.CHARGE);
        int maxCMC = Aggregates.max(ownLib, Card::getCMC);
        int optimalCMC = 0;
        int curAmount = 0;
        for (int cmc = numCtrs; cmc <= maxCMC; ++cmc) {
            int numPerCMC = CardLists.filter((Iterable<Card>)ownLib, CardPredicates.hasCMC(cmc)).size();
            if (numPerCMC < curAmount) continue;
            curAmount = numPerCMC;
            optimalCMC = cmc;
        }
        return numCtrs < optimalCMC;
    }

    private boolean doChargeToOppCtrlCMCLogic(Player ai, SpellAbility sa) {
        Card source = sa.getHostCard();
        CardCollection oppInPlay = CardLists.filter((Iterable<Card>)ai.getOpponents().getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.NONLAND_PERMANENTS);
        int numCtrs = source.getCounters(CounterEnumType.CHARGE);
        int maxCMC = Aggregates.max(oppInPlay, Card::getCMC);
        int optimalCMC = 0;
        int curAmount = 0;
        for (int cmc = numCtrs; cmc <= maxCMC; ++cmc) {
            int numPerCMC = CardLists.filter((Iterable<Card>)oppInPlay, CardPredicates.hasCMC(cmc)).size();
            if (numPerCMC < curAmount) continue;
            curAmount = numPerCMC;
            optimalCMC = cmc;
        }
        return numCtrs < optimalCMC;
    }
}

