/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.ai.AiProps;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCard;
import forge.ai.PlayerControllerAi;
import forge.ai.SpellAbilityAi;
import forge.game.GameEntity;
import forge.game.card.Card;
import forge.game.card.CardCopyService;
import forge.game.card.CardLists;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class CountersProliferateAi
extends SpellAbilityAi {
    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        ArrayList<Card> cperms = Lists.newArrayList();
        boolean allyExpOrEnergy = false;
        for (Player p : ai.getYourTeam()) {
            if (p.getCounters(CounterEnumType.EXPERIENCE) + p.getCounters(CounterEnumType.ENERGY) >= 1) {
                allyExpOrEnergy = true;
            }
            cperms.addAll(CardLists.filter((Iterable<Card>)p.getCardsIn(ZoneType.Battlefield), crd -> {
                if (!crd.hasCounters()) {
                    return false;
                }
                if (crd.isPlaneswalker()) {
                    return true;
                }
                for (Map.Entry<CounterType, Integer> e : crd.getCounters().entrySet()) {
                    if (e.getValue() < 1 || ComputerUtil.isNegativeCounter(e.getKey(), crd)) continue;
                    return true;
                }
                return false;
            }));
        }
        ArrayList<Card> hperms = Lists.newArrayList();
        boolean opponentPoison = false;
        for (Player o : ai.getOpponents()) {
            opponentPoison |= o.getPoisonCounters() > 0 && o.canReceiveCounters(CounterEnumType.POISON);
            hperms.addAll(CardLists.filter((Iterable<Card>)o.getCardsIn(ZoneType.Battlefield), crd -> {
                if (!crd.hasCounters()) {
                    return false;
                }
                if (crd.isPlaneswalker()) {
                    return false;
                }
                for (Map.Entry<CounterType, Integer> e : crd.getCounters().entrySet()) {
                    if (e.getValue() < 1 || !ComputerUtil.isNegativeCounter(e.getKey(), crd)) continue;
                    return true;
                }
                return false;
            }));
        }
        return !cperms.isEmpty() || !hperms.isEmpty() || opponentPoison || allyExpOrEnergy;
    }

    @Override
    protected boolean doTriggerAINoCost(Player aiPlayer, SpellAbility sa, boolean mandatory) {
        boolean chance = true;
        return chance;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        if ("Always".equals(sa.getParam("AILogic"))) {
            return true;
        }
        return this.checkApiLogic(ai, sa);
    }

    @Override
    public <T extends GameEntity> T chooseSingleEntity(Player ai, SpellAbility sa, Collection<T> options, boolean isOptional, Player targetedPlayer, Map<String, Object> params) {
        CounterType poison = CounterType.get(CounterEnumType.POISON);
        boolean aggroAI = ((PlayerControllerAi)ai.getController()).getAi().getBooleanProperty(AiProps.PLAY_AGGRO);
        for (Player p : Iterables.filter(options, Player.class)) {
            if (!(p.isOpponentOf(ai) ? p.getCounters(poison) > 0 && p.canReceiveCounters(poison) : (p.getCounters(poison) <= 5 && aggroAI || p.getCounters(poison) == 0) && p.getCounters(CounterEnumType.EXPERIENCE) + p.getCounters(CounterEnumType.ENERGY) >= 1 || !p.canReceiveCounters(poison))) continue;
            return (T)p;
        }
        for (Card c : Iterables.filter(options, Card.class)) {
            if (c.isPlaneswalker()) {
                if (c.getController().isOpponentOf(ai)) continue;
                return (T)c;
            }
            if (c.isBattle()) {
                if (c.getProtectingPlayer().isOpponentOf(ai)) continue;
                return (T)c;
            }
            Card lki = CardCopyService.getLKICopy(c);
            boolean hasNegative = false;
            for (CounterType ct : c.getCounters().keySet()) {
                hasNegative = hasNegative || ComputerUtil.isNegativeCounter(ct, c);
                lki.setCounters(ct, (Integer)(lki.getCounters(ct) + 1));
            }
            if (!(c.isCreature() ? c.getController().isOpponentOf(ai) == ComputerUtilCard.evaluateCreature(lki, true, false) < ComputerUtilCard.evaluateCreature(c, true, false) : !c.getController().isOpponentOf(ai) && !hasNegative)) continue;
            return (T)c;
        }
        return null;
    }
}

