/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Iterables;
import forge.ai.ComputerUtilCard;
import forge.ai.SpellAbilityAi;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.keyword.Keyword;
import forge.game.player.Player;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;

public abstract class CountersAi
extends SpellAbilityAi {
    public static Card chooseCursedTarget(CardCollectionView list, String type, int amount, Player ai) {
        CardCollection killable;
        if (amount == 1 && Iterables.any(ai.getOpponents().getCardsIn(ZoneType.Battlefield), CardPredicates.nameEquals("Vorinclex, Monstrous Raider"))) {
            return null;
        }
        Card choice = type.equals("M1M1") ? ((killable = CardLists.getNotKeyword((Iterable<Card>)CardLists.filterToughness(list, amount), Keyword.UNDYING)).size() > 0 ? ComputerUtilCard.getBestCreatureAI(killable) : ComputerUtilCard.getBestCreatureAI(list)) : Aggregates.random(list);
        return choice;
    }

    public static Card chooseBoonTarget(CardCollectionView list, String type) {
        Card choice = null;
        if (type.equals("P1P1")) {
            choice = ComputerUtilCard.getBestCreatureAI(list);
            if (choice == null) {
                choice = ComputerUtilCard.getBestLandToAnimate(list);
            }
        } else if (type.equals("DIVINITY")) {
            CardCollection boon = CardLists.filter((Iterable<Card>)list, c -> c.getCounters(CounterEnumType.DIVINITY) == 0);
            choice = ComputerUtilCard.getMostExpensivePermanentAI(boon);
        } else {
            choice = CounterType.get(type).isKeywordCounter() ? ComputerUtilCard.getBestCreatureAI(CardLists.getNotKeyword((Iterable<Card>)list, type)) : Aggregates.random(list);
        }
        return choice;
    }
}

