/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import forge.ai.AiPlayDecision;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.ComputerUtilCost;
import forge.ai.SpecialCardAi;
import forge.ai.SpellAbilityAi;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameObject;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardUtil;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.Map;

public class CopyPermanentAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player aiPlayer, SpellAbility sa) {
        CardCollection valid;
        Card source = sa.getHostCard();
        PhaseHandler ph = aiPlayer.getGame().getPhaseHandler();
        String aiLogic = sa.getParamOrDefault("AILogic", "");
        if (ComputerUtil.preventRunAwayActivations(sa)) {
            return false;
        }
        if ("MomirAvatar".equals(aiLogic)) {
            return SpecialCardAi.MomirVigAvatar.consider(aiPlayer, sa);
        }
        if ("MimicVat".equals(aiLogic)) {
            return SpecialCardAi.MimicVat.considerCopy(aiPlayer, sa);
        }
        if ("AtEOT".equals(aiLogic)) {
            return ph.is(PhaseType.END_OF_TURN);
        }
        if ("AtOppEOT".equals(aiLogic)) {
            return ph.is(PhaseType.END_OF_TURN) && ph.getPlayerTurn() != aiPlayer;
        }
        if ("DuplicatePerms".equals(aiLogic) && (valid = AbilityUtils.getDefinedCards(source, sa.getParam("Defined"), sa)).size() < 2) {
            return false;
        }
        if (sa.hasParam("AtEOT") && !ph.is(PhaseType.MAIN1)) {
            return false;
        }
        if (sa.hasParam("Defined") && sa.getParam("Defined").equals("Imprinted.ExiledWithSource") && source.getImprintedCards().isEmpty()) {
            return false;
        }
        if ((sa.isEmbalm() || sa.isEternalize()) && ComputerUtilCard.checkNeedsToPlayReqs(sa.getHostCard(), sa) != AiPlayDecision.WillPlay) {
            return false;
        }
        if (sa.costHasManaX() && sa.getSVar("X").equals("Count$xPaid")) {
            int xPay = ComputerUtilCost.getMaxXValue(sa, aiPlayer, sa.isTrigger());
            sa.setXManaCostPaid(xPay);
        }
        if (sa.usesTargeting() && sa.hasParam("TargetingPlayer")) {
            sa.resetTargets();
            Player targetingPlayer = (Player)AbilityUtils.getDefinedPlayers(source, sa.getParam("TargetingPlayer"), sa).get(false);
            sa.setTargetingPlayer(targetingPlayer);
            return targetingPlayer.getController().chooseTargetsFor(sa);
        }
        if (sa.usesTargeting() && sa.getTargetRestrictions().canTgtPlayer()) {
            if (!sa.isCurse()) {
                if (sa.canTarget(aiPlayer)) {
                    sa.getTargets().add(aiPlayer);
                    return true;
                }
                for (Player p : aiPlayer.getYourTeam()) {
                    if (!sa.canTarget(p)) continue;
                    sa.getTargets().add(p);
                    return true;
                }
                return false;
            }
            for (Player p : aiPlayer.getOpponents()) {
                if (!sa.canTarget(p)) continue;
                sa.getTargets().add(p);
                return true;
            }
            return false;
        }
        return this.doTriggerAINoCost(aiPlayer, sa, false);
    }

    @Override
    protected boolean doTriggerAINoCost(Player aiPlayer, SpellAbility sa, boolean mandatory) {
        Card host = sa.getHostCard();
        Player activator = sa.getActivatingPlayer();
        Game game = host.getGame();
        String sourceName = ComputerUtilAbility.getAbilitySourceName(sa);
        String aiLogic = sa.getParamOrDefault("AILogic", "");
        boolean canCopyLegendary = sa.hasParam("NonLegendary");
        if (sa.usesTargeting()) {
            CardCollection felidarGuardian;
            sa.resetTargets();
            CardCollection list = CardUtil.getValidCardsToTarget(sa);
            if (aiLogic.equals("Different")) {
                list = CardLists.filter(list, Predicates.not(CardPredicates.nameEquals(host.getName())));
            }
            if (list.isEmpty()) {
                return false;
            }
            CardCollection betterList = CardLists.filter((Iterable<Card>)list, Predicates.not(CardPredicates.isRemAIDeck()));
            if (betterList.isEmpty()) {
                if (!mandatory) {
                    return false;
                }
            } else {
                list = betterList;
            }
            if ("Saheeli Rai".equals(sourceName) && (felidarGuardian = CardLists.filter((Iterable<Card>)list, CardPredicates.nameEquals("Felidar Guardian"))).size() > 0) {
                sa.getTargets().add((GameObject)felidarGuardian.get(false));
                return true;
            }
            while (sa.canAddMoreTarget()) {
                if (list.isEmpty()) {
                    if (!sa.isTargetNumberValid() || sa.getTargets().size() == 0) {
                        sa.resetTargets();
                        return false;
                    }
                    break;
                }
                Card choice = Iterables.any(list = CardLists.filter((Iterable<Card>)list, c -> !c.getType().isLegendary() || canCopyLegendary || !c.getController().equals(aiPlayer)), CardPredicates.Presets.CREATURES) ? (sa.hasParam("TargetingPlayer") ? ComputerUtilCard.getWorstCreatureAI(list) : ComputerUtilCard.getBestCreatureAI(list)) : ComputerUtilCard.getMostExpensivePermanentAI(list);
                if (choice == null) {
                    if (!sa.isTargetNumberValid() || sa.getTargets().size() == 0) {
                        sa.resetTargets();
                        return false;
                    }
                    break;
                }
                list.remove(choice);
                sa.getTargets().add(choice);
            }
        } else if (sa.hasParam("Choices")) {
            CardCollectionView choices = game.getCardsIn(ZoneType.Battlefield);
            CardCollection betterChoices = this.getBetterOptions(aiPlayer, sa, choices = CardLists.getValidCards((Iterable<Card>)choices, sa.getParam("Choices"), activator, host, (CardTraitBase)sa), !mandatory);
            if (betterChoices.isEmpty()) {
                return mandatory;
            }
        }
        if ("TriggeredCardController".equals(sa.getParam("Controller"))) {
            Card trigCard = (Card)sa.getTriggeringObject(AbilityKey.Card);
            if (!mandatory && trigCard != null && trigCard.getController().isOpponentOf(aiPlayer)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        return true;
    }

    @Override
    public Card chooseSingleCard(Player ai, SpellAbility sa, Iterable<Card> options, boolean isOptional, Player targetedPlayer, Map<String, Object> params) {
        CardCollection betterOptions = this.getBetterOptions(ai, sa, options, isOptional);
        if (!betterOptions.isEmpty()) {
            options = betterOptions;
        }
        return ComputerUtilCard.getBestAI(options);
    }

    private CardCollection getBetterOptions(Player ai, SpellAbility sa, Iterable<Card> options, boolean isOptional) {
        Card host = sa.getHostCard();
        Player ctrl = host.getController();
        boolean canCopyLegendary = sa.hasParam("NonLegendary");
        String filter = canCopyLegendary ? "Permanent" : "Permanent.YouDontCtrl,Permanent.nonLegendary";
        return CardLists.getValidCards(options, filter, ctrl, host, (CardTraitBase)sa);
    }

    @Override
    protected Player chooseSinglePlayer(Player ai, SpellAbility sa, Iterable<Player> options, Map<String, Object> params) {
        if (params != null && params.containsKey("Attacker")) {
            return (Player)ComputerUtilCombat.addAttackerToCombat(sa, (Card)params.get("Attacker"), options);
        }
        CardCollection cards = new PlayerCollection(options).getCreaturesInPlay();
        Card chosen = ComputerUtilCard.getBestCreatureAI(cards);
        return chosen != null ? chosen.getController() : (Player)Iterables.getFirst(options, null);
    }

    @Override
    protected GameEntity chooseSingleAttackableEntity(Player ai, SpellAbility sa, Iterable<GameEntity> options, Map<String, Object> params) {
        if (params != null && params.containsKey("Attacker")) {
            return ComputerUtilCombat.addAttackerToCombat(sa, (Card)params.get("Attacker"), options);
        }
        return super.chooseSingleAttackableEntity(ai, sa, options, params);
    }
}

