/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.SpecialCardAi;
import forge.ai.SpellAbilityAi;
import forge.game.Game;
import forge.game.GameObject;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerPredicates;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetRestrictions;
import forge.game.staticability.StaticAbilityMustTarget;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import java.util.ArrayList;
import java.util.Map;

public class ControlGainAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        ArrayList<String> lose = Lists.newArrayList();
        if (sa.hasParam("LoseControl")) {
            lose.addAll(Lists.newArrayList(sa.getParam("LoseControl").split(",")));
        }
        TargetRestrictions tgt = sa.getTargetRestrictions();
        Game game = ai.getGame();
        PlayerCollection opponents = ai.getOpponents();
        if (tgt == null) {
            if (sa.hasParam("AllValid")) {
                CardCollectionView tgtCards = opponents.getCardsIn(ZoneType.Battlefield);
                return !(tgtCards = AbilityUtils.filterListByType(tgtCards, sa.getParam("AllValid"), sa)).isEmpty();
            }
            return true;
        }
        sa.resetTargets();
        if (sa.hasParam("TargetingPlayer")) {
            Player targetingPlayer = (Player)AbilityUtils.getDefinedPlayers(sa.getHostCard(), sa.getParam("TargetingPlayer"), sa).get(false);
            sa.setTargetingPlayer(targetingPlayer);
            return targetingPlayer.getController().chooseTargetsFor(sa);
        }
        if (tgt.canOnlyTgtOpponent()) {
            PlayerCollection oppList = opponents.filter(PlayerPredicates.isTargetableBy(sa));
            if (oppList.isEmpty()) {
                return false;
            }
            if (tgt.isRandomTarget()) {
                sa.getTargets().add(Aggregates.random(oppList));
            } else {
                sa.getTargets().add((GameObject)oppList.get(0));
            }
        }
        if (lose.contains("EOT") && game.getPhaseHandler().getPhase().isAfter(PhaseType.COMBAT_DECLARE_ATTACKERS) && !sa.isTrigger()) {
            return false;
        }
        if (sa.hasParam("Defined")) {
            return true;
        }
        CardCollection list = opponents.getCardsIn(ZoneType.Battlefield);
        list = ComputerUtil.filterAITgts(sa, ai, list, false);
        if ((list = CardLists.filter((Iterable<Card>)list, c -> {
            if (!sa.canTarget((GameObject)c)) {
                return false;
            }
            if (sa.isTrigger()) {
                return true;
            }
            if (!c.canBeControlledBy(ai)) {
                return false;
            }
            if (!lose.contains("EOT") && c.hasSVar("EndOfTurnLeavePlay")) {
                return false;
            }
            if (c.isCreature()) {
                if (c.getNetCombatDamage() <= 0) {
                    return false;
                }
                boolean found = false;
                for (Player opp : opponents) {
                    if (!ComputerUtilCombat.canAttackNextTurn(c, opp)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return false;
                }
            }
            return !ComputerUtilCard.isCardRemAIDeck(c);
        })).isEmpty()) {
            return false;
        }
        int creatures = 0;
        int artifacts = 0;
        int planeswalkers = 0;
        int lands = 0;
        int enchantments = 0;
        for (Card c2 : list) {
            if (c2.isCreature()) {
                ++creatures;
            }
            if (c2.isArtifact()) {
                ++artifacts;
            }
            if (c2.isLand()) {
                ++lands;
            }
            if (c2.isEnchantment()) {
                ++enchantments;
            }
            if (!c2.isPlaneswalker()) continue;
            ++planeswalkers;
        }
        while (sa.canAddMoreTarget()) {
            Card t2 = null;
            if (list.isEmpty()) {
                if (sa.getTargets().size() >= tgt.getMinTargets(sa.getHostCard(), sa) && sa.getTargets().size() != 0) break;
                sa.resetTargets();
                return false;
            }
            while (t2 == null) {
                CardCollection originalList = new CardCollection(list);
                boolean mustTargetFiltered = StaticAbilityMustTarget.filterMustTargetCards(ai, list, sa);
                t2 = planeswalkers > 0 ? ComputerUtilCard.getBestPlaneswalkerAI(list) : (creatures > 0 ? ComputerUtilCard.getBestCreatureAI(list) : (artifacts > 0 ? ComputerUtilCard.getBestArtifactAI(list) : (lands > 0 ? ComputerUtilCard.getBestLandAI(list) : (enchantments > 0 ? ComputerUtilCard.getBestEnchantmentAI(list, sa, false) : ComputerUtilCard.getMostExpensivePermanentAI(list)))));
                if (t2 != null) {
                    if (t2.isCreature()) {
                        --creatures;
                    }
                    if (t2.isPlaneswalker()) {
                        --planeswalkers;
                    }
                    if (t2.isLand()) {
                        --lands;
                    }
                    if (t2.isArtifact()) {
                        --artifacts;
                    }
                    if (t2.isEnchantment()) {
                        --enchantments;
                    }
                }
                if (mustTargetFiltered) {
                    list = originalList;
                }
                if (sa.canTarget(t2)) continue;
                list.remove(t2);
                t2 = null;
                if (!list.isEmpty()) continue;
                break;
            }
            if (t2 == null) continue;
            sa.getTargets().add(t2);
            list.remove(t2);
        }
        return true;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        if (!sa.usesTargeting()) {
            if (mandatory) {
                return true;
            }
        } else if (sa.hasParam("TargetingPlayer") || !this.canPlayAI(ai, sa) && mandatory) {
            if (sa.getTargetRestrictions().canOnlyTgtOpponent()) {
                PlayerCollection oppList = ai.getOpponents().filter(PlayerPredicates.isTargetableBy(sa));
                if (oppList.isEmpty()) {
                    return false;
                }
                sa.getTargets().add(Aggregates.random(oppList));
                return true;
            }
            CardCollection list = CardLists.getTargetableCards(ai.getCardsIn(ZoneType.Battlefield), sa);
            if (list.isEmpty()) {
                return false;
            }
            sa.getTargets().add(ComputerUtilCard.getWorstAI(list));
        }
        return true;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        Game game = ai.getGame();
        if (sa.hasParam("AILogic") && "DonateTargetPerm".equals(sa.getParam("AILogic"))) {
            return SpecialCardAi.Donate.considerDonatingPermanent(ai, sa);
        }
        if (!sa.usesTargeting()) {
            if (sa.hasParam("AllValid")) {
                CardCollectionView tgtCards = ai.getOpponents().getCardsIn(ZoneType.Battlefield);
                if ((tgtCards = AbilityUtils.filterListByType(tgtCards, sa.getParam("AllValid"), sa)).isEmpty()) {
                    return false;
                }
            }
            ArrayList<String> lose = Lists.newArrayList();
            if (sa.hasParam("LoseControl")) {
                lose.addAll(Lists.newArrayList(sa.getParam("LoseControl").split(",")));
            }
            return !lose.contains("EOT") || !game.getPhaseHandler().getPhase().isAfter(PhaseType.COMBAT_DECLARE_ATTACKERS);
        }
        return this.canPlayAI(ai, sa);
    }

    @Override
    protected Player chooseSinglePlayer(Player ai, SpellAbility sa, Iterable<Player> options, Map<String, Object> params) {
        ArrayList<Card> cards = Lists.newArrayList();
        for (Player p : options) {
            cards.addAll(p.getCreaturesInPlay());
        }
        Card chosen = ComputerUtilCard.getBestCreatureAI(cards);
        return chosen != null ? chosen.getController() : (Player)Iterables.getFirst(options, null);
    }
}

