/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import forge.ai.AiAttackController;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.SpellAbilityAi;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameObject;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.combat.Combat;
import forge.game.cost.Cost;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import java.util.List;
import java.util.Map;

public class ChooseSourceAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        Card host = sa.getHostCard();
        Cost abCost = sa.getPayCosts();
        Card source = sa.getHostCard();
        if (abCost != null && !this.willPayCosts(ai, sa, abCost, source)) {
            return false;
        }
        if (sa.usesTargeting()) {
            sa.resetTargets();
            Player opp = AiAttackController.choosePreferredDefenderPlayer(ai);
            if (sa.canTarget(opp)) {
                sa.getTargets().add(opp);
            } else {
                return false;
            }
        }
        if (sa.hasParam("AILogic")) {
            Game game = ai.getGame();
            if (sa.getParam("AILogic").equals("NeedsPrevention")) {
                Combat combat;
                if (!game.getStack().isEmpty()) {
                    SpellAbility topStack = game.getStack().peekAbility();
                    if (sa.hasParam("Choices") && !topStack.matchesValid(topStack.getHostCard(), sa.getParam("Choices").split(","))) {
                        return false;
                    }
                    ApiType threatApi = topStack.getApi();
                    if (threatApi != ApiType.DealDamage && threatApi != ApiType.DamageAll) {
                        return false;
                    }
                    Card threatSource = topStack.getHostCard();
                    PlayerCollection objects = !topStack.usesTargeting() && topStack.hasParam("ValidPlayers") && !topStack.hasParam("Defined") ? AbilityUtils.getDefinedPlayers(threatSource, topStack.getParam("ValidPlayers"), topStack) : ChooseSourceAi.getTargets(topStack);
                    if (!objects.contains(ai) || topStack.hasParam("NoPrevention")) {
                        return false;
                    }
                    int dmg = AbilityUtils.calculateAmount(threatSource, topStack.getParam("NumDmg"), topStack);
                    return ComputerUtilCombat.predictDamageTo(ai, dmg, threatSource, false) > 0;
                }
                if (game.getPhaseHandler().getPhase() != PhaseType.COMBAT_DECLARE_BLOCKERS) {
                    return false;
                }
                CardCollectionView choices = game.getCardsIn(ZoneType.Battlefield);
                if (sa.hasParam("Choices")) {
                    choices = CardLists.getValidCards((Iterable<Card>)choices, sa.getParam("Choices"), host.getController(), host, (CardTraitBase)sa);
                }
                return !(choices = CardLists.filter((Iterable<Card>)choices, arg_0 -> ChooseSourceAi.lambda$canPlayAI$0(combat = game.getCombat(), ai, arg_0))).isEmpty();
            }
        }
        return true;
    }

    @Override
    public Card chooseSingleCard(Player aiChoser, SpellAbility sa, Iterable<Card> options, boolean isOptional, Player targetedPlayer, Map<String, Object> params) {
        if ("NeedsPrevention".equals(sa.getParam("AILogic"))) {
            Card chosenCard;
            Player ai = sa.getActivatingPlayer();
            Game game = ai.getGame();
            if (!game.getStack().isEmpty() && (chosenCard = this.chooseCardOnStack(sa, ai, game)) != null) {
                return chosenCard;
            }
            Combat combat = game.getCombat();
            CardCollection permanentSources = CardLists.filter(options, c -> {
                if (c == null || c.getZone() == null || c.getZone().getZoneType() != ZoneType.Battlefield || combat == null || !combat.isAttacking((Card)c, ai) || !combat.isUnblocked((Card)c)) {
                    return false;
                }
                return ComputerUtilCombat.damageIfUnblocked(c, ai, combat, true) > 0;
            });
            Card bestCreature = ComputerUtilCard.getBestCreatureAI(permanentSources);
            if (bestCreature != null) {
                return bestCreature;
            }
            if (!Iterables.isEmpty(options)) {
                CardCollection oppCreatures = CardLists.filter(options, Predicates.and(CardPredicates.Presets.CREATURES, Predicates.not(CardPredicates.isOwner(aiChoser))));
                CardCollection aiNonCreatures = CardLists.filter(options, Predicates.and(Predicates.not(CardPredicates.Presets.CREATURES), CardPredicates.Presets.PERMANENTS, CardPredicates.isOwner(aiChoser)));
                if (!oppCreatures.isEmpty()) {
                    return ComputerUtilCard.getBestCreatureAI(oppCreatures);
                }
                if (!aiNonCreatures.isEmpty()) {
                    return Aggregates.random(aiNonCreatures);
                }
                return Aggregates.random(options);
            }
            if (!game.getStack().isEmpty()) {
                return game.getStack().peekAbility().getHostCard();
            }
            System.err.println("Unexpected behavior: The AI was unable to choose anything for AF ChooseSource in " + sa.getHostCard() + ", the game will likely hang.");
            return null;
        }
        return ComputerUtilCard.getBestAI(options);
    }

    private Card chooseCardOnStack(SpellAbility sa, Player ai, Game game) {
        for (SpellAbilityStackInstance si : game.getStack()) {
            int dmg;
            ApiType threatApi;
            Card source = si.getSourceCard();
            SpellAbility abilityOnStack = si.getSpellAbility();
            if (sa.hasParam("Choices") && !abilityOnStack.matchesValid(source, sa.getParam("Choices").split(",")) || (threatApi = abilityOnStack.getApi()) != ApiType.DealDamage && threatApi != ApiType.DamageAll) continue;
            PlayerCollection objects = ChooseSourceAi.getTargets(abilityOnStack);
            if (!abilityOnStack.usesTargeting() && !abilityOnStack.hasParam("Defined") && abilityOnStack.hasParam("ValidPlayers")) {
                objects = AbilityUtils.getDefinedPlayers(source, abilityOnStack.getParam("ValidPlayers"), abilityOnStack);
            }
            if (!objects.contains(ai) || abilityOnStack.hasParam("NoPrevention") || ComputerUtilCombat.predictDamageTo(ai, dmg = AbilityUtils.calculateAmount(source, abilityOnStack.getParam("NumDmg"), abilityOnStack), source, false) <= 0) continue;
            return source;
        }
        return null;
    }

    private static List<GameObject> getTargets(SpellAbility sa) {
        return sa.usesTargeting() && !sa.hasParam("Defined") ? sa.getTargets() : AbilityUtils.getDefinedObjects(sa.getHostCard(), sa.getParam("Defined"), sa);
    }

    private static /* synthetic */ boolean lambda$canPlayAI$0(Combat combat, Player ai, Card c) {
        if (combat == null || !combat.isAttacking(c, ai) || !combat.isUnblocked(c)) {
            return false;
        }
        return ComputerUtilCombat.damageIfUnblocked(c, ai, combat, true) > 0;
    }
}

