/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCost;
import forge.ai.SpellAbilityAi;
import forge.ai.SpellApiToAi;
import forge.card.MagicColor;
import forge.game.Game;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.cost.Cost;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import forge.util.collect.FCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ChooseGenericAi
extends SpellAbilityAi {
    @Override
    protected boolean checkAiLogic(Player ai, SpellAbility sa, String aiLogic) {
        if ("Khans".equals(aiLogic) || "Dragons".equals(aiLogic)) {
            return true;
        }
        if ("Pump".equals(aiLogic) || "BestOption".equals(aiLogic)) {
            for (AbilitySub sb : sa.getAdditionalAbilityList("Choices")) {
                if (!SpellApiToAi.Converter.get(sb.getApi()).canPlayAIWithSubs(ai, sb)) continue;
                return true;
            }
        } else {
            if ("AtOppEOT".equals(aiLogic)) {
                PhaseHandler ph = ai.getGame().getPhaseHandler();
                return ph.is(PhaseType.END_OF_TURN) && ph.getNextTurn() == ai;
            }
            if ("Always".equals(aiLogic)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        return sa.hasParam("AILogic");
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player aiPlayer) {
        return sa.isTrigger() ? this.doTriggerAINoCost(aiPlayer, sa, sa.isMandatory()) : this.checkApiLogic(aiPlayer, sa);
    }

    @Override
    protected boolean doTriggerAINoCost(Player aiPlayer, SpellAbility sa, boolean mandatory) {
        if ("CombustibleGearhulk".equals(sa.getParam("AILogic")) || "SoulEcho".equals(sa.getParam("AILogic"))) {
            for (Player p : aiPlayer.getOpponents()) {
                if (!p.canBeTargetedBy(sa)) continue;
                sa.resetTargets();
                sa.getTargets().add(p);
                return true;
            }
            return true;
        }
        if (ComputerUtilAbility.getAbilitySourceName(sa).equals("Deathmist Raptor")) {
            return true;
        }
        return super.doTriggerAINoCost(aiPlayer, sa, mandatory);
    }

    @Override
    public SpellAbility chooseSingleSpellAbility(Player player, SpellAbility sa, List<SpellAbility> spells, Map<String, Object> params) {
        Card host = sa.getHostCard();
        Game game = host.getGame();
        String logic = sa.getParam("AILogic");
        if (logic == null) {
            return spells.get(0);
        }
        if ("Random".equals(logic)) {
            return Aggregates.random(spells);
        }
        if ("Phasing".equals(logic)) {
            ArrayList<SpellAbility> filtered = Lists.newArrayList(Iterables.filter(spells, sp -> !sp.getDescription().contains("Creature") && !sp.getDescription().contains("Land")));
            return Aggregates.random(filtered);
        }
        if ("PayUnlessCost".equals(logic)) {
            for (SpellAbility sp2 : spells) {
                String unlessCost = sp2.getParam("UnlessCost");
                sp2.setActivatingPlayer(sa.getActivatingPlayer(), true);
                Cost unless = new Cost(unlessCost, false);
                SpellAbility.EmptySa paycost = new SpellAbility.EmptySa(sa.getHostCard(), player);
                paycost.setPayCosts(unless);
                if (!ComputerUtilCost.willPayUnlessCost(sp2, player, unless, false, new FCollection<Player>(player)) || !ComputerUtilCost.canPayCost(paycost, player, true)) continue;
                return sp2;
            }
            return spells.get(0);
        }
        if ("Khans".equals(logic) || "Dragons".equals(logic)) {
            for (SpellAbility sp3 : spells) {
                if (!sp3.getDescription().equals(logic)) continue;
                return sp3;
            }
        } else {
            if ("SelfOthers".equals(logic)) {
                SpellAbility self = null;
                SpellAbility others = null;
                for (SpellAbility sp4 : spells) {
                    if (sp4.getDescription().equals("Self")) {
                        self = sp4;
                        continue;
                    }
                    others = sp4;
                }
                String hostname = host.getName();
                if (hostname.equals("May Civilization Collapse") ? player.getLandsInPlay().isEmpty() : (hostname.equals("Feed the Machine") ? player.getCreaturesInPlay().isEmpty() : (hostname.equals("Surrender Your Thoughts") ? player.getCardsIn(ZoneType.Hand).isEmpty() : hostname.equals("The Fate of the Flammable") && !player.canLoseLife()))) {
                    return self;
                }
                return others;
            }
            if ("Counters".equals(logic)) {
                SpellAbility p1p1 = null;
                SpellAbility loyalty = null;
                for (SpellAbility sp5 : spells) {
                    if ("P1P1".equals(sp5.getParam("CounterType"))) {
                        p1p1 = sp5;
                        continue;
                    }
                    loyalty = sp5;
                }
                if (sa.getParent().getTargetCard() != null && sa.getParent().getTargetCard().isPlaneswalker()) {
                    return loyalty;
                }
                return p1p1;
            }
            if ("Fatespinner".equals(logic)) {
                SpellAbility skipDraw = null;
                SpellAbility skipCombat = null;
                for (SpellAbility sp6 : spells) {
                    if (sp6.getDescription().equals("FatespinnerSkipDraw")) {
                        skipDraw = sp6;
                        continue;
                    }
                    if (sp6.getDescription().equals("FatespinnerSkipMain")) continue;
                    skipCombat = sp6;
                }
                if (game.getReplacementHandler().wouldPhaseBeSkipped(player, "Draw")) {
                    return skipDraw;
                }
                if (game.getReplacementHandler().wouldPhaseBeSkipped(player, "BeginCombat")) {
                    return skipCombat;
                }
                return Aggregates.random(spells);
            }
            if ("SinProdder".equals(logic)) {
                SpellAbility allow = null;
                SpellAbility deny = null;
                for (SpellAbility sp7 : spells) {
                    if (sp7.getDescription().equals("No")) {
                        allow = sp7;
                        continue;
                    }
                    deny = sp7;
                }
                Card imprinted = (Card)host.getImprintedCards().getFirst();
                int dmg = imprinted.getCMC();
                Player owner = imprinted.getOwner();
                if (imprinted.getName().equals("Bridge from Below") || imprinted.getName().equals("Haakon, Stromgald Scourge")) {
                    return allow;
                }
                if (!player.getGame().isCardInPlay("Yixlid Jailer") && (imprinted.getName().equals("Gaea's Blessing") || imprinted.getName().equals("Narcomoeba"))) {
                    return allow;
                }
                if (owner.isCardInCommand("Emblem \u2014 Tamiyo, the Moon Sage")) {
                    return allow;
                }
                if (imprinted.isLand() && owner.isCardInPlay("The Gitrog Monster")) {
                    if (owner.getCardsIn(ZoneType.Library).size() < 5) {
                        return deny;
                    }
                    return allow;
                }
                if (imprinted.isCreature() && owner.isCardInPlay("Sidisi, Brood Tyrant")) {
                    return allow;
                }
                for (Card io : player.getCardsIn(ZoneType.Battlefield, "Iona, Shield of Emeria")) {
                    if (!imprinted.getColor().hasAnyColor(MagicColor.fromName(io.getChosenColor()))) continue;
                    return allow;
                }
                if (dmg == 0) {
                    return deny;
                }
                if (dmg + 3 > player.getLife()) {
                    return allow;
                }
                if (player.getLife() - dmg > 15) {
                    return deny;
                }
                return Aggregates.random(spells);
            }
            if ("CombustibleGearhulk".equals(logic)) {
                Player controller = sa.getActivatingPlayer();
                List<ZoneType> zones = ZoneType.listValueOf("Graveyard, Battlefield, Exile");
                int life = player.getLife();
                CardCollectionView revealedCards = controller.getCardsIn(zones);
                if (revealedCards.size() < 5) {
                    return life < 7 ? spells.get(0) : spells.get(1);
                }
                int totalCMC = 0;
                for (Card c : revealedCards) {
                    totalCMC += c.getCMC();
                }
                int bestGuessDamage = totalCMC * 3 / revealedCards.size();
                return life <= bestGuessDamage ? spells.get(0) : spells.get(1);
            }
            if ("SoulEcho".equals(logic)) {
                return sa.getHostCard().getController().getLife() < 10 ? spells.get(0) : Aggregates.random(spells);
            }
            if ("Pump".equals(logic) || "BestOption".equals(logic)) {
                ArrayList<SpellAbility> filtered = Lists.newArrayList();
                for (SpellAbility sp8 : spells) {
                    if (!SpellApiToAi.Converter.get(sp8.getApi()).canPlayAIWithSubs(player, sp8)) continue;
                    filtered.add(sp8);
                }
                if (!filtered.isEmpty()) {
                    return (SpellAbility)filtered.get(0);
                }
            } else if ("FoodOrTreasure".equals(logic)) {
                return ComputerUtil.aiLifeInDanger(player, false, 0) ? spells.get(0) : spells.get(1);
            }
        }
        return spells.get(0);
    }
}

