/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import forge.ai.AiAttackController;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.SpellAbilityAi;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameObject;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CounterEnumType;
import forge.game.combat.Combat;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerPredicates;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import java.util.Collections;
import java.util.Map;

public class ChooseCardAi
extends SpellAbilityAi {
    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        if (sa.usesTargeting()) {
            sa.resetTargets();
            PlayerCollection oppList = ai.getOpponents().filter(PlayerPredicates.isTargetableBy(sa));
            if (oppList.isEmpty()) {
                return false;
            }
            sa.getTargets().add((GameObject)Iterables.getFirst(oppList, null));
        }
        return true;
    }

    @Override
    protected boolean checkAiLogic(Player ai, SpellAbility sa, String aiLogic) {
        Card host = sa.getHostCard();
        Game game = ai.getGame();
        ZoneType choiceZone = ZoneType.Battlefield;
        if (sa.hasParam("ChoiceZone")) {
            choiceZone = ZoneType.smartValueOf(sa.getParam("ChoiceZone"));
        }
        CardCollectionView choices = game.getCardsIn(choiceZone);
        if (sa.hasParam("Choices")) {
            choices = CardLists.getValidCards((Iterable<Card>)choices, sa.getParam("Choices"), host.getController(), host, (CardTraitBase)sa);
        }
        if (sa.hasParam("TargetControls")) {
            choices = CardLists.filterControlledBy((Iterable<Card>)choices, ai.getOpponents());
        }
        if (aiLogic.equals("AtLeast1") || aiLogic.equals("OppPreferred")) {
            return !choices.isEmpty();
        }
        if (aiLogic.equals("AtLeast2") || aiLogic.equals("BestBlocker")) {
            return choices.size() >= 2;
        }
        if (aiLogic.equals("Clone")) {
            String filter = "Permanent.YouDontCtrl,Permanent.nonLegendary";
            return !(choices = CardLists.getValidCards((Iterable<Card>)choices, "Permanent.YouDontCtrl,Permanent.nonLegendary", host.getController(), host, (CardTraitBase)sa)).isEmpty();
        }
        if (aiLogic.equals("Never")) {
            return false;
        }
        if (aiLogic.equals("NeedsPrevention")) {
            if (!game.getPhaseHandler().is(PhaseType.COMBAT_DECLARE_BLOCKERS)) {
                return false;
            }
            Combat combat = game.getCombat();
            return !(choices = CardLists.filter((Iterable<Card>)choices, c -> {
                if (!combat.isAttacking((Card)c, ai) || !combat.isUnblocked((Card)c)) {
                    return false;
                }
                int ref = ComputerUtilAbility.getAbilitySourceName(sa).equals("Forcefield") ? 1 : 0;
                return ComputerUtilCombat.damageIfUnblocked(c, ai, combat, true) > ref;
            })).isEmpty();
        }
        if (aiLogic.equals("Ashiok")) {
            int loyalty;
            for (int i = loyalty = host.getCounters(CounterEnumType.LOYALTY) - 1; i >= 0; --i) {
                sa.setXManaCostPaid(i);
                choices = game.getCardsIn(choiceZone);
                choices = CardLists.getValidCards((Iterable<Card>)choices, sa.getParam("Choices"), host.getController(), host, (CardTraitBase)sa);
                if (choices.isEmpty()) continue;
                return true;
            }
            return !choices.isEmpty();
        }
        if (aiLogic.equals("RandomNonLand")) {
            return !CardLists.getValidCards((Iterable<Card>)choices, "Card.nonLand", host.getController(), host, (CardTraitBase)sa).isEmpty();
        }
        if (aiLogic.equals("Duneblast")) {
            CardCollection aiCreatures = ai.getCreaturesInPlay();
            CardCollection oppCreatures = AiAttackController.choosePreferredDefenderPlayer(ai).getCreaturesInPlay();
            aiCreatures = CardLists.getNotKeyword((Iterable<Card>)aiCreatures, Keyword.INDESTRUCTIBLE);
            oppCreatures = CardLists.getNotKeyword((Iterable<Card>)oppCreatures, Keyword.INDESTRUCTIBLE);
            if (aiCreatures.isEmpty() && ComputerUtilCombat.sumDamageIfUnblocked(oppCreatures, ai) >= ai.getLife()) {
                return true;
            }
            Card chosen = ComputerUtilCard.getBestCreatureAI(aiCreatures);
            aiCreatures.remove(chosen);
            int minGain = 200;
            return ComputerUtilCard.evaluateCreatureList(aiCreatures) + minGain < ComputerUtilCard.evaluateCreatureList(oppCreatures);
        }
        if (aiLogic.equals("OwnCard")) {
            CardCollection ownChoices = CardLists.filter((Iterable<Card>)choices, CardPredicates.isController(ai));
            if (ownChoices.isEmpty()) {
                ownChoices = CardLists.filter((Iterable<Card>)choices, CardPredicates.isControlledByAnyOf(ai.getAllies()));
            }
            return !ownChoices.isEmpty();
        }
        return true;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        if (sa.hasParam("AILogic") && !this.checkAiLogic(ai, sa, sa.getParam("AILogic"))) {
            return false;
        }
        return this.checkApiLogic(ai, sa);
    }

    @Override
    protected boolean checkPhaseRestrictions(Player ai, SpellAbility sa, PhaseHandler ph) {
        String aiLogic = sa.getParamOrDefault("AILogic", "");
        if (aiLogic.equals("AtOppEOT")) {
            return ph.getNextTurn().equals(ai) && ph.is(PhaseType.END_OF_TURN);
        }
        return super.checkPhaseRestrictions(ai, sa, ph);
    }

    @Override
    public Card chooseSingleCard(Player ai, SpellAbility sa, Iterable<Card> options, boolean isOptional, Player targetedPlayer, Map<String, Object> params) {
        Card host = sa.getHostCard();
        Player ctrl = host.getController();
        String logic = sa.getParamOrDefault("AILogic", "");
        if (logic.contains("NotSelf")) {
            CardCollection opt = options;
            if (opt.contains(host)) {
                opt.remove(host);
            }
            options = opt;
            logic = logic.replace("NotSelf", "");
        }
        Card choice = null;
        if (logic.isEmpty()) {
            choice = ComputerUtilCard.getBestAI(options);
        } else if ("WorstCard".equals(logic)) {
            choice = ComputerUtilCard.getWorstAI(options);
        } else if ("OwnCard".equals(logic)) {
            CardCollection ownChoices = CardLists.filter((Iterable<Card>)options, CardPredicates.isController(ai));
            if (ownChoices.isEmpty()) {
                ownChoices = CardLists.filter((Iterable<Card>)options, CardPredicates.isControlledByAnyOf(ai.getAllies()));
            }
            choice = ComputerUtilCard.getBestAI(ownChoices);
        } else if (logic.equals("BestBlocker")) {
            if (Iterables.any(options, CardPredicates.Presets.UNTAPPED)) {
                options = CardLists.filter((Iterable<Card>)options, CardPredicates.Presets.UNTAPPED);
            }
            choice = ComputerUtilCard.getBestCreatureAI(options);
        } else if (logic.equals("Clone")) {
            String filter = "Permanent.YouDontCtrl,Permanent.nonLegendary";
            CardCollection newOptions = CardLists.getValidCards((Iterable<Card>)options, "Permanent.YouDontCtrl,Permanent.nonLegendary", ctrl, host, (CardTraitBase)sa);
            if (!newOptions.isEmpty()) {
                options = newOptions;
            }
            choice = ComputerUtilCard.getBestAI(options);
        } else if ("RandomNonLand".equals(logic)) {
            options = CardLists.getValidCards((Iterable<Card>)options, "Card.nonLand", host.getController(), host, (CardTraitBase)sa);
            choice = Aggregates.random(options);
        } else if (logic.equals("NeedsPrevention")) {
            Game game = ai.getGame();
            Combat combat = game.getCombat();
            CardCollection better = CardLists.filter((Iterable<Card>)options, c -> {
                if (combat == null || !combat.isAttacking((Card)c, ai) || !combat.isUnblocked((Card)c)) {
                    return false;
                }
                int ref = ComputerUtilAbility.getAbilitySourceName(sa).equals("Forcefield") ? 1 : 0;
                return ComputerUtilCombat.damageIfUnblocked(c, ai, combat, true) > ref;
            });
            choice = !better.isEmpty() ? ComputerUtilCard.getBestAI(better) : ComputerUtilCard.getBestAI(options);
        } else if ("OppPreferred".equals(logic)) {
            CardCollection oppControlled = CardLists.filterControlledBy((Iterable<Card>)options, ai.getOpponents());
            if (!oppControlled.isEmpty()) {
                choice = ComputerUtilCard.getBestAI(oppControlled);
            } else {
                CardCollection aiControlled = CardLists.filterControlledBy((Iterable<Card>)options, ai);
                choice = ComputerUtilCard.getWorstAI(aiControlled);
            }
        } else if ("LowestCMCCreature".equals(logic)) {
            CardCollection creats = CardLists.filter((Iterable<Card>)options, CardPredicates.Presets.CREATURES);
            if ((creats = CardLists.filterToughness(creats, 1)).isEmpty()) {
                choice = ComputerUtilCard.getWorstAI(options);
            } else {
                CardLists.sortByCmcDesc(creats);
                Collections.reverse(creats);
                choice = (Card)creats.get(false);
            }
        } else if ("NegativePowerFirst".equals(logic)) {
            Card lowest = Aggregates.itemWithMin(options, Card::getNetPower);
            choice = lowest.getNetPower() <= 0 ? lowest : ComputerUtilCard.getBestCreatureAI(options);
        } else if ("TangleWire".equals(logic)) {
            CardCollection betterList = CardLists.filter((Iterable<Card>)options, c -> {
                if (c.isCreature()) {
                    return false;
                }
                for (SpellAbility sa1 : c.getAllSpellAbilities()) {
                    if (!sa1.getPayCosts().hasTapCost()) continue;
                    return false;
                }
                return true;
            });
            choice = !betterList.isEmpty() ? (Card)betterList.get(false) : ComputerUtilCard.getWorstPermanentAI(options, false, false, false, false);
        } else {
            if (logic.equals("Duneblast")) {
                CardCollection aiCreatures = ai.getCreaturesInPlay();
                if ((aiCreatures = CardLists.getNotKeyword((Iterable<Card>)aiCreatures, Keyword.INDESTRUCTIBLE)).isEmpty()) {
                    return null;
                }
                Card chosen = ComputerUtilCard.getBestCreatureAI(aiCreatures);
                return chosen;
            }
            if (logic.equals("OrzhovAdvokist")) {
                if (ai.equals(sa.getActivatingPlayer()) || ai.getOpponents().size() > 1 && !AiAttackController.choosePreferredDefenderPlayer(ai).equals(sa.getActivatingPlayer())) {
                    choice = ComputerUtilCard.getBestAI(options);
                }
            } else if (logic.equals("Phylactery")) {
                CardCollection aiArtifacts = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.ARTIFACTS);
                CardCollection indestructibles = CardLists.filter((Iterable<Card>)aiArtifacts, CardPredicates.hasKeyword(Keyword.INDESTRUCTIBLE));
                CardCollection nonCreatures = CardLists.filter((Iterable<Card>)aiArtifacts, Predicates.not(CardPredicates.Presets.CREATURES));
                CardCollection creatures = CardLists.filter((Iterable<Card>)aiArtifacts, CardPredicates.Presets.CREATURES);
                if (!indestructibles.isEmpty()) {
                    choice = ComputerUtilCard.getWorstAI(indestructibles);
                } else if (!nonCreatures.isEmpty()) {
                    choice = ComputerUtilCard.getWorstAI(nonCreatures);
                } else if (!creatures.isEmpty()) {
                    choice = ComputerUtilCard.getBestAI(creatures);
                }
            } else if (logic.equals("NextTurnAttacker")) {
                choice = ComputerUtilCard.getBestCreatureToAttackNextTurnAI(ai, options);
            } else {
                choice = ComputerUtilCard.getBestAI(options);
                System.err.println("Bad ChooseCard AILogic value for " + host.getName() + " - reverting to default");
            }
        }
        return choice;
    }
}

