/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.ai.AiAttackController;
import forge.ai.AiCardMemory;
import forge.ai.AiController;
import forge.ai.AiProps;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.ComputerUtilCost;
import forge.ai.ComputerUtilMana;
import forge.ai.PlayerControllerAi;
import forge.ai.SpecialAiLogic;
import forge.ai.SpecialCardAi;
import forge.ai.SpellAbilityAi;
import forge.ai.SpellApiToAi;
import forge.ai.ability.AttachAi;
import forge.card.CardType;
import forge.card.MagicColor;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameObject;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardCopyService;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardUtil;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.combat.Combat;
import forge.game.cost.Cost;
import forge.game.cost.CostDiscard;
import forge.game.cost.CostExile;
import forge.game.cost.CostPart;
import forge.game.cost.CostPutCounter;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.game.spellability.TargetRestrictions;
import forge.game.staticability.StaticAbilityMustTarget;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import forge.util.MyRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ChangeZoneAi
extends SpellAbilityAi {
    private static CardCollection multipleCardsToChoose = new CardCollection();

    @Override
    protected boolean willPayCosts(Player ai, SpellAbility sa, Cost cost, Card source) {
        if (sa.isCraft()) {
            CardCollection payingCards = new CardCollection();
            int needed = 0;
            for (CostPart part : cost.getCostParts()) {
                if (!(part instanceof CostExile) || part.payCostFromSource()) continue;
                int amt = part.getAbilityAmount(sa);
                needed += amt;
                CardCollection toAdd = ComputerUtil.chooseExileFrom(ai, (CostExile)part, source, amt, sa, true);
                if (toAdd == null) continue;
                payingCards.addAll(toAdd);
            }
            if (payingCards.size() < needed) {
                return false;
            }
        }
        return super.willPayCosts(ai, sa, cost, source);
    }

    @Override
    protected boolean checkAiLogic(Player ai, SpellAbility sa, String aiLogic) {
        if (sa.getHostCard() != null && sa.getHostCard().hasSVar("AIPreferenceOverride")) {
            sa.getHostCard().removeSVar("AIPreferenceOverride");
        }
        if (aiLogic.equals("BeforeCombat")) {
            if (ai.getGame().getPhaseHandler().getPhase().isAfter(PhaseType.COMBAT_BEGIN)) {
                return false;
            }
        } else if (aiLogic.equals("SurpriseBlock")) {
            if (ai.getGame().getPhaseHandler().getPhase().isBefore(PhaseType.COMBAT_DECLARE_ATTACKERS)) {
                return false;
            }
        } else if (aiLogic.equals("PriorityOptionalCost")) {
            boolean highPriority = false;
            highPriority |= CardLists.count(ai.getCardsIn(ZoneType.Hand), CardPredicates.nameEquals(sa.getHostCard().getName())) > 1;
            if (!(highPriority |= ai.getGame().getPhaseHandler().is(PhaseType.COMBAT_DECLARE_BLOCKERS) && ai.getGame().getCombat() != null && ComputerUtilCombat.lifeInDanger(ai, ai.getGame().getCombat())) && Iterables.isEmpty(sa.getOptionalCosts())) {
                return false;
            }
        } else {
            if (aiLogic.equals("NoSameCreatureType")) {
                ArrayList<ZoneType> origin = Lists.newArrayList();
                if (sa.hasParam("Origin")) {
                    origin.addAll(ZoneType.listValueOf(sa.getParam("Origin")));
                } else if (sa.hasParam("TgtZone")) {
                    origin.addAll(ZoneType.listValueOf(sa.getParam("TgtZone")));
                }
                CardCollection list = CardLists.getValidCards((Iterable<Card>)ai.getGame().getCardsIn(origin), sa.getTargetRestrictions().getValidTgts(), ai, sa.getHostCard(), (CardTraitBase)sa);
                ArrayList<String> creatureTypes = Lists.newArrayList();
                for (Card c : list) {
                    creatureTypes.addAll(c.getType().getCreatureTypes());
                }
                for (String type : creatureTypes) {
                    int freq = Collections.frequency(creatureTypes, type);
                    if (freq <= 1) continue;
                    return false;
                }
                return true;
            }
            if (aiLogic.equals("Pongify")) {
                return SpecialAiLogic.doPongifyLogic(ai, sa);
            }
        }
        return super.checkAiLogic(ai, sa, aiLogic);
    }

    @Override
    protected boolean checkApiLogic(Player aiPlayer, SpellAbility sa) {
        multipleCardsToChoose.clear();
        String aiLogic = sa.getParam("AILogic");
        if (aiLogic != null) {
            if (aiLogic.equals("Always")) {
                return true;
            }
            if (aiLogic.startsWith("ExileSpell")) {
                return this.doExileSpellLogic(aiPlayer, sa);
            }
            if (aiLogic.startsWith("SacAndUpgrade")) {
                return this.doSacAndUpgradeLogic(aiPlayer, sa);
            }
            if (aiLogic.startsWith("SacAndRetFromGrave")) {
                return this.doSacAndReturnFromGraveLogic(aiPlayer, sa);
            }
            if (aiLogic.equals("Necropotence")) {
                return SpecialCardAi.Necropotence.consider(aiPlayer, sa);
            }
            if (aiLogic.equals("ReanimateAll")) {
                return SpecialCardAi.LivingDeath.consider(aiPlayer, sa);
            }
            if (aiLogic.equals("TheScarabGod")) {
                return SpecialCardAi.TheScarabGod.consider(aiPlayer, sa);
            }
            if (aiLogic.equals("SorinVengefulBloodlord")) {
                return SpecialCardAi.SorinVengefulBloodlord.consider(aiPlayer, sa);
            }
            if (aiLogic.equals("Intuition")) {
                multipleCardsToChoose = SpecialCardAi.Intuition.considerMultiple(aiPlayer, sa);
            } else {
                if (aiLogic.equals("MazesEnd")) {
                    return SpecialCardAi.MazesEnd.consider(aiPlayer, sa);
                }
                if (aiLogic.equals("Pongify")) {
                    return sa.isTargetNumberValid();
                }
            }
        }
        if (sa.isHidden()) {
            return ChangeZoneAi.hiddenOriginCanPlayAI(aiPlayer, sa);
        }
        return ChangeZoneAi.knownOriginCanPlayAI(aiPlayer, sa);
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player aiPlayer) {
        if (sa.isHidden()) {
            return ChangeZoneAi.hiddenOriginPlayDrawbackAI(aiPlayer, sa);
        }
        return ChangeZoneAi.knownOriginPlayDrawbackAI(aiPlayer, sa);
    }

    @Override
    protected boolean doTriggerAINoCost(Player aiPlayer, SpellAbility sa, boolean mandatory) {
        String aiLogic = sa.getParamOrDefault("AILogic", "");
        if (sa.isReplacementAbility() && "Command".equals(sa.getParam("Destination")) && "ReplacedCard".equals(sa.getParam("Defined"))) {
            return this.doReturnCommanderLogic(sa, aiPlayer);
        }
        if ("Always".equals(aiLogic)) {
            return true;
        }
        if ("IfNotBuffed".equals(aiLogic)) {
            if (ComputerUtilCard.isUselessCreature(aiPlayer, sa.getHostCard())) {
                return true;
            }
            int delta = 0;
            for (Card enc : sa.getHostCard().getEnchantedBy()) {
                if (enc.getController().isOpponentOf(aiPlayer)) {
                    --delta;
                    continue;
                }
                ++delta;
            }
            return delta <= 0;
        }
        if ("SaviorOfOllenbock".equals(aiLogic)) {
            return SpecialCardAi.SaviorOfOllenbock.consider(aiPlayer, sa);
        }
        if (sa.isHidden()) {
            return ChangeZoneAi.hiddenTriggerAI(aiPlayer, sa, mandatory);
        }
        return ChangeZoneAi.knownOriginTriggerAI(aiPlayer, sa, mandatory);
    }

    private static boolean hiddenOriginCanPlayAI(Player ai, SpellAbility sa) {
        Cost abCost = sa.getPayCosts();
        Card source = sa.getHostCard();
        String sourceName = ComputerUtilAbility.getAbilitySourceName(sa);
        String aiLogic = sa.getParamOrDefault("AILogic", "");
        List<ZoneType> origin = null;
        Player opponent = AiAttackController.choosePreferredDefenderPlayer(ai);
        boolean activateForCost = ComputerUtil.activateForCost(sa, ai);
        if (sa.hasParam("Origin")) {
            try {
                origin = ZoneType.listValueOf(sa.getParam("Origin"));
            }
            catch (IllegalArgumentException ex) {
                return false;
            }
        }
        String destination = sa.getParam("Destination");
        if (abCost != null) {
            if (!(ComputerUtilCost.checkSacrificeCost(ai, abCost, source, sa) || destination.equals("Battlefield") && !source.isLand())) {
                return false;
            }
            if (!ComputerUtilCost.checkLifeCost(ai, abCost, source, 4, sa)) {
                return false;
            }
            if (!ComputerUtilCost.checkDiscardCost(ai, abCost, source, sa)) {
                for (CostPart part : abCost.getCostParts()) {
                    Object cd2;
                    if (!(part instanceof CostDiscard) || ((CostPart)(cd2 = (CostDiscard)part)).payCostFromSource() && ComputerUtil.isWorseThanDraw(ai, source)) continue;
                    return false;
                }
            }
            if (sa.isNinjutsu()) {
                if (!source.ignoreLegendRule() && ai.isCardInPlay(source.getName())) {
                    return false;
                }
                if (ai.getGame().getPhaseHandler().getPhase().isAfter(PhaseType.COMBAT_DAMAGE)) {
                    return false;
                }
                if (ai.getGame().getCombat() == null) {
                    return false;
                }
                CardCollection attackers = ai.getGame().getCombat().getUnblockedAttackers();
                boolean lowerCMC = false;
                for (Card attacker : attackers) {
                    if (attacker.getCMC() >= source.getCMC()) continue;
                    lowerCMC = true;
                    break;
                }
                if (!lowerCMC) {
                    return false;
                }
            }
        }
        if (!activateForCost && !sa.metConditions()) {
            AbilitySub abSub = sa.getSubAbility();
            if (abSub != null && !sa.isWrapper() && "True".equals(source.getSVar("AIPlayForSub"))) {
                if (!abSub.metConditions()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (ComputerUtil.preventRunAwayActivations(sa)) {
            return false;
        }
        Iterable<Player> pDefined = Lists.newArrayList(source.getController());
        TargetRestrictions tgt = sa.getTargetRestrictions();
        if (tgt != null && tgt.canTgtPlayer()) {
            sa.resetTargets();
            boolean isCurse = sa.isCurse();
            if (isCurse && sa.canTarget(opponent)) {
                sa.getTargets().add(opponent);
            } else if (!isCurse && sa.canTarget(ai)) {
                sa.getTargets().add(ai);
            }
            if (!sa.isTargetNumberValid()) {
                return false;
            }
            pDefined = sa.getTargets().getTargetPlayers();
        } else {
            pDefined = sa.hasParam("DefinedPlayer") ? AbilityUtils.getDefinedPlayers(source, sa.getParam("DefinedPlayer"), sa) : AbilityUtils.getDefinedPlayers(source, sa.getParam("Defined"), sa);
        }
        String type = sa.getParam("ChangeType");
        if (type != null && type.contains("X") && sa.getSVar("X").equals("Count$xPaid")) {
            int xPay = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
            sa.setXManaCostPaid(xPay);
            type = type.replace("X", Integer.toString(xPay));
        }
        for (Player p : pDefined) {
            CardCollectionView list = p.getCardsIn(origin);
            if (!ai.canSearchLibraryWith(sa, p)) {
                list = CardLists.filter((Iterable<Card>)list, Predicates.not(CardPredicates.inZone(ZoneType.Library)));
            }
            if (type != null && p == ai) {
                list = CardLists.getValidCards((Iterable<Card>)list, type, source.getController(), source, (CardTraitBase)sa);
                list = CardLists.filter((Iterable<Card>)list, c -> {
                    if (c.getType().isLegendary()) {
                        return !ai.isCardInPlay(c.getName());
                    }
                    return true;
                });
            }
            if (origin != null && origin.size() == 1 && origin.get(0).isKnown()) {
                list = CardLists.getValidCards((Iterable<Card>)list, type, source.getController(), source, (CardTraitBase)sa);
            }
            if (!activateForCost && list.isEmpty()) {
                return false;
            }
            if ("Atarka's Command".equals(sourceName) && (list.size() < 2 || ai.getLandsPlayedThisTurn() < 1)) {
                return false;
            }
            String num = sa.getParamOrDefault("ChangeNum", "1");
            if (num.contains("X")) {
                if (sa.getSVar("X").equals("Count$xPaid")) {
                    int xPay = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
                    if (xPay == 0) {
                        return false;
                    }
                    xPay = Math.min(xPay, list.size());
                    sa.setXManaCostPaid(xPay);
                } else {
                    int xValue = AbilityUtils.calculateAmount(source, "X", sa);
                    if (xValue == 0) {
                        return false;
                    }
                }
            }
            if (!sourceName.equals("Temur Sabertooth")) continue;
            if (ComputerUtilCard.shouldPumpCard(ai, sa.getSubAbility(), source, 0, 0, Arrays.asList("Indestructible")) || ComputerUtilCard.canPumpAgainstRemoval(ai, sa.getSubAbility())) {
                for (Card c2 : list) {
                    if (ComputerUtilCard.evaluateCreature(c2) >= ComputerUtilCard.evaluateCreature(source)) continue;
                    return true;
                }
            }
            return ChangeZoneAi.canBouncePermanent(ai, sa, list) != null;
        }
        if (ComputerUtil.playImmediately(ai, sa)) {
            return true;
        }
        if (ai.getGame().getPhaseHandler().getPhase().isBefore(PhaseType.MAIN2) && !sa.hasParam("ActivationPhases")) {
            if (!destination.equals("Battlefield") && !destination.equals("Hand")) {
                return false;
            }
            if (ai.getCardsIn(ZoneType.Hand).size() > 1 && destination.equals("Hand") && !aiLogic.equals("AnyMainPhase")) {
                return false;
            }
        }
        if (ComputerUtil.waitForBlocking(sa)) {
            return false;
        }
        AbilitySub subAb = sa.getSubAbility();
        return subAb == null || SpellApiToAi.Converter.get(subAb.getApi()).chkDrawbackWithSubs(ai, subAb);
    }

    private static boolean hiddenOriginPlayDrawbackAI(Player aiPlayer, SpellAbility sa) {
        TargetRestrictions tgt = sa.getTargetRestrictions();
        Player opp = AiAttackController.choosePreferredDefenderPlayer(aiPlayer);
        if (tgt != null && tgt.canTgtPlayer()) {
            boolean isCurse = sa.isCurse();
            if (isCurse && sa.canTarget(opp)) {
                sa.getTargets().add(opp);
            } else if (!isCurse && sa.canTarget(aiPlayer)) {
                sa.getTargets().add(aiPlayer);
            } else {
                return false;
            }
        }
        return true;
    }

    private static boolean hiddenTriggerAI(Player ai, SpellAbility sa, boolean mandatory) {
        Iterable<Player> pDefined;
        TargetRestrictions tgt;
        if (sa.hasParam("AILogic") && sa.getParam("AILogic").equals("Never")) {
            return false;
        }
        ArrayList<ZoneType> origin = new ArrayList();
        if (sa.hasParam("Origin")) {
            origin = ZoneType.listValueOf(sa.getParam("Origin"));
        }
        String type = sa.getParam("ChangeType");
        if (!mandatory && sa.getPayCosts().hasXInAnyCostPart() && type != null && type.contains("X") && sa.getSVar("X").equals("Count$xPaid")) {
            int xPay = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
            sa.setXManaCostPaid(xPay);
        }
        if ((tgt = sa.getTargetRestrictions()) != null && tgt.canTgtPlayer()) {
            Player opp = AiAttackController.choosePreferredDefenderPlayer(ai);
            if (sa.isCurse()) {
                if (sa.canTarget(opp)) {
                    sa.getTargets().add(opp);
                } else if (mandatory && sa.canTarget(ai)) {
                    sa.getTargets().add(ai);
                }
            } else if (sa.canTarget(ai)) {
                sa.getTargets().add(ai);
            } else if (mandatory && sa.canTarget(opp)) {
                sa.getTargets().add(opp);
            }
            pDefined = sa.getTargets().getTargetPlayers();
            if (Iterables.isEmpty(pDefined)) {
                return false;
            }
            if (mandatory) {
                return true;
            }
        } else {
            if (mandatory) {
                return true;
            }
            pDefined = AbilityUtils.getDefinedPlayers(sa.getHostCard(), sa.getParam("Defined"), sa);
        }
        for (Player p : pDefined) {
            CardCollectionView list = p.getCardsIn(origin);
            if (p == ai) {
                list = AbilityUtils.filterListByType(list, sa.getParam("ChangeType"), sa);
            }
            if (!list.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static Card basicManaFixing(Player ai, List<Card> list) {
        CardCollectionView combined = CardCollection.combine(ai.getCardsIn(ZoneType.Battlefield), ai.getCardsIn(ZoneType.Hand));
        ArrayList<String> basics = new ArrayList<String>();
        for (String name : MagicColor.Constant.BASIC_LANDS) {
            if (CardLists.getType(list, name).isEmpty()) continue;
            basics.add(name);
        }
        int minSize = Integer.MAX_VALUE;
        String minType = null;
        for (String b : basics) {
            int num = CardLists.getType(combined, b).size();
            if (num >= minSize) continue;
            minType = b;
            minSize = num;
        }
        CardCollection result = list;
        if (minType != null) {
            result = CardLists.getType(list, minType);
        }
        if (Iterables.any(result, Predicates.not(CardPredicates.Presets.BASIC_LANDS))) {
            result = CardLists.filter((Iterable<Card>)result, Predicates.not(CardPredicates.Presets.BASIC_LANDS));
        }
        return (Card)result.get(0);
    }

    private static boolean areAllBasics(String types) {
        for (String ct : types.split(",")) {
            if (MagicColor.Constant.BASIC_LANDS.contains(ct)) continue;
            return false;
        }
        return true;
    }

    private static Card chooseCreature(Player ai, CardCollection list) {
        if (ComputerUtil.aiLifeInDanger(ai, false, 0)) {
            ComputerUtilCard.sortByEvaluateCreature(list);
            for (Card c : list) {
                if (!ComputerUtilMana.hasEnoughManaSourcesToCast(c.getFirstSpellAbility(), ai)) continue;
                return c;
            }
            return null;
        }
        return ComputerUtilCard.getBestCreatureAI(list);
    }

    private static boolean knownOriginCanPlayAI(Player ai, SpellAbility sa) {
        AbilitySub subAb;
        ArrayList<ZoneType> origin = Lists.newArrayList();
        if (sa.hasParam("Origin")) {
            origin.addAll(ZoneType.listValueOf(sa.getParam("Origin")));
        } else if (sa.hasParam("TgtZone")) {
            origin.addAll(ZoneType.listValueOf(sa.getParam("TgtZone")));
        }
        ZoneType destination = ZoneType.smartValueOf(sa.getParam("Destination"));
        if (ComputerUtil.preventRunAwayActivations(sa)) {
            return false;
        }
        if (sa.usesTargeting()) {
            if (!ChangeZoneAi.isPreferredTarget(ai, sa, false, false)) {
                return false;
            }
        } else {
            CardCollection retrieval = sa.knownDetermineDefined(sa.getParam("Defined"));
            if (retrieval == null || retrieval.isEmpty()) {
                return false;
            }
            if (origin.contains((Object)ZoneType.Battlefield)) {
                if (ai.getGame().getStack().isEmpty()) {
                    return false;
                }
                AbilitySub abSub = sa.getSubAbility();
                ApiType subApi = null;
                if (abSub != null) {
                    subApi = abSub.getApi();
                }
                if (!(destination.equals((Object)ZoneType.Exile) && (subApi == ApiType.DelayedTrigger || subApi == ApiType.ChangeZone || "DelayedBlink".equals(sa.getParam("AILogic"))) || destination.equals((Object)ZoneType.Hand))) {
                    return false;
                }
                List<GameObject> objects = ComputerUtil.predictThreatenedObjects(ai, sa);
                boolean contains = false;
                for (Card c : retrieval) {
                    if (!objects.contains(c)) continue;
                    contains = true;
                    break;
                }
                if (!contains) {
                    return false;
                }
            }
            if (destination == ZoneType.Battlefield) {
                if (ComputerUtil.isETBprevented((Card)retrieval.get(0))) {
                    return false;
                }
                for (Card c : retrieval) {
                    if (!c.isCreature()) continue;
                    Card copy = CardCopyService.getLKICopy(c);
                    ComputerUtilCard.applyStaticContPT(c.getGame(), copy, null);
                    if (copy.getNetToughness() > 0) continue;
                    return false;
                }
                boolean nothingWillReturn = true;
                for (Card c : retrieval) {
                    boolean isCraftSa;
                    boolean bl = isCraftSa = sa.isCraft() && sa.getHostCard().equals(c);
                    if (!isCraftSa && !c.ignoreLegendRule() && ai.isCardInPlay(c.getName())) continue;
                    nothingWillReturn = false;
                    break;
                }
                if (nothingWillReturn) {
                    return false;
                }
            }
        }
        return (subAb = sa.getSubAbility()) == null || SpellApiToAi.Converter.get(subAb.getApi()).chkDrawbackWithSubs(ai, subAb);
    }

    @Override
    protected boolean checkPhaseRestrictions(Player ai, SpellAbility sa, PhaseHandler ph) {
        String aiLogic = sa.getParamOrDefault("AILogic", "");
        if (aiLogic.equals("SurvivalOfTheFittest") || aiLogic.equals("AtOppEOT")) {
            return ph.getNextTurn().equals(ai) && ph.is(PhaseType.END_OF_TURN);
        }
        if (aiLogic.equals("Main1") && ph.is(PhaseType.MAIN1, ai)) {
            return true;
        }
        if (sa.isHidden()) {
            return true;
        }
        ArrayList<ZoneType> origin = Lists.newArrayList();
        if (sa.hasParam("Origin")) {
            origin.addAll(ZoneType.listValueOf(sa.getParam("Origin")));
        } else if (sa.hasParam("TgtZone")) {
            origin.addAll(ZoneType.listValueOf(sa.getParam("TgtZone")));
        }
        ZoneType destination = ZoneType.smartValueOf(sa.getParam("Destination"));
        if (destination.equals((Object)ZoneType.Hand) && origin.contains((Object)ZoneType.Graveyard)) {
            int handSize = ai.getCardsIn(ZoneType.Hand).size();
            if (ph.getPhase().isBefore(PhaseType.MAIN1)) {
                return false;
            }
            if (ph.getPhase().isBefore(PhaseType.MAIN2) && handSize > 1) {
                return false;
            }
            if (ph.isPlayerTurn(ai) && handSize >= ai.getMaxHandSize()) {
                return false;
            }
        }
        if (sa.hasParam("Unearth") && ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_ATTACKERS)) {
            return false;
        }
        if (destination.equals((Object)ZoneType.Library) && origin.contains((Object)ZoneType.Graveyard)) {
            if (ph.getPhase().isBefore(PhaseType.MAIN2)) {
                return false;
            }
            if (ComputerUtil.waitForBlocking(sa)) {
                return false;
            }
        }
        return super.checkPhaseRestrictions(ai, sa, ph);
    }

    private static boolean knownOriginPlayDrawbackAI(Player aiPlayer, SpellAbility sa) {
        if ("MimicVat".equals(sa.getParam("AILogic"))) {
            return SpecialCardAi.MimicVat.considerExile(aiPlayer, sa);
        }
        if (!sa.usesTargeting()) {
            return true;
        }
        return ChangeZoneAi.isPreferredTarget(aiPlayer, sa, false, true);
    }

    private static boolean isPreferredTarget(Player ai, SpellAbility sa, boolean mandatory, boolean immediately) {
        boolean doWithoutTarget;
        CardCollection newList;
        Card source = sa.getHostCard();
        ArrayList<ZoneType> origin = Lists.newArrayList();
        if (sa.hasParam("Origin")) {
            origin.addAll(ZoneType.listValueOf(sa.getParam("Origin")));
        } else if (sa.hasParam("TgtZone")) {
            origin.addAll(ZoneType.listValueOf(sa.getParam("TgtZone")));
        }
        ZoneType destination = ZoneType.smartValueOf(sa.getParam("Destination"));
        Game game = ai.getGame();
        AbilitySub abSub = sa.getSubAbility();
        ApiType subApi = null;
        String subAffected = "";
        if (abSub != null) {
            subApi = abSub.getApi();
            if (abSub.hasParam("Defined")) {
                subAffected = abSub.getParam("Defined");
            }
        }
        sa.resetTargets();
        if ("X".equals(sa.getTargetRestrictions().getMinTargets()) && sa.getSVar("X").equals("Count$xPaid")) {
            int xPay = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
            sa.setXManaCostPaid(xPay);
        }
        CardCollection list = CardLists.getTargetableCards(game.getCardsIn(origin), sa);
        list = ComputerUtil.filterAITgts(sa, ai, list, true);
        if (sa.hasParam("AITgtsOnlyBetterThanSelf")) {
            list = CardLists.filter((Iterable<Card>)list, card -> ComputerUtilCard.evaluateCreature(card) > ComputerUtilCard.evaluateCreature(source) + 30);
        }
        if (source.isInZone(ZoneType.Hand)) {
            list = CardLists.filter((Iterable<Card>)list, Predicates.not(CardPredicates.nameEquals(source.getName())));
        }
        if (sa.isSpell()) {
            list.remove(source);
        }
        if (sa.hasParam("AttachedTo")) {
            list = CardLists.filter((Iterable<Card>)list, c -> {
                for (Card card : game.getCardsIn(ZoneType.Battlefield)) {
                    if (!card.isValid(sa.getParam("AttachedTo"), ai, (Card)c, (CardTraitBase)sa)) continue;
                    return true;
                }
                return false;
            });
        }
        if (sa.hasParam("AttachAfter")) {
            list = CardLists.filter((Iterable<Card>)list, c -> {
                for (Card card : game.getCardsIn(ZoneType.Battlefield)) {
                    if (!card.isValid(sa.getParam("AttachAfter"), ai, (Card)c, (CardTraitBase)sa)) continue;
                    return true;
                }
                return false;
            });
        }
        if (list.size() < sa.getMinTargets()) {
            return false;
        }
        boolean bl = immediately = immediately || ComputerUtil.playImmediately(ai, sa);
        if (origin.contains((Object)ZoneType.Battlefield)) {
            boolean blink;
            if ("Polymorph".equals(sa.getParam("AILogic"))) {
                list = CardLists.getTargetableCards(ai.getCardsIn(ZoneType.Battlefield), sa);
                if (list.isEmpty()) {
                    return false;
                }
                Card worst = ComputerUtilCard.getWorstAI(list);
                if (worst.isCreature() && ComputerUtilCard.evaluateCreature(worst) >= 200) {
                    return false;
                }
                if (!worst.isCreature() && worst.getCMC() > 1) {
                    return false;
                }
                sa.getTargets().add(worst);
                return true;
            }
            if (sa.getMinTargets() <= 1 && game.getPhaseHandler().is(PhaseType.COMBAT_DECLARE_BLOCKERS)) {
                Combat currCombat = game.getCombat();
                CardCollection attackers = currCombat.getAttackers();
                ComputerUtilCard.sortByEvaluateCreature(attackers);
                for (Card attacker : attackers) {
                    CardCollection blockers = currCombat.getBlockers(attacker);
                    if (attacker.getController().equals(ai) && attacker.getShieldCount() == 0 && ComputerUtilCombat.attackerWouldBeDestroyed(ai, attacker, currCombat) && !currCombat.getBlockers(attacker).isEmpty()) {
                        ComputerUtilCard.sortByEvaluateCreature(blockers);
                        Combat combat = new Combat(ai);
                        combat.addAttacker(attacker, ai.getWeakestOpponent());
                        for (Card blocker : blockers) {
                            combat.addBlocker(attacker, blocker);
                        }
                        for (Card blocker : blockers) {
                            combat.removeFromCombat(blocker);
                            if (!ComputerUtilCombat.attackerWouldBeDestroyed(ai, attacker, combat) && sa.canTarget(blocker)) {
                                sa.getTargets().add(blocker);
                                return true;
                            }
                            combat.addBlocker(attacker, blocker);
                        }
                    }
                    if (!attacker.getController().isOpponentOf(ai) || blockers.isEmpty()) continue;
                    for (Card blocker : blockers) {
                        if (!ComputerUtilCombat.blockerWouldBeDestroyed(ai, blocker, currCombat) || !sa.canTarget(attacker)) continue;
                        sa.getTargets().add(attacker);
                        return true;
                    }
                }
            }
            boolean bl2 = blink = destination.equals((Object)ZoneType.Exile) && (subApi == ApiType.DelayedTrigger || "DelayedBlink".equals(sa.getParam("AILogic")) || subApi == ApiType.ChangeZone && subAffected.equals("Remembered"));
            if ((destination.equals((Object)ZoneType.Hand) || blink) && sa.getMinTargets() <= 1) {
                CardCollection blinkTargets;
                Card tobounce = ChangeZoneAi.canBouncePermanent(ai, sa, list);
                if (tobounce != null) {
                    boolean saheeliFelidarCombo;
                    if ("BounceOnce".equals(sa.getParam("AILogic")) && ChangeZoneAi.isBouncedThisTurn(ai, tobounce)) {
                        return false;
                    }
                    sa.getTargets().add(tobounce);
                    boolean bl3 = saheeliFelidarCombo = ComputerUtilAbility.getAbilitySourceName(sa).equals("Felidar Guardian") && tobounce.getName().equals("Saheeli Rai") && CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), CardPredicates.nameEquals("Felidar Guardian")).size() < CardLists.filter((Iterable<Card>)ai.getOpponents().getCardsIn(ZoneType.Battlefield), CardPredicates.isType("Creature")).size() + ai.getOpponentsGreatestLifeTotal() + 10;
                    if (!saheeliFelidarCombo) {
                        ChangeZoneAi.rememberBouncedThisTurn(ai, tobounce);
                    }
                    return true;
                }
                if (blink && !(blinkTargets = CardLists.filter((Iterable<Card>)list, c -> !c.isToken() && c.getOwner().equals(ai) && (c.getController().isOpponentOf(ai) || c.hasETBTrigger(false)))).isEmpty()) {
                    CardCollection opponentBlinkTargets = CardLists.filterControlledBy((Iterable<Card>)blinkTargets, ai.getOpponents());
                    if (immediately || sa.getParent() != null || sa.isTrigger() || !opponentBlinkTargets.isEmpty() || !game.getPhaseHandler().getPhase().isBefore(PhaseType.MAIN2)) {
                        while (!blinkTargets.isEmpty() && sa.canAddMoreTarget()) {
                            Card choice = null;
                            if (!opponentBlinkTargets.isEmpty()) {
                                choice = ComputerUtilCard.getBestAI(opponentBlinkTargets);
                                opponentBlinkTargets.remove(choice);
                            } else {
                                choice = ComputerUtilCard.getBestAI(blinkTargets);
                            }
                            sa.getTargets().add(choice);
                            blinkTargets.remove(choice);
                        }
                        return true;
                    }
                }
                if (!CardLists.getNotType(list = CardLists.filterControlledBy((Iterable<Card>)list, ai.getOpponents()), "Land").isEmpty()) {
                    list = CardLists.filter((Iterable<Card>)list, c -> {
                        Iterator iterator = c.getEnchantedBy().iterator();
                        if (iterator.hasNext()) {
                            Card aura = (Card)iterator.next();
                            return aura.getController().isOpponentOf(ai);
                        }
                        if (blink) {
                            return c.isToken();
                        }
                        return c.isToken() || c.getCMC() > 0;
                    });
                }
            }
        } else if (origin.contains((Object)ZoneType.Graveyard)) {
            if (destination.equals((Object)ZoneType.Exile) || destination.equals((Object)ZoneType.Library)) {
                if (!immediately && game.getPhaseHandler().getPhase().isBefore(PhaseType.MAIN2) && !sa.hasParam("ActivationPhases") && !ComputerUtil.castSpellInMain1(ai, sa)) {
                    return false;
                }
                if (!(immediately || game.getPhaseHandler().getNextTurn().equals(ai) && !game.getPhaseHandler().getPhase().isBefore(PhaseType.END_OF_TURN) || sa.hasParam("PlayerTurn") || ChangeZoneAi.isSorcerySpeed(sa, ai) || ComputerUtil.activateForCost(sa, ai))) {
                    return false;
                }
            } else if (destination.equals((Object)ZoneType.Hand)) {
                list = CardLists.filterControlledBy((Iterable<Card>)list, ai);
            } else if (sa.hasParam("AttachedTo")) {
                list = CardLists.filter((Iterable<Card>)list, c -> {
                    for (SpellAbility attach : c.getSpellAbilities()) {
                        if (!"Pump".equals(attach.getParam("AILogic"))) continue;
                        return true;
                    }
                    return false;
                });
            }
        }
        if (origin.contains((Object)ZoneType.Battlefield) && destination.equals((Object)ZoneType.Exile) && (subApi == ApiType.DelayedTrigger || subApi == ApiType.ChangeZone && subAffected.equals("Remembered")) && !game.getPhaseHandler().is(PhaseType.COMBAT_DECLARE_ATTACKERS) && !sa.isAbility()) {
            return false;
        }
        if (destination.equals((Object)ZoneType.Exile) || origin.contains((Object)ZoneType.Battlefield)) {
            if (!immediately && game.getPhaseHandler().getPhase().isBefore(PhaseType.MAIN2) && game.getPhaseHandler().isPlayerTurn(ai) && ai.getCreaturesInPlay().isEmpty()) {
                return false;
            }
            if (!sa.hasParam("AITgtOwnCards")) {
                list = CardLists.filterControlledBy((Iterable<Card>)list, ai.getOpponents());
                list = CardLists.filter((Iterable<Card>)list, c -> {
                    for (Card aura : c.getEnchantedBy()) {
                        if (!c.getOwner().isOpponentOf(ai) || !aura.getController().equals(ai)) continue;
                        return false;
                    }
                    return true;
                });
            }
            if (CardLists.getNotType(list, "Creature").isEmpty()) {
                list = ComputerUtilCard.prioritizeCreaturesWorthRemovingNow(ai, list, false);
            }
        }
        if (game.getPhaseHandler().inCombat() && origin.contains((Object)ZoneType.Battlefield) && (!(newList = CardLists.getValidCards((Iterable<Card>)list, "Card.attacking,Card.blocking", null, null, null)).isEmpty() || !sa.isTrigger())) {
            list = newList;
        }
        boolean bl4 = doWithoutTarget = sa.isPwAbility() && sa.usesTargeting() && sa.getMinTargets() == 0 && sa.getPayCosts().hasSpecificCostType(CostPutCounter.class);
        if (list.isEmpty() && !doWithoutTarget) {
            return false;
        }
        list.removeAll(ChangeZoneAi.getSafeTargetsIfUnlessCostPaid(ai, sa, list));
        if (!mandatory && list.size() < sa.getTargetRestrictions().getMinTargets(sa.getHostCard(), sa)) {
            return false;
        }
        while (sa.canAddMoreTarget()) {
            Card firstTarget;
            Card choice = null;
            if (!list.isEmpty()) {
                if (destination.equals((Object)ZoneType.Battlefield) || origin.contains((Object)ZoneType.Battlefield)) {
                    CardCollection originalList = new CardCollection(list);
                    boolean mustTargetFiltered = StaticAbilityMustTarget.filterMustTargetCards(ai, list, sa);
                    Card mostExpensive = ComputerUtilCard.getMostExpensivePermanentAI(list);
                    if (mostExpensive.isCreature()) {
                        if (destination.equals((Object)ZoneType.Exile)) {
                            choice = ComputerUtilCard.getBestCreatureAI(list);
                        } else if (origin.contains((Object)ZoneType.Graveyard)) {
                            choice = mostExpensive;
                            for (Card c2 : list) {
                                if (!"Karmic Guide".equals(c2.getName())) continue;
                                choice = c2;
                                break;
                            }
                        } else {
                            choice = ComputerUtilCard.getBestCreatureToBounceAI(list);
                        }
                    } else {
                        choice = mostExpensive;
                    }
                    if (!immediately && sa.getMaxTargets() == 1 && !ComputerUtilCard.useRemovalNow(sa, choice, 0, destination)) {
                        return false;
                    }
                    if (mustTargetFiltered) {
                        list = originalList;
                    }
                } else if (destination.equals((Object)ZoneType.Hand) || destination.equals((Object)ZoneType.Library)) {
                    CardCollection nonLands = CardLists.getNotType(list, "Land");
                    choice = ChangeZoneAi.chooseCreature(ai, CardLists.filter((Iterable<Card>)nonLands, CardPredicates.Presets.CREATURES));
                    if (choice == null) {
                        if (ai.getLife() <= 5) {
                            CardLists.sortByCmcDesc(nonLands);
                            for (Card potentialCard : nonLands) {
                                if (!ComputerUtilMana.hasEnoughManaSourcesToCast(potentialCard.getFirstSpellAbility(), ai)) continue;
                                choice = potentialCard;
                                break;
                            }
                        } else {
                            choice = ComputerUtilCard.getBestAI(nonLands);
                        }
                    }
                    if (choice == null) {
                        CardLists.shuffle(list);
                        choice = (Card)list.get(false);
                    }
                } else {
                    choice = ComputerUtilCard.getBestAI(list);
                }
            }
            if (choice == null) {
                if (sa.getTargets().isEmpty() || !sa.isTargetNumberValid()) {
                    if (!mandatory) {
                        sa.resetTargets();
                    }
                    if (doWithoutTarget) break;
                    return false;
                }
                if (sa.isTrigger() || ComputerUtil.shouldCastLessThanMax(ai, source)) break;
                boolean aiTgtsOK = false;
                if (sa.hasParam("AIMinTgts")) {
                    int minTgts = Integer.parseInt(sa.getParam("AIMinTgts"));
                    if (sa.getTargets().size() >= minTgts) {
                        aiTgtsOK = true;
                    }
                }
                if (aiTgtsOK) break;
                return false;
            }
            if (sa.hasParam("MaxTotalTargetCMC") && choice.getCMC() > sa.getTargetRestrictions().getMaxTotalCMC(choice, sa) - sa.getTargets().getTotalTargetedCMC()) {
                list.remove(choice);
                continue;
            }
            if (sa.hasParam("MaxTotalTargetPower") && choice.getNetPower() > sa.getTargetRestrictions().getMaxTotalPower(choice, sa) - sa.getTargets().getTotalTargetedPower()) {
                list.remove(choice);
                continue;
            }
            if (sa.getTargetRestrictions().isWithSameCreatureType() && (firstTarget = sa.getTargetCard()) != null && !choice.sharesCreatureTypeWith(firstTarget)) {
                list.remove(choice);
                continue;
            }
            list.remove(choice);
            sa.getTargets().add(choice);
        }
        if (sa.getTargetRestrictions().isSingleZone()) {
            Card firstTgt = sa.getTargetCard();
            CardCollection toRemove = new CardCollection();
            if (firstTgt != null) {
                for (Card t2 : sa.getTargets().getTargetCards()) {
                    if (t2.getController().equals(firstTgt.getController())) continue;
                    toRemove.add(t2);
                }
                sa.getTargets().removeAll(toRemove);
            }
        }
        return true;
    }

    private static Card canBouncePermanent(Player ai, SpellAbility sa, CardCollectionView list) {
        CardCollectionView saheeli;
        Game game = ai.getGame();
        CardCollection aiPermanents = CardLists.filterControlledBy((Iterable<Card>)list, ai);
        CardCollection aiPlaneswalkers = CardLists.filter((Iterable<Card>)aiPermanents, CardPredicates.Presets.PLANESWALKERS);
        if (sa.getHostCard().getName().equals("Felidar Guardian") && !(saheeli = ai.getCardsIn(ZoneType.Battlefield, "Saheeli Rai")).isEmpty()) {
            return (Card)saheeli.get(false);
        }
        aiPermanents = ComputerUtil.getSafeTargets(ai, sa, aiPermanents);
        if (!game.getStack().isEmpty()) {
            List<GameObject> objects = ComputerUtil.predictThreatenedObjects(ai, sa);
            ArrayList<Card> threatenedTargets = Lists.newArrayList(aiPermanents);
            threatenedTargets.retainAll(objects);
            if (!threatenedTargets.isEmpty()) {
                return ComputerUtilCard.getBestAI(threatenedTargets);
            }
        } else if (game.getPhaseHandler().is(PhaseType.COMBAT_DECLARE_BLOCKERS)) {
            Combat combat = game.getCombat();
            CardCollection combatants = CardLists.filter((Iterable<Card>)aiPermanents, CardPredicates.Presets.CREATURES);
            ComputerUtilCard.sortByEvaluateCreature(combatants);
            for (Card c : combatants) {
                if (c.getShieldCount() != 0 || !ComputerUtilCombat.combatantWouldBeDestroyed(ai, c, combat) || c.getOwner() != ai || c.isToken()) continue;
                return c;
            }
        } else if (!(aiPlaneswalkers.isEmpty() || !sa.getHostCard().isSorcery() && game.getPhaseHandler().isPlayerTurn(ai))) {
            int maxLoyaltyToConsider = 2;
            int loyaltyDiff = 2;
            int chance = 30;
            if (ai.getController().isAI()) {
                AiController aic = ((PlayerControllerAi)ai.getController()).getAi();
                maxLoyaltyToConsider = aic.getIntProperty(AiProps.BLINK_RELOAD_PLANESWALKER_MAX_LOYALTY);
                loyaltyDiff = aic.getIntProperty(AiProps.BLINK_RELOAD_PLANESWALKER_LOYALTY_DIFF);
                chance = aic.getIntProperty(AiProps.BLINK_RELOAD_PLANESWALKER_CHANCE);
            }
            if (MyRandom.percentTrue(chance)) {
                aiPlaneswalkers.sort(CardPredicates.compareByCounterType(CounterEnumType.LOYALTY));
                for (Card pw : aiPlaneswalkers) {
                    int curLoyalty = pw.getCounters(CounterEnumType.LOYALTY);
                    int freshLoyalty = Integer.parseInt(pw.getCurrentState().getBaseLoyalty());
                    if (freshLoyalty - curLoyalty < loyaltyDiff || curLoyalty > maxLoyaltyToConsider) continue;
                    return pw;
                }
            }
        }
        Card bestChoice = null;
        int bestEval = 0;
        for (Card c : aiPermanents) {
            int eval;
            Object attached2;
            if (!c.isCreature()) continue;
            boolean hasValuableAttachments = false;
            boolean hasOppAttachments = false;
            int numNegativeCounters = 0;
            int numTotalCounters = 0;
            for (Object attached2 : c.getAttachedCards()) {
                if (!((Card)attached2).isAura()) continue;
                if (((Card)attached2).getController() == c.getController()) {
                    hasValuableAttachments = true;
                    continue;
                }
                if (!((Card)attached2).getController().isOpponentOf(c.getController())) continue;
                hasOppAttachments = true;
            }
            Map<CounterType, Integer> counters = c.getCounters();
            attached2 = counters.keySet().iterator();
            while (attached2.hasNext()) {
                CounterType ct = (CounterType)attached2.next();
                int amount = counters.get(ct);
                if (ComputerUtil.isNegativeCounter(ct, c)) {
                    numNegativeCounters += amount;
                }
                numTotalCounters += amount;
            }
            if (hasValuableAttachments || ComputerUtilCard.isUselessCreature(ai, c) && !hasOppAttachments) continue;
            Card considered = null;
            if ((c.hasKeyword(Keyword.PERSIST) || c.hasKeyword(Keyword.UNDYING)) && !ComputerUtilCard.hasActiveUndyingOrPersist(c)) {
                considered = c;
            } else if (hasOppAttachments || numTotalCounters > 0 && numNegativeCounters > numTotalCounters / 2) {
                considered = c;
            }
            if (considered == null || (eval = ComputerUtilCard.evaluateCreature(c)) <= bestEval) continue;
            bestEval = eval;
            bestChoice = considered;
        }
        if (bestChoice != null) {
            return bestChoice;
        }
        return null;
    }

    private static boolean isUnpreferredTarget(Player ai, SpellAbility sa, boolean mandatory) {
        if (!mandatory && !"Always".equals(sa.getParam("AILogic"))) {
            return false;
        }
        Card source = sa.getHostCard();
        ZoneType destination = ZoneType.smartValueOf(sa.getParam("Destination"));
        TargetRestrictions tgt = sa.getTargetRestrictions();
        List<Card> list = CardUtil.getValidCardsToTarget(sa);
        if (list.isEmpty()) {
            return false;
        }
        while (!sa.isMinTargetChosen()) {
            Card choice = null;
            if (!list.isEmpty()) {
                Card mostExpensivePermanent = ComputerUtilCard.getMostExpensivePermanentAI(list);
                if (mostExpensivePermanent.isCreature() && (destination.equals((Object)ZoneType.Battlefield) || tgt.getZone().contains((Object)ZoneType.Battlefield))) {
                    choice = ComputerUtilCard.getBestCreatureToBounceAI(list);
                } else if (destination.equals((Object)ZoneType.Battlefield) || tgt.getZone().contains((Object)ZoneType.Battlefield)) {
                    choice = mostExpensivePermanent;
                } else if (destination.equals((Object)ZoneType.Hand) || destination.equals((Object)ZoneType.Library)) {
                    CardCollection nonLands = CardLists.getNotType(list, "Land");
                    choice = ChangeZoneAi.chooseCreature(ai, CardLists.filter((Iterable<Card>)nonLands, CardPredicates.Presets.CREATURES));
                    if (choice == null) {
                        if (ai.getLife() <= 5) {
                            CardLists.sortByCmcDesc(nonLands);
                            for (Card potentialCard : nonLands) {
                                if (!ComputerUtilMana.hasEnoughManaSourcesToCast(potentialCard.getFirstSpellAbility(), ai)) continue;
                                choice = potentialCard;
                                break;
                            }
                        } else {
                            choice = ComputerUtilCard.getBestAI(nonLands);
                        }
                    }
                    if (choice == null) {
                        CardLists.shuffle(list);
                        choice = list.get(0);
                    }
                } else {
                    choice = ComputerUtilCard.getBestAI(list);
                }
            }
            if (choice == null) {
                if (sa.getTargets().size() == 0 || sa.getTargets().size() < tgt.getMinTargets(sa.getHostCard(), sa)) {
                    sa.resetTargets();
                    return false;
                }
                if (ComputerUtil.shouldCastLessThanMax(ai, source)) break;
                return false;
            }
            list.remove(choice);
            sa.getTargets().add(choice);
        }
        return true;
    }

    private static boolean knownOriginTriggerAI(Player ai, SpellAbility sa, boolean mandatory) {
        String logic = sa.getParamOrDefault("AILogic", "");
        if ("DeathgorgeScavenger".equals(logic)) {
            return SpecialCardAi.DeathgorgeScavenger.consider(ai, sa);
        }
        if ("ExtraplanarLens".equals(logic)) {
            return SpecialCardAi.ExtraplanarLens.consider(ai, sa);
        }
        if ("ExileCombatThreat".equals(logic)) {
            return ChangeZoneAi.doExileCombatThreatLogic(ai, sa);
        }
        if (!sa.usesTargeting()) {
            CardCollection list;
            if (!mandatory && sa.hasParam("AttachedTo") && !(list = AbilityUtils.getDefinedCards(sa.getHostCard(), sa.getParam("AttachedTo"), sa)).isEmpty()) {
                Card attachedTo = (Card)list.get(0);
                return !attachedTo.getController().isOpponentOf(ai);
            }
        } else if (!ChangeZoneAi.isPreferredTarget(ai, sa, mandatory, true)) {
            return ChangeZoneAi.isUnpreferredTarget(ai, sa, mandatory);
        }
        return true;
    }

    public static Card chooseCardToHiddenOriginChangeZone(ZoneType destination, List<ZoneType> origin, SpellAbility sa, CardCollection fetchList, Player player, Player decider) {
        if (fetchList.isEmpty()) {
            return null;
        }
        if (sa.hasParam("AILogic")) {
            String logic = sa.getParamOrDefault("AILogic", "");
            if ("NeverBounceItself".equals(logic)) {
                Card source = sa.getHostCard();
                if (fetchList.contains(source) && (fetchList.size() > 1 || !sa.getRootAbility().isMandatory())) {
                    fetchList.remove(source);
                }
            } else {
                if ("WorstCard".equals(logic)) {
                    return ComputerUtilCard.getWorstAI(fetchList);
                }
                if ("BestCard".equals(logic)) {
                    return ComputerUtilCard.getBestAI(fetchList);
                }
                if ("Mairsil".equals(logic)) {
                    return SpecialCardAi.MairsilThePretender.considerCardFromList(fetchList);
                }
                if ("SurvivalOfTheFittest".equals(logic)) {
                    return SpecialCardAi.SurvivalOfTheFittest.considerCardToGet(decider, sa);
                }
                if ("MazesEnd".equals(logic)) {
                    return SpecialCardAi.MazesEnd.considerCardToGet(decider, sa);
                }
                if ("Intuition".equals(logic)) {
                    if (!multipleCardsToChoose.isEmpty()) {
                        Card choice = (Card)multipleCardsToChoose.get(false);
                        multipleCardsToChoose.remove(0);
                        return choice;
                    }
                } else if (logic.startsWith("ExilePreference")) {
                    return ChangeZoneAi.doExilePreferenceLogic(decider, sa, fetchList);
                }
            }
        }
        if (fetchList.isEmpty()) {
            return null;
        }
        String type = sa.getParam("ChangeType");
        if (type == null) {
            type = "Card";
        }
        Card c = null;
        Player activator = sa.getActivatingPlayer();
        CardLists.shuffle(fetchList);
        Card first = (Card)fetchList.get(false);
        if (ZoneType.Battlefield.equals((Object)destination)) {
            fetchList = CardLists.filter((Iterable<Card>)fetchList, c1 -> {
                if (c1.getType().isLegendary()) {
                    return !decider.isCardInPlay(c1.getName());
                }
                return true;
            });
            if (player.isOpponentOf(decider) && sa.hasParam("GainControl") && activator.equals(decider)) {
                fetchList = CardLists.filter((Iterable<Card>)fetchList, c12 -> !ComputerUtilCard.isCardRemAIDeck(c12) && !ComputerUtilCard.isCardRemRandomDeck(c12));
            }
        }
        if (ZoneType.Exile.equals((Object)destination) || origin.contains((Object)ZoneType.Battlefield) || ZoneType.Library.equals((Object)destination) && origin.contains((Object)ZoneType.Hand)) {
            if (player.isOpponentOf(decider)) {
                c = ComputerUtilCard.getBestAI(fetchList);
            } else {
                Card tobounce;
                if (!sa.hasParam("Mandatory") && origin.contains((Object)ZoneType.Battlefield) && sa.hasParam("ChangeNum") && (fetchList = ChangeZoneAi.prefilterOwnListForBounceAnyNum(fetchList, decider)).isEmpty()) {
                    return null;
                }
                c = ComputerUtilCard.getWorstAI(fetchList);
                if (ComputerUtilAbility.getAbilitySourceName(sa).equals("Temur Sabertooth") && (tobounce = ChangeZoneAi.canBouncePermanent(player, sa, fetchList)) != null) {
                    c = tobounce;
                    ChangeZoneAi.rememberBouncedThisTurn(player, c);
                }
            }
        } else if (origin.contains((Object)ZoneType.Library) && (type.contains("Basic") || ChangeZoneAi.areAllBasics(type))) {
            c = ChangeZoneAi.basicManaFixing(decider, fetchList);
        } else if (ZoneType.Hand.equals((Object)destination) && CardLists.getNotType(fetchList, "Creature").isEmpty()) {
            c = ChangeZoneAi.chooseCreature(decider, fetchList);
        } else if (ZoneType.Battlefield.equals((Object)destination) || ZoneType.Graveyard.equals((Object)destination)) {
            c = !activator.equals(decider) && sa.hasParam("GainControl") ? ComputerUtilCard.getWorstAI(fetchList) : ComputerUtilCard.getBestAI(fetchList);
        } else {
            CardCollectionView hand;
            CardCollection sameNamed = CardLists.filter((Iterable<Card>)fetchList, Predicates.not(CardPredicates.nameEquals(ComputerUtilAbility.getAbilitySourceName(sa))));
            if (origin.contains((Object)ZoneType.Library) && !sameNamed.isEmpty()) {
                fetchList = sameNamed;
            }
            if (!Iterables.any(hand = decider.getCardsIn(ZoneType.Hand), CardPredicates.Presets.LANDS) && CardLists.count(decider.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.LANDS) < 4) {
                boolean canCastSomething = false;
                for (Card cardInHand : hand) {
                    canCastSomething = canCastSomething || ComputerUtilMana.hasEnoughManaSourcesToCast(cardInHand.getFirstSpellAbility(), decider);
                }
                if (!canCastSomething) {
                    c = ChangeZoneAi.basicManaFixing(decider, fetchList);
                }
            }
            if (c == null) {
                if (Iterables.all(fetchList, CardPredicates.Presets.LANDS)) {
                    c = ComputerUtilCard.getBestLandAI(fetchList);
                } else {
                    fetchList = CardLists.getNotType(fetchList, "Land");
                    c = ChangeZoneAi.chooseCreature(decider, CardLists.filter((Iterable<Card>)fetchList, CardPredicates.Presets.CREATURES));
                }
            }
            if (c == null) {
                if (decider.getLife() <= 5) {
                    CardLists.sortByCmcDesc(fetchList);
                    for (Card potentialCard : fetchList) {
                        if (!ComputerUtilMana.hasEnoughManaSourcesToCast(potentialCard.getFirstSpellAbility(), decider)) continue;
                        c = potentialCard;
                        break;
                    }
                } else {
                    c = ComputerUtilCard.getBestAI(fetchList);
                }
            }
        }
        if (c == null) {
            c = first;
        }
        return c;
    }

    private static CardCollection prefilterOwnListForBounceAnyNum(CardCollection fetchList, Player decider) {
        fetchList = CardLists.filter((Iterable<Card>)fetchList, card -> {
            if (card.isToken()) {
                return false;
            }
            if (card.isCreature() && ComputerUtilCard.isUselessCreature(decider, card)) {
                return true;
            }
            if (card.isEquipped()) {
                return false;
            }
            if (card.isEnchanted()) {
                for (Card enc : card.getEnchantedBy()) {
                    if (!enc.getOwner().isOpponentOf(decider)) continue;
                    return true;
                }
                return false;
            }
            if (card.hasCounters()) {
                if (card.isPlaneswalker()) {
                    int maxLoyaltyToConsider = 2;
                    int loyaltyDiff = 2;
                    int chance = 30;
                    if (decider.getController().isAI()) {
                        AiController aic = ((PlayerControllerAi)decider.getController()).getAi();
                        maxLoyaltyToConsider = aic.getIntProperty(AiProps.BLINK_RELOAD_PLANESWALKER_MAX_LOYALTY);
                        loyaltyDiff = aic.getIntProperty(AiProps.BLINK_RELOAD_PLANESWALKER_LOYALTY_DIFF);
                        chance = aic.getIntProperty(AiProps.BLINK_RELOAD_PLANESWALKER_CHANCE);
                    }
                    if (MyRandom.percentTrue(chance)) {
                        int curLoyalty = card.getCounters(CounterEnumType.LOYALTY);
                        int freshLoyalty = Integer.parseInt(card.getCurrentState().getBaseLoyalty());
                        if (freshLoyalty - curLoyalty >= loyaltyDiff && curLoyalty <= maxLoyaltyToConsider) {
                            return true;
                        }
                    }
                } else if (card.isCreature() && card.getCounters(CounterEnumType.M1M1) > 0) {
                    return true;
                }
                return false;
            }
            return !card.isAura();
        });
        return fetchList;
    }

    @Override
    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        return true;
    }

    @Override
    public Card chooseSingleCard(Player ai, SpellAbility sa, Iterable<Card> options, boolean isOptional, Player targetedPlayer, Map<String, Object> params) {
        return AttachAi.attachGeneralAI(ai, sa, (List)options, !isOptional, (Card)params.get("Attach"), sa.getParam("AILogic"));
    }

    @Override
    public Player chooseSinglePlayer(Player ai, SpellAbility sa, Iterable<Player> options, Map<String, Object> params) {
        if (params != null && params.containsKey("Attacker")) {
            return (Player)ComputerUtilCombat.addAttackerToCombat(sa, (Card)params.get("Attacker"), options);
        }
        return AttachAi.attachToPlayerAIPreferences(ai, sa, true, (List)options);
    }

    @Override
    protected GameEntity chooseSingleAttackableEntity(Player ai, SpellAbility sa, Iterable<GameEntity> options, Map<String, Object> params) {
        if (params != null && params.containsKey("Attacker")) {
            return ComputerUtilCombat.addAttackerToCombat(sa, (Card)params.get("Attacker"), options);
        }
        return super.chooseSingleAttackableEntity(ai, sa, options, params);
    }

    private boolean doSacAndReturnFromGraveLogic(Player ai, SpellAbility sa) {
        Card source = sa.getHostCard();
        String definedSac = StringUtils.split(source.getSVar("AIPreference"), "$")[1];
        CardCollection listToSac = CardLists.getValidCards((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), definedSac, ai, source, (CardTraitBase)sa);
        listToSac.sort(Collections.reverseOrder(CardLists.CmcComparatorInv));
        CardCollection listToRet = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Graveyard), CardPredicates.Presets.CREATURES);
        listToRet.sort(CardLists.CmcComparatorInv);
        if (!listToSac.isEmpty() && !listToRet.isEmpty()) {
            Card worstSac = (Card)listToSac.getFirst();
            Card bestRet = (Card)listToRet.getFirst();
            if (bestRet.getCMC() > worstSac.getCMC() && ComputerUtilCard.evaluateCreature(bestRet) > ComputerUtilCard.evaluateCreature(worstSac)) {
                sa.resetTargets();
                sa.getTargets().add(bestRet);
                source.setSVar("AIPreferenceOverride", "Creature.cmcEQ" + worstSac.getCMC());
                return true;
            }
        }
        return false;
    }

    private boolean doSacAndUpgradeLogic(Player ai, SpellAbility sa) {
        Card source = sa.getHostCard();
        PhaseHandler ph = ai.getGame().getPhaseHandler();
        String logic = sa.getParam("AILogic");
        boolean sacWorst = logic.contains("SacWorst");
        if (!ph.is(PhaseType.MAIN2)) {
            return false;
        }
        String definedSac = StringUtils.split(source.getSVar("AIPreference"), "$")[1];
        String definedGoal = sa.getParam("ChangeType");
        boolean anyCMC = !definedGoal.contains(".cmc");
        CardCollection listToSac = CardLists.getValidCards((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), definedSac, ai, source, (CardTraitBase)sa);
        listToSac.sort(!sacWorst ? CardLists.CmcComparatorInv : Collections.reverseOrder(CardLists.CmcComparatorInv));
        for (Card sacCandidate : listToSac) {
            int sacCMC = sacCandidate.getCMC();
            int goalCMC = source.hasSVar("X") ? AbilityUtils.calculateAmount(source, source.getSVar("X").replace("Sacrificed$CardManaCost", "Number$" + sacCMC), sa) : sacCMC + 1;
            String curGoal = definedGoal;
            if (!anyCMC) {
                curGoal = definedGoal.replace("X", String.format("%d", goalCMC));
            }
            CardCollection listGoal = CardLists.getValidCards((Iterable<Card>)ai.getCardsIn(ZoneType.Library), curGoal, ai, source, (CardTraitBase)sa);
            listGoal = !anyCMC ? CardLists.getValidCards((Iterable<Card>)listGoal, curGoal, source.getController(), source, (CardTraitBase)sa) : CardLists.getValidCards((Iterable<Card>)listGoal, curGoal + (curGoal.contains(".") ? "+" : ".") + "cmcGE" + goalCMC, source.getController(), source, (CardTraitBase)sa);
            if ((listGoal = CardLists.filter((Iterable<Card>)listGoal, c -> {
                if (c.getType().isLegendary()) {
                    return !ai.isCardInPlay(c.getName());
                }
                return true;
            })).isEmpty()) continue;
            source.setSVar("AIPreferenceOverride", "Creature.cmcEQ" + sacCMC);
            return true;
        }
        return false;
    }

    public boolean doReturnCommanderLogic(SpellAbility sa, Player aiPlayer) {
        Map originalParams = (Map)sa.getReplacingObject(AbilityKey.OriginalParams);
        SpellAbility causeSa = (SpellAbility)originalParams.get((Object)AbilityKey.Cause);
        AbilitySub causeSub = null;
        ZoneType destination = (ZoneType)((Object)originalParams.get((Object)AbilityKey.Destination));
        if (Objects.equals((Object)ZoneType.Hand, (Object)destination)) {
            return false;
        }
        if (sa.getHostCard().getName().contains("Squee, the Immortal") && (destination == ZoneType.Graveyard || destination == ZoneType.Exile)) {
            return false;
        }
        if (causeSa != null && (causeSub = causeSa.getSubAbility()) != null) {
            ApiType subApi = causeSub.getApi();
            if (subApi == ApiType.ChangeZone && "Exile".equals(causeSub.getParam("Origin")) && "Battlefield".equals(causeSub.getParam("Destination"))) {
                return false;
            }
            if (subApi == ApiType.DelayedTrigger) {
                SpellAbility exec = causeSub.getAdditionalAbility("Execute");
                if (exec != null && exec.getApi() == ApiType.ChangeZone) {
                    return !"Exile".equals(exec.getParam("Origin")) || !"Battlefield".equals(exec.getParam("Destination"));
                }
            } else {
                return causeSa.getHostCard() == null || !causeSa.getHostCard().equals(sa.getReplacingObject(AbilityKey.Card)) || !causeSa.getActivatingPlayer().equals(aiPlayer);
            }
        }
        return true;
    }

    public static boolean doExileCombatThreatLogic(Player aiPlayer, SpellAbility sa) {
        Combat combat = aiPlayer.getGame().getCombat();
        if (combat == null) {
            return false;
        }
        Card choice = null;
        int highestEval = -1;
        if (combat.getAttackingPlayer().isOpponentOf(aiPlayer)) {
            for (Card attacker : combat.getAttackers()) {
                if (!sa.canTarget(attacker)) continue;
                int eval = ComputerUtilCard.evaluateCreature(attacker);
                if (combat.isUnblocked(attacker)) {
                    eval += 100;
                }
                if (eval <= highestEval) continue;
                highestEval = eval;
                choice = attacker;
            }
        } else {
            for (Card blocker : combat.getAllBlockers()) {
                int eval;
                if (!sa.canTarget(blocker) || !blocker.getController().isOpponentOf(aiPlayer) || (eval = ComputerUtilCard.evaluateCreature(blocker)) <= highestEval) continue;
                highestEval = eval;
                choice = blocker;
            }
        }
        if (choice != null) {
            sa.getTargets().add(choice);
            return true;
        }
        return false;
    }

    public static Card doExilePreferenceLogic(Player aiPlayer, SpellAbility sa, CardCollection fetchList) {
        if (fetchList.isEmpty()) {
            return null;
        }
        Card host = sa.getHostCard();
        String logic = sa.getParamOrDefault("AILogic", "");
        String valid = logic.split(":")[1];
        boolean isCurse = logic.contains("Curse");
        boolean isOwnOnly = logic.contains("OwnOnly");
        boolean isWorstChoice = logic.contains("Worst");
        boolean isRandomChoice = logic.contains("Random");
        if (logic.endsWith("HighestCMC")) {
            return ComputerUtilCard.getMostExpensivePermanentAI(fetchList);
        }
        if (logic.contains("MostProminent")) {
            CardCollection scanList = new CardCollection();
            if (logic.endsWith("OwnType")) {
                scanList.addAll(aiPlayer.getCardsIn(ZoneType.Library));
                scanList.addAll(aiPlayer.getCardsIn(ZoneType.Hand));
            } else if (logic.endsWith("OppType")) {
                scanList.addAll(aiPlayer.getOpponents().getCardsIn(ZoneType.Library));
                scanList.addAll(aiPlayer.getOpponents().getCardsIn(ZoneType.Hand));
            }
            if (logic.contains("NonLand")) {
                scanList = CardLists.filter((Iterable<Card>)scanList, Predicates.not(CardPredicates.Presets.LANDS));
            }
            if (logic.contains("NonExiled")) {
                CardCollection exiledBy = new CardCollection();
                for (Object exiled : aiPlayer.getGame().getCardsIn(ZoneType.Exile)) {
                    if (((Card)exiled).getExiledWith() == null || !((Card)exiled).getExiledWith().getName().equals(host.getName())) continue;
                    exiledBy.add(exiled);
                }
                scanList = CardLists.filter((Iterable<Card>)scanList, card -> {
                    if (exiledBy.isEmpty()) {
                        return true;
                    }
                    Iterator iterator = exiledBy.iterator();
                    if (iterator.hasNext()) {
                        Card c = (Card)iterator.next();
                        return !c.getType().sharesCardTypeWith(card.getType());
                    }
                    return true;
                });
            }
            CardCollectionView graveyardList = aiPlayer.getGame().getCardsIn(ZoneType.Graveyard);
            HashSet<CardType.CoreType> presentTypes = new HashSet<CardType.CoreType>();
            for (Object inGrave : graveyardList) {
                for (CardType.CoreType coreType : ((Card)inGrave).getType().getCoreTypes()) {
                    presentTypes.add(coreType);
                }
            }
            HashMap<CardType.CoreType, Integer> typesInDeck = Maps.newHashMap();
            for (Card c : scanList) {
                for (CardType.CoreType coreType : c.getType().getCoreTypes()) {
                    if (!presentTypes.contains((Object)coreType)) continue;
                    Integer count = (Integer)typesInDeck.get((Object)coreType);
                    if (count == null) {
                        count = 0;
                    }
                    typesInDeck.put(coreType, count + 1);
                }
            }
            int max = 0;
            CardType.CoreType maxType = CardType.CoreType.Land;
            for (Map.Entry entry : typesInDeck.entrySet()) {
                CardType.CoreType type = (CardType.CoreType)((Object)entry.getKey());
                if (max >= (Integer)entry.getValue()) continue;
                max = (Integer)entry.getValue();
                maxType = type;
            }
            CardType.CoreType coreType = maxType;
            CardCollection cardCollection = CardLists.filter((Iterable<Card>)fetchList, card -> card.getType().hasType(determinedMaxType));
            CardCollection preferredOppList = CardLists.filter((Iterable<Card>)cardCollection, CardPredicates.isControlledByAnyOf(aiPlayer.getOpponents()));
            if (!preferredOppList.isEmpty()) {
                return Aggregates.random(preferredOppList);
            }
            if (!cardCollection.isEmpty()) {
                return Aggregates.random(cardCollection);
            }
            return Aggregates.random(fetchList);
        }
        CardCollection preferredList = CardLists.filter((Iterable<Card>)fetchList, card -> {
            boolean playerPref = true;
            if (isCurse) {
                playerPref = card.getController().isOpponentOf(aiPlayer);
            } else if (isOwnOnly) {
                boolean bl = playerPref = card.getController().equals(aiPlayer) || !card.getController().isOpponentOf(aiPlayer);
            }
            if (!playerPref) {
                return false;
            }
            return card.isValid(valid, aiPlayer, host, (CardTraitBase)sa);
        });
        if (!preferredList.isEmpty()) {
            if (isRandomChoice) {
                return Aggregates.random(preferredList);
            }
            return isWorstChoice ? ComputerUtilCard.getWorstAI(preferredList) : ComputerUtilCard.getBestAI(preferredList);
        }
        if (isRandomChoice) {
            return Aggregates.random(preferredList);
        }
        return isWorstChoice ? ComputerUtilCard.getWorstAI(fetchList) : ComputerUtilCard.getBestAI(fetchList);
    }

    private boolean doExileSpellLogic(Player aiPlayer, SpellAbility sa) {
        SpellAbility topSA;
        String aiLogic = sa.getParamOrDefault("AILogic", "");
        SpellAbilityStackInstance top = aiPlayer.getGame().getStack().peek();
        List<ApiType> dangerousApi = Arrays.asList(ApiType.DealDamage, ApiType.DamageAll, ApiType.Destroy, ApiType.DestroyAll, ApiType.Sacrifice, ApiType.SacrificeAll);
        int manaCost = 0;
        int minCost = 0;
        if (aiLogic.contains(".")) {
            minCost = Integer.parseInt(aiLogic.substring(aiLogic.indexOf(".") + 1));
        }
        if (top != null && (topSA = top.getSpellAbility()) != null) {
            if (topSA.getPayCosts().hasManaCost()) {
                manaCost = topSA.getPayCosts().getTotalMana().getCMC();
            }
            if ((manaCost >= minCost || dangerousApi.contains((Object)topSA.getApi())) && topSA.getActivatingPlayer().isOpponentOf(aiPlayer) && sa.canTargetSpellAbility(topSA)) {
                sa.resetTargets();
                sa.getTargets().add(topSA);
                return sa.isTargetNumberValid();
            }
        }
        return false;
    }

    private static CardCollection getSafeTargetsIfUnlessCostPaid(Player ai, SpellAbility sa, Iterable<Card> potentialTgts) {
        Card source = sa.getHostCard();
        CardCollection canBeSaved = new CardCollection();
        for (Card potentialTgt : potentialTgts) {
            String unlessCost = sa.hasParam("UnlessCost") ? sa.getParam("UnlessCost").trim() : null;
            if (unlessCost == null || unlessCost.endsWith(">")) continue;
            Player opp = potentialTgt.getController();
            int usableManaSources = ComputerUtilMana.getAvailableManaEstimate(opp);
            int toPay = 0;
            boolean setPayX = false;
            if (unlessCost.equals("X") && sa.getSVar(unlessCost).equals("Count$xPaid")) {
                setPayX = true;
                toPay = ComputerUtilCost.getMaxXValue(sa, ai, true);
            } else {
                toPay = AbilityUtils.calculateAmount(source, unlessCost, sa);
            }
            if (toPay == 0 || toPay <= usableManaSources) {
                canBeSaved.add(potentialTgt);
            }
            if (!setPayX) continue;
            sa.setXManaCostPaid(toPay);
        }
        return canBeSaved;
    }

    private static void rememberBouncedThisTurn(Player ai, Card c) {
        AiCardMemory.rememberCard(ai, c, AiCardMemory.MemorySet.BOUNCED_THIS_TURN);
    }

    private static boolean isBouncedThisTurn(Player ai, Card c) {
        return AiCardMemory.isRememberedCard(ai, c, AiCardMemory.MemorySet.BOUNCED_THIS_TURN);
    }
}

