/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.ai.AiCardMemory;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCost;
import forge.ai.ComputerUtilMana;
import forge.ai.SpellAbilityAi;
import forge.card.CardType;
import forge.card.ColorSet;
import forge.game.CardTraitBase;
import forge.game.CardTraitPredicates;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.ability.effects.AnimateEffectBase;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCopyService;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardTraitChanges;
import forge.game.card.CardUtil;
import forge.game.card.CounterEnumType;
import forge.game.combat.Combat;
import forge.game.cost.CostPutCounter;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbility;
import forge.game.staticability.StaticAbilityContinuous;
import forge.game.staticability.StaticAbilityLayer;
import forge.game.zone.ZoneType;
import forge.util.FileSection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnimateAi
extends SpellAbilityAi {
    @Override
    protected boolean checkAiLogic(Player ai, SpellAbility sa, String aiLogic) {
        Game game = ai.getGame();
        PhaseHandler ph = game.getPhaseHandler();
        if ("Attacking".equals(aiLogic)) {
            if (ph.getPlayerTurn().isOpponentOf(ai) || ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_ATTACKERS)) {
                return false;
            }
            CardCollection list = CardLists.getTargetableCards(ai.getCreaturesInPlay(), sa);
            for (Card c : list) {
                if (!ComputerUtilCard.doesCreatureAttackAI(ai, c)) continue;
                sa.getTargets().add(c);
            }
            return !sa.getTargets().isEmpty();
        }
        if ("EOT".equals(aiLogic) && ph.getPhase().isBefore(PhaseType.MAIN2)) {
            return false;
        }
        if ("BoneManCantRegenerate".equals(aiLogic)) {
            Card host = sa.getHostCard();
            String svar = AbilityUtils.getSVar(sa, sa.getParam("staticAbilities"));
            if (svar == null) {
                return false;
            }
            Map<String, String> map = FileSection.parseToMap(svar, FileSection.DOLLAR_SIGN_KV_SEPARATOR);
            if (!map.containsKey("Description")) {
                return false;
            }
            if (Iterables.any(host.getStaticAbilities(), CardTraitPredicates.hasParam("Description", map.get("Description")))) {
                return false;
            }
        }
        return super.checkAiLogic(ai, sa, aiLogic);
    }

    @Override
    protected boolean checkPhaseRestrictions(Player ai, SpellAbility sa, PhaseHandler ph) {
        boolean activateAsPotentialBlocker;
        SpellAbility topStack;
        Card source = sa.getHostCard();
        Game game = ai.getGame();
        if (!game.getStack().isEmpty() && (topStack = game.getStack().peekAbility()).getApi() == ApiType.Sacrifice) {
            String valid = topStack.getParamOrDefault("SacValid", "Card.Self");
            String num = topStack.getParamOrDefault("Amount", "1");
            int nToSac = AbilityUtils.calculateAmount(topStack.getHostCard(), num, topStack);
            CardCollection list = CardLists.getValidCards((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), valid, ai.getWeakestOpponent(), topStack.getHostCard(), (CardTraitBase)topStack);
            list = CardLists.filter((Iterable<Card>)list, CardPredicates.canBeSacrificedBy(topStack, true));
            ComputerUtilCard.sortByEvaluateCreature(list);
            if (!list.isEmpty() && list.size() == nToSac && ComputerUtilCost.canPayCost(sa, ai, sa.isTrigger())) {
                Card animatedCopy = AnimateAi.becomeAnimated(source, sa);
                list.add(animatedCopy);
                list = CardLists.getValidCards((Iterable<Card>)list, valid, ai.getWeakestOpponent(), topStack.getHostCard(), (CardTraitBase)topStack);
                list = CardLists.filter((Iterable<Card>)list, CardPredicates.canBeSacrificedBy(topStack, true));
                if (ComputerUtilCard.evaluateCreature(animatedCopy) < ComputerUtilCard.evaluateCreature((Card)list.get(false)) && list.contains(animatedCopy)) {
                    return true;
                }
            }
        }
        if (!(ph.is(PhaseType.COMBAT_BEGIN) || !ph.isPlayerTurn(ai) || AnimateAi.isSorcerySpeed(sa, ai) || sa.hasParam("ActivationPhases") || "Permanent".equals(sa.getParam("Duration")))) {
            return false;
        }
        if (ph.getPlayerTurn().isOpponentOf(ai) && !"Permanent".equals(sa.getParam("Duration")) && (!ph.is(PhaseType.COMBAT_DECLARE_ATTACKERS) || ph.inCombat() && game.getCombat().getAttackersOf(ai).isEmpty())) {
            return false;
        }
        if (ph.is(PhaseType.MAIN2) && !"Permanent".equals(sa.getParam("Duration")) && !"UntilYourNextTurn".equals(sa.getParam("Duration"))) {
            return false;
        }
        Player opponent = ai.getWeakestOpponent();
        boolean bl = activateAsPotentialBlocker = "UntilYourNextTurn".equals(sa.getParam("Duration")) && game.getPhaseHandler().getNextTurn() != ai && source.isPermanent();
        return !ph.isPlayerTurn(ai) || ai.getLife() >= 6 || opponent.getLife() <= 6 || !opponent.getZone(ZoneType.Battlefield).contains(CardPredicates.Presets.CREATURES) || sa.hasParam("AILogic") || "Permanent".equals(sa.getParam("Duration")) || activateAsPotentialBlocker;
    }

    @Override
    protected boolean checkApiLogic(Player aiPlayer, SpellAbility sa) {
        Card source = sa.getHostCard();
        Game game = aiPlayer.getGame();
        PhaseHandler ph = game.getPhaseHandler();
        if (!sa.metConditions() && sa.getSubAbility() == null) {
            return false;
        }
        if (!game.getStack().isEmpty() && game.getStack().peekAbility().getApi() == ApiType.Sacrifice && !AnimateAi.isAnimatedThisTurn(aiPlayer, source)) {
            this.rememberAnimatedThisTurn(aiPlayer, source);
            return true;
        }
        if (!ComputerUtilCost.checkTapTypeCost(aiPlayer, sa.getPayCosts(), source, sa, new CardCollection())) {
            return false;
        }
        if (sa.costHasManaX() && sa.getSVar("X").equals("Count$xPaid")) {
            int xPay = ComputerUtilCost.getMaxXValue(sa, aiPlayer, sa.isTrigger());
            sa.setXManaCostPaid(xPay);
        }
        if (!sa.usesTargeting()) {
            CardCollection defined = AbilityUtils.getDefinedCards(source, sa.getParam("Defined"), sa);
            boolean bFlag = false;
            boolean givesHaste = sa.hasParam("Keywords") && sa.getParam("Keywords").contains("Haste");
            for (Card c : defined) {
                if (!(bFlag |= !c.isCreature() && !c.isTapped() && (!c.hasSickness() || givesHaste || !ph.isPlayerTurn(aiPlayer)) && !c.isEquipping()) && c.isCreature() && ("Permanent".equals(sa.getParam("Duration")) || !c.isTapped() && !c.isSick())) {
                    int power = -5;
                    if (sa.hasParam("Power")) {
                        power = AbilityUtils.calculateAmount(c, sa.getParam("Power"), sa);
                    }
                    int toughness = -5;
                    if (sa.hasParam("Toughness")) {
                        toughness = AbilityUtils.calculateAmount(c, sa.getParam("Toughness"), sa);
                    }
                    if (sa.hasParam("Keywords")) {
                        for (String keyword : sa.getParam("Keywords").split(" & ")) {
                            if (c.hasKeyword(keyword)) continue;
                            bFlag = true;
                        }
                    }
                    if (power + toughness > c.getCurrentPower() + c.getCurrentToughness() && (!c.isTapped() || ph.inCombat() && game.getCombat().isAttacking(c))) {
                        bFlag = true;
                    }
                }
                if (AnimateAi.isSorcerySpeed(sa, aiPlayer) || "Permanent".equals(sa.getParam("Duration"))) continue;
                if (sa.isCrew() && c.isCreature()) {
                    return false;
                }
                Card animatedCopy = AnimateAi.becomeAnimated(c, sa);
                if (ph.isPlayerTurn(aiPlayer) && !ComputerUtilCard.doesSpecifiedCreatureAttackAI(aiPlayer, animatedCopy)) {
                    return false;
                }
                if (ph.getPlayerTurn().isOpponentOf(aiPlayer) && !ComputerUtilCard.doesSpecifiedCreatureBlock(aiPlayer, animatedCopy)) {
                    return false;
                }
                if (animatedCopy.getCurrentPower() + animatedCopy.getCurrentToughness() <= c.getCurrentPower() + c.getCurrentToughness() || AnimateAi.isAnimatedThisTurn(aiPlayer, sa.getHostCard()) || c.isTapped() && (!ph.inCombat() || !game.getCombat().isAttacking(c))) continue;
                bFlag = true;
            }
            if (bFlag) {
                this.rememberAnimatedThisTurn(aiPlayer, sa.getHostCard());
            }
            return bFlag;
        }
        sa.resetTargets();
        return this.animateTgtAI(sa);
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player aiPlayer) {
        if (sa.usesTargeting()) {
            sa.resetTargets();
            return this.animateTgtAI(sa);
        }
        return true;
    }

    @Override
    protected boolean doTriggerAINoCost(Player aiPlayer, SpellAbility sa, boolean mandatory) {
        if (sa.usesTargeting() && !this.animateTgtAI(sa) && !mandatory) {
            return false;
        }
        if (sa.usesTargeting() && mandatory) {
            sa.resetTargets();
            List<Card> list = CardUtil.getValidCardsToTarget(sa);
            if (list.isEmpty()) {
                return false;
            }
            Card toAnimate = ComputerUtilCard.getWorstAI(list);
            this.rememberAnimatedThisTurn(aiPlayer, toAnimate);
            sa.getTargets().add(toAnimate);
        }
        return true;
    }

    @Override
    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        return player.getGame().getPhaseHandler().getPhase().isBefore(PhaseType.MAIN2);
    }

    private boolean animateTgtAI(SpellAbility sa) {
        Card worst;
        Card buffed;
        Player ai = sa.getActivatingPlayer();
        PhaseHandler ph = ai.getGame().getPhaseHandler();
        String logic = sa.getParamOrDefault("AILogic", "");
        boolean alwaysActivatePWAbility = sa.isPwAbility() && sa.getPayCosts().hasSpecificCostType(CostPutCounter.class) && sa.usesTargeting() && sa.getTargetRestrictions().getMinTargets(sa.getHostCard(), sa) == 0;
        CardType types = new CardType(true);
        if (sa.hasParam("Types")) {
            types.addAll(Arrays.asList(sa.getParam("Types").split(",")));
        }
        if (types.isCreature()) {
            Game game = ai.getGame();
            CardCollection list = CardLists.getTargetableCards(game.getCardsIn(ZoneType.Battlefield), sa);
            if ((list = ComputerUtil.filterAITgts(sa, ai, list, false)).isEmpty() && !alwaysActivatePWAbility) {
                return false;
            }
            HashMap<Card, Integer> data = Maps.newHashMap();
            for (Card c : list) {
                int cValue;
                if (c.hasSVar("EndOfTurnLeavePlay") && "Permanent".equals(sa.getParam("Duration")) || c.getController().isOpponentOf(ai) && !sa.isCurse() || c.isTapped()) continue;
                Card animatedCopy = AnimateAi.becomeAnimated(c, sa);
                int aValue = ComputerUtilCard.evaluateCreature(animatedCopy);
                if (animatedCopy.getNetToughness() <= 0) {
                    boolean buffedToughness = false;
                    SpellAbility sub = sa.findSubAbilityByType(ApiType.PutCounter);
                    if (sub != null && animatedCopy.canReceiveCounters(CounterEnumType.P1P1) && "Targeted".equals(sub.getParam("Defined")) && "P1P1".equals(sub.getParam("CounterType"))) {
                        buffedToughness = true;
                    }
                    if (!buffedToughness) continue;
                }
                if (c.isCreature() && (cValue = ComputerUtilCard.evaluateCreature(c)) >= aValue || ph.isPlayerTurn(ai) && !"Permanent".equals(sa.getParam("Duration")) && !ComputerUtilCard.doesSpecifiedCreatureAttackAI(ai, animatedCopy) && !"UntilHostLeavesPlay".equals(sa.getParam("Duration"))) continue;
                data.put(c, aValue);
            }
            if (data.isEmpty() && !alwaysActivatePWAbility) {
                return false;
            }
            ArrayList<Card> maxList = Lists.newArrayList();
            int maxValue = 0;
            for (Map.Entry e : data.entrySet()) {
                int v = (Integer)e.getValue();
                if (v > maxValue) {
                    maxValue = v;
                    maxList.clear();
                }
                maxList.add((Card)e.getKey());
            }
            Card worst2 = ComputerUtilCard.getWorstAI(maxList);
            if (worst2 != null) {
                if (worst2.isLand()) {
                    this.holdAnimatedTillMain2(ai, worst2);
                    if (!ComputerUtilMana.canPayManaCost(sa, ai, 0, sa.isTrigger())) {
                        this.releaseHeldTillMain2(ai, worst2);
                        return false;
                    }
                }
                this.rememberAnimatedThisTurn(ai, worst2);
                sa.getTargets().add(worst2);
            }
            return true;
        }
        if (logic.equals("SetPT") && ComputerUtilCard.doesSpecifiedCreatureAttackAI(ai, buffed = AnimateAi.becomeAnimated(worst = ComputerUtilCard.getWorstCreatureAI(ai.getCreaturesInPlay()), sa)) && (buffed.getNetPower() - worst.getNetPower() >= 3 || !ComputerUtilCard.doesCreatureAttackAI(ai, worst))) {
            sa.getTargets().add(worst);
            this.rememberAnimatedThisTurn(ai, worst);
            return true;
        }
        if (logic.equals("ValuableAttackerOrBlocker") && ph.inCombat()) {
            Combat combat = ph.getCombat();
            CardCollection list = CardLists.getTargetableCards(ai.getGame().getCardsIn(ZoneType.Battlefield), sa);
            for (Card c : list) {
                boolean isValuableBlocker;
                Card animated = AnimateAi.becomeAnimated(c, sa);
                boolean isValuableAttacker = ph.is(PhaseType.MAIN1, ai) && ComputerUtilCard.doesSpecifiedCreatureAttackAI(ai, animated);
                boolean bl = isValuableBlocker = combat != null && combat.getDefendingPlayers().contains(ai) && ComputerUtilCard.doesSpecifiedCreatureBlock(ai, animated);
                if (!isValuableAttacker && !isValuableBlocker) continue;
                return true;
            }
        }
        return false;
    }

    public static Card becomeAnimated(Card card, SpellAbility sa) {
        Card copy = CardCopyService.getLKICopy(card);
        AnimateAi.becomeAnimated(copy, card.hasSickness(), sa);
        return copy;
    }

    private static void becomeAnimated(Card card, boolean hasOriginalCardSickness, SpellAbility sa) {
        Card source = sa.getHostCard();
        Game game = sa.getActivatingPlayer().getGame();
        long timestamp = game.getNextTimestamp();
        card.setSickness(hasOriginalCardSickness);
        Integer power = null;
        if (sa.hasParam("Power") && (power = Integer.valueOf(AbilityUtils.calculateAmount(source, sa.getParam("Power"), sa))) == 0 && "PTByCMC".equals(sa.getParam("AILogic"))) {
            power = card.getManaCost().getCMC();
        }
        Integer toughness = null;
        if (sa.hasParam("Toughness") && (toughness = Integer.valueOf(AbilityUtils.calculateAmount(source, sa.getParam("Toughness"), sa))) == 0 && "PTByCMC".equals(sa.getParam("AILogic"))) {
            toughness = card.getManaCost().getCMC();
        }
        CardType types = new CardType(true);
        if (sa.hasParam("Types")) {
            types.addAll(Arrays.asList(sa.getParam("Types").split(",")));
        }
        CardType removeTypes = new CardType(true);
        if (sa.hasParam("RemoveTypes")) {
            removeTypes.addAll(Arrays.asList(sa.getParam("RemoveTypes").split(",")));
        }
        if (types.hasSubtype("ChosenType")) {
            types.clear();
            types.add(source.getChosenType());
        }
        ArrayList<String> keywords = Lists.newArrayList();
        if (sa.hasParam("Keywords")) {
            keywords.addAll(Arrays.asList(sa.getParam("Keywords").split(" & ")));
        }
        ArrayList<String> removeKeywords = Lists.newArrayList();
        if (sa.hasParam("RemoveKeywords")) {
            removeKeywords.addAll(Arrays.asList(sa.getParam("RemoveKeywords").split(" & ")));
        }
        ArrayList<String> hiddenKeywords = Lists.newArrayList();
        if (sa.hasParam("HiddenKeywords")) {
            hiddenKeywords.addAll(Arrays.asList(sa.getParam("HiddenKeywords").split(" & ")));
        }
        for (int i = 0; i < keywords.size(); ++i) {
            String k = (String)keywords.get(i);
            if (!source.hasSVar(k)) continue;
            keywords.add(source.getSVar(k));
            keywords.remove(k);
        }
        ColorSet finalColors = null;
        if (sa.hasParam("Colors")) {
            String colors = sa.getParam("Colors");
            finalColors = colors.equals("ChosenColor") ? ColorSet.fromNames(source.getChosenColors()) : ColorSet.fromNames(colors.split(","));
        }
        ArrayList<String> abilities = Lists.newArrayList();
        if (sa.hasParam("Abilities")) {
            abilities.addAll(Arrays.asList(sa.getParam("Abilities").split(",")));
        }
        ArrayList<String> replacements = Lists.newArrayList();
        if (sa.hasParam("Replacements")) {
            replacements.addAll(Arrays.asList(sa.getParam("Replacements").split(",")));
        }
        ArrayList<String> triggers = Lists.newArrayList();
        if (sa.hasParam("Triggers")) {
            triggers.addAll(Arrays.asList(sa.getParam("Triggers").split(",")));
        }
        ArrayList<String> stAbs = Lists.newArrayList();
        if (sa.hasParam("staticAbilities")) {
            stAbs.addAll(Arrays.asList(sa.getParam("staticAbilities").split(",")));
        }
        ArrayList<String> sVars = Lists.newArrayList();
        if (sa.hasParam("sVars")) {
            sVars.addAll(Arrays.asList(sa.getParam("sVars").split(",")));
        }
        AnimateEffectBase.doAnimate(card, sa, power, toughness, types, removeTypes, finalColors, keywords, removeKeywords, hiddenKeywords, abilities, triggers, replacements, stAbs, timestamp, "Permanent");
        CardTraitChanges traits = card.getChangedCardTraits().get(timestamp, 0);
        if (traits != null) {
            for (StaticAbility stAb : traits.getStaticAbilities()) {
                if (!"Continuous".equals(stAb.getParam("Mode"))) continue;
                for (StaticAbilityLayer layer : stAb.getLayers()) {
                    StaticAbilityContinuous.applyContinuousAbility(stAb, new CardCollection(card), layer);
                }
            }
        }
        if (sa.hasParam("sVars")) {
            HashMap<String, String> sVarsMap = Maps.newHashMap();
            for (String s2 : sa.getParam("sVars").split(",")) {
                String actualsVar = AbilityUtils.getSVar(sa, s2);
                String name = s2;
                if (actualsVar.startsWith("SVar:")) {
                    actualsVar = actualsVar.split("SVar:")[1];
                    name = actualsVar.split(":")[0];
                    actualsVar = actualsVar.split(":")[1];
                }
                sVarsMap.put(name, actualsVar);
            }
            card.addChangedSVars(sVarsMap, timestamp, 0L);
        }
        ComputerUtilCard.applyStaticContPT(game, card, null);
    }

    private void rememberAnimatedThisTurn(Player ai, Card c) {
        AiCardMemory.rememberCard(ai, c, AiCardMemory.MemorySet.ANIMATED_THIS_TURN);
    }

    public static boolean isAnimatedThisTurn(Player ai, Card c) {
        return AiCardMemory.isRememberedCard(ai, c, AiCardMemory.MemorySet.ANIMATED_THIS_TURN);
    }

    private void holdAnimatedTillMain2(Player ai, Card c) {
        AiCardMemory.rememberCard(ai, c, AiCardMemory.MemorySet.HELD_MANA_SOURCES_FOR_MAIN2);
    }

    private void releaseHeldTillMain2(Player ai, Card c) {
        AiCardMemory.forgetCard(ai, c, AiCardMemory.MemorySet.HELD_MANA_SOURCES_FOR_MAIN2);
    }
}

