/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.SpellAbilityAi;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.combat.CombatUtil;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.spellability.SpellAbility;
import java.util.Map;

public class AlterAttributeAi
extends SpellAbilityAi {
    @Override
    protected boolean checkApiLogic(Player aiPlayer, SpellAbility sa) {
        Card source = sa.getHostCard();
        boolean activate = Boolean.parseBoolean(sa.getParamOrDefault("Activate", "true"));
        String[] attributes = sa.getParam("Attributes").split(",");
        if (sa.usesTargeting()) {
            return false;
        }
        CardCollection defined = AbilityUtils.getDefinedCards(source, sa.getParam("Defined"), sa);
        for (Card c : defined) {
            block14: for (String attr : attributes) {
                switch (attr.trim()) {
                    case "Solve": 
                    case "Solved": {
                        if (c.isSolved() || !activate) continue block14;
                        return true;
                    }
                    case "Suspect": 
                    case "Suspected": {
                        return activate;
                    }
                    case "Saddle": 
                    case "Saddled": {
                        return !c.isSaddled();
                    }
                }
            }
        }
        return false;
    }

    @Override
    protected boolean checkPhaseRestrictions(Player ai, SpellAbility sa, PhaseHandler ph) {
        String[] attributes;
        Card source = sa.getHostCard();
        block7: for (String attr : attributes = sa.getParam("Attributes").split(",")) {
            switch (attr.trim()) {
                case "Saddle": 
                case "Saddled": {
                    if (!ph.isPlayerTurn(ai)) {
                        return false;
                    }
                    if (!ph.getPhase().isBefore(PhaseType.COMBAT_BEGIN)) {
                        return false;
                    }
                    if (CombatUtil.canAttack(source)) continue block7;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        String[] attributes;
        boolean activate = Boolean.parseBoolean(sa.getParamOrDefault("Activate", "true"));
        for (String attr : attributes = sa.getParam("Attributes").split(",")) {
            switch (attr.trim()) {
                case "Suspect": 
                case "Suspected": {
                    return activate;
                }
            }
        }
        return true;
    }
}

