/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.SpellAbilityAi;
import forge.game.ability.AbilityUtils;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerPredicates;
import forge.game.spellability.SpellAbility;
import org.apache.commons.lang3.StringUtils;

public class AddTurnAi
extends SpellAbilityAi {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        PlayerCollection targetableOpps = ai.getOpponents().filter(PlayerPredicates.isTargetableBy(sa));
        Player opp = targetableOpps.min(PlayerPredicates.compareByLife());
        if (sa.usesTargeting()) {
            sa.resetTargets();
            if (sa.canTarget(ai) && (mandatory || !ai.getGame().getReplacementHandler().wouldExtraTurnBeSkipped(ai))) {
                sa.getTargets().add(ai);
                return true;
            } else {
                if (!mandatory) return false;
                for (Player ally : ai.getAllies()) {
                    if (!sa.canTarget(ally)) continue;
                    sa.getTargets().add(ally);
                    break;
                }
                if (sa.getTargetRestrictions().isMinTargetsChosen(sa.getHostCard(), sa) || opp == null) return false;
                sa.getTargets().add(opp);
            }
            return true;
        } else {
            PlayerCollection tgtPlayers = AbilityUtils.getDefinedPlayers(sa.getHostCard(), sa.getParam("Defined"), sa);
            for (Player p : tgtPlayers) {
                if (!p.isOpponentOf(ai) || mandatory) continue;
                return false;
            }
            return StringUtils.isNumeric(sa.getParam("NumTurns"));
        }
    }

    @Override
    protected boolean canPlayAI(Player aiPlayer, SpellAbility sa) {
        return this.doTriggerAINoCost(aiPlayer, sa, false);
    }
}

