/*
 * Decompiled with CFR 0.152.
 */
package forge.ai;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.StaticData;
import forge.card.CardEdition;
import forge.card.CardStateName;
import forge.card.GamePieceType;
import forge.card.MagicColor;
import forge.card.mana.ManaAtom;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.ability.AbilityFactory;
import forge.game.ability.effects.DetachedCardEffect;
import forge.game.card.Card;
import forge.game.card.CardCloneStates;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardCopyService;
import forge.game.card.CardFactory;
import forge.game.card.CounterType;
import forge.game.card.token.TokenInfo;
import forge.game.combat.Combat;
import forge.game.combat.CombatUtil;
import forge.game.event.GameEventAttackersDeclared;
import forge.game.event.GameEventCombatChanged;
import forge.game.mana.ManaPool;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.AbilityManaPart;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.zone.PlayerZone;
import forge.game.zone.ZoneType;
import forge.item.IPaperCard;
import forge.item.PaperCard;
import forge.item.PaperToken;
import forge.util.TextUtil;
import forge.util.collect.FCollectionView;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public abstract class GameState {
    private static final Map<ZoneType, String> ZONES = new HashMap<ZoneType, String>();
    private final List<PlayerState> playerStates = new ArrayList<PlayerState>();
    private boolean puzzleCreatorState = false;
    private final Map<Integer, Card> idToCard = new HashMap<Integer, Card>();
    private final Map<Card, Integer> cardToAttachId = new HashMap<Card, Integer>();
    private final Map<Card, Player> cardToEnchantPlayerId = new HashMap<Card, Player>();
    private final Map<Card, Integer> markedDamage = new HashMap<Card, Integer>();
    private final Map<Card, List<String>> cardToChosenClrs = new HashMap<Card, List<String>>();
    private final Map<Card, CardCollection> cardToChosenCards = new HashMap<Card, CardCollection>();
    private final Map<Card, String> cardToChosenType = new HashMap<Card, String>();
    private final Map<Card, String> cardToChosenType2 = new HashMap<Card, String>();
    private final Map<Card, List<String>> cardToRememberedId = new HashMap<Card, List<String>>();
    private final Map<Card, List<String>> cardToImprintedId = new HashMap<Card, List<String>>();
    private final Map<Card, List<String>> cardToMergedCards = new HashMap<Card, List<String>>();
    private final Map<Card, List<String>> cardToNamedCard = new HashMap<Card, List<String>>();
    private final Map<Card, String> cardToExiledWithId = new HashMap<Card, String>();
    private final Map<Card, Card> cardAttackMap = new HashMap<Card, Card>();
    private final Map<Card, String> cardToScript = new HashMap<Card, String>();
    private final Map<String, String> abilityString = new HashMap<String, String>();
    private final Set<Card> cardsReferencedByID = new HashSet<Card>();
    private final Set<Card> cardsWithoutETBTrigs = new HashSet<Card>();
    private String tChangePlayer = "NONE";
    private String tChangePhase = "NONE";
    private String tAdvancePhase = "NONE";
    private int turn = 1;
    private boolean removeSummoningSickness = false;
    private final int TARGET_NONE = -1;
    private final int TARGET_HUMAN = -2;
    private final int TARGET_AI = -3;

    public abstract IPaperCard getPaperCard(String var1, String var2, int var3);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.puzzleCreatorState) {
            sb.append("[metadata]\n");
            sb.append("Name:New Puzzle\n");
            sb.append("URL:https://www.cardforge.org\n");
            sb.append("Goal:Win\n");
            sb.append("Turns:1\n");
            sb.append("Difficulty:Easy\n");
            sb.append("Description:Win this turn.\n");
            sb.append("[state]\n");
        }
        sb.append(TextUtil.concatNoSpace("turn=", String.valueOf(this.turn), "\n"));
        sb.append(TextUtil.concatNoSpace("activeplayer=", this.tChangePlayer, "\n"));
        sb.append(TextUtil.concatNoSpace("activephase=", this.tChangePhase, "\n"));
        int playerIndex = 0;
        for (PlayerState p : this.playerStates) {
            String prefix = "p" + playerIndex++;
            sb.append(TextUtil.concatNoSpace(prefix + "life=", String.valueOf(p.life), "\n"));
            sb.append(TextUtil.concatNoSpace(prefix + "landsplayed=", String.valueOf(p.landsPlayed), "\n"));
            sb.append(TextUtil.concatNoSpace(prefix + "landsplayedlastturn=", String.valueOf(p.landsPlayedLastTurn), "\n"));
            sb.append(TextUtil.concatNoSpace(prefix + "numringtemptedyou=", String.valueOf(p.numRingTemptedYou), "\n"));
            if (!p.counters.isEmpty()) {
                sb.append(TextUtil.concatNoSpace(prefix + "counters=", p.counters, "\n"));
            }
            if (!p.manaPool.isEmpty()) {
                sb.append(TextUtil.concatNoSpace(prefix + "manapool=", p.manaPool, "\n"));
            }
            if (!p.persistentMana.isEmpty()) {
                sb.append(TextUtil.concatNoSpace(prefix + "persistentmana=", p.persistentMana, "\n"));
            }
            this.appendCards(p.cardTexts, prefix, sb);
        }
        return sb.toString();
    }

    private void appendCards(Map<ZoneType, String> cardTexts, String categoryPrefix, StringBuilder sb) {
        for (Map.Entry<ZoneType, String> kv : cardTexts.entrySet()) {
            sb.append(TextUtil.concatNoSpace(categoryPrefix, ZONES.get((Object)kv.getKey()), "=", kv.getValue(), "\n"));
        }
    }

    public void initFromGame(Game game) {
        this.playerStates.clear();
        for (Player player : game.getPlayers()) {
            PlayerState p = new PlayerState();
            p.life = player.getLife();
            p.landsPlayed = player.getLandsPlayedThisTurn();
            p.landsPlayedLastTurn = player.getLandsPlayedLastTurn();
            p.counters = this.countersToString(player.getCounters());
            p.manaPool = this.processManaPool(player.getManaPool());
            p.numRingTemptedYou = player.getNumRingTemptedYou();
            this.playerStates.add(p);
        }
        this.tChangePlayer = "p" + game.getPlayers().indexOf(game.getPhaseHandler().getPlayerTurn());
        this.tChangePhase = game.getPhaseHandler().getPhase().toString();
        this.turn = game.getPhaseHandler().getTurn();
        this.cardsReferencedByID.clear();
        for (ZoneType zone : ZONES.keySet()) {
            for (Card card : game.getCardsIncludePhasingIn(zone)) {
                GameEntity def;
                if (card.getExiledWith() != null) {
                    this.cardsReferencedByID.add(card.getExiledWith());
                }
                if (zone == ZoneType.Battlefield && !card.getAllAttachedCards().isEmpty()) {
                    this.cardsReferencedByID.add(card);
                }
                for (Object o : card.getRemembered()) {
                    if (!(o instanceof Card)) continue;
                    this.cardsReferencedByID.add((Card)o);
                }
                for (Card i : card.getImprintedCards()) {
                    this.cardsReferencedByID.add(i);
                }
                for (Card i : card.getChosenCards()) {
                    this.cardsReferencedByID.add(i);
                }
                if (game.getCombat() == null || !game.getCombat().isAttacking(card) || !((def = game.getCombat().getDefenderByAttacker(card)) instanceof Card)) continue;
                this.cardsReferencedByID.add((Card)def);
            }
        }
        for (ZoneType zone : ZONES.keySet()) {
            for (PlayerState p : this.playerStates) {
                p.cardTexts.put(zone, "");
            }
            for (Card card : game.getCardsIncludePhasingIn(zone)) {
                if (card.getName().equals("Puzzle Goal") && card.getOracleText().contains("New Puzzle")) {
                    this.puzzleCreatorState = true;
                }
                if (card instanceof DetachedCardEffect) continue;
                int playerIndex = game.getPlayers().indexOf(card.getController());
                this.addCard(zone, this.playerStates.get(playerIndex).cardTexts, card);
            }
        }
    }

    private String getPlayerString(Player p) {
        return "P" + p.getGame().getPlayers().indexOf(p);
    }

    private Player parsePlayerString(Game game, String str) {
        if (str.equalsIgnoreCase("HUMAN")) {
            return (Player)game.getPlayers().get(false);
        }
        if (str.equalsIgnoreCase("AI")) {
            return (Player)game.getPlayers().get(true);
        }
        if (str.startsWith("P") && Character.isDigit(str.charAt(1))) {
            return (Player)game.getPlayers().get(Integer.parseInt(String.valueOf(str.charAt(1))));
        }
        return (Player)game.getPlayers().get(false);
    }

    private void addCard(ZoneType zoneType, Map<ZoneType, String> cardTexts, Card c) {
        Map<CounterType, Integer> counters;
        StringBuilder newText = new StringBuilder(cardTexts.get((Object)zoneType));
        if (newText.length() > 0) {
            newText.append(";");
        }
        if (c.isToken()) {
            newText.append("t:").append(new TokenInfo(c));
        } else {
            if (c.getPaperCard() == null) {
                return;
            }
            if (c.hasMergedCard()) {
                newText.append(c.getTopMergedCard().getPaperCard().getName()).append("|Set:").append(c.getTopMergedCard().getPaperCard().getEdition()).append("|Art:").append(c.getTopMergedCard().getPaperCard().getArtIndex());
            } else {
                newText.append(c.getPaperCard().getName()).append("|Set:").append(c.getPaperCard().getEdition()).append("|Art:").append(c.getPaperCard().getArtIndex());
            }
        }
        if (c.isCommander()) {
            newText.append("|IsCommander");
        }
        if (c.isRingBearer()) {
            newText.append("|IsRingBearer");
        }
        if (this.cardsReferencedByID.contains(c)) {
            newText.append("|Id:").append(c.getId());
        }
        if (zoneType == ZoneType.Battlefield) {
            if (c.getOwner() != c.getController()) {
                newText.append("|Owner:").append(this.getPlayerString(c.getOwner()));
            }
            if (c.isTapped()) {
                newText.append("|Tapped");
            }
            if (c.isSick()) {
                newText.append("|SummonSick");
            }
            if (c.isRenowned()) {
                newText.append("|Renowned");
            }
            if (c.isSolved()) {
                newText.append("|Solved");
            }
            if (c.isSuspected()) {
                newText.append("|Suspected");
            }
            if (c.isMonstrous()) {
                newText.append("|Monstrous");
            }
            if (c.isPhasedOut()) {
                newText.append("|PhasedOut:");
                newText.append(this.getPlayerString(c.getPhasedOut()));
            }
            if (c.isFaceDown()) {
                newText.append("|FaceDown");
                if (c.isManifested()) {
                    newText.append(":Manifested");
                }
                if (c.isCloaked()) {
                    newText.append(":Cloaked");
                }
            }
            if (c.getCurrentStateName().equals((Object)CardStateName.Transformed)) {
                newText.append("|Transformed");
            } else if (c.getCurrentStateName().equals((Object)CardStateName.Flipped)) {
                newText.append("|Flipped");
            } else if (c.getCurrentStateName().equals((Object)CardStateName.Meld)) {
                newText.append("|Meld");
                if (c.getMeldedWith() != null) {
                    newText.append(":");
                    newText.append(c.getMeldedWith().getName());
                }
            } else if (c.getCurrentStateName().equals((Object)CardStateName.Modal)) {
                newText.append("|Modal");
            }
            if (c.getPlayerAttachedTo() != null) {
                newText.append("|EnchantingPlayer:");
                newText.append(this.getPlayerString(c.getPlayerAttachedTo()));
            } else if (c.isAttachedToEntity()) {
                newText.append("|AttachedTo:").append(c.getEntityAttachedTo().getId());
            }
            if (c.getDamage() > 0) {
                newText.append("|Damage:").append(c.getDamage());
            }
            if (c.hasChosenColor()) {
                newText.append("|ChosenColor:").append(TextUtil.join(c.getChosenColors(), ","));
            }
            if (c.hasChosenType()) {
                newText.append("|ChosenType:").append(c.getChosenType());
            }
            if (c.hasChosenType2()) {
                newText.append("|ChosenType2:").append(c.getChosenType2());
            }
            if (!c.getNamedCard().isEmpty()) {
                newText.append("|NamedCard:").append(c.getNamedCard());
            }
            ArrayList<String> chosenCardIds = Lists.newArrayList();
            for (Object obj : c.getChosenCards()) {
                chosenCardIds.add(String.valueOf(((GameEntity)obj).getId()));
            }
            if (!chosenCardIds.isEmpty()) {
                newText.append("|ChosenCards:").append(TextUtil.join(chosenCardIds, ","));
            }
            ArrayList<String> rememberedCardIds = Lists.newArrayList();
            for (Object e : c.getRemembered()) {
                if (!(e instanceof Card)) continue;
                int id = ((Card)e).getId();
                rememberedCardIds.add(String.valueOf(id));
            }
            if (!rememberedCardIds.isEmpty()) {
                newText.append("|RememberedCards:").append(TextUtil.join(rememberedCardIds, ","));
            }
            ArrayList<String> imprintedCardIds = Lists.newArrayList();
            for (Card impr : c.getImprintedCards()) {
                int id = impr.getId();
                imprintedCardIds.add(String.valueOf(id));
            }
            if (!imprintedCardIds.isEmpty()) {
                newText.append("|Imprinting:").append(TextUtil.join(imprintedCardIds, ","));
            }
            if (c.hasMergedCard()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Card merged : c.getMergedCards()) {
                    if (c.getTopMergedCard() == merged) continue;
                    arrayList.add(merged.getPaperCard().getName().replace(",", "^"));
                }
                newText.append("|MergedCards:").append(TextUtil.join(arrayList, ","));
            }
            if (c.getClassLevel() > 1) {
                newText.append("|ClassLevel:").append(c.getClassLevel());
            }
        }
        if (zoneType == ZoneType.Exile) {
            if (c.getExiledWith() != null) {
                newText.append("|ExiledWith:").append(c.getExiledWith().getId());
            }
            if (c.isFaceDown()) {
                newText.append("|FaceDown");
            }
            if (c.isAdventureCard() && c.getZone().is(ZoneType.Exile)) {
                newText.append("|OnAdventure");
            }
            if (c.isForetold()) {
                newText.append("|Foretold");
                if (c.enteredThisTurn()) {
                    newText.append("|ForetoldThisTurn");
                }
            }
        }
        if (!(zoneType != ZoneType.Battlefield && zoneType != ZoneType.Exile || (counters = c.getCounters()).isEmpty())) {
            newText.append("|Counters:");
            newText.append(this.countersToString(counters));
        }
        if (c.getGame().getCombat() != null && c.getGame().getCombat().isAttacking(c)) {
            newText.append("|Attacking");
            GameEntity def = c.getGame().getCombat().getDefenderByAttacker(c);
            if (def instanceof Card) {
                newText.append(":").append(def.getId());
            }
        }
        cardTexts.put(zoneType, newText.toString());
    }

    private String countersToString(Map<CounterType, Integer> counters) {
        boolean first = true;
        StringBuilder counterString = new StringBuilder();
        for (Map.Entry<CounterType, Integer> kv : counters.entrySet()) {
            if (!first) {
                counterString.append(",");
            }
            first = false;
            counterString.append(TextUtil.concatNoSpace(kv.getKey().toString(), "=", String.valueOf(kv.getValue())));
        }
        return counterString.toString();
    }

    private String[] splitLine(String line) {
        if (line.charAt(0) == '#') {
            return null;
        }
        String[] tempData = line.split("=", 2);
        if (tempData.length >= 2) {
            return tempData;
        }
        if (tempData.length == 1 && line.endsWith("=")) {
            return new String[]{tempData[0], ""};
        }
        return null;
    }

    public void parse(InputStream in) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        this.parse(br.lines());
    }

    public void parse(List<String> lines) {
        this.parse(lines.stream());
    }

    public void parse(Stream<String> lines) {
        this.playerStates.clear();
        lines.forEach(this::parseLine);
    }

    private PlayerState getPlayerState(int index) {
        while (index >= this.playerStates.size()) {
            this.playerStates.add(new PlayerState());
        }
        return this.playerStates.get(index);
    }

    private PlayerState getPlayerState(String key) {
        if (key.startsWith("human")) {
            return this.getPlayerState(0);
        }
        if (key.startsWith("ai")) {
            return this.getPlayerState(1);
        }
        if (key.startsWith("p") && Character.isDigit(key.charAt(1))) {
            return this.getPlayerState(Integer.parseInt(String.valueOf(key.charAt(1))));
        }
        System.err.println("Unknown player state key: " + key);
        return new PlayerState();
    }

    protected void parseLine(String line) {
        String[] keyValue = this.splitLine(line);
        if (keyValue == null) {
            return;
        }
        String categoryName = keyValue[0].toLowerCase();
        String categoryValue = keyValue[1];
        if (categoryName.startsWith("active")) {
            if (categoryName.endsWith("player")) {
                this.tChangePlayer = categoryValue.trim().toLowerCase();
            } else if (categoryName.endsWith("phase")) {
                this.tChangePhase = categoryValue.trim().toUpperCase();
            } else if (categoryName.endsWith("phaseadvance")) {
                this.tAdvancePhase = categoryValue.trim().toUpperCase();
            }
            return;
        }
        if (categoryName.equals("turn")) {
            this.turn = Integer.parseInt(categoryValue);
        } else if (categoryName.equals("removesummoningsickness")) {
            this.removeSummoningSickness = categoryValue.equalsIgnoreCase("true");
        } else if (categoryName.endsWith("life")) {
            this.getPlayerState(categoryName).life = Integer.parseInt(categoryValue);
        } else if (categoryName.endsWith("counters")) {
            this.getPlayerState(categoryName).counters = categoryValue;
        } else if (categoryName.endsWith("landsplayed")) {
            this.getPlayerState(categoryName).landsPlayed = Integer.parseInt(categoryValue);
        } else if (categoryName.endsWith("landsplayedlastturn")) {
            this.getPlayerState(categoryName).landsPlayedLastTurn = Integer.parseInt(categoryValue);
        } else if (categoryName.endsWith("numringtemptedyou")) {
            this.getPlayerState(categoryName).numRingTemptedYou = Integer.parseInt(categoryValue);
        } else if (categoryName.endsWith("play") || categoryName.endsWith("battlefield")) {
            this.getPlayerState(categoryName).cardTexts.put(ZoneType.Battlefield, categoryValue);
        } else if (categoryName.endsWith("hand")) {
            this.getPlayerState(categoryName).cardTexts.put(ZoneType.Hand, categoryValue);
        } else if (categoryName.endsWith("graveyard")) {
            this.getPlayerState(categoryName).cardTexts.put(ZoneType.Graveyard, categoryValue);
        } else if (categoryName.endsWith("library")) {
            this.getPlayerState(categoryName).cardTexts.put(ZoneType.Library, categoryValue);
        } else if (categoryName.endsWith("exile")) {
            this.getPlayerState(categoryName).cardTexts.put(ZoneType.Exile, categoryValue);
        } else if (categoryName.endsWith("command")) {
            this.getPlayerState(categoryName).cardTexts.put(ZoneType.Command, categoryValue);
        } else if (categoryName.endsWith("sideboard")) {
            this.getPlayerState(categoryName).cardTexts.put(ZoneType.Sideboard, categoryValue);
        } else if (categoryName.startsWith("ability")) {
            this.abilityString.put(categoryName.substring("ability".length()), categoryValue);
        } else if (categoryName.endsWith("precast")) {
            this.getPlayerState(categoryName).precast = categoryValue;
        } else if (categoryName.endsWith("putonstack")) {
            this.getPlayerState(categoryName).putOnStack = categoryValue;
        } else if (categoryName.endsWith("manapool")) {
            this.getPlayerState(categoryName).manaPool = categoryValue;
        } else if (categoryName.endsWith("persistentmana")) {
            this.getPlayerState(categoryName).persistentMana = categoryValue;
        } else {
            System.err.println("Unknown key: " + categoryName);
        }
    }

    public void applyToGame(Game game) {
        game.getAction().invoke(() -> this.applyGameOnThread(game));
    }

    protected void applyGameOnThread(Game game) {
        if (game.getPlayers().size() != this.playerStates.size()) {
            throw new RuntimeException("Non-matching number of players, (" + game.getPlayers().size() + " vs. " + this.playerStates.size() + ")");
        }
        this.idToCard.clear();
        this.cardToAttachId.clear();
        this.cardToEnchantPlayerId.clear();
        this.cardToRememberedId.clear();
        this.cardToExiledWithId.clear();
        this.cardToImprintedId.clear();
        this.markedDamage.clear();
        this.cardToChosenClrs.clear();
        this.cardToChosenCards.clear();
        this.cardToChosenType.clear();
        this.cardToChosenType2.clear();
        this.cardToMergedCards.clear();
        this.cardToScript.clear();
        this.cardAttackMap.clear();
        int playerTurn = this.playerStates.indexOf(this.getPlayerState(this.tChangePlayer));
        Player newPlayerTurn = (Player)game.getPlayers().get(playerTurn);
        PhaseType newPhase = this.tChangePhase.equalsIgnoreCase("none") ? null : PhaseType.smartValueOf(this.tChangePhase);
        PhaseType advPhase = this.tAdvancePhase.equalsIgnoreCase("none") ? null : PhaseType.smartValueOf(this.tAdvancePhase);
        game.getStack().setResolving(true);
        game.getPhaseHandler().devModeSet(newPhase, newPlayerTurn, this.turn);
        game.getTriggerHandler().setSuppressAllTriggers(true);
        for (int i = 0; i < this.playerStates.size(); ++i) {
            this.setupPlayerState((Player)game.getPlayers().get(i), this.playerStates.get(i));
        }
        this.handleCardAttachments();
        this.handleChosenEntities();
        this.handleRememberedEntities();
        this.handleMergedCards();
        this.handleScriptExecution(game);
        this.handlePrecastSpells(game);
        this.handleMarkedDamage();
        game.getTriggerHandler().setSuppressAllTriggers(false);
        this.handleAddSAsToStack(game);
        if (newPhase == PhaseType.COMBAT_DECLARE_ATTACKERS || newPhase == PhaseType.COMBAT_DECLARE_BLOCKERS) {
            boolean toDeclareBlockers;
            boolean bl = toDeclareBlockers = newPhase == PhaseType.COMBAT_DECLARE_BLOCKERS;
            if (newPlayerTurn != null) {
                this.handleCombat(game, newPlayerTurn, newPlayerTurn.getSingleOpponent(), toDeclareBlockers);
            }
        }
        game.getStack().setResolving(false);
        game.getStack().unfreezeStack();
        if (advPhase != null) {
            game.getPhaseHandler().devAdvanceToPhase(advPhase);
        }
        if (this.removeSummoningSickness) {
            for (Card card : game.getCardsInGame()) {
                card.setSickness(false);
            }
        }
        game.getAction().checkStateEffects(true);
        game.copyLastState();
        game.stashGameState();
        for (int i = 0; i < this.playerStates.size(); ++i) {
            int life = this.playerStates.get(i).life;
            if (life > 0) continue;
            ((Player)game.getPlayers().get(i)).setLife(life, null);
        }
    }

    private String processManaPool(ManaPool manaPool) {
        StringBuilder mana = new StringBuilder();
        for (byte c : ManaAtom.MANATYPES) {
            int amount = manaPool.getAmountOfColor(c);
            for (int i = 0; i < amount; ++i) {
                mana.append(MagicColor.toShortString(c)).append(" ");
            }
        }
        return mana.toString().trim();
    }

    private void updateManaPool(Player p, String manaDef, boolean clearPool, boolean persistent) {
        Game game = p.getGame();
        if (clearPool) {
            p.getManaPool().clearPool(false);
        }
        if (!manaDef.isEmpty()) {
            Card dummy = new Card(-777777, game);
            dummy.setOwner(p);
            HashMap<String, String> produced = Maps.newHashMap();
            produced.put("Produced", manaDef);
            if (persistent) {
                produced.put("PersistentMana", "True");
            }
            AbilityManaPart abMana = new AbilityManaPart(dummy, produced);
            game.getAction().invoke(() -> abMana.produceMana(null));
        }
    }

    private void handleCombat(Game game, Player attackingPlayer, Player defendingPlayer, boolean toDeclareBlockers) {
        game.getPhaseHandler().devModeSet(PhaseType.COMBAT_DECLARE_ATTACKERS, attackingPlayer, this.turn);
        if (game.getPhaseHandler().getCombat() == null) {
            game.getPhaseHandler().setCombat(new Combat(attackingPlayer));
            game.updateCombatForView();
        }
        Combat combat = game.getPhaseHandler().getCombat();
        for (Map.Entry<Card, Card> attackMap : this.cardAttackMap.entrySet()) {
            Card attacker = attackMap.getKey();
            Card attacked = attackMap.getValue();
            combat.addAttacker(attacker, attacked == null ? defendingPlayer : attacked);
        }
        ArrayListMultimap<GameEntity, Card> attackersMap = ArrayListMultimap.create();
        for (GameEntity ge : combat.getDefenders()) {
            attackersMap.putAll(ge, (Iterable<Card>)combat.getAttackersOf(ge));
        }
        game.fireEvent(new GameEventAttackersDeclared(attackingPlayer, attackersMap));
        for (Card c : combat.getAttackers()) {
            CombatUtil.checkDeclaredAttacker(game, c, combat, false);
        }
        game.updateCombatForView();
        game.fireEvent(new GameEventCombatChanged());
        game.getStack().addAllTriggeredAbilitiesToStack();
        if (toDeclareBlockers && game.getStack().isEmpty()) {
            game.getPhaseHandler().devAdvanceToPhase(PhaseType.COMBAT_DECLARE_BLOCKERS);
        }
    }

    private void handleRememberedEntities() {
        Card tgt;
        List<String> ids;
        Card c;
        for (Map.Entry<Card, List<String>> entry : this.cardToRememberedId.entrySet()) {
            c = entry.getKey();
            ids = entry.getValue();
            for (String id : ids) {
                tgt = this.idToCard.get(Integer.parseInt(id));
                c.addRemembered(tgt);
            }
        }
        for (Map.Entry<Card, List<String>> entry : this.cardToImprintedId.entrySet()) {
            c = entry.getKey();
            ids = entry.getValue();
            for (String id : ids) {
                tgt = this.idToCard.get(Integer.parseInt(id));
                c.addImprintedCard(tgt);
            }
        }
        for (Map.Entry<Card, Object> entry : this.cardToExiledWithId.entrySet()) {
            c = entry.getKey();
            String id = (String)entry.getValue();
            Card exiledWith = this.idToCard.get(Integer.parseInt(id));
            if (exiledWith == null) continue;
            exiledWith.addExiledCard(c);
            c.setExiledWith(exiledWith);
            c.setExiledBy(exiledWith.getController());
        }
    }

    private int parseTargetInScript(String tgtDef) {
        int tgtID = tgtDef.equalsIgnoreCase("human") ? -2 : (tgtDef.equalsIgnoreCase("ai") ? -3 : Integer.parseInt(tgtDef));
        return tgtID;
    }

    private void handleScriptedTargetingForSA(Game game, SpellAbility sa, int tgtID) {
        Player human = (Player)game.getPlayers().get(false);
        Player ai = (Player)game.getPlayers().get(true);
        if (tgtID != -1) {
            switch (tgtID) {
                case -2: {
                    sa.getTargets().add(human);
                    break;
                }
                case -3: {
                    sa.getTargets().add(ai);
                    break;
                }
                default: {
                    sa.getTargets().add(this.idToCard.get(tgtID));
                }
            }
        }
        if (sa.hasParam("RememberTargets")) {
            sa.getHostCard().addRemembered(sa.getTargets());
        }
    }

    private void handleScriptExecution(Game game) {
        for (Map.Entry<Card, String> scriptPtr : this.cardToScript.entrySet()) {
            Card c = scriptPtr.getKey();
            String sPtr = scriptPtr.getValue();
            this.executeScript(game, c, sPtr);
        }
    }

    private void executeScript(Game game, Card c, String sPtr) {
        this.executeScript(game, c, sPtr, false);
    }

    private void executeScript(Game game, Card c, String sPtr, boolean putOnStack) {
        int tgtID = -1;
        if (sPtr.contains("->")) {
            String tgtDef = sPtr.substring(sPtr.lastIndexOf("->") + 2);
            tgtID = this.parseTargetInScript(tgtDef);
            sPtr = sPtr.substring(0, sPtr.lastIndexOf("->"));
        }
        SpellAbility sa = null;
        if (StringUtils.isNumeric(sPtr)) {
            int numSA = Integer.parseInt(sPtr);
            if (c.getSpellAbilities().size() >= numSA) {
                sa = c.getSpellAbilities().get((SpellAbility)numSA);
            } else {
                System.err.println("ERROR: Unable to find SA with index " + numSA + " on card " + c + " to execute!");
            }
        } else if (sPtr.startsWith("KW#")) {
            String kwName = sPtr.substring(3);
            FCollectionView<SpellAbility> saList = c.getSpellAbilities();
            if (kwName.equals("Awaken") || kwName.equals("AwakenOnly")) {
                for (SpellAbility ab : saList) {
                    if (!ab.getDescription().startsWith("Awaken")) continue;
                    ab.setActivatingPlayer(c.getController());
                    this.handleScriptedTargetingForSA(game, ab.getSubAbility(), tgtID);
                    sa = kwName.equals("AwakenOnly") ? ab.getSubAbility() : ab;
                }
                if (sa == null) {
                    System.err.println("ERROR: Could not locate keyworded ability Awaken in card " + c + " to execute!");
                    return;
                }
            }
        } else {
            String svarValue = "";
            if (sPtr.startsWith("CustomScript:")) {
                svarValue = sPtr.substring(sPtr.indexOf(":") + 1);
            } else {
                if (!c.hasSVar(sPtr)) {
                    System.err.println("ERROR: Unable to find SVar " + sPtr + " on card " + c + " + to execute!");
                    return;
                }
                svarValue = c.getSVar(sPtr);
                if (tgtID != -1 && svarValue.contains("| Defined$")) {
                    svarValue = TextUtil.fastReplace(svarValue, "| Defined$", "| Undefined$");
                    svarValue = tgtID == -2 || tgtID == -3 ? svarValue + " | ValidTgts$ Player" : svarValue + " | ValidTgts$ Card";
                }
            }
            sa = AbilityFactory.getAbility(svarValue, c);
            if (sa == null) {
                System.err.println("ERROR: Unable to generate ability for SVar " + svarValue);
            }
        }
        if (sa != null) {
            sa.setActivatingPlayer(c.getController());
        }
        this.handleScriptedTargetingForSA(game, sa, tgtID);
        if (putOnStack) {
            game.getStack().addAndUnfreeze(sa);
        } else {
            sa.resolve();
            for (AbilitySub subSa = sa.getSubAbility(); subSa != null; subSa = subSa.getSubAbility()) {
                ((SpellAbility)subSa).resolve();
            }
        }
    }

    private void handlePrecastSpells(Game game) {
        for (int i = 0; i < this.playerStates.size(); ++i) {
            String[] spellList;
            if (this.playerStates.get(i).precast == null) continue;
            for (String spell : spellList = TextUtil.split(this.playerStates.get(i).precast, ';')) {
                this.precastSpellFromCard(spell, (Player)game.getPlayers().get(i), game);
            }
        }
    }

    private void handleAddSAsToStack(Game game) {
        for (int i = 0; i < this.playerStates.size(); ++i) {
            String[] spellList;
            if (this.playerStates.get(i).putOnStack == null) continue;
            for (String spell : spellList = TextUtil.split(this.playerStates.get(i).putOnStack, ';')) {
                this.precastSpellFromCard(spell, (Player)game.getPlayers().get(i), game, true);
            }
        }
    }

    private void precastSpellFromCard(String spellDef, Player activator, Game game) {
        this.precastSpellFromCard(spellDef, activator, game, false);
    }

    private void precastSpellFromCard(String spellDef, Player activator, Game game, boolean putOnStack) {
        int tgtID = -1;
        String scriptID = "";
        if (spellDef.contains(":")) {
            scriptID = spellDef.substring(spellDef.indexOf(":") + 1).trim();
            spellDef = spellDef.substring(0, spellDef.indexOf(":")).trim();
        } else if (spellDef.contains("->")) {
            String tgtDef = spellDef.substring(spellDef.indexOf("->") + 2).trim();
            tgtID = this.parseTargetInScript(tgtDef);
            spellDef = spellDef.substring(0, spellDef.indexOf("->")).trim();
        }
        Card c = null;
        if (StringUtils.isNumeric(spellDef)) {
            c = this.idToCard.get(Integer.parseInt(spellDef));
            if (c == null) {
                System.err.println("ERROR: Could not find a card with ID " + spellDef + " to precast!");
                return;
            }
        } else {
            PaperCard pc = StaticData.instance().getCommonCards().getCard(spellDef);
            if (pc == null) {
                System.err.println("ERROR: Could not find a card with name " + spellDef + " to precast!");
                return;
            }
            c = Card.fromPaperCard(pc, activator);
        }
        SpellAbility sa = null;
        if (!scriptID.isEmpty()) {
            this.executeScript(game, c, scriptID, putOnStack);
            return;
        }
        sa = !c.getName().equals(spellDef) && c.hasAlternateState() && spellDef.equals(c.getAlternateState().getName()) ? c.getAlternateState().getFirstSpellAbility() : c.getFirstSpellAbility();
        sa.setActivatingPlayer(activator);
        this.handleScriptedTargetingForSA(game, sa, tgtID);
        if (putOnStack) {
            game.getStack().addAndUnfreeze(sa);
        } else {
            sa.resolve();
        }
    }

    private void handleMarkedDamage() {
        for (Map.Entry<Card, Integer> entry : this.markedDamage.entrySet()) {
            Card c = entry.getKey();
            Integer dmg = entry.getValue();
            c.setDamage(dmg);
        }
    }

    private void handleChosenEntities() {
        Card c;
        for (Map.Entry<Card, List<String>> entry : this.cardToChosenClrs.entrySet()) {
            c = entry.getKey();
            List<String> colors = entry.getValue();
            c.setChosenColors(colors);
        }
        for (Map.Entry<Card, Object> entry : this.cardToChosenType.entrySet()) {
            c = entry.getKey();
            c.setChosenType((String)entry.getValue());
        }
        for (Map.Entry<Card, Object> entry : this.cardToChosenType2.entrySet()) {
            c = entry.getKey();
            c.setChosenType2((String)entry.getValue());
        }
        for (Map.Entry<Card, Object> entry : this.cardToNamedCard.entrySet()) {
            c = entry.getKey();
            for (String s2 : (List)entry.getValue()) {
                c.addNamedCard(s2);
            }
        }
        for (Map.Entry<Card, Object> entry : this.cardToChosenCards.entrySet()) {
            c = entry.getKey();
            c.setChosenCards((Iterable)entry.getValue());
        }
    }

    private void handleCardAttachments() {
        Card attachedTo;
        for (Map.Entry<Card, Integer> entry : this.cardToAttachId.entrySet()) {
            attachedTo = this.idToCard.get(entry.getValue());
            attachedTo.unAttachAllCards();
        }
        for (Map.Entry<Card, Integer> entry : this.cardToAttachId.entrySet()) {
            attachedTo = this.idToCard.get(entry.getValue());
            Card attacher = entry.getKey();
            if (!attacher.isAttachment()) continue;
            attacher.attachToEntity(attachedTo, null, true);
        }
        for (Map.Entry<Card, Comparable<Integer>> entry : this.cardToEnchantPlayerId.entrySet()) {
            entry.getKey().attachToEntity((GameEntity)((Object)entry.getValue()), null);
        }
    }

    private void handleMergedCards() {
        for (Map.Entry<Card, List<String>> entry : this.cardToMergedCards.entrySet()) {
            Card mergedTo = entry.getKey();
            for (String mergedCardName : entry.getValue()) {
                PaperCard pc = StaticData.instance().getCommonCards().getCard(mergedCardName.replace("^", ","));
                if (pc == null) {
                    System.err.println("ERROR: Tried to create a non-existent card named " + mergedCardName + " (as a merged card) when loading game state!");
                    continue;
                }
                Card c = Card.fromPaperCard(pc, mergedTo.getOwner());
                this.emulateMergeViaMutate(mergedTo, c);
            }
        }
    }

    private void emulateMergeViaMutate(Card top, Card bottom) {
        if (top == null || bottom == null) {
            System.err.println("ERROR: Tried to call emulateMergeViaMutate with a null card!");
            return;
        }
        Game game = top.getGame();
        bottom.setMergedToCard(top);
        if (!top.hasMergedCard()) {
            top.addMergedCard(top);
        }
        top.addMergedCard(bottom);
        top.removeMutatedStates();
        long ts = game.getNextTimestamp();
        top.setMutatedTimestamp(ts);
        if (top.getCurrentStateName() != CardStateName.FaceDown) {
            CardCloneStates mutatedStates = CardFactory.getMutatedCloneStates(top, null);
            top.addCloneState(mutatedStates, ts);
        }
        bottom.setTapped(top.isTapped());
        bottom.setFlipped(top.isFlipped());
        top.setTimesMutated(top.getTimesMutated() + 1);
        top.updateTokenView();
    }

    private void applyCountersToGameEntity(GameEntity entity, String counterString) {
        String[] allCounterStrings;
        entity.setCounters(Maps.newHashMap());
        for (String counterPair : allCounterStrings = counterString.split(",")) {
            String[] pair = counterPair.split("=", 2);
            entity.addCounterInternal(CounterType.getType(pair[0]), Integer.parseInt(pair[1]), null, false, null, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setupPlayerState(Player p, PlayerState state) {
        for (ZoneType zoneType : ZONES.keySet()) {
            p.getZone(zoneType).removeAllCards(true);
        }
        p.setCommanders(Lists.newArrayList());
        p.clearTheRing();
        EnumMap<ZoneType, CardCollectionView> playerCards = new EnumMap<ZoneType, CardCollectionView>(ZoneType.class);
        for (Map.Entry entry : state.cardTexts.entrySet()) {
            String value = (String)entry.getValue();
            playerCards.put((ZoneType)((Object)entry.getKey()), this.processCardsForZone(value.isEmpty() ? new String[]{} : value.split(";"), p));
        }
        if (state.life >= 0) {
            p.setLife(state.life, null);
        }
        p.setLandsPlayedThisTurn(state.landsPlayed);
        p.setLandsPlayedLastTurn(state.landsPlayedLastTurn);
        p.setNumRingTemptedYou(state.numRingTemptedYou);
        p.clearPaidForSA();
        for (Map.Entry entry : playerCards.entrySet()) {
            PlayerZone zone = p.getZone((ZoneType)((Object)entry.getKey()));
            if (entry.getKey() == ZoneType.Battlefield) {
                ArrayList<Card> cards = new ArrayList<Card>();
                for (Card c : (CardCollectionView)entry.getValue()) {
                    if (!c.isToken()) continue;
                    cards.add(c);
                }
                zone.setCards(cards);
                for (Card c : (CardCollectionView)entry.getValue()) {
                    if (c.isToken()) continue;
                    boolean tapped = c.isTapped();
                    boolean sickness = c.hasSickness();
                    Map<CounterType, Integer> counters = c.getCounters();
                    c.setCounters(Maps.newHashMap());
                    if (c.isAura()) {
                        c.setEntityAttachedTo(new CardCopyService(c).copyCard(true));
                    }
                    if (this.cardsWithoutETBTrigs.contains(c)) {
                        p.getGame().getAction().moveTo(ZoneType.Battlefield, c, null, null);
                    } else {
                        p.getZone(ZoneType.Hand).add(c);
                        p.getGame().getAction().moveToPlay(c, null, null);
                    }
                    c.setTapped(tapped);
                    c.setSickness(sickness);
                    c.setCounters(counters);
                }
                continue;
            }
            zone.setCards((Iterable)entry.getValue());
        }
        if (!p.getCommanders().isEmpty()) {
            p.createCommanderEffect();
        }
        this.updateManaPool(p, state.manaPool, true, false);
        this.updateManaPool(p, state.persistentMana, false, true);
        if (!state.counters.isEmpty()) {
            this.applyCountersToGameEntity(p, state.counters);
        }
        if (state.numRingTemptedYou > 0) {
            void var4_8;
            boolean bl = true;
            while (var4_8 <= state.numRingTemptedYou && var4_8 <= 4) {
                p.setRingLevel((int)var4_8);
                ++var4_8;
            }
        }
    }

    private CardCollectionView processCardsForZone(String[] data, Player player) {
        CardCollection cl = new CardCollection();
        for (String element : data) {
            Card c;
            String tokenStr;
            String[] cardinfo = element.trim().split("\\|");
            String setCode = null;
            for (String info : cardinfo) {
                if (!info.startsWith("Set:")) continue;
                setCode = info.substring(info.indexOf(58) + 1);
                break;
            }
            int artID = -1;
            for (String info : cardinfo) {
                if (!info.startsWith("Art:")) continue;
                try {
                    artID = Integer.parseInt(info.substring(info.indexOf(58) + 1));
                }
                catch (Exception e) {}
                break;
            }
            boolean hasSetCurSet = false;
            if (cardinfo[0].startsWith("t:")) {
                tokenStr = cardinfo[0].substring(2);
                c = new TokenInfo(tokenStr).makeOneToken(player);
            } else if (cardinfo[0].startsWith("T:")) {
                tokenStr = cardinfo[0].substring(2);
                PaperToken token = StaticData.instance().getAllTokens().getToken(tokenStr, setCode != null ? setCode : CardEdition.UNKNOWN.getName());
                if (token == null) {
                    System.err.println("ERROR: Tried to create a non-existent token named " + cardinfo[0] + " when loading game state!");
                    continue;
                }
                c = CardFactory.getCard(token, player, player.getGame());
            } else {
                PaperCard pc = StaticData.instance().getCommonCards().getCard(cardinfo[0], setCode, artID);
                if (pc == null) {
                    System.err.println("ERROR: Tried to create a non-existent card named " + cardinfo[0] + " (set: " + (setCode == null ? "any" : setCode) + ") when loading game state!");
                    continue;
                }
                c = Card.fromPaperCard(pc, player);
                if (setCode != null) {
                    hasSetCurSet = true;
                }
            }
            c.setSickness(false);
            for (String info : cardinfo) {
                if (info.startsWith("Tapped")) {
                    c.tap(false, null, null);
                    continue;
                }
                if (info.startsWith("Renowned")) {
                    c.setRenowned(true);
                    continue;
                }
                if (info.startsWith("Solved")) {
                    c.setSolved(true);
                    continue;
                }
                if (info.startsWith("Saddled")) {
                    c.setSaddled(true);
                    continue;
                }
                if (info.startsWith("Suspected")) {
                    c.setSuspected(true);
                    continue;
                }
                if (info.startsWith("Monstrous")) {
                    c.setMonstrous(true);
                    continue;
                }
                if (info.startsWith("PhasedOut")) {
                    String tgt = info.substring(info.indexOf(58) + 1);
                    c.setPhasedOut(this.parsePlayerString(player.getGame(), tgt));
                    continue;
                }
                if (info.startsWith("Counters:")) {
                    this.applyCountersToGameEntity(c, info.substring(info.indexOf(58) + 1));
                    continue;
                }
                if (info.startsWith("SummonSick")) {
                    c.setSickness(true);
                    continue;
                }
                if (info.startsWith("FaceDown")) {
                    c.turnFaceDown(true);
                    if (info.endsWith("Manifested")) {
                        c.setManifested(true);
                    }
                    if (!info.endsWith("Cloaked")) continue;
                    c.setCloaked(true);
                    continue;
                }
                if (info.startsWith("Transformed")) {
                    c.setState(CardStateName.Transformed, true);
                    c.setBackSide(true);
                    continue;
                }
                if (info.startsWith("Flipped")) {
                    c.setState(CardStateName.Flipped, true);
                    continue;
                }
                if (info.startsWith("Meld")) {
                    if (info.indexOf(58) > 0) {
                        String meldCardName = info.substring(info.indexOf(58) + 1).replace("^", ",");
                        PaperCard pc = StaticData.instance().getCommonCards().getCard(meldCardName);
                        if (pc == null) {
                            System.err.println("ERROR: Tried to create a non-existent card named " + meldCardName + " (as a MeldedWith card) when loading game state!");
                            continue;
                        }
                        Card meldTarget = Card.fromPaperCard(pc, c.getOwner());
                        c.setMeldedWith(meldTarget);
                    }
                    c.setState(CardStateName.Meld, true);
                    c.setBackSide(true);
                    continue;
                }
                if (info.startsWith("Modal")) {
                    c.setState(CardStateName.Modal, true);
                    c.setBackSide(true);
                    continue;
                }
                if (info.startsWith("OnAdventure")) {
                    String abAdventure = "DB$ Effect | RememberObjects$ Self | StaticAbilities$ Play | ForgetOnMoved$ Exile | Duration$ Permanent | ConditionDefined$ Self | ConditionPresent$ Card.!copiedSpell";
                    SpellAbility saAdventure = AbilityFactory.getAbility(abAdventure, c);
                    StringBuilder sbPlay = new StringBuilder();
                    sbPlay.append("Mode$ Continuous | MayPlay$ True | EffectZone$ Command | Affected$ Card.IsRemembered+nonAdventure");
                    sbPlay.append(" | AffectedZone$ Exile | Description$ You may cast the card.");
                    saAdventure.setSVar("Play", sbPlay.toString());
                    saAdventure.setActivatingPlayer(c.getOwner());
                    saAdventure.resolve();
                    c.setExiledWith(c);
                    c.setExiledBy(c.getController());
                    continue;
                }
                if (info.startsWith("IsCommander")) {
                    player.addCommander(c);
                    continue;
                }
                if (info.startsWith("IsRingBearer")) {
                    c.setRingBearer(true);
                    player.setRingBearer(c);
                    continue;
                }
                if (info.startsWith("Id:")) {
                    int id = Integer.parseInt(info.substring(3));
                    this.idToCard.put(id, c);
                    continue;
                }
                if (info.startsWith("Attaching:") || info.startsWith("AttachedTo:")) {
                    int id = Integer.parseInt(info.substring(info.indexOf(58) + 1));
                    this.cardToAttachId.put(c, id);
                    continue;
                }
                if (info.startsWith("EnchantingPlayer:")) {
                    String tgt = info.substring(info.indexOf(58) + 1);
                    this.cardToEnchantPlayerId.put(c, this.parsePlayerString(player.getGame(), tgt));
                    continue;
                }
                if (info.startsWith("Owner:")) {
                    String owner = info.substring(info.indexOf(58) + 1);
                    Player controller = c.getController();
                    c.setOwner(this.parsePlayerString(player.getGame(), owner));
                    c.setController(controller, c.getGame().getNextTimestamp());
                    continue;
                }
                if (info.startsWith("Ability:")) {
                    String abString = info.substring(info.indexOf(58) + 1).toLowerCase();
                    c.addSpellAbility(AbilityFactory.getAbility(this.abilityString.get(abString), c));
                    continue;
                }
                if (info.startsWith("Damage:")) {
                    int dmg = Integer.parseInt(info.substring(info.indexOf(58) + 1));
                    this.markedDamage.put(c, dmg);
                    continue;
                }
                if (info.startsWith("ChosenColor:")) {
                    this.cardToChosenClrs.put(c, Arrays.asList(info.substring(info.indexOf(58) + 1).split(",")));
                    continue;
                }
                if (info.startsWith("ChosenType:")) {
                    this.cardToChosenType.put(c, info.substring(info.indexOf(58) + 1));
                    continue;
                }
                if (info.startsWith("ChosenType2:")) {
                    this.cardToChosenType2.put(c, info.substring(info.indexOf(58) + 1));
                    continue;
                }
                if (info.startsWith("ChosenCards:")) {
                    String[] idlist;
                    CardCollection chosen = new CardCollection();
                    for (String id : idlist = info.substring(info.indexOf(58) + 1).split(",")) {
                        chosen.add(this.idToCard.get(Integer.parseInt(id)));
                    }
                    this.cardToChosenCards.put(c, chosen);
                    continue;
                }
                if (info.startsWith("MergedCards:")) {
                    List<String> cardNames = Arrays.asList(info.substring(info.indexOf(58) + 1).split(","));
                    this.cardToMergedCards.put(c, cardNames);
                    continue;
                }
                if (info.startsWith("NamedCard:")) {
                    List<String> cardNames = Arrays.asList(info.substring(info.indexOf(58) + 1).split(","));
                    this.cardToNamedCard.put(c, cardNames);
                    continue;
                }
                if (info.startsWith("ExecuteScript:")) {
                    this.cardToScript.put(c, info.substring(info.indexOf(58) + 1));
                    continue;
                }
                if (info.startsWith("RememberedCards:")) {
                    this.cardToRememberedId.put(c, Arrays.asList(info.substring(info.indexOf(58) + 1).split(",")));
                    continue;
                }
                if (info.startsWith("Imprinting:")) {
                    this.cardToImprintedId.put(c, Arrays.asList(info.substring(info.indexOf(58) + 1).split(",")));
                    continue;
                }
                if (info.startsWith("ExiledWith:")) {
                    this.cardToExiledWithId.put(c, info.substring(info.indexOf(58) + 1));
                    continue;
                }
                if (info.startsWith("Attacking")) {
                    if (info.contains(":")) {
                        int id = Integer.parseInt(info.substring(info.indexOf(58) + 1));
                        this.cardAttackMap.put(c, this.idToCard.get(id));
                        continue;
                    }
                    this.cardAttackMap.put(c, null);
                    continue;
                }
                if (info.equals("NoETBTrigs")) {
                    this.cardsWithoutETBTrigs.add(c);
                    continue;
                }
                if (info.equals("Foretold")) {
                    c.setForetold(true);
                    c.turnFaceDown(true);
                    c.addMayLookTemp(c.getOwner());
                    continue;
                }
                if (info.equals("ForetoldThisTurn")) {
                    c.setTurnInZone(this.turn);
                    continue;
                }
                if (info.equals("IsToken")) {
                    c.setGamePieceType(GamePieceType.TOKEN);
                    continue;
                }
                if (!info.startsWith("ClassLevel:")) continue;
                c.setClassLevel(Integer.parseInt(info.substring(info.indexOf(58) + 1)));
            }
            if (!hasSetCurSet && !c.isToken()) {
                c.setSetCode(c.getMostRecentSet());
            }
            cl.add(c);
        }
        return cl;
    }

    static {
        ZONES.put(ZoneType.Battlefield, "battlefield");
        ZONES.put(ZoneType.Hand, "hand");
        ZONES.put(ZoneType.Graveyard, "graveyard");
        ZONES.put(ZoneType.Library, "library");
        ZONES.put(ZoneType.Exile, "exile");
        ZONES.put(ZoneType.Command, "command");
        ZONES.put(ZoneType.Sideboard, "sideboard");
    }

    static class PlayerState {
        private int life = -1;
        private String counters = "";
        private String manaPool = "";
        private String persistentMana = "";
        private int landsPlayed = 0;
        private int landsPlayedLastTurn = 0;
        private int numRingTemptedYou = 0;
        private String precast = null;
        private String putOnStack = null;
        private final Map<ZoneType, String> cardTexts = new EnumMap<ZoneType, String>(ZoneType.class);

        PlayerState() {
        }
    }
}

