/*
 * Decompiled with CFR 0.152.
 */
package forge.ai;

import com.google.common.collect.Lists;
import forge.ai.AiController;
import forge.ai.AiProps;
import forge.ai.ComputerUtilCard;
import forge.ai.PlayerControllerAi;
import forge.card.CardStateName;
import forge.game.Game;
import forge.game.GameActionUtil;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.cost.CostPart;
import forge.game.cost.CostPayEnergy;
import forge.game.cost.CostPutCounter;
import forge.game.cost.CostRemoveCounter;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.OptionalCostValue;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.game.zone.ZoneType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ComputerUtilAbility {
    public static final saComparator saEvaluator = new saComparator();

    public static CardCollection getAvailableLandsToPlay(Game game, Player player) {
        if (!game.getStack().isEmpty() || !game.getPhaseHandler().getPhase().isMain()) {
            return null;
        }
        CardCollection landList = new CardCollection(player.getCardsIn(ZoneType.Hand));
        landList = CardLists.filter((Iterable<Card>)landList, c -> {
            if (!c.hasPlayableLandFace()) {
                return false;
            }
            return player.canPlayLand((Card)c, false, c.getFirstSpellAbility());
        });
        CardCollection landsNotInHand = new CardCollection(player.getCardsIn(ZoneType.Graveyard));
        landsNotInHand.addAll(game.getCardsIn(ZoneType.Exile));
        if (!player.getCardsIn(ZoneType.Library).isEmpty()) {
            landsNotInHand.add((Card)player.getCardsIn(ZoneType.Library).get(false));
        }
        for (Card crd : landsNotInHand) {
            if (!crd.hasPlayableLandFace() && (!crd.isFaceDown() || !crd.getState(CardStateName.Original).getType().isLand()) || crd.mayPlay(player).isEmpty()) continue;
            landList.add(crd);
        }
        if (landList.isEmpty()) {
            return null;
        }
        return landList;
    }

    public static CardCollection getAvailableCards(Game game, Player player) {
        CardCollection all = new CardCollection(player.getCardsIn(ZoneType.Hand));
        all.addAll(player.getCardsIn(ZoneType.Graveyard));
        for (Player p : game.getPlayers()) {
            if (p.getCardsIn(ZoneType.Library).isEmpty()) continue;
            all.add((Card)p.getCardsIn(ZoneType.Library).get(false));
        }
        all.addAll(game.getCardsIn(ZoneType.Command));
        all.addAll(game.getCardsIn(ZoneType.Exile));
        all.addAll(game.getCardsIn(ZoneType.Battlefield));
        return all;
    }

    public static List<SpellAbility> getSpellAbilities(CardCollectionView l, Player player) {
        ArrayList<SpellAbility> spellAbilities = Lists.newArrayList();
        for (Card c : l) {
            spellAbilities.addAll(c.getAllPossibleAbilities(player, false));
        }
        return spellAbilities;
    }

    public static List<SpellAbility> getOriginalAndAltCostAbilities(List<SpellAbility> originList, Player player) {
        ArrayList<SpellAbility> newAbilities = Lists.newArrayList();
        ArrayList<SpellAbility> originListWithAddCosts = Lists.newArrayList();
        for (SpellAbility sa : originList) {
            sa.setActivatingPlayer(player, true);
            originListWithAddCosts.addAll(GameActionUtil.getAdditionalCostSpell(sa));
        }
        for (SpellAbility sa : originListWithAddCosts) {
            List<SpellAbility> saAltCosts = GameActionUtil.getAlternativeCosts(sa, player, false);
            ArrayList<SpellAbility> priorityAltSa = Lists.newArrayList();
            ArrayList<SpellAbility> otherAltSa = Lists.newArrayList();
            for (SpellAbility altSa : saAltCosts) {
                if (sa.getPayCosts().isOnlyManaCost() && altSa.getPayCosts().isOnlyManaCost() && sa.getPayCosts().getTotalMana().compareTo(altSa.getPayCosts().getTotalMana()) == 1) {
                    priorityAltSa.add(altSa);
                    continue;
                }
                otherAltSa.add(altSa);
            }
            newAbilities.addAll(priorityAltSa);
            newAbilities.add(sa);
            newAbilities.addAll(otherAltSa);
        }
        ArrayList<SpellAbility> result = Lists.newArrayList();
        for (SpellAbility sa : newAbilities) {
            sa.setActivatingPlayer(player, true);
            boolean choseOptCost = false;
            List<OptionalCostValue> list = GameActionUtil.getOptionalCostValues(sa);
            if (!list.isEmpty() && !(list = player.getController().chooseOptionalCosts(sa, list)).isEmpty()) {
                choseOptCost = true;
                result.add(GameActionUtil.addOptionalCosts(sa, list));
            }
            if (choseOptCost) continue;
            result.add(sa);
        }
        return result;
    }

    public static SpellAbility getTopSpellAbilityOnStack(Game game, SpellAbility sa) {
        Iterator<SpellAbilityStackInstance> it = game.getStack().iterator();
        if (!it.hasNext()) {
            return null;
        }
        SpellAbility tgtSA = it.next().getSpellAbility();
        if (sa.equals(tgtSA) && game.getStack().size() > 1) {
            if (!it.hasNext()) {
                return null;
            }
            tgtSA = it.next().getSpellAbility();
        }
        return tgtSA;
    }

    public static SpellAbility getFirstCopySASpell(List<SpellAbility> spells) {
        SpellAbility sa = null;
        for (SpellAbility spell : spells) {
            if (spell.getApi() != ApiType.CopySpellAbility) continue;
            sa = spell;
            break;
        }
        return sa;
    }

    public static Card getAbilitySource(SpellAbility sa) {
        return sa.getOriginalHost() != null ? sa.getOriginalHost() : sa.getHostCard();
    }

    public static String getAbilitySourceName(SpellAbility sa) {
        Card c = ComputerUtilAbility.getAbilitySource(sa);
        return c != null ? c.getName() : "";
    }

    public static CardCollection getCardsTargetedWithApi(Player ai, CardCollection cardList, SpellAbility sa, ApiType api) {
        CardCollection targeted = new CardCollection();
        if (sa != null) {
            for (SpellAbility saSub = sa.getRootAbility(); saSub != null; saSub = saSub.getSubAbility()) {
                if (saSub.getApi() != api || saSub.getTargets() == null) continue;
                for (Card c : cardList) {
                    if (!saSub.getTargets().getTargetCards().contains(c)) continue;
                    targeted.add(c);
                }
            }
        }
        for (SpellAbilityStackInstance si : ai.getGame().getStack()) {
            SpellAbility ab = si.getSpellAbility();
            if (ab == null || ab.getApi() != api || si.getTargetChoices() == null) continue;
            for (Card c : cardList) {
                if (!si.getTargetChoices().getTargetCards().contains(c)) continue;
                targeted.add(c);
            }
        }
        return targeted;
    }

    public static boolean isFullyTargetable(SpellAbility sa) {
        for (SpellAbility sub = sa; sub != null; sub = sub.getSubAbility()) {
            if (!sub.usesTargeting() || sub.getTargetRestrictions().getNumCandidates(sub, true) >= sub.getMinTargets()) continue;
            return false;
        }
        return true;
    }

    public static List<SpellAbility> sortCreatureSpells(List<SpellAbility> all) {
        List<SpellAbility> creatures = AiController.filterListByApi(Lists.newArrayList(all), ApiType.PermanentCreature);
        if (creatures.size() <= 1) {
            return all;
        }
        creatures.sort(ComputerUtilCard.EvaluateCreatureSpellComparator);
        int idx = 0;
        for (int i = 0; i < all.size(); ++i) {
            if (all.get(i).getApi() != ApiType.PermanentCreature) continue;
            all.set(i, creatures.get(idx));
            ++idx;
        }
        return all;
    }

    public static final class saComparator
    implements Comparator<SpellAbility> {
        @Override
        public int compare(SpellAbility a, SpellAbility b) {
            return this.compareEvaluator(a, b, false);
        }

        public int compareEvaluator(SpellAbility a, SpellAbility b, boolean safeToEvaluateCreatures) {
            int a1 = a.getPayCosts().getTotalMana().getCMC();
            int b1 = b.getPayCosts().getTotalMana().getCMC();
            if (a.hasParam("AIActivateLast") && !b.hasParam("AIActivateLast")) {
                return 1;
            }
            if (b.hasParam("AIActivateLast") && !a.hasParam("AIActivateLast")) {
                return -1;
            }
            if (ApiType.RollPlanarDice == a.getApi() || ApiType.RollPlanarDice == b.getApi()) {
                Game game;
                Card hostCardForGame = a.getHostCard();
                if (hostCardForGame == null) {
                    if (b.getHostCard() != null) {
                        hostCardForGame = b.getHostCard();
                    } else {
                        return 0;
                    }
                }
                if ((game = hostCardForGame.getGame()).getActivePlanes() != null) {
                    for (Card c : game.getActivePlanes()) {
                        if (!c.hasSVar("AIRollPlanarDieParams") || !c.getSVar("AIRollPlanarDieParams").toLowerCase().matches(".*lowpriority\\$\\s*true.*")) continue;
                        if (ApiType.RollPlanarDice == a.getApi()) {
                            return 1;
                        }
                        return -1;
                    }
                }
            }
            int a2 = 0;
            int b2 = 0;
            if (a.getApi() == ApiType.Pump && a.getPayCosts().getCostEnergy() != null && a.getPayCosts().hasOnlySpecificCostType(CostPayEnergy.class)) {
                a2 = a.getPayCosts().getCostEnergy().convertAmount();
            }
            if (b.getApi() == ApiType.Pump && b.getPayCosts().getCostEnergy() != null && b.getPayCosts().hasOnlySpecificCostType(CostPayEnergy.class)) {
                b2 = b.getPayCosts().getCostEnergy().convertAmount();
            }
            if (a2 == 0 && b2 > 0) {
                return -1;
            }
            if (b2 == 0 && a2 > 0) {
                return 1;
            }
            if (a1 == 0 && b1 > 0 && ApiType.Mana != a.getApi()) {
                return -1;
            }
            if (a1 > 0 && b1 == 0 && ApiType.Mana != b.getApi()) {
                return 1;
            }
            if (a.getHostCard() != null && a.getHostCard().hasSVar("FreeSpellAI")) {
                return -1;
            }
            if (b.getHostCard() != null && b.getHostCard().hasSVar("FreeSpellAI")) {
                return 1;
            }
            if (a.getHostCard().equals(b.getHostCard()) && a.getApi() == b.getApi()) {
                if (a.isSpectacle() && !b.isSpectacle() && a1 < b1) {
                    return 1;
                }
                if (b.isSpectacle() && !a.isSpectacle() && b1 < a1) {
                    return 1;
                }
            }
            a1 += saComparator.getSpellAbilityPriority(a);
            b1 += saComparator.getSpellAbilityPriority(b);
            if (safeToEvaluateCreatures) {
                a1 += Math.round((float)ComputerUtilCard.evaluateCreature(a) / 100.0f);
                b1 += Math.round((float)ComputerUtilCard.evaluateCreature(b) / 100.0f);
            }
            return b1 - a1;
        }

        private static int getSpellAbilityPriority(SpellAbility sa) {
            Player ai;
            int p = 0;
            Card source = sa.getHostCard();
            Player player = ai = source == null ? sa.getActivatingPlayer() : source.getController();
            if (ai == null) {
                System.err.println("Error: couldn't figure out the activating player and host card for SA: " + sa);
                return 0;
            }
            boolean noCreatures = ai.getCreaturesInPlay().isEmpty();
            if (source != null) {
                if (source.isCreature()) {
                    ++p;
                }
                if (source.hasSVar("AIPriorityModifier")) {
                    p += Integer.parseInt(source.getSVar("AIPriorityModifier"));
                }
                if (ComputerUtilCard.isCardRemAIDeck(sa.getOriginalHost() != null ? sa.getOriginalHost() : source)) {
                    p -= 10;
                }
                if (source.isEquipment() && noCreatures) {
                    p -= 9;
                }
                if (sa.getApi() == ApiType.Attach && !sa.isCurse() && source.getGame().getPhaseHandler().getPhase().isAfter(PhaseType.COMBAT_DECLARE_BLOCKERS)) {
                    --p;
                }
                if (source.hasKeyword(Keyword.SURGE) && !sa.isSurged()) {
                    p -= 9;
                }
                if (source.isInZone(ZoneType.Graveyard) && sa.getMayPlay() != null && source.mayPlay(sa.getMayPlay()) != null) {
                    p += 50;
                }
                if (source.hasKeyword(Keyword.STORM) && ai.getController() instanceof PlayerControllerAi) {
                    p -= ((PlayerControllerAi)ai.getController()).getAi().getIntProperty(AiProps.PRIORITY_REDUCTION_FOR_STORM_SPELLS);
                }
            }
            if (sa.isSurged() || sa.isProwl()) {
                p += 9;
            }
            if (sa.isPwAbility()) {
                CostPart cost = sa.getPayCosts().getCostParts().get(0);
                if (cost instanceof CostRemoveCounter) {
                    p += cost.convertAmount() == null ? 1 : cost.convertAmount();
                } else if (cost instanceof CostPutCounter) {
                    p -= cost.convertAmount().intValue();
                }
                if (sa.hasParam("Ultimate")) {
                    p += 9;
                }
            }
            if (ApiType.DestroyAll == sa.getApi()) {
                p += 4;
            } else if (ApiType.Mana == sa.getApi()) {
                p -= 9;
            }
            if ("ManaRitual".equals(sa.getParam("AILogic"))) {
                p += 9;
            }
            return p;
        }
    }
}

