/*
 * Decompiled with CFR 0.152.
 */
package forge.ai;

import forge.LobbyPlayer;
import forge.ai.AiProps;
import forge.ai.LobbyPlayerAi;
import forge.util.Aggregates;
import forge.util.FileUtil;
import forge.util.TextUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class AiProfileUtil {
    private static Map<String, Map<AiProps, String>> loadedProfiles = new HashMap<String, Map<AiProps, String>>();
    private static String AI_PROFILE_DIR;
    private static final String AI_PROFILE_EXT = ".ai";
    public static final String AI_PROFILE_RANDOM_MATCH = "Random (Every Match)";
    public static final String AI_PROFILE_RANDOM_DUEL = "Random (Every Game)";
    private static AISideboardingMode aiSideboardingMode;

    public static AISideboardingMode getAISideboardingMode() {
        return aiSideboardingMode;
    }

    public static void setAiSideboardingMode(AISideboardingMode mode) {
        aiSideboardingMode = mode;
    }

    private static String buildFileName(String profileName) {
        return TextUtil.concatNoSpace(AI_PROFILE_DIR, "/", profileName, AI_PROFILE_EXT);
    }

    public static final void loadAllProfiles(String aiProfileDir) {
        AI_PROFILE_DIR = aiProfileDir;
        loadedProfiles.clear();
        List<String> availableProfiles = AiProfileUtil.getAvailableProfiles();
        for (String profile : availableProfiles) {
            loadedProfiles.put(profile, AiProfileUtil.loadProfile(profile));
        }
    }

    private static Map<AiProps, String> loadProfile(String profileName) {
        HashMap<AiProps, String> profileMap = new HashMap<AiProps, String>();
        List<String> lines = FileUtil.readFile(AiProfileUtil.buildFileName(profileName));
        for (String line : lines) {
            if (line.startsWith("#") || line.length() == 0) continue;
            String[] split = line.split("=");
            if (split.length == 2) {
                profileMap.put(AiProps.valueOf(split[0]), split[1]);
                continue;
            }
            if (split.length != 1 || !line.endsWith("=")) continue;
            profileMap.put(AiProps.valueOf(split[0]), "");
        }
        return profileMap;
    }

    public static String getAIProp(LobbyPlayer p, AiProps fp0) {
        String val = null;
        if (!(p instanceof LobbyPlayerAi)) {
            return "";
        }
        String profile = ((LobbyPlayerAi)p).getAiProfile();
        if (loadedProfiles.get(profile) != null) {
            val = loadedProfiles.get(profile).get((Object)fp0);
        }
        if (val == null) {
            val = fp0.getDefault();
        }
        return val;
    }

    public static List<String> getAvailableProfiles() {
        ArrayList<String> availableProfiles = new ArrayList<String>();
        File dir = new File(AI_PROFILE_DIR);
        String[] children = dir.list();
        if (children == null) {
            System.err.println("AIProfile > can't find AI profile directory!");
        } else {
            for (String child : children) {
                if (!child.endsWith(AI_PROFILE_EXT)) continue;
                availableProfiles.add(child.substring(0, child.length() - AI_PROFILE_EXT.length()));
            }
        }
        return availableProfiles;
    }

    public static List<String> getProfilesDisplayList() {
        ArrayList<String> availableProfiles = new ArrayList<String>();
        availableProfiles.add(AI_PROFILE_RANDOM_MATCH);
        availableProfiles.add(AI_PROFILE_RANDOM_DUEL);
        availableProfiles.addAll(AiProfileUtil.getAvailableProfiles());
        return availableProfiles;
    }

    public static String[] getProfilesArray() {
        return AiProfileUtil.getProfilesDisplayList().toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static String getRandomProfile() {
        return Aggregates.random(AiProfileUtil.getAvailableProfiles());
    }

    static {
        aiSideboardingMode = AISideboardingMode.Off;
    }

    public static enum AISideboardingMode {
        Off,
        AI,
        HumanForAI;


        public static AISideboardingMode normalizedValueOf(String value) {
            return AISideboardingMode.valueOf(value.replace(" ", ""));
        }
    }
}

