/*
 * Decompiled with CFR 0.152.
 */
package forge.ai;

import forge.ai.AiController;
import forge.ai.PlayerControllerAi;
import forge.game.card.Card;
import forge.game.player.Player;
import java.util.HashSet;
import java.util.Set;

public class AiCardMemory {
    private final Set<Card> memMandatoryAttackers = new HashSet<Card>();
    private final Set<Card> memTrickAttackers;
    private final Set<Card> memHeldManaSources = new HashSet<Card>();
    private final Set<Card> memHeldManaSourcesForCombat = new HashSet<Card>();
    private final Set<Card> memHeldManaSourcesForEnemyCombat = new HashSet<Card>();
    private final Set<Card> memHeldManaSourcesForNextSpell;
    private final Set<Card> memAttachedThisTurn = new HashSet<Card>();
    private final Set<Card> memAnimatedThisTurn = new HashSet<Card>();
    private final Set<Card> memBouncedThisTurn = new HashSet<Card>();
    private final Set<Card> memActivatedThisTurn = new HashSet<Card>();
    private final Set<Card> memChosenFogEffect;
    private final Set<Card> memMarkedToAvoidReentry;
    private final Set<Card> memPaysTapCost;
    private final Set<Card> memPaysSacCost;
    private final Set<Card> memRevealedCards;

    public AiCardMemory() {
        this.memTrickAttackers = new HashSet<Card>();
        this.memChosenFogEffect = new HashSet<Card>();
        this.memMarkedToAvoidReentry = new HashSet<Card>();
        this.memHeldManaSourcesForNextSpell = new HashSet<Card>();
        this.memPaysTapCost = new HashSet<Card>();
        this.memPaysSacCost = new HashSet<Card>();
        this.memRevealedCards = new HashSet<Card>();
    }

    private Set<Card> getMemorySet(MemorySet set) {
        switch (set) {
            case MANDATORY_ATTACKERS: {
                return this.memMandatoryAttackers;
            }
            case TRICK_ATTACKERS: {
                return this.memTrickAttackers;
            }
            case HELD_MANA_SOURCES_FOR_MAIN2: {
                return this.memHeldManaSources;
            }
            case HELD_MANA_SOURCES_FOR_DECLBLK: {
                return this.memHeldManaSourcesForCombat;
            }
            case HELD_MANA_SOURCES_FOR_ENEMY_DECLBLK: {
                return this.memHeldManaSourcesForEnemyCombat;
            }
            case HELD_MANA_SOURCES_FOR_NEXT_SPELL: {
                return this.memHeldManaSourcesForNextSpell;
            }
            case ATTACHED_THIS_TURN: {
                return this.memAttachedThisTurn;
            }
            case ANIMATED_THIS_TURN: {
                return this.memAnimatedThisTurn;
            }
            case BOUNCED_THIS_TURN: {
                return this.memBouncedThisTurn;
            }
            case ACTIVATED_THIS_TURN: {
                return this.memActivatedThisTurn;
            }
            case CHOSEN_FOG_EFFECT: {
                return this.memChosenFogEffect;
            }
            case MARKED_TO_AVOID_REENTRY: {
                return this.memMarkedToAvoidReentry;
            }
            case PAYS_TAP_COST: {
                return this.memPaysTapCost;
            }
            case PAYS_SAC_COST: {
                return this.memPaysSacCost;
            }
            case REVEALED_CARDS: {
                return this.memRevealedCards;
            }
        }
        return null;
    }

    public boolean isRememberedCard(Card c, MemorySet set) {
        if (c == null) {
            return false;
        }
        Set<Card> memorySet = this.getMemorySet(set);
        return memorySet != null && memorySet.contains(c);
    }

    public boolean isRememberedCardByName(String cardName, MemorySet set) {
        Set<Card> memorySet = this.getMemorySet(set);
        if (memorySet != null) {
            for (Card c : memorySet) {
                if (!c.getName().equals(cardName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRememberedCardByName(String cardName, MemorySet set, Player owner) {
        Set<Card> memorySet = this.getMemorySet(set);
        if (memorySet != null) {
            for (Card c : memorySet) {
                if (!c.getName().equals(cardName) || !c.getOwner().equals(owner)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean rememberCard(Card c, MemorySet set) {
        if (c == null) {
            return false;
        }
        Set<Card> memorySet = this.getMemorySet(set);
        if (memorySet != null) {
            memorySet.add(c);
        }
        return true;
    }

    public boolean forgetCard(Card c, MemorySet set) {
        if (c == null) {
            return false;
        }
        if (!this.isRememberedCard(c, set)) {
            return false;
        }
        Set<Card> memorySet = this.getMemorySet(set);
        if (memorySet != null) {
            memorySet.remove(c);
        }
        return true;
    }

    public boolean forgetAnyCardWithName(String cardName, MemorySet set) {
        Set<Card> memorySet = this.getMemorySet(set);
        if (memorySet != null) {
            for (Card c : memorySet) {
                if (!c.getName().equals(cardName)) continue;
                return this.forgetCard(c, set);
            }
        }
        return false;
    }

    public boolean forgetAnyCardWithName(String cardName, MemorySet set, Player owner) {
        Set<Card> memorySet = this.getMemorySet(set);
        if (memorySet != null) {
            for (Card c : memorySet) {
                if (!c.getName().equals(cardName) || !c.getOwner().equals(owner)) continue;
                return this.forgetCard(c, set);
            }
        }
        return false;
    }

    public boolean isMemorySetEmpty(MemorySet set) {
        return set == null || this.getMemorySet(set).isEmpty();
    }

    public void clearMemorySet(MemorySet set) {
        if (set != null) {
            this.getMemorySet(set).clear();
        }
    }

    public void clearAllRemembered() {
        for (MemorySet memSet : MemorySet.values()) {
            this.clearMemorySet(memSet);
        }
    }

    public static Set<Card> getMemorySet(Player ai, MemorySet set) {
        if (!ai.getController().isAI()) {
            return null;
        }
        return ((PlayerControllerAi)ai.getController()).getAi().getCardMemory().getMemorySet(set);
    }

    public static void rememberCard(Player ai, Card c, MemorySet set) {
        if (!ai.getController().isAI()) {
            return;
        }
        ((PlayerControllerAi)ai.getController()).getAi().getCardMemory().rememberCard(c, set);
    }

    public static void rememberCard(AiController aic, Card c, MemorySet set) {
        aic.getCardMemory().rememberCard(c, set);
    }

    public static void forgetCard(Player ai, Card c, MemorySet set) {
        if (!ai.getController().isAI()) {
            return;
        }
        ((PlayerControllerAi)ai.getController()).getAi().getCardMemory().forgetCard(c, set);
    }

    public static void forgetCard(AiController aic, Card c, MemorySet set) {
        aic.getCardMemory().forgetCard(c, set);
    }

    public static boolean isRememberedCard(Player ai, Card c, MemorySet set) {
        if (!ai.getController().isAI()) {
            return false;
        }
        return ((PlayerControllerAi)ai.getController()).getAi().getCardMemory().isRememberedCard(c, set);
    }

    public static boolean isRememberedCard(AiController aic, Card c, MemorySet set) {
        return aic.getCardMemory().isRememberedCard(c, set);
    }

    public static boolean isRememberedCardByName(Player ai, String name, MemorySet set) {
        if (!ai.getController().isAI()) {
            return false;
        }
        return ((PlayerControllerAi)ai.getController()).getAi().getCardMemory().isRememberedCardByName(name, set);
    }

    public static boolean isRememberedCardByName(AiController aic, String name, MemorySet set) {
        return aic.getCardMemory().isRememberedCardByName(name, set);
    }

    public static void clearMemorySet(Player ai, MemorySet set) {
        if (!ai.getController().isAI()) {
            return;
        }
        ((PlayerControllerAi)ai.getController()).getAi().getCardMemory().clearMemorySet(set);
    }

    public static void clearMemorySet(AiController aic, MemorySet set) {
        if (!AiCardMemory.isMemorySetEmpty(aic, set)) {
            aic.getCardMemory().clearMemorySet(set);
        }
    }

    public static boolean isMemorySetEmpty(Player ai, MemorySet set) {
        if (!ai.getController().isAI()) {
            return false;
        }
        return ((PlayerControllerAi)ai.getController()).getAi().getCardMemory().isMemorySetEmpty(set);
    }

    public static boolean isMemorySetEmpty(AiController aic, MemorySet set) {
        return aic.getCardMemory().isMemorySetEmpty(set);
    }

    public static enum MemorySet {
        MANDATORY_ATTACKERS,
        TRICK_ATTACKERS,
        HELD_MANA_SOURCES_FOR_MAIN2,
        HELD_MANA_SOURCES_FOR_DECLBLK,
        HELD_MANA_SOURCES_FOR_ENEMY_DECLBLK,
        HELD_MANA_SOURCES_FOR_NEXT_SPELL,
        ATTACHED_THIS_TURN,
        ANIMATED_THIS_TURN,
        BOUNCED_THIS_TURN,
        ACTIVATED_THIS_TURN,
        CHOSEN_FOG_EFFECT,
        MARKED_TO_AVOID_REENTRY,
        PAYS_TAP_COST,
        PAYS_SAC_COST,
        REVEALED_CARDS;

    }
}

