/*
 * Decompiled with CFR 0.152.
 */
package forge.ai;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import forge.ai.AiController;
import forge.ai.AiProps;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.ComputerUtilMana;
import forge.ai.PlayerControllerAi;
import forge.card.CardStateName;
import forge.game.GameEntity;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CounterEnumType;
import forge.game.combat.AttackingBand;
import forge.game.combat.Combat;
import forge.game.combat.CombatUtil;
import forge.game.cost.Cost;
import forge.game.keyword.Keyword;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbilityAssignCombatDamageAsUnblocked;
import forge.game.staticability.StaticAbilityCantAttackBlock;
import forge.game.staticability.StaticAbilityMustBlock;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;
import forge.util.collect.FCollectionView;
import java.util.ArrayList;
import java.util.List;

public class AiBlockController {
    private final Player ai;
    private List<Card> attackers = new ArrayList<Card>();
    private List<Card> attackersLeft = new ArrayList<Card>();
    private List<Card> blockedButUnkilled = new ArrayList<Card>();
    private List<Card> blockersLeft = new ArrayList<Card>();
    private int diff = 0;
    private boolean lifeInDanger = false;
    private boolean checkingOther = false;

    public AiBlockController(Player aiPlayer, boolean checkingOther) {
        this.checkingOther = checkingOther;
        this.ai = aiPlayer;
    }

    private static List<Card> getPossibleBlockers(Combat combat, Card attacker, List<Card> blockersLeft, boolean solo) {
        ArrayList<Card> blockers = new ArrayList<Card>();
        for (Card blocker : blockersLeft) {
            boolean cantBlockAlone;
            if (!CombatUtil.canBlock(attacker, blocker, combat)) continue;
            boolean bl = cantBlockAlone = blocker.hasKeyword("CARDNAME can't attack or block alone.") || blocker.hasKeyword("CARDNAME can't block alone.");
            if (solo && cantBlockAlone) continue;
            blockers.add(blocker);
        }
        return blockers;
    }

    private List<Card> getSafeBlockers(Combat combat, Card attacker, List<Card> blockersLeft) {
        ArrayList<Card> blockers = new ArrayList<Card>();
        for (Card b : blockersLeft) {
            if (ComputerUtilCombat.canDestroyBlocker(this.ai, b, attacker, combat, false, attacker.getGame().getPhaseHandler().inCombat())) continue;
            blockers.add(b);
        }
        return blockers;
    }

    private List<Card> getKillingBlockers(Combat combat, Card attacker, List<Card> blockersLeft) {
        ArrayList<Card> blockers = new ArrayList<Card>();
        for (Card b : blockersLeft) {
            if (!ComputerUtilCombat.canDestroyAttacker(this.ai, attacker, b, combat, false, attacker.getGame().getPhaseHandler().inCombat())) continue;
            blockers.add(b);
        }
        return blockers;
    }

    private List<Card> sortPotentialAttackers(Combat combat) {
        CardCollection sortedAttackers = new CardCollection();
        CardCollection firstAttacker = new CardCollection();
        FCollectionView<GameEntity> defenders = combat.getDefenders();
        List<Card> attackingCmd = ComputerUtilCombat.getLifeThreateningCommanders(this.ai, combat);
        if (defenders.size() == 1 || !attackingCmd.isEmpty()) {
            CardCollection attackers = combat.getAttackersOf(defenders.get((GameEntity)false));
            ComputerUtilCard.sortByEvaluateCreature(attackers);
            CardLists.sortByPowerDesc(attackers);
            attackers.sort((o1, o2) -> {
                if (o1.hasSVar("MustBeBlocked") && !o2.hasSVar("MustBeBlocked")) {
                    return -1;
                }
                if (!o1.hasSVar("MustBeBlocked") && o2.hasSVar("MustBeBlocked")) {
                    return 1;
                }
                if (attackingCmd.contains(o1) && !attackingCmd.contains(o2)) {
                    return -1;
                }
                if (!attackingCmd.contains(o1) && attackingCmd.contains(o2)) {
                    return 1;
                }
                return 0;
            });
            return attackers;
        }
        for (GameEntity defender : defenders) {
            if (defender instanceof Card && ((Card)defender).getController().equals(this.ai) || defender instanceof Card && ((Card)defender).isBattle() && ((Card)defender).getProtectingPlayer().equals(this.ai)) {
                CardCollection attackers = combat.getAttackersOf(defender);
                CardLists.sortByPowerDesc(attackers);
                sortedAttackers.addAll(attackers);
                continue;
            }
            if (!(defender instanceof Player) || !defender.equals(this.ai)) continue;
            firstAttacker = combat.getAttackersOf(defender);
            CardLists.sortByPowerDesc(firstAttacker);
        }
        if (ComputerUtilCombat.lifeInDanger(this.ai, combat)) {
            sortedAttackers.addAll(0, firstAttacker);
        } else {
            sortedAttackers.addAll(firstAttacker);
        }
        return sortedAttackers;
    }

    private void makeGoodBlocks(Combat combat) {
        List<Card> blockers;
        Card blocker;
        ArrayList<Card> currentAttackers = new ArrayList<Card>(this.attackersLeft);
        for (Card attacker : this.attackersLeft) {
            List<Card> killingBlockers;
            if (CombatUtil.getMinNumBlockersForAttacker(attacker, combat.getDefenderPlayerByAttacker(attacker)) > 1) continue;
            blocker = null;
            blockers = AiBlockController.getPossibleBlockers(combat, attacker, this.blockersLeft, true);
            List<Card> safeBlockers = this.getSafeBlockers(combat, attacker, blockers);
            if (!safeBlockers.isEmpty()) {
                killingBlockers = this.getKillingBlockers(combat, attacker, safeBlockers);
                if (!killingBlockers.isEmpty()) {
                    if (ComputerUtilCombat.attackerHasThreateningAfflict(attacker, this.ai)) continue;
                    blocker = ComputerUtilCard.getWorstCreatureAI(killingBlockers);
                } else if (!StaticAbilityAssignCombatDamageAsUnblocked.assignCombatDamageAsUnblocked(attacker) && !ComputerUtilCombat.attackerHasThreateningAfflict(attacker, this.ai)) {
                    blocker = ComputerUtilCard.getWorstCreatureAI(safeBlockers);
                    if (attacker.hasKeyword(Keyword.TRAMPLE)) {
                        boolean doNotBlock = false;
                        for (Card other : this.attackersLeft) {
                            if (other.equals(attacker) || !CombatUtil.canBlock(other, blocker) || other.hasKeyword(Keyword.TRAMPLE) || ComputerUtilCombat.attackerHasThreateningAfflict(other, this.ai) || ComputerUtilCombat.canDestroyBlocker(this.ai, blocker, other, combat, false) || StaticAbilityAssignCombatDamageAsUnblocked.assignCombatDamageAsUnblocked(other) || other.getNetCombatDamage() <= blocker.getLethalDamage()) continue;
                            doNotBlock = true;
                            break;
                        }
                        if (doNotBlock) continue;
                    }
                    this.blockedButUnkilled.add(attacker);
                }
            } else {
                killingBlockers = this.getKillingBlockers(combat, attacker, blockers);
                for (Card b : killingBlockers) {
                    if (!(b.hasKeyword(Keyword.UNDYING) && b.getCounters(CounterEnumType.P1P1) == 0 || b.hasSVar("SacMe") || b.hasKeyword(Keyword.VANISHING) && b.getCounters(CounterEnumType.TIME) == 1 || b.hasKeyword(Keyword.FADING) && b.getCounters(CounterEnumType.FADE) == 0) && !b.hasSVar("EndOfTurnLeavePlay")) continue;
                    blocker = b;
                    break;
                }
                for (Card b : blockers) {
                    if ((!b.hasSVar("SacMe") || Integer.parseInt(b.getSVar("SacMe")) <= 3) && (!b.hasSVar("SacMeAfterBlock") || attacker.hasKeyword(Keyword.TRAMPLE) || attacker.hasKeyword(Keyword.BANDING))) continue;
                    blocker = b;
                    if (ComputerUtilCombat.canDestroyAttacker(this.ai, attacker, blocker, combat, false)) break;
                    this.blockedButUnkilled.add(attacker);
                    break;
                }
                if (!killingBlockers.isEmpty()) {
                    Card worst = ComputerUtilCard.getWorstCreatureAI(killingBlockers);
                    int value = ComputerUtilCard.evaluateCreature(attacker);
                    for (Trigger trigger : attacker.getTriggers()) {
                        TriggerType mode = trigger.getMode();
                        if (!trigger.requirementsCheck(attacker.getGame())) continue;
                        if (mode == TriggerType.DamageDone) {
                            if (!trigger.matchesValidParam("ValidSource", attacker) || "False".equals(trigger.getParam("CombatDamage")) || attacker.getNetCombatDamage() <= 0 || !trigger.matchesValidParam("ValidTarget", combat.getDefenderByAttacker(attacker))) continue;
                            value += 50;
                            continue;
                        }
                        if (mode != TriggerType.AttackerUnblocked || !trigger.matchesValidParam("ValidCard", attacker)) continue;
                        value += 50;
                    }
                    if (ComputerUtilCard.evaluateCreature(worst) + this.diff < value) {
                        blocker = worst;
                    }
                }
            }
            if (blocker == null) continue;
            currentAttackers.remove(attacker);
            combat.addBlocker(attacker, blocker);
        }
        this.attackersLeft = new ArrayList<Card>(currentAttackers);
        for (Card attacker : this.attackersLeft) {
            if (CombatUtil.getMinNumBlockersForAttacker(attacker, combat.getDefenderPlayerByAttacker(attacker)) > 1) continue;
            blocker = null;
            blockers = AiBlockController.getPossibleBlockers(combat, attacker, this.blockersLeft, true);
            for (Card b : blockers) {
                if (!(b.hasKeyword(Keyword.VANISHING) && b.getCounters(CounterEnumType.TIME) == 1 || b.hasKeyword(Keyword.FADING) && b.getCounters(CounterEnumType.FADE) == 0) && !b.hasSVar("EndOfTurnLeavePlay")) continue;
                blocker = b;
                if (ComputerUtilCombat.canDestroyAttacker(this.ai, attacker, blocker, combat, false)) break;
                this.blockedButUnkilled.add(attacker);
                break;
            }
            if (blocker == null) continue;
            currentAttackers.remove(attacker);
            combat.addBlocker(attacker, blocker);
        }
        this.attackersLeft = new ArrayList<Card>(currentAttackers);
    }

    private Predicate<Card> rampagesOrNeedsManyToBlock(Combat combat) {
        return Predicates.or(CardPredicates.hasKeyword(Keyword.RAMPAGE), input -> StaticAbilityCantAttackBlock.getMinMaxBlocker(input, combat.getDefenderPlayerByAttacker((Card)input)).getRight() < Integer.MAX_VALUE);
    }

    private Predicate<Card> changesPTWhenBlocked(boolean onlyForDefVsTrample) {
        return card -> {
            for (Trigger tr : card.getTriggers()) {
                SpellAbility ab;
                if (tr.getMode() != TriggerType.AttackerBlocked || (ab = tr.getOverridingAbility()) == null) continue;
                if (ab.getApi() == ApiType.Pump && "Self".equals(ab.getParam("Defined"))) {
                    String rawP = ab.getParam("NumAtt");
                    String rawT = ab.getParam("NumDef");
                    if (!"+X".equals(rawP) || !"+X".equals(rawT) || !card.getSVar("X").startsWith("Count$Valid Creature.blockingTriggeredAttacker")) continue;
                    return true;
                }
                if (ab.getApi() != ApiType.PumpAll || !ab.hasParam("ValidCards") || !ab.getParam("ValidCards").startsWith("Creature.blockingSource")) continue;
                int pBonus = AbilityUtils.calculateAmount(card, ab.getParam("NumAtt"), ab);
                int tBonus = AbilityUtils.calculateAmount(card, ab.getParam("NumDef"), ab);
                return !onlyForDefVsTrample && pBonus < 0 || tBonus < 0;
            }
            return false;
        };
    }

    private void makeGangBlocks(Combat combat) {
        List<Card> blockers;
        CardCollection currentAttackers = CardLists.filter(this.attackersLeft, Predicates.not(this.rampagesOrNeedsManyToBlock(combat)));
        for (Card attacker : this.attackersLeft) {
            if (ComputerUtilCombat.combatantCantBeDestroyed(this.ai, attacker) || ComputerUtilCombat.dealsFirstStrikeDamage(attacker, false, combat)) continue;
            blockers = AiBlockController.getPossibleBlockers(combat, attacker, this.blockersLeft, false);
            ArrayList<Card> firstStrikeBlockers = new ArrayList<Card>();
            ArrayList<Card> blockGang = new ArrayList<Card>();
            for (Card blocker : blockers) {
                if (ComputerUtilCombat.canDestroyBlockerBeforeFirstStrike(blocker, attacker, false) || !blocker.hasFirstStrike() && !blocker.hasDoubleStrike()) continue;
                firstStrikeBlockers.add(blocker);
            }
            if (firstStrikeBlockers.size() <= 1) continue;
            CardLists.sortByPowerDesc(firstStrikeBlockers);
            for (Card blocker : firstStrikeBlockers) {
                int damageNeeded = ComputerUtilCombat.getDamageToKill(attacker, false) + ComputerUtilCombat.predictToughnessBonusOfAttacker(attacker, blocker, combat, false);
                if (ComputerUtilCombat.totalFirstStrikeDamageOfBlockers(attacker, blockGang) >= damageNeeded && CombatUtil.getMinNumBlockersForAttacker(attacker, this.ai) <= blockGang.size()) continue;
                blockGang.add(blocker);
                if (ComputerUtilCombat.totalFirstStrikeDamageOfBlockers(attacker, blockGang) < damageNeeded) continue;
                currentAttackers.remove(attacker);
                for (Card b : blockGang) {
                    if (!CombatUtil.canBlock(attacker, blocker, combat)) continue;
                    combat.addBlocker(attacker, b);
                }
            }
        }
        this.attackersLeft = new ArrayList<Card>(currentAttackers);
        boolean considerTripleBlock = true;
        block4: for (Card attacker : this.attackersLeft) {
            int damageNeeded;
            int absorbedDamage2;
            int currentDamage;
            if (ComputerUtilCombat.combatantCantBeDestroyed(this.ai, attacker) || CombatUtil.getMinNumBlockersForAttacker(attacker, this.ai) > (considerTripleBlock ? 3 : 2)) continue;
            int evalAttackerValue = ComputerUtilCard.evaluateCreature(attacker);
            blockers = AiBlockController.getPossibleBlockers(combat, attacker, this.blockersLeft, false);
            ArrayList<Card> blockGang = new ArrayList<Card>();
            boolean foundDoubleBlock = false;
            CardCollection usableBlockers = CardLists.filter(blockers, c -> {
                if (ComputerUtilCombat.dealsFirstStrikeDamage(attacker, false, combat) && !ComputerUtilCombat.dealsFirstStrikeDamage(c, false, combat)) {
                    return false;
                }
                return this.lifeInDanger || this.wouldLikeToRandomlyTrade(attacker, (Card)c, combat) || ComputerUtilCard.evaluateCreature(c) + this.diff < ComputerUtilCard.evaluateCreature(attacker);
            });
            if (usableBlockers.size() < 2) {
                return;
            }
            Card leader = ComputerUtilCard.getBestCreatureAI(usableBlockers);
            blockGang.add(leader);
            usableBlockers.remove(leader);
            int absorbedDamage = ComputerUtilCombat.getEnoughDamageToKill(leader, attacker.getNetCombatDamage(), attacker, true);
            int currentValue = ComputerUtilCard.evaluateCreature(leader);
            for (Card blocker : usableBlockers) {
                currentDamage = ComputerUtilCombat.totalDamageOfBlockers(attacker, blockGang);
                int additionalDamage = ComputerUtilCombat.dealsDamageAsBlocker(attacker, blocker);
                absorbedDamage2 = ComputerUtilCombat.getEnoughDamageToKill(blocker, attacker.getNetCombatDamage(), attacker, true);
                int addedValue = ComputerUtilCard.evaluateCreature(blocker);
                damageNeeded = ComputerUtilCombat.getDamageToKill(attacker, false) + ComputerUtilCombat.predictToughnessBonusOfAttacker(attacker, blocker, combat, false);
                if ((damageNeeded > currentDamage || CombatUtil.getMinNumBlockersForAttacker(attacker, this.ai) > blockGang.size()) && damageNeeded <= currentDamage + additionalDamage && (absorbedDamage2 + absorbedDamage > attacker.getNetCombatDamage() || currentValue + addedValue - 50 <= evalAttackerValue || this.lifeInDanger && ComputerUtilCombat.lifeInDanger(this.ai, combat)) && CombatUtil.canBlock(attacker, blocker, combat)) {
                    currentAttackers.remove(attacker);
                    combat.addBlocker(attacker, blocker);
                    if (CombatUtil.canBlock(attacker, leader, combat)) {
                        combat.addBlocker(attacker, leader);
                    }
                    foundDoubleBlock = true;
                    break;
                }
                if (foundDoubleBlock || currentDamage + additionalDamage < damageNeeded) continue;
                considerTripleBlock = false;
            }
            if (foundDoubleBlock || !considerTripleBlock) continue;
            for (Card secondBlocker : usableBlockers) {
                currentDamage = ComputerUtilCombat.totalDamageOfBlockers(attacker, blockGang);
                int additionalDamage2 = ComputerUtilCombat.dealsDamageAsBlocker(attacker, secondBlocker);
                absorbedDamage2 = ComputerUtilCombat.getEnoughDamageToKill(secondBlocker, attacker.getNetCombatDamage(), attacker, true);
                int addedValue2 = ComputerUtilCard.evaluateCreature(secondBlocker);
                damageNeeded = ComputerUtilCombat.getDamageToKill(attacker, false) + ComputerUtilCombat.predictToughnessBonusOfAttacker(attacker, secondBlocker, combat, false);
                ArrayList<Card> usableBlockersAsThird = new ArrayList<Card>(usableBlockers);
                usableBlockersAsThird.remove(secondBlocker);
                for (Card thirdBlocker : usableBlockersAsThird) {
                    int additionalDamage3 = ComputerUtilCombat.dealsDamageAsBlocker(attacker, thirdBlocker);
                    int absorbedDamage3 = ComputerUtilCombat.getEnoughDamageToKill(thirdBlocker, attacker.getNetCombatDamage(), attacker, true);
                    int addedValue3 = ComputerUtilCard.evaluateCreature(secondBlocker);
                    int netCombatDamage = attacker.getNetCombatDamage();
                    if (damageNeeded <= currentDamage && CombatUtil.getMinNumBlockersForAttacker(attacker, this.ai) <= blockGang.size() || damageNeeded > currentDamage + additionalDamage2 + additionalDamage3 || !(absorbedDamage2 + absorbedDamage > netCombatDamage && absorbedDamage3 + absorbedDamage > netCombatDamage && absorbedDamage3 + absorbedDamage2 > netCombatDamage || currentValue + addedValue2 + addedValue3 - 50 <= evalAttackerValue || thirdBlocker.isToken() && absorbedDamage2 + absorbedDamage > netCombatDamage) && (!this.lifeInDanger || !ComputerUtilCombat.lifeInDanger(this.ai, combat)) || !CombatUtil.canBlock(attacker, secondBlocker, combat) || !CombatUtil.canBlock(attacker, thirdBlocker, combat)) continue;
                    currentAttackers.remove(attacker);
                    combat.addBlocker(attacker, thirdBlocker);
                    if (CombatUtil.canBlock(attacker, secondBlocker, combat)) {
                        combat.addBlocker(attacker, secondBlocker);
                    }
                    if (!CombatUtil.canBlock(attacker, leader, combat)) continue block4;
                    combat.addBlocker(attacker, leader);
                    continue block4;
                }
            }
        }
        this.attackersLeft = new ArrayList<Card>(currentAttackers);
    }

    private void makeGangNonLethalBlocks(Combat combat) {
        ArrayList<Card> currentAttackers = new ArrayList<Card>(this.attackersLeft);
        block0: for (Card attacker : this.attackersLeft) {
            if (CombatUtil.getMinNumBlockersForAttacker(attacker, combat.getDefenderPlayerByAttacker(attacker)) != 2) continue;
            List<Card> blockers = AiBlockController.getPossibleBlockers(combat, attacker, this.blockersLeft, false);
            ArrayList<Card> blockGang = new ArrayList<Card>();
            CardCollection usableBlockers = CardLists.filter(blockers, c -> c.getNetToughness() > attacker.getNetCombatDamage() || c.getNetToughness() + ComputerUtilCombat.predictToughnessBonusOfBlocker(attacker, c, true) > attacker.getNetCombatDamage());
            if (usableBlockers.size() < 2) {
                return;
            }
            Card leader = ComputerUtilCard.getWorstCreatureAI(usableBlockers);
            blockGang.add(leader);
            usableBlockers.remove(leader);
            int absorbedDamage = ComputerUtilCombat.getEnoughDamageToKill(leader, attacker.getNetCombatDamage(), attacker, true);
            for (Card blocker : usableBlockers) {
                int absorbedDamage2 = ComputerUtilCombat.getEnoughDamageToKill(blocker, attacker.getNetCombatDamage(), attacker, true);
                if (absorbedDamage <= attacker.getNetCombatDamage() || absorbedDamage2 <= attacker.getNetCombatDamage()) continue;
                currentAttackers.remove(attacker);
                combat.addBlocker(attacker, blocker);
                if (!CombatUtil.canBlock(attacker, leader, combat)) continue block0;
                combat.addBlocker(attacker, leader);
                continue block0;
            }
        }
        this.attackersLeft = new ArrayList<Card>(currentAttackers);
    }

    private void makeTradeBlocks(Combat combat) {
        ArrayList<Card> currentAttackers = new ArrayList<Card>(this.attackersLeft);
        for (Card attacker : this.attackersLeft) {
            List<Card> possibleBlockers;
            List<Card> killingBlockers;
            if (CombatUtil.getMinNumBlockersForAttacker(attacker, combat.getDefenderPlayerByAttacker(attacker)) > 1 || ComputerUtilCombat.attackerHasThreateningAfflict(attacker, this.ai) || (killingBlockers = this.getKillingBlockers(combat, attacker, possibleBlockers = AiBlockController.getPossibleBlockers(combat, attacker, this.blockersLeft, true))).isEmpty()) continue;
            Card blocker = ComputerUtilCard.getWorstCreatureAI(killingBlockers);
            boolean doTrade = false;
            doTrade = this.lifeInDanger && ComputerUtilCombat.lifeInDanger(this.ai, combat) ? true : this.wouldLikeToRandomlyTrade(attacker, blocker, combat);
            if (!doTrade) continue;
            combat.addBlocker(attacker, blocker);
            currentAttackers.remove(attacker);
        }
        this.attackersLeft = currentAttackers;
    }

    private void makeChumpBlocks(Combat combat) {
        ArrayList<Card> currentAttackers = new ArrayList<Card>(this.attackersLeft);
        this.makeChumpBlocks(combat, currentAttackers);
        if (this.lifeInDanger) {
            this.makeMultiChumpBlocks(combat);
        }
    }

    private void makeChumpBlocks(Combat combat, List<Card> attackers) {
        if (!ComputerUtilCombat.lifeInDanger(this.ai, combat)) {
            this.lifeInDanger = false;
            return;
        }
        if (attackers.isEmpty()) {
            return;
        }
        Card attacker = attackers.get(0);
        if (CombatUtil.getMinNumBlockersForAttacker(attacker, combat.getDefenderPlayerByAttacker(attacker)) > 1 || StaticAbilityAssignCombatDamageAsUnblocked.assignCombatDamageAsUnblocked(attacker) || ComputerUtilCombat.attackerHasThreateningAfflict(attacker, this.ai)) {
            attackers.remove(0);
            this.makeChumpBlocks(combat, attackers);
            return;
        }
        List<Card> chumpBlockers = AiBlockController.getPossibleBlockers(combat, attacker, this.blockersLeft, true);
        if (!chumpBlockers.isEmpty()) {
            Card blocker = ComputerUtilCard.getWorstCreatureAI(chumpBlockers);
            if (attacker.hasKeyword(Keyword.TRAMPLE)) {
                int damageAbsorbed = blocker.getLethalDamage();
                if (attacker.getNetCombatDamage() > damageAbsorbed) {
                    for (Card other : attackers) {
                        if (other.equals(attacker) || other.getNetCombatDamage() < damageAbsorbed || other.hasKeyword(Keyword.TRAMPLE) || StaticAbilityAssignCombatDamageAsUnblocked.assignCombatDamageAsUnblocked(other) || ComputerUtilCombat.attackerHasThreateningAfflict(other, this.ai) || !CombatUtil.canBlock(other, blocker, combat)) continue;
                        combat.addBlocker(other, blocker);
                        this.attackersLeft.remove(other);
                        this.blockedButUnkilled.add(other);
                        attackers.remove(other);
                        this.makeChumpBlocks(combat, attackers);
                        return;
                    }
                }
            }
            combat.addBlocker(attacker, blocker);
            this.attackersLeft.remove(attacker);
            this.blockedButUnkilled.add(attacker);
        }
        attackers.remove(0);
        this.makeChumpBlocks(combat, attackers);
    }

    private void makeMultiChumpBlocks(Combat combat) {
        ArrayList<Card> currentAttackers = new ArrayList<Card>(this.attackersLeft);
        for (Card attacker : currentAttackers) {
            List<Card> possibleBlockers;
            if (CombatUtil.getMinNumBlockersForAttacker(attacker, combat.getDefenderPlayerByAttacker(attacker)) <= 1 || !CombatUtil.canAttackerBeBlockedWithAmount(attacker, (possibleBlockers = AiBlockController.getPossibleBlockers(combat, attacker, this.blockersLeft, true)).size(), combat)) continue;
            ArrayList<Card> usedBlockers = new ArrayList<Card>();
            for (Card blocker : possibleBlockers) {
                if (!CombatUtil.canBlock(attacker, blocker, combat)) continue;
                combat.addBlocker(attacker, blocker);
                usedBlockers.add(blocker);
                if (!CombatUtil.canAttackerBeBlockedWithAmount(attacker, usedBlockers.size(), combat)) continue;
                this.attackersLeft.remove(attacker);
                usedBlockers.clear();
                break;
            }
            for (Card blocker : usedBlockers) {
                combat.removeBlockAssignment(attacker, blocker);
            }
        }
    }

    private void reinforceBlockersAgainstTrample(Combat combat) {
        CardCollection tramplingAttackers = CardLists.getKeyword(this.attackers, Keyword.TRAMPLE);
        tramplingAttackers = CardLists.filter((Iterable<Card>)tramplingAttackers, Predicates.not(this.rampagesOrNeedsManyToBlock(combat)));
        tramplingAttackers = CardLists.filter((Iterable<Card>)tramplingAttackers, Predicates.not(this.changesPTWhenBlocked(true)));
        for (Card attacker : tramplingAttackers) {
            if (CombatUtil.getMinNumBlockersForAttacker(attacker, combat.getDefenderPlayerByAttacker(attacker)) > combat.getBlockers(attacker).size()) continue;
            boolean needsMoreChumpBlockers = true;
            if (AttackingBand.isValidBand(combat.getBlockers(attacker), true)) continue;
            List<Card> chumpBlockers = AiBlockController.getPossibleBlockers(combat, attacker, this.blockersLeft, false);
            chumpBlockers.removeAll(combat.getBlockers(attacker));
            for (Card blocker : chumpBlockers) {
                if (!blocker.hasKeyword(Keyword.BANDING) && !blocker.hasKeyword(Keyword.BANDSWITH) || ComputerUtilCombat.getAttack(attacker) <= ComputerUtilCombat.totalShieldDamage(attacker, combat.getBlockers(attacker)) || ComputerUtilCombat.shieldDamage(attacker, blocker) <= 0 || !CombatUtil.canBlock(attacker, blocker, combat) || !ComputerUtilCombat.lifeInDanger(this.ai, combat)) continue;
                combat.addBlocker(attacker, blocker);
                needsMoreChumpBlockers = false;
                break;
            }
            if (!needsMoreChumpBlockers || StaticAbilityAssignCombatDamageAsUnblocked.assignCombatDamageAsUnblocked(attacker) || !needsMoreChumpBlockers) continue;
            for (Card blocker : chumpBlockers) {
                if (ComputerUtilCombat.getAttack(attacker) <= ComputerUtilCombat.totalShieldDamage(attacker, combat.getBlockers(attacker)) || ComputerUtilCombat.shieldDamage(attacker, blocker) <= 0 || !CombatUtil.canBlock(attacker, blocker, combat) || !ComputerUtilCombat.lifeInDanger(this.ai, combat)) continue;
                combat.addBlocker(attacker, blocker);
            }
        }
    }

    private void reinforceBlockersToKill(Combat combat) {
        CardCollection targetAttackers = CardLists.filter(this.blockedButUnkilled, Predicates.not(this.rampagesOrNeedsManyToBlock(combat)));
        targetAttackers = CardLists.filter((Iterable<Card>)targetAttackers, Predicates.not(this.changesPTWhenBlocked(false)));
        for (Card attacker : targetAttackers) {
            int damageNeeded;
            List<Card> safeBlockers;
            CardCollection blockers = AiBlockController.getPossibleBlockers(combat, attacker, this.blockersLeft, false);
            blockers.removeAll(combat.getBlockers(attacker));
            blockers = CardLists.filter(blockers, blocker -> !ComputerUtilCombat.isCombatDamagePrevented(blocker, attacker, blocker.getNetCombatDamage()));
            if (blockers.size() > 0) {
                safeBlockers = this.getSafeBlockers(combat, attacker, blockers);
                for (Card blocker2 : safeBlockers) {
                    damageNeeded = ComputerUtilCombat.getDamageToKill(attacker, false) + ComputerUtilCombat.predictToughnessBonusOfAttacker(attacker, blocker2, combat, false);
                    if (damageNeeded > ComputerUtilCombat.totalDamageOfBlockers(attacker, combat.getBlockers(attacker)) && ComputerUtilCombat.dealsDamageAsBlocker(attacker, blocker2) > 0 && CombatUtil.canBlock(attacker, blocker2, combat)) {
                        combat.addBlocker(attacker, blocker2);
                    }
                    blockers.remove(blocker2);
                }
            }
            if (ComputerUtilCombat.combatantCantBeDestroyed(this.ai, attacker)) continue;
            if (ComputerUtilCombat.dealsFirstStrikeDamage(attacker, false, combat)) {
                safeBlockers = CardLists.getKeyword((Iterable<Card>)blockers, Keyword.FIRST_STRIKE);
                safeBlockers.addAll(CardLists.getKeyword((Iterable<Card>)blockers, Keyword.DOUBLE_STRIKE));
            } else {
                safeBlockers = new ArrayList<Card>(blockers);
            }
            for (Card blocker2 : safeBlockers) {
                damageNeeded = ComputerUtilCombat.getDamageToKill(attacker, false) + ComputerUtilCombat.predictToughnessBonusOfAttacker(attacker, blocker2, combat, false);
                int currentDamage = ComputerUtilCombat.totalDamageOfBlockers(attacker, combat.getBlockers(attacker));
                int additionalDamage = ComputerUtilCombat.dealsDamageAsBlocker(attacker, blocker2);
                if (damageNeeded <= currentDamage || damageNeeded > currentDamage + additionalDamage || ComputerUtilCard.evaluateCreature(blocker2) + this.diff >= ComputerUtilCard.evaluateCreature(attacker) || !CombatUtil.canBlock(attacker, blocker2, combat) || ComputerUtilCombat.canDestroyBlockerBeforeFirstStrike(blocker2, attacker, false)) continue;
                combat.addBlocker(attacker, blocker2);
                this.blockersLeft.remove(blocker2);
            }
        }
    }

    private void makeChumpBlocksToSavePW(Combat combat) {
        if (this.lifeInDanger) {
            return;
        }
        AiController aic = ((PlayerControllerAi)this.ai.getController()).getAi();
        int evalThresholdToken = aic.getIntProperty(AiProps.THRESHOLD_TOKEN_CHUMP_TO_SAVE_PLANESWALKER);
        int evalThresholdNonToken = aic.getIntProperty(AiProps.THRESHOLD_NONTOKEN_CHUMP_TO_SAVE_PLANESWALKER);
        boolean onlyIfLethal = aic.getBooleanProperty(AiProps.CHUMP_TO_SAVE_PLANESWALKER_ONLY_ON_LETHAL);
        if (evalThresholdToken > 0 || evalThresholdNonToken > 0) {
            CardCollection threatenedPWs = new CardCollection();
            for (Card attacker : this.attackers) {
                GameEntity def = combat.getDefenderByAttacker(attacker);
                if (!(def instanceof Card)) continue;
                if (!onlyIfLethal) {
                    threatenedPWs.add((Card)def);
                    continue;
                }
                int damageToPW = 0;
                for (Card pwatkr : combat.getAttackersOf(def)) {
                    if (combat.isBlocked(pwatkr)) continue;
                    damageToPW += ComputerUtilCombat.predictDamageTo(def, pwatkr.getNetCombatDamage(), pwatkr, true);
                }
                if ((onlyIfLethal || damageToPW <= 0) && damageToPW < def.getCounters(CounterEnumType.LOYALTY)) continue;
                threatenedPWs.add((Card)def);
            }
            CardCollection pwsWithChumpBlocks = new CardCollection();
            CardCollection chosenChumpBlockers = new CardCollection();
            CardCollection chumpPWDefenders = CardLists.filter(this.blockersLeft, card -> ComputerUtilCard.evaluateCreature(card) <= (card.isToken() ? evalThresholdToken : evalThresholdNonToken));
            CardLists.sortByPowerAsc(chumpPWDefenders);
            if (!chumpPWDefenders.isEmpty()) {
                for (Card attacker : this.attackers) {
                    GameEntity def;
                    if (attacker.hasKeyword(Keyword.TRAMPLE) || !combat.getBlockers(attacker).isEmpty() || !((def = combat.getDefenderByAttacker(attacker)) instanceof Card) || !threatenedPWs.contains(def)) continue;
                    Card blockerDecided = null;
                    for (Card blocker : chumpPWDefenders) {
                        if (!CombatUtil.canBlock(attacker, blocker, combat)) continue;
                        combat.addBlocker(attacker, blocker);
                        pwsWithChumpBlocks.add((Card)def);
                        chosenChumpBlockers.add(blocker);
                        blockerDecided = blocker;
                        this.blockersLeft.remove(blocker);
                        break;
                    }
                    chumpPWDefenders.remove(blockerDecided);
                }
                for (Card pw : pwsWithChumpBlocks) {
                    CardCollection pwAttackers = combat.getAttackersOf(pw);
                    if (pwAttackers.isEmpty()) continue;
                    CardCollection pwDefenders = new CardCollection();
                    boolean isFullyBlocked = true;
                    int damageToPW = 0;
                    for (Card pwAtk : pwAttackers) {
                        if (!combat.getBlockers(pwAtk).isEmpty()) {
                            pwDefenders.addAll(combat.getBlockers(pwAtk));
                            continue;
                        }
                        isFullyBlocked = false;
                        damageToPW += ComputerUtilCombat.predictDamageTo(pw, pwAtk.getNetCombatDamage(), pwAtk, true);
                    }
                    if (isFullyBlocked || damageToPW < pw.getCounters(CounterEnumType.LOYALTY)) continue;
                    for (Card chump : pwDefenders) {
                        if (!chosenChumpBlockers.contains(chump)) continue;
                        combat.removeFromCombat(chump);
                    }
                }
            }
        }
    }

    private void makeRequiredBlocks(Combat combat) {
        CardCollection chumpBlockers = new CardCollection();
        for (Card blocker : this.blockersLeft) {
            if (!CombatUtil.mustBlockAnAttacker(blocker, combat, null) && !StaticAbilityMustBlock.blocksEachCombatIfAble(blocker)) continue;
            chumpBlockers.add(blocker);
        }
        if (!chumpBlockers.isEmpty()) {
            for (Card attacker : this.attackers) {
                List<Card> blockers = AiBlockController.getPossibleBlockers(combat, attacker, chumpBlockers, false);
                for (Card blocker : blockers) {
                    if (!CombatUtil.canBlock(attacker, blocker, combat) || !this.blockersLeft.contains(blocker) || !CombatUtil.mustBlockAnAttacker(blocker, combat, null) && !StaticAbilityMustBlock.blocksEachCombatIfAble(blocker)) continue;
                    combat.addBlocker(attacker, blocker);
                    if (!blocker.getMustBlockCards().isEmpty()) {
                        int mustBlockAmt = blocker.getMustBlockCards().size();
                        CardCollection blockedSoFar = combat.getAttackersBlockedBy(blocker);
                        boolean canBlockAnother = CombatUtil.canBlockMoreCreatures(blocker, blockedSoFar);
                        if (canBlockAnother && mustBlockAmt != blockedSoFar.size()) continue;
                        this.blockersLeft.remove(blocker);
                        continue;
                    }
                    this.blockersLeft.remove(blocker);
                }
            }
        }
    }

    private void clearBlockers(Combat combat, List<Card> possibleBlockers) {
        for (Card blocker : CardLists.filterControlledBy((Iterable<Card>)combat.getAllBlockers(), this.ai)) {
            combat.removeFromCombat(blocker);
        }
        this.attackersLeft = new ArrayList<Card>(this.attackers);
        this.blockersLeft = new ArrayList<Card>(possibleBlockers);
        this.blockedButUnkilled = new ArrayList<Card>();
    }

    public void assignBlockersForCombat(Combat combat) {
        this.assignBlockersForCombat(combat, null);
    }

    public void assignBlockersForCombat(Combat combat, CardCollection exludedBlockers) {
        CardCollection possibleBlockers = this.ai.getCreaturesInPlay();
        if (exludedBlockers != null && !exludedBlockers.isEmpty()) {
            possibleBlockers.removeAll(exludedBlockers);
        }
        this.attackers = this.sortPotentialAttackers(combat);
        this.assignBlockers(combat, possibleBlockers);
    }

    public void assignAdditionalBlockers(Combat combat, CardCollectionView blockers) {
        CardCollection possibleBlockers = this.ai.getCreaturesInPlay();
        for (Card c : blockers) {
            if (possibleBlockers.contains(c)) continue;
            possibleBlockers.add(c);
        }
        this.attackers = this.sortPotentialAttackers(combat);
        this.assignBlockers(combat, possibleBlockers);
    }

    public void assignBlockersGivenAttackers(Combat combat, List<Card> givenAttackers) {
        CardCollection possibleBlockers = this.ai.getCreaturesInPlay();
        this.attackers = givenAttackers;
        this.assignBlockers(combat, possibleBlockers);
    }

    private void assignBlockers(Combat combat, List<Card> possibleBlockers) {
        if (this.attackers.isEmpty()) {
            return;
        }
        this.clearBlockers(combat, possibleBlockers);
        this.diff = this.ai.getLife() * 2 - 5;
        if (this.ai.getController().isAI() && this.diff > 0 && ((PlayerControllerAi)this.ai.getController()).getAi().getBooleanProperty(AiProps.PLAY_AGGRO)) {
            this.diff = 0;
        }
        for (Card a : this.attackers) {
            if (CombatUtil.canBeBlocked(a, null, this.ai)) continue;
            this.attackersLeft.remove(a);
        }
        if (this.attackersLeft.isEmpty()) {
            return;
        }
        for (Card b : possibleBlockers) {
            if (CombatUtil.canBlock(b, combat)) continue;
            this.blockersLeft.remove(b);
        }
        CardLists.sortByPowerAsc(this.blockersLeft);
        this.makeGoodBlocks(combat);
        this.makeGangBlocks(combat);
        if (!ComputerUtil.hasAFogEffect(this.ai, this.ai, this.checkingOther)) {
            this.lifeInDanger = ComputerUtilCombat.lifeInDanger(this.ai, combat);
            this.makeTradeBlocks(combat);
            if (this.lifeInDanger) {
                this.makeChumpBlocks(combat);
            }
            if (this.lifeInDanger && ComputerUtilCombat.lifeInDanger(this.ai, combat)) {
                this.reinforceBlockersAgainstTrample(combat);
            } else {
                this.lifeInDanger = false;
            }
            if (!this.lifeInDanger) {
                this.reinforceBlockersToKill(combat);
            }
            if (this.removeUnpayableBlocks(combat) || this.lifeInDanger) {
                this.lifeInDanger = ComputerUtilCombat.lifeInDanger(this.ai, combat);
            }
            if (this.lifeInDanger) {
                this.clearBlockers(combat, possibleBlockers);
                this.makeTradeBlocks(combat);
                this.makeGoodBlocks(combat);
                this.makeChumpBlocks(combat);
                if (this.lifeInDanger && ComputerUtilCombat.lifeInDanger(this.ai, combat)) {
                    this.reinforceBlockersAgainstTrample(combat);
                } else {
                    this.lifeInDanger = false;
                }
                this.makeGangBlocks(combat);
                this.reinforceBlockersToKill(combat);
            }
            if (this.lifeInDanger && ComputerUtilCombat.lifeInSeriousDanger(this.ai, combat)) {
                this.clearBlockers(combat, possibleBlockers);
                this.makeChumpBlocks(combat);
                if (this.lifeInDanger && ComputerUtilCombat.lifeInDanger(this.ai, combat)) {
                    this.makeTradeBlocks(combat);
                } else {
                    this.lifeInDanger = false;
                }
                if (this.lifeInDanger && ComputerUtilCombat.lifeInDanger(this.ai, combat)) {
                    this.reinforceBlockersAgainstTrample(combat);
                } else {
                    this.lifeInDanger = false;
                }
                if (!this.lifeInDanger) {
                    this.makeGoodBlocks(combat);
                }
                this.makeGangBlocks(combat);
                this.reinforceBlockersToKill(combat);
            }
        }
        this.makeRequiredBlocks(combat);
        if (this.ai.getController().isAI()) {
            this.makeChumpBlocksToSavePW(combat);
        }
        this.makeGangNonLethalBlocks(combat);
        for (Card attacker : this.attackers) {
            if (CombatUtil.canAttackerBeBlockedWithAmount(attacker, combat.getBlockers(attacker).size(), combat)) continue;
            for (Card blocker : CardLists.filterControlledBy((Iterable<Card>)combat.getBlockers(attacker), this.ai)) {
                combat.removeFromCombat(blocker);
            }
        }
    }

    public static CardCollection orderBlockers(Card attacker, CardCollection blockers) {
        int damage = attacker.getNetCombatDamage();
        ComputerUtilCard.sortByEvaluateCreature(blockers);
        CardCollection first = new CardCollection();
        CardCollection last = new CardCollection();
        for (Card blocker : blockers) {
            int lethal = ComputerUtilCombat.getEnoughDamageToKill(blocker, damage, attacker, true);
            if (lethal > damage) {
                last.add(blocker);
                continue;
            }
            first.add(blocker);
            damage -= lethal;
        }
        first.addAll(last);
        return first;
    }

    public static CardCollection orderBlocker(Card attacker, Card blocker, CardCollection oldBlockers) {
        Card newBlockerRightAfter;
        CardCollection allBlockers = new CardCollection(oldBlockers);
        allBlockers.add(blocker);
        ComputerUtilCard.sortByEvaluateCreature(allBlockers);
        int newBlockerIndex = allBlockers.indexOf(blocker);
        int damage = attacker.getNetCombatDamage();
        CardCollection result = new CardCollection();
        boolean newBlockerIsAdded = false;
        Card card = newBlockerRightAfter = newBlockerIndex == 0 ? null : (Card)allBlockers.get(newBlockerIndex - 1);
        if (newBlockerRightAfter == null && damage >= ComputerUtilCombat.getEnoughDamageToKill(blocker, damage, attacker, true)) {
            result.add(blocker);
            newBlockerIsAdded = true;
        }
        for (Card c : oldBlockers) {
            int lethal = ComputerUtilCombat.getEnoughDamageToKill(c, damage, attacker, true);
            result.add(c);
            if (newBlockerIsAdded || c != newBlockerRightAfter || (damage -= lethal) > ComputerUtilCombat.getEnoughDamageToKill(blocker, damage, attacker, true)) continue;
            result.add(blocker);
            newBlockerIsAdded = true;
        }
        if (!newBlockerIsAdded) {
            result.add(blocker);
        }
        return result;
    }

    public static CardCollection orderAttackers(Card blocker, CardCollection attackers) {
        int damage = blocker.getNetCombatDamage();
        ComputerUtilCard.sortByEvaluateCreature(attackers);
        CardCollection first = new CardCollection();
        CardCollection last = new CardCollection();
        for (Card attacker : attackers) {
            int lethal = ComputerUtilCombat.getEnoughDamageToKill(attacker, damage, blocker, true);
            if (lethal > damage) {
                last.add(attacker);
                continue;
            }
            first.add(attacker);
            damage -= lethal;
        }
        first.addAll(last);
        return first;
    }

    private boolean wouldLikeToRandomlyTrade(Card attacker, Card blocker, Combat combat) {
        boolean blkEmbalm;
        AiController aic;
        boolean enableRandomTrades = false;
        boolean randomTradeIfBehindOnBoard = false;
        boolean randomTradeIfCreatInHand = false;
        int chanceModForEmbalm = 0;
        int chanceToTradeToSaveWalker = 0;
        int chanceToTradeDownToSaveWalker = 0;
        int minRandomTradeChance = 0;
        int maxRandomTradeChance = 0;
        int maxCreatDiff = 0;
        int maxCreatDiffWithRepl = 0;
        int aiCreatureCount = 0;
        int oppCreatureCount = 0;
        if (this.ai.getController().isAI() && !(aic = ((PlayerControllerAi)this.ai.getController()).getAi()).usesSimulation()) {
            enableRandomTrades = aic.getBooleanProperty(AiProps.ENABLE_RANDOM_FAVORABLE_TRADES_ON_BLOCK);
            randomTradeIfBehindOnBoard = aic.getBooleanProperty(AiProps.RANDOMLY_TRADE_EVEN_WHEN_HAVE_LESS_CREATS);
            randomTradeIfCreatInHand = aic.getBooleanProperty(AiProps.ALSO_TRADE_WHEN_HAVE_A_REPLACEMENT_CREAT);
            minRandomTradeChance = aic.getIntProperty(AiProps.MIN_CHANCE_TO_RANDOMLY_TRADE_ON_BLOCK);
            maxRandomTradeChance = aic.getIntProperty(AiProps.MAX_CHANCE_TO_RANDOMLY_TRADE_ON_BLOCK);
            chanceModForEmbalm = aic.getIntProperty(AiProps.CHANCE_DECREASE_TO_TRADE_VS_EMBALM);
            maxCreatDiff = aic.getIntProperty(AiProps.MAX_DIFF_IN_CREATURE_COUNT_TO_TRADE);
            maxCreatDiffWithRepl = aic.getIntProperty(AiProps.MAX_DIFF_IN_CREATURE_COUNT_TO_TRADE_WITH_REPL);
            chanceToTradeToSaveWalker = aic.getIntProperty(AiProps.CHANCE_TO_TRADE_TO_SAVE_PLANESWALKER);
            chanceToTradeDownToSaveWalker = aic.getIntProperty(AiProps.CHANCE_TO_TRADE_DOWN_TO_SAVE_PLANESWALKER);
        }
        if (!enableRandomTrades) {
            return false;
        }
        aiCreatureCount = ComputerUtil.countUsefulCreatures(this.ai);
        if (!this.attackersLeft.isEmpty()) {
            oppCreatureCount = ComputerUtil.countUsefulCreatures(this.attackersLeft.get(0).getController());
        }
        if (attacker != null && attacker.getOwner() != null && attacker.getOwner().equals(this.ai) && "6".equals(attacker.getSVar("SacMe"))) {
            return false;
        }
        int numSteps = Math.max(1, this.ai.getStartingLife() - 5);
        float chanceStep = (maxRandomTradeChance - minRandomTradeChance) / numSteps;
        int chance = (int)Math.max((float)minRandomTradeChance, (float)maxRandomTradeChance - (float)Math.max(5, this.ai.getLife() - 5) * chanceStep);
        if (chance > maxRandomTradeChance) {
            chance = maxRandomTradeChance;
        }
        int evalAtk = ComputerUtilCard.evaluateCreature(attacker, true, false);
        boolean atkEmbalm = (attacker.hasKeyword(Keyword.EMBALM) || attacker.hasKeyword(Keyword.ETERNALIZE)) && !attacker.isToken();
        boolean bl = blkEmbalm = (blocker.hasKeyword(Keyword.EMBALM) || blocker.hasKeyword(Keyword.ETERNALIZE)) && !blocker.isToken();
        if (atkEmbalm && !blkEmbalm) {
            chance = Math.max(0, chance - chanceModForEmbalm);
        }
        int evalBlk = blocker.isFaceDown() && blocker.getView().canFaceDownBeShownTo(this.ai.getView()) && blocker.getState(CardStateName.Original).getType().isCreature() ? ComputerUtilCard.evaluateCreature(Card.fromPaperCard(blocker.getPaperCard(), this.ai), false, true) : ComputerUtilCard.evaluateCreature(blocker, true, false);
        int chanceToSavePW = chanceToTradeDownToSaveWalker > 0 && evalAtk + 1 < evalBlk ? chanceToTradeDownToSaveWalker : chanceToTradeToSaveWalker;
        boolean powerParityOrHigher = blocker.getNetPower() <= attacker.getNetPower();
        boolean creatureParityOrAllowedDiff = aiCreatureCount + (randomTradeIfBehindOnBoard ? maxCreatDiff : 0) >= oppCreatureCount;
        boolean wantToTradeWithCreatInHand = !this.checkingOther && randomTradeIfCreatInHand && this.ai.getZone(ZoneType.Hand).contains(CardPredicates.Presets.CREATURES) && aiCreatureCount + maxCreatDiffWithRepl >= oppCreatureCount;
        boolean wantToSavePlaneswalker = MyRandom.percentTrue(chanceToSavePW) && combat.getDefenderByAttacker(attacker) instanceof Card && ((Card)combat.getDefenderByAttacker(attacker)).isPlaneswalker();
        boolean wantToTradeDownToSavePW = chanceToTradeDownToSaveWalker > 0;
        return !(evalBlk > evalAtk + 1 && (!wantToSavePlaneswalker || !wantToTradeDownToSavePW) || !powerParityOrHigher || !creatureParityOrAllowedDiff && !wantToTradeWithCreatInHand || !MyRandom.percentTrue(chance) && !wantToSavePlaneswalker);
    }

    private boolean removeUnpayableBlocks(Combat combat) {
        int myFreeMana = ComputerUtilMana.getAvailableManaEstimate(this.ai);
        int currentBlockTax = 0;
        CardCollection oldBlockers = CardLists.filterControlledBy((Iterable<Card>)combat.getAllBlockers(), this.ai);
        CardLists.sortByPowerDesc(oldBlockers);
        boolean modified = false;
        for (Card blocker : oldBlockers) {
            int taxCMC;
            Cost tax = CombatUtil.getBlockCost(blocker.getGame(), blocker, (Card)combat.getAttackersBlockedBy(blocker).get(false));
            int n = taxCMC = tax != null ? tax.getCostMana().getMana().getCMC() : 0;
            if (myFreeMana < currentBlockTax + taxCMC) {
                combat.removeFromCombat(blocker);
                modified = true;
                continue;
            }
            currentBlockTax += taxCMC;
        }
        return modified;
    }
}

