/*
 * Decompiled with CFR 0.152.
 */
package forge.ai;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.ai.AiCardMemory;
import forge.ai.AiController;
import forge.ai.AiProps;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.ComputerUtilCost;
import forge.ai.ComputerUtilMana;
import forge.ai.PlayerControllerAi;
import forge.ai.ability.AnimateAi;
import forge.game.CardTraitBase;
import forge.game.GameEntity;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.ability.effects.ProtectEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardUtil;
import forge.game.card.CounterEnumType;
import forge.game.combat.Combat;
import forge.game.combat.CombatUtil;
import forge.game.combat.GlobalAttackRestrictions;
import forge.game.cost.Cost;
import forge.game.keyword.Keyword;
import forge.game.keyword.KeywordInterface;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityPredicates;
import forge.game.staticability.StaticAbility;
import forge.game.staticability.StaticAbilityAssignCombatDamageAsUnblocked;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import forge.util.Expressions;
import forge.util.MyRandom;
import forge.util.collect.FCollection;
import forge.util.collect.FCollectionView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class AiAttackController {
    private List<Card> attackers;
    private List<Card> blockers;
    private List<Card> oppList;
    private List<Card> myList;
    private final Player ai;
    private Player defendingOpponent;
    private int aiAggression = 0;
    private final boolean nextTurn;
    final boolean LOG_AI_ATTACKS = false;

    public AiAttackController(Player ai) {
        this(ai, false);
    }

    public AiAttackController(Player ai, boolean nextTurn) {
        this.ai = ai;
        this.defendingOpponent = AiAttackController.choosePreferredDefenderPlayer(ai, true);
        this.myList = ai.getCreaturesInPlay();
        this.nextTurn = nextTurn;
        this.refreshCombatants(this.defendingOpponent);
    }

    public AiAttackController(Player ai, Card attacker) {
        this.ai = ai;
        this.defendingOpponent = AiAttackController.choosePreferredDefenderPlayer(ai, true);
        this.oppList = AiAttackController.getOpponentCreatures(this.defendingOpponent);
        this.myList = ai.getCreaturesInPlay();
        this.nextTurn = false;
        this.attackers = new ArrayList<Card>();
        if (CombatUtil.canAttack(attacker, this.defendingOpponent)) {
            this.attackers.add(attacker);
        }
        this.blockers = AiAttackController.getPossibleBlockers(this.oppList, this.attackers, this.nextTurn);
    }

    private void refreshCombatants(GameEntity defender) {
        this.oppList = defender instanceof Card && ((Card)defender).isBattle() ? AiAttackController.getOpponentCreatures(((Card)defender).getProtectingPlayer()) : AiAttackController.getOpponentCreatures(this.defendingOpponent);
        this.attackers = new ArrayList<Card>();
        for (Card c : this.myList) {
            if (!this.canAttackWrapper(c, defender)) continue;
            this.attackers.add(c);
        }
        this.blockers = AiAttackController.getPossibleBlockers(this.oppList, this.attackers, this.nextTurn);
    }

    public static List<Card> getOpponentCreatures(Player defender) {
        CardCollection defenders = defender.getCreaturesInPlay();
        int totalMana = ComputerUtilMana.getAvailableManaEstimate(defender, true);
        int manaReserved = 0;
        Predicate canAnimate = c -> !c.isTapped() && !c.isCreature() && !c.isPlaneswalker();
        CardCollection tappedDefenders = new CardCollection();
        for (Card c2 : CardLists.filter((Iterable<Card>)defender.getCardsIn(ZoneType.Battlefield), canAnimate)) {
            int saCMC;
            for (SpellAbility sa : Iterables.filter(c2.getSpellAbilities(), SpellAbilityPredicates.isApi(ApiType.Animate))) {
                Card animatedCopy;
                if (sa.usesTargeting() || !sa.getParamOrDefault("Defined", "Self").equals("Self")) continue;
                sa.setActivatingPlayer(defender);
                if (sa.isCrew() && !ComputerUtilCost.checkTapTypeCost(defender, sa.getPayCosts(), c2, sa, tappedDefenders) || !ComputerUtilCost.canPayCost(sa, defender, false) || !sa.getRestrictions().checkOtherRestrictions(c2, sa, defender) || !(animatedCopy = AnimateAi.becomeAnimated(c2, sa)).isCreature() || totalMana - manaReserved < (saCMC = sa.getPayCosts() != null && sa.getPayCosts().hasManaCost() ? sa.getPayCosts().getTotalMana().getCMC() : 0)) continue;
                manaReserved += saCMC;
                defenders.add(animatedCopy);
                break;
            }
            defenders.removeAll(tappedDefenders);
            for (SpellAbility sa : Iterables.filter(c2.getSpellAbilities(), SpellAbilityPredicates.isApi(ApiType.SetState))) {
                Card transformedCopy = ComputerUtilCombat.canTransform(c2);
                if (!transformedCopy.isCreature() || totalMana - manaReserved < (saCMC = sa.getPayCosts() != null && sa.getPayCosts().hasManaCost() ? sa.getPayCosts().getTotalMana().getCMC() : 0)) continue;
                manaReserved += saCMC;
                defenders.add(transformedCopy);
            }
        }
        return defenders;
    }

    public void removeBlocker(Card blocker) {
        this.oppList.remove(blocker);
        this.blockers.remove(blocker);
    }

    private boolean canAttackWrapper(Card attacker, GameEntity defender) {
        if (this.nextTurn) {
            return CombatUtil.canAttackNextTurn(attacker, defender);
        }
        return CombatUtil.canAttack(attacker, defender);
    }

    public static Player choosePreferredDefenderPlayer(Player ai) {
        return AiAttackController.choosePreferredDefenderPlayer(ai, false);
    }

    public static Player choosePreferredDefenderPlayer(Player ai, boolean forCombatDmg) {
        Player defender = ai.getWeakestOpponent();
        if (defender.getLife() > 8) {
            ArrayList<Player> opps = Lists.newArrayList(ai.getOpponents());
            if (forCombatDmg) {
                for (Player p : ai.getOpponents()) {
                    if (p.isMonarch() && ai.canBecomeMonarch()) {
                        opps.add(p);
                    }
                    if (!p.hasInitiative()) continue;
                    opps.add(p);
                }
            }
            return Aggregates.random(opps);
        }
        return defender;
    }

    public static final List<Card> sortAttackers(List<Card> in) {
        ArrayList<Card> list = new ArrayList<Card>();
        block0: for (Card attacker : in) {
            for (Trigger trigger : attacker.getTriggers()) {
                if (trigger.getMode() != TriggerType.Attacks) continue;
                list.add(attacker);
                continue block0;
            }
        }
        for (Card attacker : in) {
            if (list.contains(attacker)) continue;
            list.add(attacker);
        }
        return list;
    }

    public final boolean isEffectiveAttacker(Player ai, Card attacker, Combat combat, GameEntity defender) {
        if (attacker.getNetToughness() + ComputerUtilCombat.predictToughnessBonusOfAttacker(attacker, null, combat, true) <= 0) {
            return false;
        }
        for (Card c : ai.getOpponents().getCardsIn(ZoneType.Battlefield)) {
            for (Trigger t2 : c.getTriggers()) {
                SpellAbility sa;
                if (t2.getMode() != TriggerType.Attacks || (sa = t2.ensureAbility()) == null || sa.getApi() != ApiType.EachDamage || !"TriggeredAttacker".equals(sa.getParam("Defined"))) continue;
                CardCollection valid = CardLists.getValidCards((Iterable<Card>)c.getController().getCreaturesInPlay(), sa.getParam("ValidCards"), c.getController(), c, (CardTraitBase)sa);
                if (attacker.getNetToughness() > valid.size()) continue;
                return false;
            }
        }
        if ("TRUE".equals(attacker.getSVar("HasAttackEffect"))) {
            return true;
        }
        int dmgIfUnblocked = ComputerUtilCombat.damageIfUnblocked(attacker, defender, combat, true);
        if (dmgIfUnblocked > 0) {
            boolean onlyIfExalted = false;
            if (combat.getAttackers().isEmpty() && ai.countExaltedBonus() > 0 && dmgIfUnblocked - ai.countExaltedBonus() == 0) {
                onlyIfExalted = true;
            }
            if (!onlyIfExalted || this.attackers.size() == 1 || this.aiAggression == 6) {
                return true;
            }
        }
        if (defender instanceof Player && ComputerUtilCombat.poisonIfUnblocked(attacker, (Player)defender) > 0) {
            return true;
        }
        int exalted = ai.countExaltedBonus();
        if (this.attackers.size() == 1 && exalted > 0 && ComputerUtilCombat.predictDamageTo(defender, exalted, attacker, true) > 0) {
            return true;
        }
        CardCollectionView controlledByCompy = ai.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES);
        for (Card c : controlledByCompy) {
            for (Trigger trigger : c.getTriggers()) {
                if (!ComputerUtilCombat.combatTriggerWillTrigger(attacker, null, trigger, combat, this.attackers)) continue;
                return true;
            }
        }
        return false;
    }

    public static final List<Card> getPossibleBlockers(List<Card> blockers, List<Card> attackers, boolean nextTurn) {
        return CardLists.filter(blockers, c -> AiAttackController.canBlockAnAttacker(c, attackers, nextTurn));
    }

    public static final boolean canBlockAnAttacker(Card c, List<Card> attackers, boolean nextTurn) {
        return AiAttackController.getCardCanBlockAnAttacker(c, attackers, nextTurn) != null;
    }

    public static final Card getCardCanBlockAnAttacker(Card c, List<Card> attackers, boolean nextTurn) {
        ArrayList<Card> attackerList = new ArrayList<Card>(attackers);
        if (!c.isCreature()) {
            return null;
        }
        for (Card attacker : attackerList) {
            if (!CombatUtil.canBlock(attacker, c, nextTurn)) continue;
            return attacker;
        }
        return null;
    }

    public final List<Card> notNeededAsBlockers(List<Card> currentAttackers, List<Card> potentialAttackers) {
        if (this.ai.getGame().getPhaseHandler().getNextTurn().equals(this.ai)) {
            return potentialAttackers;
        }
        if (!AiCardMemory.isMemorySetEmpty(this.ai, AiCardMemory.MemorySet.CHOSEN_FOG_EFFECT)) {
            ArrayList<Card> toRemove = Lists.newArrayList();
            for (Card c2 : potentialAttackers) {
                if (!AiCardMemory.isRememberedCard(this.ai, c2, AiCardMemory.MemorySet.CHOSEN_FOG_EFFECT)) continue;
                toRemove.add(c2);
            }
            potentialAttackers.removeAll(toRemove);
            return potentialAttackers;
        }
        if (this.ai.isCardInPlay("Masako the Humorless")) {
            return potentialAttackers;
        }
        CardCollection notNeededAsBlockers = new CardCollection((Iterable<Card>)potentialAttackers);
        ArrayList<Card> vigilantes = new ArrayList<Card>();
        for (Card c3 : Iterables.concat(currentAttackers, potentialAttackers)) {
            if (c3.hasKeyword(Keyword.VIGILANCE) || ComputerUtilCard.willUntap(this.ai, c3)) {
                vigilantes.add(c3);
                continue;
            }
            if (!currentAttackers.contains(c3)) continue;
            notNeededAsBlockers.add(c3);
        }
        CardCollection opponentsAttackers = CardLists.filter((Iterable<Card>)this.ai.getOpponents().getCreaturesInPlay(), c -> !c.hasSVar("EndOfTurnLeavePlay") && (c.toughnessAssignsDamage() || c.getNetCombatDamage() > 0 || c.getNetCombatDamage() + ComputerUtilCombat.predictPowerBonusOfAttacker(c, null, null, true) > 0) && ComputerUtilCombat.canAttackNextTurn(c));
        List<Card> blockers = AiAttackController.getPossibleBlockers(potentialAttackers, opponentsAttackers, true);
        if (!blockers.isEmpty()) {
            notNeededAsBlockers.removeAll((Collection<?>)blockers);
            boolean playAggro = false;
            boolean pilotsNonAggroDeck = false;
            if (this.ai.getController().isAI()) {
                PlayerControllerAi aic = (PlayerControllerAi)this.ai.getController();
                pilotsNonAggroDeck = aic.pilotsNonAggroDeck();
                playAggro = !pilotsNonAggroDeck || aic.getAi().getBooleanProperty(AiProps.PLAY_AGGRO);
            }
            int thresholdMod = 0;
            int lastAcceptableBaselineLife = 0;
            if (pilotsNonAggroDeck) {
                lastAcceptableBaselineLife = ComputerUtil.predictNextCombatsRemainingLife(this.ai, playAggro, pilotsNonAggroDeck, 0, notNeededAsBlockers);
                if (!this.ai.isCardInPlay("Laboratory Maniac")) {
                    thresholdMod += 3 - Math.min(this.ai.getCardsIn(ZoneType.Library).size(), 3);
                }
                if (this.aiAggression > 4) {
                    ++thresholdMod;
                }
            }
            CardLists.sortByPowerDesc(blockers);
            for (Card c4 : blockers) {
                if (vigilantes.contains(c4)) continue;
                notNeededAsBlockers.add(c4);
                int currentBaselineLife = ComputerUtil.predictNextCombatsRemainingLife(this.ai, playAggro, pilotsNonAggroDeck, 0, notNeededAsBlockers);
                if (currentBaselineLife == Integer.MIN_VALUE) {
                    notNeededAsBlockers.remove(c4);
                    break;
                }
                if (!pilotsNonAggroDeck) continue;
                int ownAttackerDmg = c4.getNetCombatDamage();
                ownAttackerDmg = c4.toughnessAssignsDamage() ? (ownAttackerDmg += ComputerUtilCombat.predictToughnessBonusOfAttacker(c4, null, null, true)) : (ownAttackerDmg += ComputerUtilCombat.predictPowerBonusOfAttacker(c4, null, null, true));
                if (c4.hasDoubleStrike()) {
                    ownAttackerDmg *= 2;
                }
                if (Math.abs(currentBaselineLife - lastAcceptableBaselineLife) > (ownAttackerDmg += thresholdMod)) {
                    notNeededAsBlockers.remove(c4);
                    continue;
                }
                if (Math.abs(currentBaselineLife - lastAcceptableBaselineLife) == ownAttackerDmg) {
                    // empty if block
                }
                lastAcceptableBaselineLife = currentBaselineLife;
            }
        }
        notNeededAsBlockers.addAll(vigilantes);
        notNeededAsBlockers.removeAll((Collection<?>)currentAttackers);
        int humanExaltedBonus = this.defendingOpponent.countExaltedBonus();
        int blockersNeeded = potentialAttackers.size() - notNeededAsBlockers.size();
        if (humanExaltedBonus > 0) {
            boolean finestHour = this.defendingOpponent.isCardInPlay("Finest Hour");
            if ((blockersNeeded <= 0 || finestHour) && !this.oppList.isEmpty()) {
                int totalExaltedAttack;
                int humanBasePower = ComputerUtilCombat.getAttack(this.oppList.get(0)) + humanExaltedBonus;
                if (finestHour) {
                    humanBasePower += humanExaltedBonus;
                }
                int n = totalExaltedAttack = this.defendingOpponent.isCardInPlay("Rafiq of the Many") ? 2 * humanBasePower : humanBasePower;
                if (this.ai.getLife() - 3 <= totalExaltedAttack) {
                    if (blockersNeeded == 0 && !notNeededAsBlockers.isEmpty()) {
                        notNeededAsBlockers.remove(0);
                    }
                    if (finestHour && !notNeededAsBlockers.isEmpty()) {
                        notNeededAsBlockers.remove(0);
                    }
                }
            }
        }
        return notNeededAsBlockers;
    }

    public void reinforceWithBanding(Combat combat) {
        this.reinforceWithBanding(combat, null);
    }

    public void reinforceWithBanding(Combat combat, Card test) {
        CardCollection attackers = combat.getAttackers();
        if (attackers.isEmpty()) {
            return;
        }
        List<Card> bandingCreatures = null;
        if (test == null) {
            bandingCreatures = CardLists.filter(this.myList, card -> card.hasKeyword(Keyword.BANDING) || card.hasKeyword(Keyword.BANDSWITH));
            bandingCreatures = CardLists.filter((Iterable<Card>)bandingCreatures, card -> !combat.isAttacking((Card)card) && CombatUtil.canAttack(card));
            bandingCreatures = this.notNeededAsBlockers(attackers, bandingCreatures);
        } else if (test.hasKeyword(Keyword.BANDING) || test.hasKeyword(Keyword.BANDSWITH)) {
            bandingCreatures = new CardCollection(test);
        }
        GlobalAttackRestrictions restrict = GlobalAttackRestrictions.getGlobalRestrictions(this.ai, combat.getDefenders());
        int attackMax = restrict.getMax();
        if (attackMax >= attackers.size()) {
            return;
        }
        if (bandingCreatures != null) {
            List<String> evasionKeywords = Arrays.asList("Flying", "Horsemanship", "Shadow", "Landwalk:Plains", "Landwalk:Island", "Landwalk:Forest", "Landwalk:Mountain", "Landwalk:Swamp");
            for (Card c : bandingCreatures) {
                Card bestBand = null;
                if (c.getNetPower() <= 0) {
                    attackers = CardLists.filter((Iterable<Card>)attackers, card -> combat.getBandOfAttacker((Card)card).getAttackers().size() == 1);
                }
                Card bestAttacker = ComputerUtilCard.getBestCreatureAI(attackers);
                if (c.hasKeyword(Keyword.BANDSWITH)) {
                    Iterator<KeywordInterface> iterator = c.getKeywords(Keyword.BANDSWITH).iterator();
                    if (iterator.hasNext()) {
                        KeywordInterface kw = iterator.next();
                        String o = kw.getOriginal();
                        String[] m4 = o.split(":");
                        CardCollection bandPartner = CardLists.getValidCards((Iterable<Card>)attackers, m4[1], c.getController(), c, null);
                        bestBand = ComputerUtilCard.getBestCreatureAI(bandPartner);
                    }
                } else {
                    bestBand = !c.hasAnyKeyword(evasionKeywords) && bestAttacker != null && bestAttacker.hasAnyKeyword(evasionKeywords) ? ComputerUtilCard.getBestCreatureAI(CardLists.filter((Iterable<Card>)attackers, card -> !card.hasAnyKeyword(evasionKeywords))) : bestAttacker;
                }
                if (c.getNetPower() <= 0) {
                    attackers = combat.getAttackers();
                }
                if (bestBand == null) continue;
                GameEntity defender = combat.getDefenderByAttacker(bestBand);
                if (attackMax == -1) {
                    int n = attackMax = restrict.getDefenderMax().get(defender) == null ? -1 : (Integer)restrict.getDefenderMax().get(defender);
                }
                if (attackMax != -1 && attackMax <= combat.getAttackers().size() || !CombatUtil.canAttack(c, defender)) continue;
                combat.addAttacker(c, defender, combat.getBandOfAttacker(bestBand));
            }
        }
    }

    private boolean doAssault() {
        AiController aic;
        if (this.ai.isCardInPlay("Beastmaster Ascension") && this.attackers.size() > 1) {
            CardCollectionView beastions = this.ai.getCardsIn(ZoneType.Battlefield, "Beastmaster Ascension");
            int minCreatures = 7;
            for (Card beastion : beastions) {
                int counters = beastion.getCounters(CounterEnumType.QUEST);
                minCreatures = Math.min(minCreatures, 7 - counters);
            }
            if (this.attackers.size() >= minCreatures) {
                return true;
            }
        }
        if (ComputerUtil.hasAFogEffect(this.defendingOpponent, this.ai, true)) {
            return false;
        }
        CardLists.sortByPowerDesc(this.attackers);
        CardCollection unblockedAttackers = new CardCollection();
        CardCollection remainingAttackers = new CardCollection((Iterable<Card>)this.attackers);
        CardCollection remainingBlockers = new CardCollection((Iterable<Card>)this.blockers);
        CardCollection blockedAttackers = new CardCollection();
        int maxBlockersAfterCrew = remainingBlockers.size();
        if (this.defendingOpponent.isCardInPlay("Peacewalker Colossus") && Iterables.any(this.defendingOpponent.getLandsInPlay(), CardPredicates.Presets.UNTAPPED)) {
            maxBlockersAfterCrew += CardLists.count(CardLists.getNotType(this.defendingOpponent.getCardsIn(ZoneType.Battlefield), "Creature"), Predicates.and(CardPredicates.isType("Vehicle"), CardPredicates.Presets.UNTAPPED));
        }
        boolean predictEvasion = false;
        if (this.ai.getController().isAI() && (aic = ((PlayerControllerAi)this.ai.getController()).getAi()).getBooleanProperty(AiProps.COMBAT_ASSAULT_ATTACK_EVASION_PREDICTION)) {
            predictEvasion = true;
        }
        CardCollection accountedBlockers = new CardCollection((Iterable<Card>)this.blockers);
        CardCollection categorizedAttackers = new CardCollection();
        if (predictEvasion) {
            categorizedAttackers.addAll(ComputerUtilCombat.categorizeAttackersByEvasion(this.attackers));
        } else {
            categorizedAttackers.addAll(this.attackers);
        }
        for (Card attacker : categorizedAttackers) {
            if (!CombatUtil.canBeBlocked(attacker, accountedBlockers, null) || StaticAbilityAssignCombatDamageAsUnblocked.assignCombatDamageAsUnblocked(attacker)) {
                unblockedAttackers.add(attacker);
                continue;
            }
            if (!predictEvasion) continue;
            List<Card> potentialBestBlockers = CombatUtil.getPotentialBestBlockers(attacker, accountedBlockers, null);
            accountedBlockers.removeAll((Collection<?>)potentialBestBlockers);
        }
        remainingAttackers.removeAll(unblockedAttackers);
        for (Card blocker : this.blockers) {
            if (!blocker.canBlockAny()) continue;
            for (Card attacker : this.attackers) {
                if (!CombatUtil.canBlock(attacker, blocker)) continue;
                remainingAttackers.remove(attacker);
                blockedAttackers.add(attacker);
            }
            remainingBlockers.remove(blocker);
        }
        for (Card blocker : remainingBlockers) {
            if (remainingAttackers.isEmpty() || maxBlockersAfterCrew == 0) break;
            int numExtraBlocks = blocker.canBlockAdditional();
            while (numExtraBlocks-- > 0 && !remainingAttackers.isEmpty()) {
                blockedAttackers.add((Card)remainingAttackers.remove(0));
            }
            if (remainingAttackers.isEmpty()) break;
            blockedAttackers.add((Card)remainingAttackers.remove(0));
            --maxBlockersAfterCrew;
        }
        unblockedAttackers.addAll(remainingAttackers);
        int totalCombatDamage = 0;
        int myFreeMana = ComputerUtilMana.getAvailableManaEstimate(this.ai, !this.nextTurn);
        Pair<Integer, Integer> tramplerFirst = this.getDamageFromBlockingTramplers(blockedAttackers, remainingBlockers, myFreeMana);
        int trampleDamage = tramplerFirst.getLeft();
        int tramplerTaxPaid = tramplerFirst.getRight();
        if (tramplerTaxPaid > 0) {
            int unblockableAttackTax = 0;
            CardCollection unblockableWithPaying = new CardCollection();
            CardCollection unblockableCantPayFor = new CardCollection();
            CardCollection unblockableWithoutCost = new CardCollection();
            for (Card attacker : unblockedAttackers) {
                Cost tax = CombatUtil.getAttackCost(this.ai.getGame(), attacker, this.defendingOpponent);
                if (tax == null) {
                    unblockableWithoutCost.add(attacker);
                    continue;
                }
                int taxCMC = tax.getCostMana().getMana().getCMC();
                if (myFreeMana < unblockableAttackTax + taxCMC) {
                    unblockableCantPayFor.add(attacker);
                    continue;
                }
                unblockableAttackTax += taxCMC;
                unblockableWithPaying.add(attacker);
            }
            int dmgUnblockableAfterPaying = ComputerUtilCombat.sumDamageIfUnblocked(unblockableWithPaying, this.defendingOpponent);
            unblockedAttackers = unblockableWithoutCost;
            if (dmgUnblockableAfterPaying > trampleDamage) {
                totalCombatDamage = dmgUnblockableAfterPaying;
                trampleDamage = this.getDamageFromBlockingTramplers(blockedAttackers, remainingBlockers, myFreeMana -= unblockableAttackTax).getLeft();
            } else {
                myFreeMana -= tramplerTaxPaid;
                for (Card attacker : unblockableWithPaying) {
                    Cost tax = CombatUtil.getAttackCost(this.ai.getGame(), attacker, this.defendingOpponent);
                    int taxCMC = tax.getCostMana().getMana().getCMC();
                    if (myFreeMana < unblockableAttackTax + taxCMC) continue;
                    unblockableAttackTax += taxCMC;
                    unblockedAttackers.add(attacker);
                }
            }
        }
        if ((totalCombatDamage += ComputerUtilCombat.sumDamageIfUnblocked(unblockedAttackers, this.defendingOpponent) + trampleDamage) + ComputerUtil.possibleNonCombatDamage(this.ai, this.defendingOpponent) >= this.defendingOpponent.getLife() && (!this.defendingOpponent.cantLoseForZeroOrLessLife() && !this.ai.cantWin() || this.defendingOpponent.getLife() >= 1)) {
            return true;
        }
        int totalPoisonDamage = ComputerUtilCombat.sumPoisonIfUnblocked(unblockedAttackers, this.defendingOpponent);
        return totalPoisonDamage >= 10 - this.defendingOpponent.getPoisonCounters();
    }

    private Pair<Integer, Integer> getDamageFromBlockingTramplers(List<Card> blockedAttackers, List<Card> blockers, int myFreeMana) {
        int currentAttackTax = 0;
        int trampleDamage = 0;
        CardCollection remainingBlockers = new CardCollection((Iterable<Card>)blockers);
        for (Card attacker : CardLists.getKeyword(blockedAttackers, Keyword.TRAMPLE)) {
            int taxCMC;
            Cost tax = CombatUtil.getAttackCost(this.ai.getGame(), attacker, this.defendingOpponent);
            int n = taxCMC = tax != null ? tax.getCostMana().getMana().getCMC() : 0;
            if (myFreeMana < currentAttackTax + taxCMC) continue;
            currentAttackTax += taxCMC;
            int damage = ComputerUtilCombat.getAttack(attacker);
            for (Card blocker : remainingBlockers.threadSafeIterable()) {
                if (!CombatUtil.canBlock(attacker, blocker) || damage <= 0) continue;
                damage -= ComputerUtilCombat.shieldDamage(attacker, blocker);
                remainingBlockers.remove(blocker);
            }
            if (damage <= 0) continue;
            trampleDamage += damage;
        }
        return Pair.of(trampleDamage, currentAttackTax);
    }

    private GameEntity chooseDefender(Combat c, boolean bAssault) {
        CardCollection prefBattleList;
        Player prefDefender;
        FCollectionView<GameEntity> defs = c.getDefenders();
        if (defs.size() == 1) {
            return defs.getFirst();
        }
        GameEntity gameEntity = prefDefender = defs.contains(this.defendingOpponent) ? this.defendingOpponent : defs.get((GameEntity)false);
        if (bAssault) {
            return prefDefender;
        }
        CardCollection pwDefending = c.getDefendingPlaneswalkers();
        if (!pwDefending.isEmpty()) {
            Card pwNearUlti = ComputerUtilCard.getBestPlaneswalkerToDamage(pwDefending);
            return pwNearUlti != null ? pwNearUlti : ComputerUtilCard.getBestPlaneswalkerAI(pwDefending);
        }
        CardCollection defBattles = c.getDefendingBattles();
        CardCollection ownBattleDefending = CardLists.filter((Iterable<Card>)defBattles, CardPredicates.isController(this.ai));
        CardCollection allyBattleDefending = CardLists.filter((Iterable<Card>)defBattles, CardPredicates.isControlledByAnyOf(this.ai.getAllies()));
        CardCollection cardCollection = prefBattleList = ownBattleDefending.isEmpty() ? allyBattleDefending : ownBattleDefending;
        if (!prefBattleList.isEmpty()) {
            return Collections.min(prefBattleList, CardPredicates.compareByCounterType(CounterEnumType.DEFENSE));
        }
        return prefDefender;
    }

    /*
     * WARNING - void declaration
     */
    public final int declareAttackers(Combat combat) {
        boolean isUnblockableCreature;
        void var18_39;
        AiController aic;
        boolean bAssault;
        GameEntity defender;
        if (this.attackers.isEmpty() && this.ai.getOpponents().size() > 1) {
            PlayerCollection opps = this.ai.getOpponents();
            opps.remove(this.defendingOpponent);
            this.defendingOpponent = Aggregates.random(opps);
            this.refreshCombatants(this.defendingOpponent);
        }
        if ((defender = this.chooseDefender(combat, bAssault = this.doAssault())) != this.defendingOpponent) {
            if (defender instanceof Player) {
                this.defendingOpponent = (Player)defender;
            } else if (defender instanceof Card) {
                Card defCard = (Card)defender;
                this.defendingOpponent = defCard.isBattle() ? defCard.getProtectingPlayer() : defCard.getController();
            }
            this.refreshCombatants(defender);
        }
        if (this.attackers.isEmpty()) {
            return this.aiAggression;
        }
        boolean playAggro = false;
        int chanceToAttackToTrade = 0;
        boolean tradeIfTappedOut = false;
        int extraChanceIfOppHasMana = 0;
        boolean tradeIfLowerLifePressure = false;
        boolean predictEvasion = false;
        boolean simAI = false;
        if (this.ai.getController().isAI() && !(simAI = (aic = ((PlayerControllerAi)this.ai.getController()).getAi()).usesSimulation())) {
            playAggro = aic.getBooleanProperty(AiProps.PLAY_AGGRO);
            chanceToAttackToTrade = aic.getIntProperty(AiProps.CHANCE_TO_ATTACK_INTO_TRADE);
            tradeIfTappedOut = aic.getBooleanProperty(AiProps.ATTACK_INTO_TRADE_WHEN_TAPPED_OUT);
            extraChanceIfOppHasMana = aic.getIntProperty(AiProps.CHANCE_TO_ATKTRADE_WHEN_OPP_HAS_MANA);
            tradeIfLowerLifePressure = aic.getBooleanProperty(AiProps.RANDOMLY_ATKTRADE_ONLY_ON_LOWER_LIFE_PRESSURE);
            predictEvasion = aic.getBooleanProperty(AiProps.COMBAT_ATTRITION_ATTACK_EVASION_PREDICTION);
        }
        boolean lightmineField = this.ai.getGame().isCardInPlay("Lightmine Field");
        boolean seasonOfTheWitch = this.ai.getGame().isCardInPlay("Season of the Witch");
        List<Card> attackersLeft = new ArrayList<Card>(this.attackers);
        GlobalAttackRestrictions restrict = GlobalAttackRestrictions.getGlobalRestrictions(this.ai, combat.getDefenders());
        int attackMax = restrict.getMax();
        if (attackMax == -1) {
            int n = attackMax = restrict.getDefenderMax().get(defender) == null ? -1 : (Integer)restrict.getDefenderMax().get(defender);
        }
        if (attackMax == 0) {
            return this.aiAggression;
        }
        int numForcedAttackers = 0;
        if (!this.nextTurn) {
            for (Card card : this.attackers) {
                Object mustAttackDef = null;
                if (card.getSVar("MustAttack").equals("True")) {
                    mustAttackDef = defender;
                } else if (card.hasSVar("EndOfTurnLeavePlay") && this.isEffectiveAttacker(this.ai, card, combat, defender)) {
                    mustAttackDef = defender;
                } else if (seasonOfTheWitch) {
                    mustAttackDef = defender;
                } else {
                    if (combat.getAttackConstraints().getRequirements().get(card) == null) continue;
                    List<Pair<GameEntity, Integer>> reqs = combat.getAttackConstraints().getRequirements().get(card).getSortedRequirements();
                    GameEntity def = defender;
                    reqs.sort((r1, r2) -> {
                        if (r1.getValue() == r2.getValue()) {
                            if (((GameEntity)r1.getKey()).equals(def) && !((GameEntity)r2.getKey()).equals(def)) {
                                return -1;
                            }
                            if (((GameEntity)r2.getKey()).equals(def) && !((GameEntity)r1.getKey()).equals(def)) {
                                return 1;
                            }
                            if (r1.getKey() instanceof Card && r2.getKey() instanceof Player) {
                                return -1;
                            }
                            if (r2.getKey() instanceof Card && r1.getKey() instanceof Player) {
                                return 1;
                            }
                            if (r1.getKey() instanceof Player && r2.getKey() instanceof Player) {
                                return ((Player)r1.getKey()).getLife() - ((Player)r2.getKey()).getLife();
                            }
                        }
                        return (Integer)r2.getValue() - (Integer)r1.getValue();
                    });
                    for (Pair<GameEntity, Integer> e : reqs) {
                        Object mustAttackDefMaybe;
                        if (e.getRight() == 0 || !this.canAttackWrapper(card, (GameEntity)(mustAttackDefMaybe = e.getLeft())) || CombatUtil.getAttackCost(this.ai.getGame(), card, (GameEntity)mustAttackDefMaybe) != null) continue;
                        mustAttackDef = mustAttackDefMaybe;
                        break;
                    }
                }
                if (mustAttackDef == null) continue;
                combat.addAttacker(card, (GameEntity)mustAttackDef);
                attackersLeft.remove(card);
                ++numForcedAttackers;
            }
            if (attackersLeft.isEmpty()) {
                return this.aiAggression;
            }
        }
        if (lightmineField) {
            this.doLightmineFieldAttackLogic(attackersLeft, numForcedAttackers, playAggro);
        }
        if (!this.doRevengeOfRavensAttackLogic(defender, attackersLeft, numForcedAttackers, attackMax)) {
            return this.aiAggression;
        }
        if (bAssault && defender == this.defendingOpponent) {
            CardLists.sortByPowerDesc(attackersLeft);
            for (Card card : attackersLeft) {
                if (attackMax != -1 && combat.getAttackers().size() >= attackMax) {
                    return this.aiAggression;
                }
                if (!this.canAttackWrapper(card, defender) || !this.isEffectiveAttacker(this.ai, card, combat, defender)) continue;
                combat.addAttacker(card, defender);
            }
            return this.aiAggression;
        }
        if (this.ai.getController().isAI()) {
            for (Card card : this.attackers) {
                if (!AiCardMemory.isRememberedCard(this.ai, card, AiCardMemory.MemorySet.MANDATORY_ATTACKERS)) continue;
                combat.addAttacker(card, defender);
                attackersLeft.remove(card);
            }
        }
        if (combat.getAttackers().isEmpty()) {
            boolean exalted;
            boolean bl = exalted = this.ai.countExaltedBonus() > 2;
            if (!exalted) {
                for (Card c : this.ai.getCardsIn(ZoneType.Battlefield)) {
                    if (c.getName().equals("Rafiq of the Many") || c.getName().equals("Battlegrace Angel")) {
                        exalted = true;
                        break;
                    }
                    if (!c.getName().equals("Finest Hour") || !this.ai.getGame().getPhaseHandler().isFirstCombat()) continue;
                    exalted = true;
                    break;
                }
            }
            if (exalted) {
                CardLists.sortByPowerDesc(this.attackers);
                this.aiAggression = 6;
                for (Card attacker : this.attackers) {
                    if (!this.canAttackWrapper(attacker, defender) || !this.shouldAttack(attacker, this.blockers, combat, defender)) continue;
                    combat.addAttacker(attacker, defender);
                    return this.aiAggression;
                }
            }
        }
        if (attackMax != -1) {
            CardLists.sortByPowerDesc(this.attackers);
            this.aiAggression = 6;
            for (Card card : this.attackers) {
                if (combat.getAttackers().size() >= attackMax) break;
                if (!this.canAttackWrapper(card, defender) || !this.shouldAttack(card, this.blockers, combat, defender)) continue;
                combat.addAttacker(card, defender);
            }
            return this.aiAggression;
        }
        if (simAI && ComputerUtilCard.isNonDisabledCardInPlay(this.ai, "Reconnaissance")) {
            for (Card card : attackersLeft) {
                if (!this.canAttackWrapper(card, defender)) continue;
                combat.addAttacker(card, defender);
            }
            this.aiAggression = 6;
            return this.aiAggression;
        }
        int computerForces = 0;
        boolean bl = false;
        int humanForcesForAttritionalAttack = 0;
        ArrayList<Card> nextTurnAttackers = new ArrayList<Card>();
        int candidateCounterAttackDamage = 0;
        ArrayList<Card> candidateAttackers = new ArrayList<Card>();
        int candidateUnblockedDamage = 0;
        for (Card card : this.myList) {
            if (!ComputerUtilCombat.canAttackNextTurn(card) || card.getNetCombatDamage() <= 0) continue;
            candidateAttackers.add(card);
            candidateUnblockedDamage += ComputerUtilCombat.damageIfUnblocked(card, this.defendingOpponent, null, false);
            ++computerForces;
        }
        CardCollection categorizedOppList = new CardCollection();
        if (predictEvasion) {
            categorizedOppList.addAll(ComputerUtilCombat.categorizeAttackersByEvasion(this.oppList));
        } else {
            categorizedOppList.addAll(this.oppList);
        }
        for (Card pCard : categorizedOppList) {
            Card potentialOppBlocker;
            if (pCard.getNetCombatDamage() > 0 && ComputerUtilCombat.canAttackNextTurn(pCard)) {
                nextTurnAttackers.add(pCard);
                candidateCounterAttackDamage += pCard.getNetCombatDamage();
                ++var18_39;
            }
            if ((potentialOppBlocker = AiAttackController.getCardCanBlockAnAttacker(pCard, candidateAttackers, true)) == null) continue;
            ++humanForcesForAttritionalAttack;
            if (!predictEvasion) continue;
            candidateAttackers.remove(potentialOppBlocker);
        }
        double d = 1000000.0;
        if (candidateCounterAttackDamage > 0) {
            d = (double)this.ai.getLife() / (double)candidateCounterAttackDamage;
        }
        double humanLifeToDamageRatio = 1000000.0;
        if (candidateUnblockedDamage > 0) {
            humanLifeToDamageRatio = (double)(this.defendingOpponent.getLife() - ComputerUtil.possibleNonCombatDamage(this.ai, this.defendingOpponent)) / (double)candidateUnblockedDamage;
        }
        int outNumber = computerForces - var18_39;
        for (Card blocker : this.blockers) {
            if (!blocker.canBlockAny()) continue;
            d -= 1.0;
        }
        double ratioDiff = d - humanLifeToDamageRatio;
        boolean doAttritionalAttack = false;
        CardLists.sortByPowerAsc(this.attackers);
        int humanLife = this.defendingOpponent.getLife();
        ArrayList<Card> attritionalAttackers = new ArrayList<Card>();
        for (int x = 0; x < this.attackers.size() - var18_39; ++x) {
            attritionalAttackers.add(this.attackers.get(x));
        }
        for (int attackRounds = 1; !attritionalAttackers.isEmpty() && humanLife > 0 && attackRounds < 99; ++attackRounds) {
            int damageThisRound = 0;
            for (Card attritionalAttacker : attritionalAttackers) {
                damageThisRound += attritionalAttacker.getNetCombatDamage();
            }
            humanLife -= damageThisRound;
            for (int z = 0; z < humanForcesForAttritionalAttack; ++z) {
                if (attritionalAttackers.isEmpty()) continue;
                attritionalAttackers.remove(attritionalAttackers.size() - 1);
            }
            doAttritionalAttack = humanLife <= 0;
        }
        double unblockableDamage = 0.0;
        double nextUnblockableDamage = 0.0;
        double turnsUntilDeathByUnblockable = 0.0;
        boolean doUnblockableAttack = false;
        for (Card attacker : this.attackers) {
            isUnblockableCreature = true;
            for (Card blocker : this.blockers) {
                if (!CombatUtil.canBlock(attacker, blocker)) continue;
                isUnblockableCreature = false;
                break;
            }
            if (!isUnblockableCreature) continue;
            unblockableDamage += (double)ComputerUtilCombat.damageIfUnblocked(attacker, this.defendingOpponent, combat, false);
        }
        for (Card attacker : nextTurnAttackers) {
            isUnblockableCreature = true;
            for (Card blocker : this.myList) {
                if (!CombatUtil.canBlock(attacker, blocker, true)) continue;
                isUnblockableCreature = false;
                break;
            }
            if (!isUnblockableCreature) continue;
            nextUnblockableDamage += (double)ComputerUtilCombat.damageIfUnblocked(attacker, this.defendingOpponent, null, false);
        }
        if (unblockableDamage > 0.0 && !this.defendingOpponent.cantLoseForZeroOrLessLife() && this.defendingOpponent.canLoseLife()) {
            turnsUntilDeathByUnblockable = 1.0 + ((double)this.defendingOpponent.getLife() - unblockableDamage) / nextUnblockableDamage;
        }
        if (this.defendingOpponent.canLoseLife()) {
            doUnblockableAttack = true;
        }
        this.aiAggression = ratioDiff > 0.0 && doAttritionalAttack ? 5 : (ratioDiff >= 1.0 && this.attackers.size() > 1 && (humanLifeToDamageRatio < 2.0 || outNumber > 0) || playAggro && MyRandom.percentTrue(chanceToAttackToTrade) && humanLifeToDamageRatio > 1.0 ? 4 : (MyRandom.percentTrue(chanceToAttackToTrade) && humanLifeToDamageRatio > 1.0 && this.defendingOpponent != null && ComputerUtil.countUsefulCreatures(this.ai) > ComputerUtil.countUsefulCreatures(this.defendingOpponent) && this.ai.getLife() > this.defendingOpponent.getLife() && !ComputerUtilCombat.lifeInDanger(this.ai, combat) && ComputerUtilMana.getAvailableManaEstimate(this.ai) > 0 || tradeIfTappedOut && ComputerUtilMana.getAvailableManaEstimate(this.defendingOpponent) == 0 || MyRandom.percentTrue(extraChanceIfOppHasMana) && (!tradeIfLowerLifePressure || this.ai.getLifeLostLastTurn() + this.ai.getLifeLostThisTurn() < this.defendingOpponent.getLifeLostThisTurn() + this.defendingOpponent.getLifeLostThisTurn()) ? 4 : (ratioDiff >= 0.0 && this.attackers.size() > 1 ? 3 : (ratioDiff + (double)outNumber >= -1.0 || d > 1.0 || ratioDiff * -1.0 < turnsUntilDeathByUnblockable ? 2 : (doUnblockableAttack ? 1 : 0)))));
        attackersLeft = this.notNeededAsBlockers(combat.getAttackers(), attackersLeft);
        attackersLeft = AiAttackController.sortAttackers(attackersLeft);
        FCollection<Player> possibleDefenders = new FCollection<Player>(this.defendingOpponent);
        possibleDefenders.addAll(this.defendingOpponent.getPlaneswalkersInPlay());
        while (!attackersLeft.isEmpty()) {
            CardCollection attackersAssigned = new CardCollection();
            for (int i = 0; i < attackersLeft.size(); ++i) {
                Card attacker = attackersLeft.get(i);
                if (this.aiAggression < 5 && !attacker.hasFirstStrike() && !attacker.hasDoubleStrike() && ComputerUtilCombat.getTotalFirstStrikeBlockPower(attacker, this.defendingOpponent) >= ComputerUtilCombat.getDamageToKill(attacker, false) || !this.shouldAttack(attacker, this.blockers, combat, defender) || !this.canAttackWrapper(attacker, defender)) continue;
                combat.addAttacker(attacker, defender);
                attackersAssigned.add(attacker);
                if (i >= attackersLeft.size() - 1 || !(defender instanceof Card)) continue;
                int blockNum = this.blockers.size();
                int attackNum = 0;
                int damage = 0;
                CardCollection attacking = combat.getAttackersOf(defender);
                CardLists.sortByPowerDesc(attacking);
                for (Card atta : attacking) {
                    if (attackNum >= blockNum || !CombatUtil.canBeBlocked(atta, this.blockers, combat)) {
                        damage += ComputerUtilCombat.damageIfUnblocked(atta, defender, null, false);
                        continue;
                    }
                    ++attackNum;
                }
                if (damage >= ComputerUtilCombat.getDamageToKill((Card)defender, true)) break;
            }
            attackersLeft.removeAll(attackersAssigned);
            possibleDefenders.remove(defender);
            if (attackersLeft.isEmpty() || possibleDefenders.isEmpty()) break;
            CardCollection pwDefending = new CardCollection(Iterables.filter(possibleDefenders, Card.class));
            if (pwDefending.isEmpty()) {
                defender = this.defendingOpponent;
                continue;
            }
            Card pwNearUlti = ComputerUtilCard.getBestPlaneswalkerToDamage(pwDefending);
            defender = pwNearUlti != null ? pwNearUlti : ComputerUtilCard.getBestPlaneswalkerAI(pwDefending);
        }
        return this.aiAggression;
    }

    public final boolean shouldAttack(Card attacker, List<Card> defenders, Combat combat, GameEntity defender) {
        if (attacker.hasSVar("NonCombatPriority") && !attacker.hasKeyword(Keyword.VIGILANCE) && attacker.getCurrentPower() * Integer.parseInt(attacker.getSVar("NonCombatPriority")) < this.ai.getOpponentsSmallestLifeTotal()) {
            for (SpellAbility sa : attacker.getSpellAbilities()) {
                if (!sa.isActivatedAbility() || !sa.getPayCosts().hasTapCost() || !ComputerUtilCost.canPayCost(sa, this.ai, false)) continue;
                return false;
            }
        }
        if (!this.isEffectiveAttacker(this.ai, attacker, combat, defender)) {
            return false;
        }
        SpellAbilityFactors saf = new SpellAbilityFactors(attacker);
        if (this.aiAggression != 5) {
            saf.calculate(defenders, combat);
        }
        if (saf.canKillAll && saf.isWorthLessThanAllKillers && !CombatUtil.canBlock(attacker)) {
            return true;
        }
        if (!saf.canBeKilled && !saf.dangerousBlockersPresent && saf.canTrampleOverDefenders) {
            return true;
        }
        switch (this.aiAggression) {
            case 6: {
                if ((!saf.canKillAll || !saf.isWorthLessThanAllKillers) && saf.canBeBlocked()) break;
                return true;
            }
            case 5: {
                return true;
            }
            case 4: {
                if (!saf.canKillAll && (!saf.dangerousBlockersPresent || !saf.canKillAllDangerous || saf.canBeKilledByOne) && saf.canBeBlocked() && saf.defPower != 0) break;
                return true;
            }
            case 3: {
                if (!(saf.canKillAll && saf.isWorthLessThanAllKillers || (saf.dangerousBlockersPresent && saf.canKillAllDangerous || saf.hasAttackEffect || saf.hasCombatEffect) && !saf.canBeKilledByOne) && saf.canBeBlocked()) break;
                return true;
            }
            case 2: {
                if (saf.canBeBlocked() && (!saf.canKillAll && !saf.hasAttackEffect && !saf.hasCombatEffect || saf.canBeKilledByOne || (!saf.dangerousBlockersPresent || !saf.canKillAllDangerous) && saf.canBeKilled)) break;
                return true;
            }
            case 1: {
                if (saf.canBeBlocked() && (saf.numberOfPossibleBlockers != 1 || !saf.canKillAll || saf.canBeKilledByOne)) break;
                return true;
            }
        }
        return false;
    }

    public static List<Card> exertAttackers(List<Card> attackers, int aggression) {
        ArrayList<Card> exerters = Lists.newArrayList();
        for (Card c : attackers) {
            boolean shouldExert = false;
            if (c.hasSVar("EndOfTurnLeavePlay")) {
                shouldExert = true;
            } else if (c.hasKeyword(Keyword.VIGILANCE) || ComputerUtilCard.willUntap(c.getController(), c)) {
                shouldExert = true;
            }
            boolean missTarget = false;
            block1: for (StaticAbility st : c.getStaticAbilities()) {
                if (!"OptionalAttackCost".equals(st.getParam("Mode"))) continue;
                SpellAbility sa = st.getPayingTrigSA();
                if (sa == null) {
                    for (Trigger t2 : c.getTriggers()) {
                        PlayerControllerAi aic;
                        if (!TriggerType.Exerted.equals((Object)t2.getMode())) continue;
                        sa = t2.ensureAbility();
                        if (!c.getController().isAI() || (aic = (PlayerControllerAi)c.getController().getController()).getAi().doTrigger(sa, false)) continue;
                        missTarget = true;
                        break block1;
                    }
                    break;
                }
                if (!sa.usesTargeting()) continue;
                sa.setActivatingPlayer(c.getController(), true);
                List<Card> validTargets = CardUtil.getValidCardsToTarget(sa);
                if (validTargets.isEmpty()) {
                    missTarget = true;
                    break;
                }
                if (!sa.isCurse() || Iterables.any(validTargets, CardPredicates.isControlledByAnyOf(c.getController().getOpponents()))) continue;
                missTarget = true;
                break;
            }
            if (missTarget) continue;
            if (!shouldExert) {
                boolean bl = shouldExert = aggression > 3;
            }
            if (!shouldExert && c.hasSVar("AIExertCondition") && !c.getSVar("AIExertCondition").isEmpty()) {
                int y;
                String needsToExert = c.getSVar("AIExertCondition");
                String sVar = needsToExert.split(" ")[0];
                String comparator = needsToExert.split(" ")[1];
                String compareTo = comparator.substring(2);
                int x = AbilityUtils.calculateAmount(c, sVar, null);
                if (Expressions.compare(x, comparator, y = AbilityUtils.calculateAmount(c, compareTo, null))) {
                    shouldExert = true;
                }
            }
            if (!shouldExert) continue;
            exerters.add(c);
        }
        return exerters;
    }

    public String toProtectAttacker(SpellAbility sa) {
        if (sa.getApi() != ApiType.Protection || this.oppList.isEmpty() || AiAttackController.getPossibleBlockers(this.oppList, this.attackers, this.nextTurn).isEmpty()) {
            return null;
        }
        List<String> choices = ProtectEffect.getProtectionList(sa);
        String color = ComputerUtilCard.getMostProminentColor(AiAttackController.getPossibleBlockers(this.oppList, this.attackers, this.nextTurn));
        String artifact = null;
        if (choices.contains("artifacts")) {
            artifact = "artifacts";
        }
        if (!choices.contains(color)) {
            color = null;
        }
        for (Card c : this.oppList) {
            if (artifact != null && !c.isArtifact()) {
                artifact = null;
            }
            if (color != null) {
                switch (color) {
                    case "black": {
                        if (c.isBlack()) break;
                        color = null;
                        break;
                    }
                    case "blue": {
                        if (c.isBlue()) break;
                        color = null;
                        break;
                    }
                    case "green": {
                        if (c.isGreen()) break;
                        color = null;
                        break;
                    }
                    case "red": {
                        if (c.isRed()) break;
                        color = null;
                        break;
                    }
                    case "white": {
                        if (c.isWhite()) break;
                        color = null;
                    }
                }
            }
            if (color != null || artifact != null) continue;
            return null;
        }
        if (color != null) {
            return color;
        }
        if (artifact != null) {
            return artifact;
        }
        return null;
    }

    private void doLightmineFieldAttackLogic(List<Card> attackersLeft, int numForcedAttackers, boolean playAggro) {
        CardCollection attSorted = new CardCollection((Iterable<Card>)attackersLeft);
        CardCollection attUnsafe = new CardCollection();
        CardLists.sortByToughnessDesc(attSorted);
        int i = numForcedAttackers;
        int refPowerValue = 0;
        if (!playAggro && this.blockers.size() > 0) {
            CardCollection blkSorted = new CardCollection((Iterable<Card>)this.blockers);
            CardLists.sortByPowerDesc(blkSorted);
            refPowerValue += ((Card)blkSorted.get(false)).getCurrentPower();
        }
        for (Card cre : attSorted) {
            if (++i + refPowerValue < cre.getCurrentToughness()) continue;
            attUnsafe.add(cre);
        }
        attackersLeft.removeAll(attUnsafe);
    }

    private boolean doRevengeOfRavensAttackLogic(GameEntity defender, List<Card> attackersLeft, int numForcedAttackers, int maxAttack) {
        boolean revengeOfRavens = false;
        if (defender instanceof Player) {
            revengeOfRavens = !CardLists.filter((Iterable<Card>)((Player)defender).getCardsIn(ZoneType.Battlefield), CardPredicates.nameEquals("Revenge of Ravens")).isEmpty();
        } else if (defender instanceof Card) {
            boolean bl = revengeOfRavens = !CardLists.filter((Iterable<Card>)((Card)defender).getController().getCardsIn(ZoneType.Battlefield), CardPredicates.nameEquals("Revenge of Ravens")).isEmpty();
        }
        if (!revengeOfRavens) {
            return true;
        }
        int life = this.ai.canLoseLife() && !this.ai.cantLoseForZeroOrLessLife() ? this.ai.getLife() : Integer.MAX_VALUE;
        int n = maxAttack = maxAttack < 0 ? 0x7FFFFFFE : maxAttack;
        if (Math.min(maxAttack, numForcedAttackers) >= life) {
            return false;
        }
        CardCollection attUnsafe = new CardCollection();
        for (Card attacker : attackersLeft) {
            if (attacker.getNetCombatDamage() > 1) continue;
            attUnsafe.add(attacker);
        }
        attackersLeft.removeAll(attUnsafe);
        return Math.min(maxAttack, attackersLeft.size()) < life;
    }

    private class SpellAbilityFactors {
        Card attacker = null;
        boolean canBeKilled = false;
        boolean canBeKilledByOne = false;
        boolean canKillAll = true;
        boolean canKillAllDangerous = true;
        boolean isWorthLessThanAllKillers = true;
        boolean hasAttackEffect = false;
        boolean hasCombatEffect = false;
        boolean dangerousBlockersPresent = false;
        boolean canTrampleOverDefenders = false;
        int numberOfPossibleBlockers = 0;
        int defPower = 0;

        SpellAbilityFactors(Card c) {
            this.attacker = c;
        }

        private boolean canBeBlocked() {
            return this.numberOfPossibleBlockers > 2 || this.numberOfPossibleBlockers >= 1 && CombatUtil.canAttackerBeBlockedWithAmount(this.attacker, 1, AiAttackController.this.defendingOpponent) || this.numberOfPossibleBlockers == 2 && CombatUtil.canAttackerBeBlockedWithAmount(this.attacker, 2, AiAttackController.this.defendingOpponent);
        }

        private void calculate(List<Card> defenders, Combat combat) {
            this.hasAttackEffect = this.attacker.getSVar("HasAttackEffect").equals("TRUE") || this.attacker.hasKeyword(Keyword.ANNIHILATOR);
            this.hasCombatEffect = this.attacker.getSVar("HasCombatEffect").equals("TRUE") || "Blocked".equals(this.attacker.getSVar("HasAttackEffect")) || this.attacker.isWitherDamage() || this.attacker.hasKeyword(Keyword.LIFELINK) || this.attacker.hasKeyword(Keyword.AFFLICT);
            CardCollection validBlockers = CardLists.filter(defenders, defender1 -> CombatUtil.canBlock(this.attacker, defender1));
            this.canTrampleOverDefenders = this.attacker.hasKeyword(Keyword.TRAMPLE) && this.attacker.getNetCombatDamage() > Aggregates.sum(validBlockers, Card::getNetToughness);
            this.dangerousBlockersPresent = Iterables.any(validBlockers, Predicates.or(CardPredicates.hasKeyword(Keyword.WITHER), CardPredicates.hasKeyword(Keyword.INFECT), CardPredicates.hasKeyword(Keyword.LIFELINK)));
            this.defPower = CardLists.getTotalPower(validBlockers, true, false);
            for (Card blocker : validBlockers) {
                boolean noContributionToAttack;
                if (!this.isWorthLessThanAllKillers && !this.canKillAllDangerous && this.numberOfPossibleBlockers >= 2) continue;
                ++this.numberOfPossibleBlockers;
                if (this.isWorthLessThanAllKillers && ComputerUtilCombat.canDestroyAttacker(AiAttackController.this.ai, this.attacker, blocker, combat, false) && (!this.attacker.hasKeyword(Keyword.UNDYING) || this.attacker.getCounters(CounterEnumType.P1P1) != 0)) {
                    this.canBeKilledByOne = true;
                    if (this.isWorthLessThanAllKillers && !this.attacker.hasSVar("SacMe") && ComputerUtilCard.evaluateCreature(blocker) <= ComputerUtilCard.evaluateCreature(this.attacker)) {
                        this.isWorthLessThanAllKillers = false;
                    }
                }
                if (!this.canKillAllDangerous || ComputerUtilCombat.canDestroyBlocker(AiAttackController.this.ai, blocker, this.attacker, combat, false)) continue;
                this.canKillAll = false;
                if (blocker.getSVar("HasCombatEffect").equals("TRUE") || blocker.getSVar("HasBlockEffect").equals("TRUE") || blocker.hasKeyword(Keyword.WITHER) || blocker.hasKeyword(Keyword.INFECT) || blocker.hasKeyword(Keyword.LIFELINK)) {
                    this.canKillAllDangerous = false;
                }
                if (!this.canKillAllDangerous) continue;
                boolean avoidAttackingIntoBlock = AiAttackController.this.ai.getController().isAI() && ((PlayerControllerAi)AiAttackController.this.ai.getController()).getAi().getBooleanProperty(AiProps.TRY_TO_AVOID_ATTACKING_INTO_CERTAIN_BLOCK);
                boolean attackerWillDie = this.defPower >= this.attacker.getNetToughness();
                boolean uselessAttack = !this.hasCombatEffect && !this.hasAttackEffect;
                boolean bl = noContributionToAttack = AiAttackController.this.attackers.size() <= defenders.size() || this.attacker.getNetPower() <= 0;
                if (!attackerWillDie && (!avoidAttackingIntoBlock || !uselessAttack || !noContributionToAttack)) continue;
                this.canKillAllDangerous = false;
            }
            if (!this.attacker.hasKeyword(Keyword.VIGILANCE) && ComputerUtilCard.canBeKilledByRoyalAssassin(AiAttackController.this.ai, this.attacker)) {
                this.canKillAllDangerous = false;
                this.canBeKilled = true;
                this.canBeKilledByOne = true;
                this.isWorthLessThanAllKillers = false;
                this.hasCombatEffect = false;
            } else if ((this.canKillAllDangerous || !this.canBeKilled) && ComputerUtilCard.canBeBlockedProfitably(AiAttackController.this.defendingOpponent, this.attacker, true)) {
                this.canKillAllDangerous = false;
                this.canBeKilled = true;
            }
        }
    }
}

