/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.world;

import com.badlogic.gdx.graphics.Color;
import forge.adventure.world.ColorMap;
import forge.adventure.world.Model;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.IntStream;

public class SimpleTiledModel
extends Model {
    List<Color[]> tiles;
    List<String> tilenames;
    int tilesize;
    boolean black;

    public SimpleTiledModel(int tilesize, List<Map<String, String>> tileSymmetries, List<Map<String, String>> neighborData, Map<String, String[]> subsetData, Map<String, ColorMap> tileData, String subsetName, int width, int height, boolean periodic, boolean black, boolean unique) {
        super(width, height);
        int d;
        this.periodic = periodic;
        this.black = black;
        this.tilesize = tilesize;
        List<String> subset = null;
        if (subsetName != null && subsetData != null && subsetData.containsKey(subsetName)) {
            subset = Arrays.asList(subsetData.get(subsetName));
        }
        Function<BiFunction, Color[]> tile = f -> {
            Color[] result = new Color[this.tilesize * this.tilesize];
            for (int y = 0; y < this.tilesize; ++y) {
                for (int x = 0; x < this.tilesize; ++x) {
                    result[x + y * tilesize] = (Color)f.apply(x, y);
                }
            }
            return result;
        };
        Function<Color[], Color[]> rotate = array -> (Color[])tile.apply((x, y) -> array[this.tilesize - 1 - y + x * this.tilesize]);
        this.tiles = new ArrayList<Color[]>();
        this.tilenames = new ArrayList<String>();
        ArrayList<Double> tempStationary = new ArrayList<Double>();
        ArrayList<Integer[]> action = new ArrayList<Integer[]>();
        HashMap<String, Integer> firstOccurrence = new HashMap<String, Integer>();
        for (Map<String, String> xtile : tileSymmetries) {
            int t2;
            Function<Integer, Integer> b;
            Function<Integer, Integer> a;
            int cardinality;
            String tilename = xtile.get("name");
            String sym = xtile.getOrDefault("symmetry", "X");
            if (subset != null && !subset.contains(tilename)) continue;
            switch (sym) {
                case "L": {
                    cardinality = 4;
                    a = i -> (i + 1) % 4;
                    b = i -> i % 2 == 0 ? i + 1 : i - 1;
                    break;
                }
                case "T": {
                    cardinality = 4;
                    a = i -> (i + 1) % 4;
                    b = i -> i % 2 == 0 ? i : 4 - i;
                    break;
                }
                case "I": {
                    cardinality = 2;
                    a = i -> 1 - i;
                    b = i -> i;
                    break;
                }
                case "\\": {
                    cardinality = 2;
                    a = i -> 1 - i;
                    b = i -> 1 - i;
                    break;
                }
                default: {
                    cardinality = 1;
                    a = i -> i;
                    b = i -> i;
                }
            }
            this.T = action.size();
            firstOccurrence.put(tilename, this.T);
            Integer[][] map = new Integer[cardinality][];
            for (t2 = 0; t2 < cardinality; ++t2) {
                map[t2] = new Integer[8];
                map[t2][0] = t2;
                map[t2][1] = a.apply(t2);
                map[t2][2] = a.apply(a.apply(t2));
                map[t2][3] = a.apply(a.apply(a.apply(t2)));
                map[t2][4] = b.apply(t2);
                map[t2][5] = b.apply(a.apply(t2));
                map[t2][6] = b.apply(a.apply(a.apply(t2)));
                map[t2][7] = b.apply(a.apply(a.apply(a.apply(t2))));
                int s2 = 0;
                while (s2 < 8) {
                    Integer[] integerArray = map[t2];
                    int n = s2++;
                    Integer.valueOf(integerArray[n] + this.T);
                }
                action.add(map[t2]);
            }
            if (unique) {
                for (t2 = 0; t2 < cardinality; ++t2) {
                    ColorMap xtileData = tileData.get(tilename);
                    this.tiles.add(tile.apply(xtileData::getColor));
                    this.tilenames.add(String.format("%s %s", tilename, t2));
                }
            } else {
                ColorMap xtileData = tileData.get(tilename);
                this.tiles.add(tile.apply(xtileData::getColor));
                this.tilenames.add(String.format("%s 0", tilename));
                for (int t3 = 1; t3 < cardinality; ++t3) {
                    this.tiles.add(rotate.apply(this.tiles.get(this.T + t3 - 1)));
                    this.tilenames.add(String.format("%s %s", tilename, t3));
                }
            }
            for (t2 = 0; t2 < cardinality; ++t2) {
                tempStationary.add(Double.valueOf(xtile.getOrDefault("weight", "1.0")));
            }
        }
        this.T = action.size();
        this.weights = tempStationary.toArray(new Double[0]);
        this.propagator = new int[4][][];
        boolean[][][] tempPropagator = new boolean[4][][];
        for (int d2 = 0; d2 < 4; ++d2) {
            tempPropagator[d2] = new boolean[this.T][];
            this.propagator[d2] = new int[this.T][];
            for (int t4 = 0; t4 < this.T; ++t4) {
                tempPropagator[d2][t4] = new boolean[this.T];
            }
        }
        for (Map<String, String> xneighbor : neighborData) {
            String[] left = (String[])Arrays.stream(xneighbor.get("left").split(" ")).filter(x -> !x.isEmpty()).toArray(String[]::new);
            String[] right = (String[])Arrays.stream(xneighbor.get("right").split(" ")).filter(x -> !x.isEmpty()).toArray(String[]::new);
            if (subset != null && (!subset.contains(left[0]) || !subset.contains(right[0]))) continue;
            int L = ((Integer[])action.get((Integer)firstOccurrence.get(left[0])))[left.length == 1 ? 0 : Integer.parseInt(left[1])];
            int D = ((Integer[])action.get(L))[1];
            int R = ((Integer[])action.get((Integer)firstOccurrence.get(right[0])))[right.length == 1 ? 0 : Integer.parseInt(right[1])];
            int U = ((Integer[])action.get(R))[1];
            tempPropagator[0][R][L] = true;
            tempPropagator[0][((Integer[])action.get((int)R))[6].intValue()][((Integer[])action.get((int)L))[6].intValue()] = true;
            tempPropagator[0][((Integer[])action.get((int)L))[4].intValue()][((Integer[])action.get((int)R))[4].intValue()] = true;
            tempPropagator[0][((Integer[])action.get((int)L))[2].intValue()][((Integer[])action.get((int)R))[2].intValue()] = true;
            tempPropagator[1][U][D] = true;
            tempPropagator[1][((Integer[])action.get((int)D))[6].intValue()][((Integer[])action.get((int)U))[6].intValue()] = true;
            tempPropagator[1][((Integer[])action.get((int)U))[4].intValue()][((Integer[])action.get((int)D))[4].intValue()] = true;
            tempPropagator[1][((Integer[])action.get((int)D))[2].intValue()][((Integer[])action.get((int)U))[2].intValue()] = true;
        }
        for (int t2 = 0; t2 < this.T; ++t2) {
            for (int t1 = 0; t1 < this.T; ++t1) {
                tempPropagator[2][t2][t1] = tempPropagator[0][t1][t2];
                tempPropagator[3][t2][t1] = tempPropagator[1][t1][t2];
            }
        }
        ArrayList sparsePropagator = new ArrayList();
        for (d = 0; d < 4; ++d) {
            sparsePropagator.add(d, new ArrayList());
            for (int t5 = 0; t5 < this.T; ++t5) {
                ((ArrayList)sparsePropagator.get(d)).add(t5, new ArrayList());
            }
        }
        for (d = 0; d < 4; ++d) {
            for (int t1 = 0; t1 < this.T; ++t1) {
                ArrayList sp = (ArrayList)((ArrayList)sparsePropagator.get(d)).get(t1);
                boolean[] tp = tempPropagator[d][t1];
                for (int t2 = 0; t2 < this.T; ++t2) {
                    if (!tp[t2]) continue;
                    sp.add(t2);
                }
                int ST = sp.size();
                this.propagator[d][t1] = new int[ST];
                for (int st = 0; st < ST; ++st) {
                    this.propagator[d][t1][st] = (Integer)sp.get(st);
                }
            }
        }
    }

    @Override
    protected boolean onBoundary(int x, int y) {
        return !this.periodic && (x < 0 || y < 0 || x >= this.FMX || y >= this.FMY);
    }

    public String textOutput() {
        StringBuilder result = new StringBuilder();
        for (int y = 0; y < this.FMY; ++y) {
            for (int x = 0; x < this.FMX; ++x) {
                result.append(String.format("{%s}, ", this.tilenames.get(this.observed[x + y * this.FMX])));
            }
            result.append("\n");
        }
        return result.toString();
    }

    @Override
    public ColorMap graphics() {
        ColorMap result = new ColorMap(this.FMX * this.tilesize, this.FMY * this.tilesize);
        if (this.observed != null) {
            for (int x = 0; x < this.FMX; ++x) {
                for (int y = 0; y < this.FMY; ++y) {
                    Color[] tile = this.tiles.get(this.observed[x + y * this.FMX]);
                    for (int yt = 0; yt < this.tilesize; ++yt) {
                        for (int xt = 0; xt < this.tilesize; ++xt) {
                            Color c = tile[xt + yt * this.tilesize];
                            result.setColor(x * this.tilesize + xt, y * this.tilesize + yt, c);
                        }
                    }
                }
            }
        } else {
            for (int x = 0; x < this.FMX; ++x) {
                for (int y = 0; y < this.FMY; ++y) {
                    boolean[] a = this.wave[x + y * this.FMX];
                    int amount = IntStream.range(0, a.length).map(idx -> a[idx] ? 1 : 0).sum();
                    double lambda = 1.0 / IntStream.range(0, this.T).filter(idx -> a[idx]).mapToDouble(idx -> this.weights[idx]).sum();
                    for (int yt = 0; yt < this.tilesize; ++yt) {
                        for (int xt = 0; xt < this.tilesize; ++xt) {
                            if (this.black && amount == this.T) {
                                result.setColor(x * this.tilesize + xt, y * this.tilesize * yt, Color.BLACK);
                                continue;
                            }
                            double r = 0.0;
                            double g2 = 0.0;
                            double b = 0.0;
                            for (int t2 = 0; t2 < this.T; ++t2) {
                                if (!a[t2]) continue;
                                Color c = this.tiles.get(t2)[xt + yt * this.tilesize];
                                r += (double)c.r * this.weights[t2] * lambda;
                                g2 += (double)c.g * this.weights[t2] * lambda;
                                b += (double)c.b * this.weights[t2] * lambda;
                            }
                            Color newColor = new Color((float)r, (float)g2, (float)b, 1.0f);
                            result.setColor(x * this.tilesize + xt, y * this.tilesize + yt, newColor);
                        }
                    }
                }
            }
        }
        return result;
    }
}

