/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.world;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.IntMap;
import forge.adventure.data.BiomeData;
import forge.adventure.data.BiomeStructureData;
import forge.adventure.data.BiomeTerrainData;
import forge.adventure.util.Config;
import forge.adventure.world.BiomeStructure;
import forge.gui.FThreads;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;

public class BiomeTexture
implements Serializable {
    private final BiomeData data;
    private final int tileSize;
    public Pixmap emptyPixmap = null;
    ArrayList<ArrayList<Pixmap>> images = new ArrayList();
    ArrayList<ArrayList<Pixmap>> smallImages = new ArrayList();
    ArrayList<IntMap<Pixmap>> edgeImages = new ArrayList();

    public BiomeTexture(BiomeData data, int tileSize) {
        this.data = data;
        this.tileSize = tileSize;
        this.generate();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.generate();
    }

    private void generate() {
        FThreads.invokeInEdtNowOrLater(() -> {
            if (this.images != null) {
                for (ArrayList<Pixmap> arrayList : this.images) {
                    for (Pixmap pixmap : arrayList) {
                        pixmap.dispose();
                    }
                }
                this.images.clear();
            }
            this.images = new ArrayList();
            if (this.smallImages != null) {
                for (ArrayList<Pixmap> arrayList : this.smallImages) {
                    for (Pixmap pixmap : arrayList) {
                        pixmap.dispose();
                    }
                }
                this.smallImages.clear();
            }
            this.smallImages = new ArrayList();
            if (this.edgeImages != null) {
                for (IntMap intMap : this.edgeImages) {
                    for (IntMap.Entry entry : new IntMap.Entries(intMap)) {
                        ((Pixmap)entry.value).dispose();
                    }
                }
                this.edgeImages.clear();
            }
            this.edgeImages = new ArrayList();
            ArrayList<TextureAtlas.AtlasRegion> regions = new ArrayList<TextureAtlas.AtlasRegion>();
            ArrayList<TextureAtlas> arrayList = new ArrayList<TextureAtlas>();
            regions.add(Config.instance().getAtlas(this.data.tilesetAtlas).findRegion(this.data.tilesetName));
            arrayList.add(Config.instance().getAtlas(this.data.tilesetAtlas));
            if (this.data.terrain != null) {
                for (BiomeStructureData biomeStructureData : this.data.terrain) {
                    TextureAtlas.AtlasRegion region = Config.instance().getAtlas(this.data.tilesetAtlas).findRegion(((BiomeTerrainData)((Object)biomeStructureData)).spriteName);
                    if (region == null) {
                        System.err.print("Can not find sprite " + ((BiomeTerrainData)((Object)biomeStructureData)).spriteName);
                        continue;
                    }
                    regions.add(region);
                    arrayList.add(Config.instance().getAtlas(this.data.tilesetAtlas));
                }
            }
            if (this.data.structures != null) {
                for (BiomeStructureData biomeStructureData : this.data.structures) {
                    BiomeStructure structure = new BiomeStructure(biomeStructureData, 0L, 0, 0);
                    TextureAtlas atlas = structure.atlas();
                    for (BiomeStructureData.BiomeStructureDataMapping mapping : structure.mapping()) {
                        TextureAtlas.AtlasRegion region = atlas.findRegion(mapping.name);
                        if (region == null) {
                            System.err.print("Can not find sprite " + mapping.name);
                            continue;
                        }
                        regions.add(region);
                        arrayList.add(atlas);
                    }
                }
            }
            for (TextureAtlas.AtlasRegion atlasRegion : regions) {
                Pixmap subPixmap;
                int py;
                int px;
                int y;
                ArrayList<Pixmap> pics = new ArrayList<Pixmap>();
                ArrayList<Pixmap> arrayList2 = new ArrayList<Pixmap>();
                if (!atlasRegion.getTexture().getTextureData().isPrepared()) {
                    atlasRegion.getTexture().getTextureData().prepare();
                }
                Pixmap completePicture = atlasRegion.getTexture().getTextureData().consumePixmap();
                for (y = 0; y < 4; ++y) {
                    for (int x = 0; x < 3; ++x) {
                        px = atlasRegion.getRegionX() + x * this.tileSize;
                        py = atlasRegion.getRegionY() + y * this.tileSize;
                        subPixmap = new Pixmap(this.tileSize, this.tileSize, Pixmap.Format.RGBA8888);
                        subPixmap.drawPixmap(completePicture, 0, 0, px, py, this.tileSize, this.tileSize);
                        pics.add(subPixmap);
                    }
                }
                for (y = 0; y < 8; ++y) {
                    for (int x = 0; x < 6; ++x) {
                        px = atlasRegion.getRegionX() + x * this.tileSize / 2;
                        py = atlasRegion.getRegionY() + y * this.tileSize / 2;
                        subPixmap = new Pixmap(this.tileSize / 2, this.tileSize / 2, Pixmap.Format.RGBA8888);
                        subPixmap.drawPixmap(completePicture, 0, 0, px, py, this.tileSize / 2, this.tileSize / 2);
                        arrayList2.add(subPixmap);
                    }
                }
                this.images.add(pics);
                this.smallImages.add(arrayList2);
                this.edgeImages.add(new IntMap());
                completePicture.dispose();
            }
        });
    }

    public Pixmap getPixmap(int biomeSubIndex) {
        if (biomeSubIndex >= this.edgeImages.size() || biomeSubIndex < 0) {
            if (this.emptyPixmap == null) {
                this.emptyPixmap = new Pixmap(1, 1, Pixmap.Format.RGBA8888);
            }
            return this.emptyPixmap;
        }
        return this.images.get(biomeSubIndex).get(BigPictures.Center.value);
    }

    public void drawPixmapOn(int biomeSubIndex, int neighbors, Pixmap subPixmap) {
        int id = neighbors * 100;
        if (biomeSubIndex >= this.edgeImages.size() || biomeSubIndex < 0) {
            return;
        }
        if (this.edgeImages.get(biomeSubIndex).containsKey(id)) {
            return;
        }
        int tileSize = subPixmap.getHeight();
        block0 : switch (neighbors) {
            case 511: {
                subPixmap.drawPixmap(this.images.get(biomeSubIndex).get(BigPictures.Center.value), 0, 0);
                break;
            }
            case 504: {
                subPixmap.drawPixmap(this.images.get(biomeSubIndex).get(BigPictures.BottomEdge.value), 0, 0);
                break;
            }
            case 63: {
                subPixmap.drawPixmap(this.images.get(biomeSubIndex).get(BigPictures.TopEdge.value), 0, 0);
                break;
            }
            case 219: {
                subPixmap.drawPixmap(this.images.get(biomeSubIndex).get(BigPictures.LeftEdge.value), 0, 0);
                break;
            }
            case 438: {
                subPixmap.drawPixmap(this.images.get(biomeSubIndex).get(BigPictures.RightEdge.value), 0, 0);
                break;
            }
            case 186: {
                subPixmap.drawPixmap(this.images.get(biomeSubIndex).get(BigPictures.InnerEdges.value), 0, 0);
                break;
            }
            case 95: {
                subPixmap.drawPixmap(this.images.get(biomeSubIndex).get(BigPictures.LeftTopEdge.value), 0, 0);
                break;
            }
            case 311: {
                subPixmap.drawPixmap(this.images.get(biomeSubIndex).get(BigPictures.RightTopEdge.value), 0, 0);
                break;
            }
            case 473: {
                subPixmap.drawPixmap(this.images.get(biomeSubIndex).get(BigPictures.LeftBottomEdge.value), 0, 0);
                break;
            }
            case 500: {
                subPixmap.drawPixmap(this.images.get(biomeSubIndex).get(BigPictures.RightBottomEdge.value), 0, 0);
                break;
            }
            default: {
                switch (neighbors & 0x1A0) {
                    case 0: 
                    case 256: {
                        subPixmap.drawPixmap(this.smallImages.get(biomeSubIndex).get(SmallPictures.LeftTopEdge00.value), 0, 0);
                        break;
                    }
                    case 128: 
                    case 384: {
                        subPixmap.drawPixmap(this.smallImages.get(biomeSubIndex).get(SmallPictures.LeftEdge00.value), 0, 0);
                        break;
                    }
                    case 32: 
                    case 288: {
                        subPixmap.drawPixmap(this.smallImages.get(biomeSubIndex).get(SmallPictures.TopEdge00.value), 0, 0);
                        break;
                    }
                    case 160: {
                        subPixmap.drawPixmap(this.smallImages.get(biomeSubIndex).get(SmallPictures.InnerTopLeftEdge.value), 0, 0);
                        break;
                    }
                    case 416: {
                        subPixmap.drawPixmap(this.smallImages.get(biomeSubIndex).get(SmallPictures.Center00.value), 0, 0);
                    }
                }
                switch (neighbors & 0xC8) {
                    case 0: 
                    case 64: {
                        subPixmap.drawPixmap(this.smallImages.get(biomeSubIndex).get(SmallPictures.RightTopEdge10.value), tileSize / 2, 0);
                        break;
                    }
                    case 128: 
                    case 192: {
                        subPixmap.drawPixmap(this.smallImages.get(biomeSubIndex).get(SmallPictures.RightEdge10.value), tileSize / 2, 0);
                        break;
                    }
                    case 8: 
                    case 72: {
                        subPixmap.drawPixmap(this.smallImages.get(biomeSubIndex).get(SmallPictures.TopEdge10.value), tileSize / 2, 0);
                        break;
                    }
                    case 136: {
                        subPixmap.drawPixmap(this.smallImages.get(biomeSubIndex).get(SmallPictures.InnerTopRightEdge.value), tileSize / 2, 0);
                        break;
                    }
                    case 200: {
                        subPixmap.drawPixmap(this.smallImages.get(biomeSubIndex).get(SmallPictures.Center10.value), tileSize / 2, 0);
                    }
                }
                switch (neighbors & 0x26) {
                    case 0: 
                    case 4: {
                        subPixmap.drawPixmap(this.smallImages.get(biomeSubIndex).get(SmallPictures.LeftBottomEdge01.value), 0, tileSize / 2);
                        break;
                    }
                    case 32: 
                    case 36: {
                        subPixmap.drawPixmap(this.smallImages.get(biomeSubIndex).get(SmallPictures.BottomEdge01.value), 0, tileSize / 2);
                        break;
                    }
                    case 2: 
                    case 6: {
                        subPixmap.drawPixmap(this.smallImages.get(biomeSubIndex).get(SmallPictures.LeftEdge01.value), 0, tileSize / 2);
                        break;
                    }
                    case 34: {
                        subPixmap.drawPixmap(this.smallImages.get(biomeSubIndex).get(SmallPictures.InnerBottomLeftEdge.value), 0, tileSize / 2);
                        break;
                    }
                    case 38: {
                        subPixmap.drawPixmap(this.smallImages.get(biomeSubIndex).get(SmallPictures.Center01.value), 0, tileSize / 2);
                    }
                }
                switch (neighbors & 0xB) {
                    case 0: 
                    case 1: {
                        subPixmap.drawPixmap(this.smallImages.get(biomeSubIndex).get(SmallPictures.RightBottomEdge11.value), tileSize / 2, tileSize / 2);
                        break block0;
                    }
                    case 8: 
                    case 9: {
                        subPixmap.drawPixmap(this.smallImages.get(biomeSubIndex).get(SmallPictures.BottomEdge11.value), tileSize / 2, tileSize / 2);
                        break block0;
                    }
                    case 2: 
                    case 3: {
                        subPixmap.drawPixmap(this.smallImages.get(biomeSubIndex).get(SmallPictures.RightEdge11.value), tileSize / 2, tileSize / 2);
                        break block0;
                    }
                    case 10: {
                        subPixmap.drawPixmap(this.smallImages.get(biomeSubIndex).get(SmallPictures.InnerBottomRightEdge.value), tileSize / 2, tileSize / 2);
                        break block0;
                    }
                    case 11: {
                        subPixmap.drawPixmap(this.smallImages.get(biomeSubIndex).get(SmallPictures.Center11.value), tileSize / 2, tileSize / 2);
                    }
                }
            }
        }
        this.edgeImages.get(biomeSubIndex).put(biomeSubIndex, subPixmap);
    }

    static enum SmallPictures {
        Empty1(0),
        Empty2(1),
        Empty3(2),
        Empty4(3),
        InnerTopLeftEdge(4),
        InnerTopRightEdge(5),
        Empty5(6),
        Empty6(7),
        Empty7(8),
        Empty8(9),
        InnerBottomLeftEdge(10),
        InnerBottomRightEdge(11),
        LeftTopEdge00(12),
        LeftTopEdge10(13),
        TopEdge00(14),
        TopEdge10(15),
        RightTopEdge00(16),
        RightTopEdge10(17),
        LeftTopEdge01(18),
        LeftTopEdge11(19),
        TopEdge01(20),
        TopEdge11(21),
        RightTopEdge01(22),
        RightTopEdge11(23),
        LeftEdge00(24),
        LeftEdge10(25),
        Center00(26),
        Center10(27),
        RightEdge00(28),
        RightEdge10(29),
        LeftEdge01(30),
        LeftEdge11(31),
        Center01(32),
        Center11(33),
        RightEdge01(34),
        RightEdge11(35),
        LeftBottomEdge00(36),
        LeftBottomEdge10(37),
        BottomEdge00(38),
        BottomEdge10(39),
        RightBottomEdge00(40),
        RightBottomEdge10(41),
        LeftBottomEdge01(42),
        LeftBottomEdge11(43),
        BottomEdge01(44),
        BottomEdge11(45),
        RightBottomEdge01(46),
        RightBottomEdge11(47);

        public final int value;

        private SmallPictures(int i) {
            this.value = i;
        }
    }

    static enum BigPictures {
        Empty1(0),
        Empty2(1),
        InnerEdges(2),
        LeftTopEdge(3),
        TopEdge(4),
        RightTopEdge(5),
        LeftEdge(6),
        Center(7),
        RightEdge(8),
        LeftBottomEdge(9),
        BottomEdge(10),
        RightBottomEdge(11);

        public final int value;

        private BigPictures(int i) {
            this.value = i;
        }
    }
}

