/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.world;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import forge.adventure.data.BiomeStructureData;
import forge.adventure.util.Config;
import forge.adventure.world.ColorMap;
import forge.adventure.world.OverlappingModel;
import java.util.HashMap;

public class BiomeStructure {
    private final BiomeStructureData data;
    final long seed;
    private final int biomeWidth;
    private final int biomeHeight;
    private int[][] dataMap;
    private boolean[][] collisionMap;
    boolean init = false;
    private TextureAtlas structureAtlas;
    public ColorMap image;
    private static final int MAXIMUM_WAVEFUNCTIONSIZE = 10;

    public BiomeStructure(BiomeStructureData data, long seed, int width, int height) {
        this.data = data;
        this.seed = seed;
        this.biomeWidth = width;
        this.biomeHeight = height;
    }

    public TextureAtlas atlas() {
        if (this.structureAtlas == null) {
            try {
                this.structureAtlas = Config.instance().getAtlas(this.data.structureAtlasPath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.structureAtlas;
    }

    public int structureObjectCount() {
        return this.data.mappingInfo.length;
    }

    public int objectID(int x, int y) {
        if (!this.init) {
            this.initialize();
        }
        if (x >= this.dataMap.length || x < 0 || y < 0 || y >= this.dataMap[0].length) {
            return -1;
        }
        return this.dataMap[x][y];
    }

    public void initialize(ColorMap sourceImage, ColorMap maskImage) {
        long currentTime = System.currentTimeMillis();
        this.init = true;
        int targetWidth = (int)(this.data.width * (float)this.biomeWidth);
        int targetHeight = (int)(this.data.height * (float)this.biomeHeight);
        this.dataMap = new int[targetWidth][targetHeight];
        this.collisionMap = new boolean[targetWidth][targetHeight];
        ColorMap finalImage = new ColorMap(targetWidth, targetHeight);
        HashMap<Integer, Integer> colorIdMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.data.mappingInfo.length; ++i) {
            colorIdMap.put(Integer.parseInt(this.data.mappingInfo[i].color, 16), i);
        }
        for (int mx = 0; mx < targetWidth; mx += Math.min(targetWidth - mx, 10)) {
            for (int my = 0; my < targetWidth; my += Math.min(targetHeight - my, 10)) {
                int y;
                int x;
                OverlappingModel model = new OverlappingModel(sourceImage, this.data.N, Math.min(targetWidth - mx, 10), Math.min(targetHeight - my, 10), this.data.periodicInput, this.data.periodicOutput, this.data.symmetry, this.data.ground);
                boolean suc = false;
                for (int i = 0; i < 10 && !suc; ++i) {
                    suc = model.run((int)this.seed + i * 5355 + mx * my, 0);
                }
                if (!suc) {
                    for (x = 0; x < this.dataMap.length; ++x) {
                        for (y = 0; y < this.dataMap[x].length; ++y) {
                            this.dataMap[mx + x][my + y] = -1;
                        }
                    }
                    return;
                }
                this.image = model.graphics();
                for (x = 0; x < this.image.getWidth(); ++x) {
                    for (y = 0; y < this.image.getHeight(); ++y) {
                        boolean isWhitePixel;
                        boolean bl = isWhitePixel = maskImage != null && maskImage.getColor((int)((float)((mx + x) * maskImage.getWidth()) / (float)targetWidth), (int)((float)(my + y) * ((float)maskImage.getHeight() / (float)targetHeight))).equals(Color.WHITE);
                        if (isWhitePixel) {
                            finalImage.setColor(mx + x, my + y, Color.WHITE);
                        } else {
                            finalImage.setColor(mx + x, my + y, this.image.getColor(x, y));
                        }
                        int rgb = Color.rgb888(this.image.getColor(x, y));
                        if (isWhitePixel || !colorIdMap.containsKey(rgb)) {
                            this.dataMap[mx + x][my + y] = -1;
                            continue;
                        }
                        this.dataMap[mx + x][my + y] = (Integer)colorIdMap.get(rgb);
                        this.collisionMap[mx + x][my + y] = this.data.mappingInfo[((Integer)colorIdMap.get((Object)Integer.valueOf((int)rgb))).intValue()].collision;
                    }
                }
            }
            this.image = finalImage;
        }
    }

    public void initialize() {
        this.initialize(this.sourceImage(), this.maskImage());
    }

    public ColorMap sourceImage() {
        return new ColorMap(Config.instance().getFile(this.data.sourcePath));
    }

    public String sourceImagePath() {
        return Config.instance().getFilePath(this.data.sourcePath);
    }

    private ColorMap maskImage() {
        return new ColorMap(Config.instance().getFile(this.data.maskPath));
    }

    public BiomeStructureData.BiomeStructureDataMapping[] mapping() {
        return this.data.mappingInfo;
    }

    public boolean collision(int x, int y) {
        if (!this.init) {
            this.initialize();
        }
        if (x >= this.collisionMap.length || x < 0 || y < 0 || y >= this.collisionMap[0].length) {
            return false;
        }
        return this.collisionMap[x][y];
    }

    public String maskImagePath() {
        return Config.instance().getFilePath(this.data.maskPath);
    }
}

