/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.world;

import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import forge.adventure.data.BiomeSpriteData;
import forge.adventure.util.Config;

public class BiomeSprites {
    private final ObjectMap<String, Array<Sprite>> spriteBuffer = new ObjectMap();
    public String textureAtlas;
    public BiomeSpriteData[] sprites;

    public Sprite getSprite(String name, int seed) {
        int index;
        Array<Sprite> sprites;
        if (!this.spriteBuffer.containsKey(name)) {
            this.spriteBuffer.put(name, new Array());
        }
        if ((sprites = this.spriteBuffer.get(name)).isEmpty()) {
            sprites.addAll(Config.instance().getAtlas(this.textureAtlas).createSprites(name));
        }
        if ((index = seed % sprites.size) >= sprites.size || index < 0) {
            System.err.println("Invalid index: " + index + " [" + name + "]");
            return null;
        }
        return sprites.get(index);
    }

    public BiomeSpriteData getSpriteData(String name) {
        for (BiomeSpriteData data : this.sprites) {
            if (!data.name.equals(name)) continue;
            return data;
        }
        return null;
    }
}

