/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.util.pathfinding;

import com.badlogic.gdx.ai.pfa.Connection;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import forge.adventure.util.pathfinding.NavigationEdge;

public class NavigationVertex {
    public Vector2 pos = Vector2.Zero;
    public ObjectMap<NavigationVertex, NavigationEdge> incomingEdges = new ObjectMap();
    public ObjectMap<NavigationVertex, NavigationEdge> outgoingEdges = new ObjectMap();
    int index = -1;

    public NavigationVertex(Vector2 position) {
        this.pos = position;
    }

    public NavigationVertex(float x, float y) {
        this.pos = new Vector2(x, y);
    }

    public boolean hasEdgeTo(NavigationVertex otherNode) {
        return this.incomingEdges.containsKey(otherNode);
    }

    public Array<Connection<NavigationVertex>> getAllConnections() {
        Array<Connection<NavigationVertex>> ret = new Array<Connection<NavigationVertex>>();
        for (NavigationEdge e : this.incomingEdges.values()) {
            ret.add(e);
        }
        for (NavigationEdge e : this.outgoingEdges.values()) {
            ret.add(e);
        }
        return ret;
    }

    public void removeEdges(NavigationVertex node) {
        this.outgoingEdges.remove(node);
        this.incomingEdges.remove(node);
    }
}

