/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.util.pathfinding;

import com.badlogic.gdx.ai.pfa.Connection;
import com.badlogic.gdx.ai.pfa.indexed.IndexedAStarPathFinder;
import com.badlogic.gdx.ai.pfa.indexed.IndexedGraph;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import forge.adventure.util.pathfinding.EuclidianHeuristic;
import forge.adventure.util.pathfinding.NavigationEdge;
import forge.adventure.util.pathfinding.NavigationVertex;
import forge.adventure.util.pathfinding.ProgressableGraphPath;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class NavigationGraph
implements IndexedGraph<NavigationVertex> {
    private int lastNodeIndex = 0;
    Map<Integer, NavigationVertex> nodes = new HashMap<Integer, NavigationVertex>();
    EuclidianHeuristic navigationHeuristic = new EuclidianHeuristic();

    public NavigationVertex addVertex(NavigationVertex node) {
        node.index = this.lastNodeIndex++;
        this.nodes.put(node.index, node);
        return node;
    }

    public NavigationVertex addVertex(Vector2 position) {
        return this.addVertex(new NavigationVertex(position));
    }

    public NavigationVertex addVertex(float x, float y) {
        return this.addVertex(new NavigationVertex(x, y));
    }

    public void removeVertex(NavigationVertex node) {
        for (NavigationVertex v : node.incomingEdges.keys()) {
            v.removeEdges(node);
        }
        this.nodes.remove(node.index >= 0 ? node.index : this.lookupIndex(node));
    }

    public void removeVertex(Vector2 position) {
        this.removeVertex(this.getVertexByPosition(position));
    }

    public void removeVertex(float x, float y) {
        this.removeVertex(new Vector2(x, y));
    }

    public void removeVertices(Collection<NavigationVertex> vertices) {
        for (NavigationVertex v : vertices) {
            this.removeVertex(v);
        }
    }

    public void removeVertexIf(Predicate<NavigationVertex> predicate) {
        this.removeVertices(this.nodes.values().stream().filter(predicate).collect(Collectors.toList()));
    }

    public int lookupIndex(NavigationVertex item) {
        return this.lookupIndex(item.pos);
    }

    public int lookupIndex(Vector2 pos) {
        for (int i : this.nodes.keySet()) {
            if (!this.nodes.get((Object)Integer.valueOf((int)i)).pos.equals(pos)) continue;
            return i;
        }
        return -1;
    }

    public void addEdge(NavigationVertex fromNode, NavigationVertex toNode) {
        if (fromNode.index < 0) {
            fromNode = this.getVertexByPosition(fromNode.pos);
        }
        if (toNode.index < 0) {
            toNode = this.getVertexByPosition(toNode.pos);
        }
        if (this.edgeExists(fromNode, toNode)) {
            System.out.println(fromNode.pos + " is already connected to " + toNode.pos);
            return;
        }
        if (fromNode.index >= 0 || toNode.index < 0) {
            NavigationEdge fromAToB = new NavigationEdge(fromNode, toNode);
            NavigationEdge fromBToA = new NavigationEdge(toNode, fromNode);
            fromNode.outgoingEdges.put(toNode, fromAToB);
            fromNode.incomingEdges.put(toNode, fromBToA);
            toNode.outgoingEdges.put(fromNode, fromBToA);
            toNode.incomingEdges.put(fromNode, fromAToB);
        }
    }

    public void addEdge(Vector2 fromNode, NavigationVertex toNode) {
        this.addEdge(new NavigationVertex(fromNode), toNode);
    }

    public void addEdge(NavigationVertex fromNode, Vector2 toNode) {
        this.addEdge(fromNode, new NavigationVertex(toNode));
    }

    public void addEdgeUnchecked(NavigationVertex fromNode, NavigationVertex toNode) {
        NavigationEdge fromAToB = new NavigationEdge(fromNode, toNode);
        NavigationEdge fromBToA = new NavigationEdge(toNode, fromNode);
        fromNode.outgoingEdges.put(toNode, fromAToB);
        fromNode.incomingEdges.put(toNode, fromBToA);
        toNode.outgoingEdges.put(fromNode, fromBToA);
        toNode.incomingEdges.put(fromNode, fromAToB);
    }

    @Override
    public int getIndex(NavigationVertex node) {
        return node.index;
    }

    @Override
    public int getNodeCount() {
        return this.lastNodeIndex;
    }

    @Override
    public Array<Connection<NavigationVertex>> getConnections(NavigationVertex fromNode) {
        return fromNode.getAllConnections();
    }

    public boolean edgeExists(NavigationVertex fromNode, NavigationVertex toNode) {
        if (fromNode.index < 0) {
            fromNode = this.getVertexByPosition(fromNode.pos);
        }
        if (toNode.index < 0) {
            toNode = this.getVertexByPosition(toNode.pos);
        }
        return fromNode.outgoingEdges.containsKey(toNode);
    }

    public Collection<NavigationVertex> getNodes() {
        return this.nodes.values();
    }

    public ProgressableGraphPath<NavigationVertex> findPath(Vector2 origin, Vector2 destination) {
        ProgressableGraphPath<NavigationVertex> navPath = new ProgressableGraphPath<NavigationVertex>();
        NavigationVertex originVertex = this.getVertexByPosition(origin);
        NavigationVertex destinationVertex = this.getVertexByPosition(destination);
        if (originVertex.index > -1 && destinationVertex.index > -1) {
            new IndexedAStarPathFinder<NavigationVertex>(this).searchNodePath(originVertex, destinationVertex, this.navigationHeuristic, navPath);
        }
        return navPath;
    }

    public NavigationVertex getVertexByPosition(Vector2 position) {
        return this.nodes.get(this.lookupIndex(position));
    }

    public boolean containsNode(Vector2 nodePosition) {
        return this.nodes.containsKey(this.lookupIndex(nodePosition));
    }
}

