/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.util.pathfinding;

import com.badlogic.gdx.ai.utils.Collision;
import com.badlogic.gdx.ai.utils.Ray;
import com.badlogic.gdx.ai.utils.RaycastCollisionDetector;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.RayCastCallback;
import com.badlogic.gdx.physics.box2d.World;

public class Box2dRaycastCollisionDetector
implements RaycastCollisionDetector<Vector2> {
    World world;
    Box2dRaycastCallback callback;

    public Box2dRaycastCollisionDetector(World world) {
        this(world, new Box2dRaycastCallback());
    }

    public Box2dRaycastCollisionDetector(World world, Box2dRaycastCallback callback) {
        this.world = world;
        this.callback = callback;
    }

    @Override
    public boolean collides(Ray<Vector2> ray) {
        return this.findCollision((Collision<Vector2>)null, ray);
    }

    @Override
    public boolean findCollision(Collision<Vector2> outputCollision, Ray<Vector2> inputRay) {
        this.callback.collided = false;
        if (!((Vector2)inputRay.start).epsilonEquals((Vector2)inputRay.end, 1.0E-6f)) {
            this.callback.outputCollision = outputCollision;
            this.world.rayCast(this.callback, (Vector2)inputRay.start, (Vector2)inputRay.end);
        }
        return this.callback.collided;
    }

    public static class Box2dRaycastCallback
    implements RayCastCallback {
        public Collision<Vector2> outputCollision;
        public boolean collided;

        @Override
        public float reportRayFixture(Fixture fixture, Vector2 point, Vector2 normal, float fraction) {
            if (this.outputCollision != null) {
                this.outputCollision.set(point, normal);
            }
            this.collided = true;
            return fraction;
        }
    }
}

