/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.util;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.OrderedMap;
import com.github.tommyettinger.textra.TextraButton;
import com.github.tommyettinger.textra.TextraLabel;
import forge.Forge;
import forge.adventure.data.UIData;
import forge.adventure.scene.UIScene;
import forge.adventure.util.Config;
import forge.adventure.util.Controls;
import forge.adventure.util.KeyBinding;
import forge.adventure.util.Selector;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UIActor
extends Group {
    UIData data;
    Actor lastActor = null;
    public Array<UIScene.Selectable> selectActors = new Array();
    private HashMap<KeyBinding, Button> keyMap = new HashMap();
    public Array<KeyHintLabel> keyLabels = new Array();

    public UIActor(FileHandle handle) {
        this.data = new Json().fromJson(UIData.class, handle);
        this.setWidth(this.data.width);
        this.setHeight(this.data.height);
        for (OrderedMap<String, String> element : this.data.elements) {
            Actor newActor;
            String type = (String)element.get("type");
            if (type == null) {
                newActor = new Actor();
            } else {
                switch (type) {
                    case "Selector": {
                        newActor = new Selector();
                        this.readSelectorProperties((Selector)newActor, new OrderedMap.OrderedMapEntries<String, String>(element));
                        break;
                    }
                    case "Label": {
                        newActor = Controls.newTextraLabel("");
                        this.readLabelProperties((TextraLabel)newActor, new OrderedMap.OrderedMapEntries<String, String>(element));
                        break;
                    }
                    case "TypingLabel": {
                        newActor = Controls.newTypingLabel("");
                        this.readLabelProperties((TextraLabel)newActor, new OrderedMap.OrderedMapEntries<String, String>(element));
                        break;
                    }
                    case "Table": {
                        newActor = new Table(Controls.getSkin());
                        this.readTableProperties((Table)newActor, new OrderedMap.OrderedMapEntries<String, String>(element));
                        break;
                    }
                    case "Image": {
                        newActor = new Image();
                        this.readImageProperties((Image)newActor, new OrderedMap.OrderedMapEntries<String, String>(element));
                        break;
                    }
                    case "ImageButton": {
                        newActor = new ImageButton(Controls.getSkin());
                        this.readImageButtonProperties((ImageButton)newActor, new OrderedMap.OrderedMapEntries<String, String>(element));
                        break;
                    }
                    case "Window": {
                        newActor = new Window("", Controls.getSkin());
                        this.readWindowProperties((Window)newActor, new OrderedMap.OrderedMapEntries<String, String>(element));
                        break;
                    }
                    case "TextButton": {
                        newActor = Controls.newTextButton("");
                        this.readButtonProperties((TextraButton)newActor, new OrderedMap.OrderedMapEntries<String, String>(element));
                        break;
                    }
                    case "TextField": {
                        newActor = new TextField("", Controls.getSkin());
                        this.readTextFieldProperties((TextField)newActor, new OrderedMap.OrderedMapEntries<String, String>(element));
                        break;
                    }
                    case "Scroll": {
                        newActor = new ScrollPane(null, Controls.getSkin());
                        this.readScrollPaneProperties((ScrollPane)newActor, new OrderedMap.OrderedMapEntries<String, String>(element));
                        break;
                    }
                    case "CheckBox": {
                        newActor = new CheckBox("", Controls.getSkin());
                        this.readCheckBoxProperties((CheckBox)newActor, new OrderedMap.OrderedMapEntries<String, String>(element));
                        break;
                    }
                    case "SelectBox": {
                        newActor = Controls.newComboBox();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + type);
                    }
                }
            }
            float yValue = 0.0f;
            for (ObjectMap.Entry entry : new OrderedMap.OrderedMapEntries<String, String>(element)) {
                switch (entry.key.toString()) {
                    case "selectable": {
                        this.selectActors.add(new UIScene.Selectable<Actor>(newActor));
                        break;
                    }
                    case "scale": {
                        newActor.setScale(((Float)entry.value).floatValue());
                        break;
                    }
                    case "width": {
                        newActor.setWidth(((Float)entry.value).floatValue());
                        break;
                    }
                    case "height": {
                        newActor.setHeight(((Float)entry.value).floatValue());
                        if (!this.data.yDown) break;
                        newActor.setY((float)this.data.height - yValue - newActor.getHeight());
                        break;
                    }
                    case "x": {
                        newActor.setX(((Float)entry.value).floatValue());
                        break;
                    }
                    case "y": {
                        yValue = ((Float)entry.value).floatValue();
                        newActor.setY(this.data.yDown ? (float)this.data.height - yValue - newActor.getHeight() : yValue);
                        break;
                    }
                    case "yOffset": {
                        if (this.data.yDown) {
                            yValue = ((Float)entry.value).floatValue() + (this.lastActor != null ? (float)this.data.height - this.lastActor.getY() : 0.0f);
                            newActor.setY((float)this.data.height - yValue - newActor.getHeight());
                            break;
                        }
                        yValue = ((Float)entry.value).floatValue() + (this.lastActor != null ? this.lastActor.getY() : 0.0f);
                        newActor.setY(yValue);
                        break;
                    }
                    case "xOffset": {
                        newActor.setX(((Float)entry.value).floatValue() + (this.lastActor != null ? this.lastActor.getX() : 0.0f));
                        break;
                    }
                    case "name": {
                        newActor.setName((String)entry.value);
                    }
                }
            }
            this.lastActor = newActor;
            this.addActor(newActor);
        }
    }

    public Button buttonPressed(int key) {
        for (Map.Entry<KeyBinding, Button> entry : this.keyMap.entrySet()) {
            if (!entry.getKey().isPressed(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    private void readScrollPaneProperties(ScrollPane newActor, ObjectMap.Entries<String, String> entries) {
        newActor.setActor(Controls.newTextraLabel(""));
        for (ObjectMap.Entry entry : entries) {
            switch (entry.key.toString()) {
                case "style": {
                    newActor.setStyle(Controls.getSkin().get(entry.value.toString(), ScrollPane.ScrollPaneStyle.class));
                }
            }
        }
    }

    private void readWindowProperties(Window newActor, ObjectMap.Entries<String, String> entries) {
        for (ObjectMap.Entry entry : entries) {
            switch (entry.key.toString()) {
                case "style": {
                    newActor.setStyle(Controls.getSkin().get(entry.value.toString(), Window.WindowStyle.class));
                }
            }
        }
        newActor.setMovable(false);
    }

    private void readTextFieldProperties(TextField newActor, ObjectMap.Entries<String, String> entries) {
        for (ObjectMap.Entry entry : entries) {
            switch (entry.key.toString()) {
                case "text": {
                    newActor.setText(UIActor.localize(entry.value.toString()));
                    break;
                }
                case "align": {
                    newActor.setAlignment(((Float)entry.value).intValue());
                }
            }
        }
    }

    public static String localize(String str) {
        Pattern regex = Pattern.compile("tr\\([^\\)]*\\)");
        for (int i = 0; i < 100; ++i) {
            Matcher matcher = regex.matcher(str);
            if (!matcher.find()) {
                return str;
            }
            str = matcher.replaceFirst(Forge.getLocalizer().getMessage(matcher.group().substring(3, matcher.group().length() - 1), new Object[0]));
        }
        return str;
    }

    private void readImageButtonProperties(ImageButton newActor, ObjectMap.Entries<String, String> entries) {
        for (ObjectMap.Entry entry : entries) {
            switch (entry.key.toString()) {
                case "style": {
                    newActor.setStyle(Controls.getSkin().get(entry.value.toString(), ImageButton.ImageButtonStyle.class));
                    break;
                }
                case "binding": {
                    this.keyMap.put(KeyBinding.valueOf(entry.value.toString()), newActor);
                }
            }
        }
    }

    private void readLabelProperties(TextraLabel newActor, ObjectMap.Entries<String, String> entries) {
        for (ObjectMap.Entry entry : entries) {
            switch (entry.key.toString()) {
                case "text": {
                    newActor.setText(UIActor.localize(entry.value.toString()));
                    break;
                }
                case "font": 
                case "fontName": {
                    if (entry.value.toString().equals("default")) break;
                    newActor.setFont(Controls.getTextraFont(entry.value.toString()));
                    break;
                }
                case "style": {
                    newActor.style = Controls.getSkin().get(entry.value.toString(), Label.LabelStyle.class);
                    break;
                }
                case "color": 
                case "fontColor": {
                    newActor.layout.setBaseColor(Controls.colorFromString(entry.value.toString()));
                }
            }
        }
        newActor.setText(newActor.storedText);
        newActor.layout();
    }

    private void readTableProperties(Table newActor, ObjectMap.Entries<String, String> entries) {
        for (ObjectMap.Entry entry : entries) {
            switch (entry.key.toString()) {
                case "font": {
                    newActor.getSkin().get(Label.LabelStyle.class).font = Controls.getBitmapFont(entry.value.toString());
                    if (entry.value.toString().contains("black")) {
                        newActor.getSkin().get(Label.LabelStyle.class).fontColor = Color.BLACK;
                    }
                    if (!entry.value.toString().contains("big")) break;
                    newActor.setScale(2.0f, 2.0f);
                }
            }
        }
    }

    private void readSelectorProperties(Selector newActor, ObjectMap.Entries<String, String> entries) {
    }

    private void readCheckBoxProperties(CheckBox newActor, ObjectMap.Entries<String, String> entries) {
        for (ObjectMap.Entry entry : entries) {
            switch (entry.key.toString()) {
                case "text": {
                    newActor.setText(UIActor.localize(entry.value.toString()));
                }
            }
        }
    }

    private void readButtonProperties(TextraButton newActor, ObjectMap.Entries<String, String> entries) {
        for (ObjectMap.Entry entry : entries) {
            switch (entry.key.toString()) {
                case "text": {
                    newActor.setText(UIActor.localize(entry.value.toString()));
                    break;
                }
                case "style": {
                    newActor.setStyle(Controls.getSkin().get(entry.value.toString(), TextButton.TextButtonStyle.class));
                    break;
                }
                case "binding": {
                    this.keyMap.put(KeyBinding.valueOf(entry.value.toString()), newActor);
                    KeyHintLabel label = new KeyHintLabel(KeyBinding.valueOf(entry.value.toString()));
                    this.keyLabels.add(label);
                    newActor.add(label);
                }
            }
        }
        newActor.layout();
    }

    private void readImageProperties(Image newActor, ObjectMap.Entries<String, String> entries) {
        for (ObjectMap.Entry entry : entries) {
            switch (entry.key.toString()) {
                case "image": {
                    boolean is2D = entry.value.toString().startsWith("ui");
                    Texture t2 = Forge.getAssets().getTexture(Config.instance().getFile(entry.value.toString()), is2D, false);
                    TextureRegion tr = new TextureRegion(t2);
                    if (entry.value.toString().contains("title_bg")) {
                        final ShaderProgram shaderNightDay = Forge.getGraphics().getShaderNightDay();
                        newActor.setDrawable(new TextureRegionDrawable(tr){

                            @Override
                            public void draw(Batch batch, float x, float y, float width, float height) {
                                try {
                                    if (Config.instance().getSettingData().dayNightBG) {
                                        batch.end();
                                        shaderNightDay.bind();
                                        shaderNightDay.setUniformf("u_timeOfDay", UIScene.getTimeOfDay());
                                        shaderNightDay.setUniformf("u_time", 0.0f);
                                        shaderNightDay.setUniformf("u_bias", 0.9f);
                                        batch.setShader(shaderNightDay);
                                        batch.begin();
                                        batch.draw(this.getRegion(), x, y, width, height);
                                        batch.end();
                                        batch.setShader(null);
                                        batch.begin();
                                    } else {
                                        batch.draw(this.getRegion(), x, y, width, height);
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                        break;
                    }
                    newActor.setDrawable(new TextureRegionDrawable(tr));
                }
            }
        }
    }

    public void onButtonPress(String name, Runnable func) {
        Object button = this.findActor(name);
        if (button != null) {
            ((Actor)button).addListener(new ClickListener((Actor)button, func){
                final /* synthetic */ Actor val$button;
                final /* synthetic */ Runnable val$func;
                {
                    this.val$button = actor;
                    this.val$func = runnable;
                }

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    if (this.val$button instanceof Button && ((Button)this.val$button).isDisabled()) {
                        return;
                    }
                    this.val$func.run();
                }
            });
        }
    }

    public void controllerDisconnected() {
        for (KeyHintLabel label : this.keyLabels) {
            label.disconnected();
        }
    }

    public void controllerConnected() {
        for (KeyHintLabel label : this.keyLabels) {
            label.connected();
        }
    }

    public void pressUp(int code) {
        for (KeyHintLabel label : this.keyLabels) {
            label.buttonUp(code);
        }
    }

    public void pressDown(int code) {
        for (KeyHintLabel label : this.keyLabels) {
            label.buttonDown(code);
        }
    }

    private class KeyHintLabel
    extends TextraLabel {
        KeyBinding keyBinding;

        public KeyHintLabel(KeyBinding keyBinding) {
            super(keyBinding.getLabelText(false), Controls.getKeysFont());
            this.keyBinding = keyBinding;
        }

        public void connected() {
            this.updateText();
        }

        private void updateText() {
            this.setText(this.keyBinding.getLabelText(false));
            this.layout();
        }

        public void disconnected() {
            this.updateText();
        }

        public boolean buttonDown(int i) {
            if (this.keyBinding.isPressed(i)) {
                this.setText(this.keyBinding.getLabelText(true));
            }
            this.layout();
            return false;
        }

        public boolean buttonUp(int i) {
            if (this.keyBinding.isPressed(i)) {
                this.updateText();
            }
            return false;
        }
    }
}

