/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.util;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pools;
import com.github.tommyettinger.textra.TextraButton;
import forge.adventure.util.Controls;
import forge.adventure.util.KeyBinding;

public class Selector
extends Table {
    private final ImageButton leftArrow;
    private final ImageButton rightArrow;
    private final TextraButton label;
    private int currentIndex = 0;
    private Array<String> textList;

    public Selector() {
        final Selector self = this;
        ImageButton.ImageButtonStyle leftArrowStyle = Controls.getSkin().get("leftarrow", ImageButton.ImageButtonStyle.class);
        this.leftArrow = new ImageButton(leftArrowStyle){

            @Override
            public boolean hasKeyboardFocus() {
                return self.hasKeyboardFocus();
            }
        };
        ImageButton.ImageButtonStyle rightArrowStyle = Controls.getSkin().get("rightarrow", ImageButton.ImageButtonStyle.class);
        this.rightArrow = new ImageButton(rightArrowStyle){

            @Override
            public boolean hasKeyboardFocus() {
                return self.hasKeyboardFocus();
            }
        };
        this.label = new Controls.TextButtonFix(""){

            @Override
            public boolean hasKeyboardFocus() {
                return self.hasKeyboardFocus();
            }
        };
        this.add(this.leftArrow).pad(2.0f);
        this.add(this.label).expand().fill();
        this.add(this.rightArrow).pad(2.0f);
        this.leftArrow.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Selector.this.setCurrentIndex(Selector.this.currentIndex - 1);
            }
        });
        this.rightArrow.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Selector.this.setCurrentIndex(Selector.this.currentIndex + 1);
            }
        });
        this.addListener(new InputListener(){

            @Override
            public boolean keyDown(InputEvent event, int keycode) {
                if (KeyBinding.Left.isPressed(keycode)) {
                    Selector.this.setCurrentIndex(Selector.this.currentIndex - 1);
                }
                if (KeyBinding.Right.isPressed(keycode)) {
                    Selector.this.setCurrentIndex(Selector.this.currentIndex + 1);
                }
                return true;
            }
        });
    }

    @Override
    protected void sizeChanged() {
        super.sizeChanged();
        this.leftArrow.setWidth(this.getHeight());
        this.leftArrow.setHeight(this.getHeight());
        this.rightArrow.setWidth(this.getHeight());
        this.rightArrow.setHeight(this.getHeight());
        this.label.setHeight(this.getHeight());
        this.label.setX(this.getHeight());
        this.label.setWidth(this.getWidth() - this.getHeight() * 2.0f);
        this.rightArrow.setX(this.getWidth() - this.getHeight());
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int currentIndex) {
        if ((currentIndex %= this.textList.size) < 0) {
            currentIndex += this.textList.size;
        }
        int oldIndex = currentIndex;
        this.currentIndex = currentIndex;
        this.label.setText(this.textList.get(currentIndex));
        this.label.layout();
        ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
        if (this.fire(changeEvent)) {
            this.currentIndex = oldIndex;
            this.label.setText(this.textList.get(currentIndex));
            this.label.layout();
        }
        Pools.free(changeEvent);
    }

    public String getText() {
        return this.textList.get(this.currentIndex);
    }

    public TextraButton getLabel() {
        return this.label;
    }

    public ImageButton getLeftArrow() {
        return this.leftArrow;
    }

    public ImageButton getRightArrow() {
        return this.rightArrow;
    }

    public Array<String> getTextList() {
        return this.textList;
    }

    public void setTextList(Array<String> textList) {
        this.textList = textList;
        this.setCurrentIndex(this.currentIndex);
    }

    public void setTextList(String[] strings) {
        this.textList = new Array<String>(strings);
        this.setCurrentIndex(this.currentIndex);
    }
}

