/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.util;

import forge.adventure.data.ItemData;
import forge.deck.Deck;
import forge.item.PaperCard;

public class Reward {
    Type type;
    PaperCard card;
    ItemData item;
    Deck deck;
    boolean isNoSell;
    boolean isAutoSell;
    private final int count;

    public Reward(ItemData item) {
        this.type = Type.Item;
        this.item = item;
        this.count = 1;
    }

    public Reward(int count) {
        this.type = Type.Gold;
        this.count = count;
    }

    public Reward(PaperCard card) {
        this(card, false);
    }

    public Reward(PaperCard card, boolean isNoSell) {
        this.type = Type.Card;
        this.card = card;
        this.count = 0;
        this.isNoSell = isNoSell;
    }

    public Reward(Type type, int count) {
        this.type = type;
        this.count = count;
    }

    public Reward(Deck deck) {
        this(deck, false);
    }

    public Reward(Deck deck, boolean isNoSell) {
        this.type = Type.CardPack;
        this.deck = deck;
        this.count = 0;
        this.isNoSell = isNoSell;
    }

    public PaperCard getCard() {
        return this.card;
    }

    public ItemData getItem() {
        return this.item;
    }

    public Deck getDeck() {
        return this.deck;
    }

    public Type getType() {
        return this.type;
    }

    public int getCount() {
        return this.count;
    }

    public boolean isNoSell() {
        return this.isNoSell;
    }

    public boolean isAutoSell() {
        return this.isAutoSell;
    }

    public void setAutoSell(boolean val) {
        this.isAutoSell = val;
    }

    public static enum Type {
        Card,
        Gold,
        Item,
        Life,
        Shards,
        CardPack;

    }
}

