/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.util;

import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.Array;
import forge.adventure.util.Config;

public class NavArrowActor
extends Actor {
    public float navTargetAngle = 0.0f;
    private Animation<TextureRegion> currentAnimation;
    private Array<Sprite> sprites;
    float timer;

    public NavArrowActor() {
        if (this.sprites == null) {
            this.sprites = Config.instance().getAtlas("maps/tileset/compass.atlas").createSprites();
            if (this.sprites.isEmpty()) {
                System.out.print("NavArrow sprite not found");
            }
        }
        this.currentAnimation = new Animation<Sprite>(0.4f, this.sprites);
    }

    @Override
    public void act(float delta) {
        this.timer += delta;
        super.act(delta);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.currentAnimation == null) {
            return;
        }
        TextureRegion currentFrame = this.currentAnimation.getKeyFrame(this.timer, true);
        this.setHeight(currentFrame.getRegionHeight());
        this.setWidth(currentFrame.getRegionWidth());
        batch.draw(currentFrame, this.getX() - (float)(currentFrame.getRegionWidth() / 2), this.getY() - (float)(currentFrame.getRegionHeight() / 2), (float)currentFrame.getRegionWidth() * 0.5f, (float)currentFrame.getRegionHeight() * 0.5f, currentFrame.getRegionWidth(), currentFrame.getRegionHeight(), 1.0f, 1.0f, this.navTargetAngle);
    }
}

