/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.util;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.SerializationException;

public class JSONStringLoader {
    private static final Json JSON = new Json();

    @Null
    public static <T> T parse(Class<T> type, String json, String fallback) {
        return JSONStringLoader.parse(type, null, json, fallback);
    }

    @Null
    public static <T> T parse(Class<T> type, Class elementType, String json, String fallback) {
        if (json != null && !json.isEmpty()) {
            try {
                return JSON.fromJson(type, elementType, json);
            }
            catch (SerializationException E) {
                System.err.printf("Error loading JSON string:\n%s\nUsing fallback.", E.getMessage());
            }
        }
        return JSON.fromJson(type, elementType, fallback);
    }
}

