/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.util;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.SequenceAction;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Dialog;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.Timer;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.TextraButton;
import com.github.tommyettinger.textra.TextraLabel;
import com.github.tommyettinger.textra.TypingButton;
import com.github.tommyettinger.textra.TypingLabel;
import forge.Forge;
import forge.adventure.player.AdventurePlayer;
import forge.adventure.util.Config;
import forge.adventure.util.Current;
import forge.card.ColorSet;
import forge.sound.SoundEffectType;
import forge.sound.SoundSystem;
import java.util.function.Function;

public class Controls {
    public static TextraButton newTextButton(String text) {
        TextButtonFix button = new TextButtonFix(text);
        button.getTextraLabel().setWrap(false);
        return button;
    }

    public static TypingButton newTypingButton(String text) {
        TypingButtonFix button = new TypingButtonFix(text);
        button.getTextraLabel().setWrap(false);
        return button;
    }

    public static Rectangle getBoundingRect(Actor actor) {
        return new Rectangle(actor.getX(), actor.getY(), actor.getWidth(), actor.getHeight());
    }

    public static boolean actorContainsVector(Actor actor, Vector2 point) {
        if (actor == null) {
            return false;
        }
        if (!actor.isVisible()) {
            return false;
        }
        return Controls.getBoundingRect(actor).contains(point);
    }

    public static boolean actorContainsVector(Array<TextraButton> buttons, Vector2 point) {
        boolean value = false;
        if (buttons == null) {
            return false;
        }
        if (buttons.isEmpty()) {
            return false;
        }
        for (Actor actor : buttons) {
            if (actor == null) {
                return false;
            }
            if (!actor.isVisible()) {
                return false;
            }
            if (!Controls.getBoundingRect(actor).contains(point)) continue;
            value = true;
        }
        return value;
    }

    public static SelectBox<String> newComboBox(String[] text, String item, final Function<Object, Void> func) {
        SelectBox ret = Controls.newComboBox();
        ret.getStyle().listStyle.selection.setTopHeight(4.0f);
        ret.setItems(text);
        ret.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                try {
                    func.apply(((SelectBox)actor).getSelected());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        func.apply(item);
        ret.getList().setAlignment(1);
        ret.setSelected(item);
        ret.setAlignment(16);
        return ret;
    }

    public static SelectBox<String> newComboBox(Array<String> text, String item, final Function<Object, Void> func) {
        SelectBox ret = Controls.newComboBox();
        ret.getStyle().listStyle.selection.setTopHeight(4.0f);
        ret.setItems(text);
        ret.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                try {
                    func.apply(((SelectBox)actor).getSelected());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        func.apply(item);
        ret.getList().setAlignment(1);
        ret.setSelected(item);
        ret.setAlignment(16);
        return ret;
    }

    public static <T> SelectBox newComboBox() {
        return new SelectBox<T>(Controls.getSkin()){

            @Override
            @Null
            protected Drawable getBackgroundDrawable() {
                if (this.isDisabled() && this.getStyle().backgroundDisabled != null) {
                    return this.getStyle().backgroundDisabled;
                }
                if (this.getScrollPane().hasParent() && this.getStyle().backgroundOpen != null) {
                    return this.getStyle().backgroundOpen;
                }
                return (this.isOver() || this.hasKeyboardFocus()) && this.getStyle().backgroundOver != null ? this.getStyle().backgroundOver : this.getStyle().background;
            }

            @Override
            protected GlyphLayout drawItem(Batch batch, BitmapFont font, T item, float x, float y, float width) {
                if (this.getUserObject() != null && this.getUserObject() instanceof String && ((String)this.getUserObject()).isEmpty()) {
                    return super.drawItem(batch, font, Forge.getLocalizer().getMessage("lblSelectingFilter", new Object[0]), x, y, width);
                }
                return super.drawItem(batch, font, item, x, y, width);
            }
        };
    }

    public static SelectBox<Float> newComboBox(Float[] text, float item, final Function<Object, Void> func) {
        SelectBox ret = Controls.newComboBox();
        ret.getStyle().listStyle.selection.setTopHeight(4.0f);
        ret.setItems(text);
        ret.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                try {
                    func.apply(((SelectBox)actor).getSelected());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        func.apply(Float.valueOf(item));
        ret.getList().setAlignment(1);
        ret.setSelected(Float.valueOf(item));
        ret.setAlignment(16);
        return ret;
    }

    public static TextField newTextField(String text) {
        return new TextField(text, Controls.getSkin());
    }

    public static TextField newTextField(String text, final Function<String, Void> func) {
        TextField ret = new TextField(text, Controls.getSkin());
        ret.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                try {
                    func.apply(((TextField)actor).getText());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return ret;
    }

    public static TextraButton newTextButton(String text, final Runnable func) {
        TextraButton ret = Controls.newTextButton(text);
        ret.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                try {
                    if (func != null) {
                        func.run();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return ret;
    }

    public static Slider newSlider(float min2, float max, float step, boolean vertical) {
        Slider ret = new Slider(min2, max, step, vertical, Controls.getSkin()){

            @Override
            protected Drawable getBackgroundDrawable() {
                Slider.SliderStyle style = super.getStyle();
                if (this.isDisabled() && style.disabledBackground != null) {
                    return style.disabledBackground;
                }
                if (this.isDragging() && style.backgroundDown != null) {
                    return style.backgroundDown;
                }
                return (this.isOver() || this.hasKeyboardFocus()) && style.backgroundOver != null ? style.backgroundOver : style.background;
            }
        };
        return ret;
    }

    public static CheckBox newCheckBox(String text) {
        CheckBox ret = new CheckBox(text, Controls.getSkin());
        return ret;
    }

    public static BitmapFont getBitmapFont(String fontName) {
        switch (fontName) {
            case "blackbig": 
            case "big": {
                return Controls.getBitmapFont("default", 2.0f);
            }
        }
        return Controls.getBitmapFont("default", 1.0f);
    }

    public static BitmapFont getBitmapFont(String fontName, float scaleXY) {
        Controls.getSkin().getFont(fontName).getData().setScale(scaleXY, scaleXY);
        return Controls.getSkin().getFont("default");
    }

    public static Skin getSkin() {
        FileHandle skinFile = Config.instance().getFile("skin/ui_skin.json");
        Skin skin = Forge.getAssets().manager().get(skinFile.path(), Skin.class, false);
        if (skin == null) {
            Forge.getAssets().manager().load(skinFile.path(), Skin.class);
            Forge.getAssets().manager().finishLoadingAsset(skinFile.path());
            skin = Forge.getAssets().manager().get(skinFile.path(), Skin.class, false);
        }
        return skin;
    }

    public static Label newLabel(String name) {
        Label ret = new Label((CharSequence)name, Controls.getSkin());
        return ret;
    }

    public static Color colorFromString(String name) {
        String upperCase = name.toUpperCase();
        if (upperCase.startsWith("0X") || upperCase.startsWith("#")) {
            return new Color(Long.decode(upperCase).intValue());
        }
        if (upperCase.equals("WHITE")) {
            return Color.WHITE;
        }
        if (upperCase.equals("LIGHT_GRAY")) {
            return Color.LIGHT_GRAY;
        }
        if (upperCase.equals("GRAY")) {
            return Color.GRAY;
        }
        if (upperCase.equals("DARK_GRAY")) {
            return Color.DARK_GRAY;
        }
        if (upperCase.equals("BLACK")) {
            return Color.BLACK;
        }
        if (upperCase.equals("CLEAR")) {
            return Color.CLEAR;
        }
        if (upperCase.equals("BLUE")) {
            return Color.BLUE;
        }
        if (upperCase.equals("NAVY")) {
            return Color.NAVY;
        }
        if (upperCase.equals("ROYAL")) {
            return Color.ROYAL;
        }
        if (upperCase.equals("SLATE")) {
            return Color.SLATE;
        }
        if (upperCase.equals("SKY")) {
            return Color.SKY;
        }
        if (upperCase.equals("CYAN")) {
            return Color.CYAN;
        }
        if (upperCase.equals("TEAL")) {
            return Color.TEAL;
        }
        if (upperCase.equals("GREEN")) {
            return Color.GREEN;
        }
        if (upperCase.equals("CHARTREUSE")) {
            return Color.CHARTREUSE;
        }
        if (upperCase.equals("LIME")) {
            return Color.LIME;
        }
        if (upperCase.equals("FOREST")) {
            return Color.FOREST;
        }
        if (upperCase.equals("OLIVE")) {
            return Color.OLIVE;
        }
        if (upperCase.equals("YELLOW")) {
            return Color.YELLOW;
        }
        if (upperCase.equals("GOLD")) {
            return Color.GOLD;
        }
        if (upperCase.equals("GOLDENROD")) {
            return Color.GOLDENROD;
        }
        if (upperCase.equals("ORANGE")) {
            return Color.ORANGE;
        }
        if (upperCase.equals("TAN")) {
            return Color.TAN;
        }
        if (upperCase.equals("FIREBRICK")) {
            return Color.FIREBRICK;
        }
        if (upperCase.equals("RED")) {
            return Color.RED;
        }
        if (upperCase.equals("SCARLET")) {
            return Color.SCARLET;
        }
        if (upperCase.equals("CORAL")) {
            return Color.CORAL;
        }
        if (upperCase.equals("SALMON")) {
            return Color.SALMON;
        }
        if (upperCase.equals("PINK")) {
            return Color.PINK;
        }
        if (upperCase.equals("MAGENTA")) {
            return Color.MAGENTA;
        }
        if (upperCase.equals("PURPLE")) {
            return Color.PURPLE;
        }
        if (upperCase.equals("VIOLET")) {
            return Color.VIOLET;
        }
        if (upperCase.equals("MAROON")) {
            return Color.MAROON;
        }
        return Color.BLACK;
    }

    public static TextraLabel newTextraLabel(String name, Font font) {
        LabelFix ret = new LabelFix(name, font);
        return ret;
    }

    public static TextraLabel newTextraLabel(String name) {
        return Controls.newTextraLabel(name, Controls.getTextraFont());
    }

    public static TextraLabel newRewardLabel(String name) {
        return Controls.newTextraLabel(name, Controls.getRewardHeaderFont());
    }

    public static String colorIdToTypingString(ColorSet color) {
        return Controls.colorIdToTypingString(color, false);
    }

    public static String colorIdToTypingString(ColorSet color, boolean vertical) {
        String nextline = vertical ? "\n" : "";
        String colorId = "";
        if (color.hasWhite()) {
            colorId = colorId + "[+w]" + nextline;
        }
        if (color.hasBlue()) {
            colorId = colorId + "[+u]" + nextline;
        }
        if (color.hasBlack()) {
            colorId = colorId + "[+b]" + nextline;
        }
        if (color.hasRed()) {
            colorId = colorId + "[+r]" + nextline;
        }
        if (color.hasGreen()) {
            colorId = colorId + "[+g]" + nextline;
        }
        if (color.isColorless()) {
            colorId = colorId + "[+c]" + nextline;
        }
        return colorId;
    }

    public static TypingLabel newTypingLabel(String name) {
        TypingLabel ret = new TypingLabel(name == null ? "" : name, Controls.getSkin(), Controls.getTextraFont());
        ret.setVariable("player_name", Current.player().getName());
        ret.setVariable("player_color_id", Controls.colorIdToTypingString(Current.player().getColorIdentity()));
        return ret;
    }

    public static Dialog newDialog(String title) {
        Dialog ret = new Dialog(title, Controls.getSkin());
        ret.setMovable(false);
        return ret;
    }

    public static Font getKeysFont() {
        return Forge.getAssets().getKeysFont(Controls.getSkin().getFont("default"), Config.instance().getAtlas("skin/keys.atlas"));
    }

    public static Font getTextraFont() {
        return Forge.getAssets().getTextraFont(Controls.getSkin().getFont("default"), Config.instance().getAtlas("sprites/items.atlas"), Config.instance().getAtlas("sprites/pixelmana.atlas"));
    }

    public static Font getRewardHeaderFont() {
        return Forge.getAssets().getGenericHeaderFont(Controls.getSkin().getFont("default"));
    }

    public static Font getTextraFont(String name) {
        return Forge.getAssets().getTextraFont(name, Controls.getSkin().getFont(name), Config.instance().getAtlas("sprites/items.atlas"));
    }

    public static TextraLabel newAccountingLabel(TextraLabel target, Boolean isShards) {
        AccountingLabel label = new AccountingLabel(target, isShards);
        return label;
    }

    public static class AccountingLabel
    extends TextraLabel {
        private TextraLabel label;
        private final TextraLabel placeholder;
        private String currencyIcon;
        private boolean isShards;
        private int currencyAmount;
        private float animationDelay = 2.0f;
        private final String NEGDECOR = "[RED]-";
        private final String POSDECOR = "[GREEN]+";
        private final Timer t = new Timer();

        public AccountingLabel(TextraLabel target, boolean isShards) {
            target.setVisible(false);
            this.placeholder = target;
            this.label = Controls.newTextraLabel(target.getName() + "Replacement");
            this.currencyAmount = isShards ? Current.player().getShards() : Current.player().getGold();
            this.isShards = isShards;
            if (isShards) {
                this.currencyAmount = Current.player().getShards();
                this.currencyIcon = "[+Shards]";
                Current.player().onShardsChange(() -> this.update(AdventurePlayer.current().getShards(), true));
            } else {
                this.currencyAmount = Current.player().getGold();
                this.currencyIcon = "[+Gold] ";
                Current.player().onGoldChange(() -> this.update(AdventurePlayer.current().getGold(), true));
            }
            this.label.setText(this.getLabelText(this.currencyAmount));
            this.setName(this.label.getName());
            this.replaceLabel(this.label);
        }

        public void setAnimationDelay(float animationDelay) {
            this.animationDelay = animationDelay;
        }

        public float getAnimationDelay() {
            return this.animationDelay;
        }

        public void update(int newAmount) {
            this.update(newAmount, false);
        }

        public void update(int newAmount, boolean animate) {
            if (animate) {
                TextraLabel temporaryLabel = this.getUpdateLabel(newAmount);
                this.currencyAmount = newAmount;
                this.replaceLabel(temporaryLabel);
                Timer.schedule(new AccountingLabelUpdater(temporaryLabel), this.animationDelay);
            } else {
                this.currencyAmount = newAmount;
                this.drawFinalLabel(false);
            }
        }

        private void drawFinalLabel(boolean fadeIn) {
            TextraLabel finalLabel = this.getDefaultLabel();
            if (fadeIn) {
                SequenceAction sequence = new SequenceAction();
                sequence.addAction(Actions.alpha(0.5f));
                sequence.addAction(Actions.alpha(1.0f, 2.0f, Interpolation.pow2Out));
                finalLabel.addAction(sequence);
            }
            this.replaceLabel(finalLabel);
        }

        private TextraLabel getDefaultLabel() {
            return Controls.newTextraLabel(this.getLabelText(this.currencyAmount));
        }

        private TextraLabel getUpdateLabel(int newAmount) {
            int delta = newAmount - this.currencyAmount;
            String updateText = delta == 0 ? "" : (delta < 0 ? "[RED]-" + delta * -1 : "[GREEN]+" + delta);
            return Controls.newTextraLabel(this.getLabelText(this.currencyAmount, updateText));
        }

        private String getLabelText(int amount) {
            return this.getLabelText(amount, "");
        }

        private String getLabelText(int amount, String updateText) {
            return amount + " " + this.currencyIcon + updateText;
        }

        private void replaceLabel(TextraLabel newLabel) {
            newLabel.setName(this.label.getName());
            newLabel.style = this.placeholder.style;
            newLabel.setBounds(this.placeholder.getX(), this.placeholder.getY(), this.label.getWidth(), this.placeholder.getHeight());
            newLabel.setFont(this.label.getFont());
            newLabel.style = this.placeholder.style;
            newLabel.layout.setBaseColor(this.label.layout.getBaseColor());
            newLabel.layout();
            this.label.remove();
            this.label = newLabel;
            this.placeholder.getStage().addActor(this.label);
        }

        private class AccountingLabelUpdater
        extends Timer.Task {
            TextraLabel target;

            @Override
            public void run() {
                if (AccountingLabel.this.label.equals(this.target)) {
                    AccountingLabel.this.drawFinalLabel(true);
                }
            }

            AccountingLabelUpdater(TextraLabel replacement) {
                this.target = replacement;
            }
        }
    }

    static class TypingButtonFix
    extends TypingButton {
        public TypingButtonFix(@Null String text) {
            super(text == null ? "NULL" : text, Controls.getSkin(), Controls.getTextraFont());
            this.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    super.clicked(event, x, y);
                    SoundSystem.instance.play(SoundEffectType.ButtonPress, false);
                }
            });
        }

        @Override
        public void setStyle(Button.ButtonStyle style, boolean makeGridGlyphs) {
            super.setStyle(style, makeGridGlyphs);
            this.getTextraLabel().setFont(Controls.getTextraFont());
        }

        @Override
        public String getText() {
            return this.getTextraLabel().storedText;
        }

        @Override
        public void setText(@Null String text) {
            this.getTextraLabel().storedText = text;
            this.getTextraLabel().layout.setTargetWidth(this.getTextraLabel().getMaxWidth());
            this.getTextraLabel().getFont().markup(text, this.getTextraLabel().layout.clear());
            this.getTextraLabel().setWidth(this.getTextraLabel().layout.getWidth() + (this.getTextraLabel().style != null && this.getTextraLabel().style.background != null ? this.getTextraLabel().style.background.getLeftWidth() + this.getTextraLabel().style.background.getRightWidth() : 0.0f));
            this.layout();
        }
    }

    static class TextButtonFix
    extends TextraButton {
        public TextButtonFix(@Null String text) {
            super(text == null ? "NULL" : text, Controls.getSkin(), Controls.getTextraFont());
            this.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    super.clicked(event, x, y);
                    SoundSystem.instance.play(SoundEffectType.ButtonPress, false);
                }
            });
        }

        @Override
        public void setStyle(Button.ButtonStyle style, boolean makeGridGlyphs) {
            super.setStyle(style, makeGridGlyphs);
            this.getTextraLabel().setFont(Controls.getTextraFont());
        }

        @Override
        public String getText() {
            return this.getTextraLabel().storedText;
        }

        @Override
        public void setText(@Null String text) {
            this.getTextraLabel().storedText = text;
            this.getTextraLabel().layout.setTargetWidth(this.getTextraLabel().getMaxWidth());
            this.getTextraLabel().getFont().markup(text, this.getTextraLabel().layout.clear());
            this.getTextraLabel().setWidth(this.getTextraLabel().layout.getWidth() + (this.getTextraLabel().style != null && this.getTextraLabel().style.background != null ? this.getTextraLabel().style.background.getLeftWidth() + this.getTextraLabel().style.background.getRightWidth() : 0.0f));
            this.layout();
        }
    }

    static class LabelFix
    extends TextraLabel {
        public LabelFix(String text, Font font) {
            super(text, Controls.getSkin(), font);
        }

        @Override
        public void setText(@Null String text) {
            this.storedText = text;
            this.layout.setTargetWidth(this.getMaxWidth());
            this.getFont().markup(text, this.layout.clear());
            this.setWidth(this.layout.getWidth() + (this.style != null && this.style.background != null ? this.style.background.getLeftWidth() + this.style.background.getRightWidth() : 0.0f));
            this.layout();
        }
    }
}

