/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.util;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Json;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import forge.StaticData;
import forge.adventure.data.ConfigData;
import forge.adventure.data.GeneratedDeckData;
import forge.adventure.data.GeneratedDeckTemplateData;
import forge.adventure.data.RewardData;
import forge.adventure.util.Config;
import forge.adventure.util.Current;
import forge.adventure.util.Reward;
import forge.card.CardEdition;
import forge.card.CardRarity;
import forge.card.CardType;
import forge.card.DeckHints;
import forge.card.MagicColor;
import forge.card.mana.ManaCostShard;
import forge.deck.Deck;
import forge.deck.DeckSection;
import forge.deck.DeckgenUtil;
import forge.deck.io.DeckSerializer;
import forge.game.GameFormat;
import forge.item.BoosterPack;
import forge.item.PaperCard;
import forge.item.SealedTemplate;
import forge.item.generation.UnOpenedProduct;
import forge.model.FModel;
import forge.util.Aggregates;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;

public class CardUtil {
    private static final GameFormat.Collection formats = FModel.getFormats();
    private static final Predicate<CardEdition> filterPioneer = CardUtil.formats.getPioneer().editionLegalPredicate;
    private static final Predicate<CardEdition> filterModern = CardUtil.formats.getModern().editionLegalPredicate;
    private static final Predicate<CardEdition> filterVintage = CardUtil.formats.getVintage().editionLegalPredicate;
    private static final Predicate<CardEdition> filterStandard = CardUtil.formats.getStandard().editionLegalPredicate;

    public static List<PaperCard> getPredicateResult(Iterable<PaperCard> cards, RewardData data) {
        ArrayList<PaperCard> result = new ArrayList<PaperCard>();
        CardPredicate pre = new CardPredicate(data, true);
        for (PaperCard item : cards) {
            if (!pre.apply(item)) continue;
            result.add(item);
        }
        return result;
    }

    public static List<PaperCard> generateCards(Iterable<PaperCard> cards, RewardData data, int count, Random r) {
        boolean allCardVariants = Config.instance().getSettingData().useAllCardVariants;
        ArrayList<PaperCard> result = new ArrayList<PaperCard>();
        List<PaperCard> pool = CardUtil.getPredicateResult(cards, data);
        if (pool.size() > 0) {
            for (int i = 0; i < count; ++i) {
                PaperCard candidate = pool.get(r.nextInt(pool.size()));
                if (candidate == null) continue;
                if (allCardVariants) {
                    PaperCard finalCandidate = CardUtil.getCardByName(candidate.getCardName());
                    result.add(finalCandidate);
                    continue;
                }
                result.add(candidate);
            }
        }
        return result;
    }

    public static int getCardPrice(PaperCard card) {
        if (card == null) {
            return 0;
        }
        switch (card.getRarity()) {
            case BasicLand: {
                return 5;
            }
            case Common: {
                return 50;
            }
            case Uncommon: {
                return 150;
            }
            case Rare: {
                return 300;
            }
            case MythicRare: {
                return 500;
            }
        }
        return 600;
    }

    public static int getRewardPrice(Reward reward) {
        PaperCard card = reward.getCard();
        if (card != null) {
            return CardUtil.getCardPrice(card);
        }
        if (reward.getItem() != null) {
            return reward.getItem().cost;
        }
        if (reward.getType() == Reward.Type.Life) {
            return reward.getCount() * 500;
        }
        if (reward.getType() == Reward.Type.Shards) {
            return reward.getCount() * 500;
        }
        if (reward.getType() == Reward.Type.Gold) {
            return reward.getCount();
        }
        return 1000;
    }

    public static Deck generateDeck(GeneratedDeckData data, CardEdition starterEdition, boolean discourageDuplicates) {
        List<String> editionCodes = starterEdition != null ? Arrays.asList(starterEdition.getCode(), starterEdition.getCode2()) : Arrays.asList("JMP", "J22", "DMU", "BRO", "ONE", "MOM");
        Deck deck = new Deck(data.name);
        if (data.mainDeck != null) {
            deck.getOrCreate(DeckSection.Main).addAllFlat(RewardData.generateAllCards(Arrays.asList(data.mainDeck), true));
            if (data.sideBoard != null) {
                deck.getOrCreate(DeckSection.Sideboard).addAllFlat(RewardData.generateAllCards(Arrays.asList(data.sideBoard), true));
            }
            return deck;
        }
        if (data.jumpstartPacks != null) {
            deck.getOrCreate(DeckSection.Main);
            HashMap<String, Object> packCandidates = null;
            ArrayList<String> usedPackNames = new ArrayList<String>();
            for (int i = 0; i < data.jumpstartPacks.length; ++i) {
                List selectedPack;
                Object packContents;
                String targetName;
                byte targetColor = MagicColor.fromName(data.jumpstartPacks[i]);
                switch (targetColor) {
                    default: {
                        targetName = "Plains";
                        break;
                    }
                    case 2: {
                        targetName = "Island";
                        break;
                    }
                    case 4: {
                        targetName = "Swamp";
                        break;
                    }
                    case 8: {
                        targetName = "Mountain";
                        break;
                    }
                    case 16: {
                        targetName = "Forest";
                    }
                }
                packCandidates = new HashMap<String, Object>();
                for (SealedTemplate template : StaticData.instance().getSpecialBoosters()) {
                    if (!editionCodes.contains(template.getEdition().split("\\s", 2)[0]) || (packContents = new UnOpenedProduct(template).get()).size() < 18 | packContents.size() > 25 || packContents.stream().filter(x -> x.getName().equals(targetName)).count() < 3L) continue;
                    packCandidates.putIfAbsent(template.getEdition(), packContents);
                }
                if (discourageDuplicates) {
                    HashMap<String, List> filteredPackCandidates = new HashMap<String, List>();
                    packContents = packCandidates.entrySet().iterator();
                    while (packContents.hasNext()) {
                        Map.Entry entry = packContents.next();
                        if (usedPackNames.contains(entry.getKey())) continue;
                        filteredPackCandidates.put((String)entry.getKey(), (List)entry.getValue());
                    }
                    if (filteredPackCandidates.size() == 0) {
                        filteredPackCandidates = packCandidates;
                    }
                    Object[] keys = filteredPackCandidates.keySet().toArray();
                    String keyName = (String)keys[Current.world().getRandom().nextInt(keys.length)];
                    usedPackNames.add(keyName);
                    selectedPack = (List)filteredPackCandidates.remove(keyName);
                } else {
                    Object[] keys = packCandidates.keySet().toArray();
                    selectedPack = (List)packCandidates.get((String)keys[Current.world().getRandom().nextInt(keys.length)]);
                }
                int size = 20 - selectedPack.size();
                for (int c = 0; c < size; ++c) {
                    selectedPack.add((PaperCard)Aggregates.random(selectedPack));
                }
                deck.getOrCreate(DeckSection.Main).addAllFlat(selectedPack);
            }
            return deck;
        }
        if (data.template != null) {
            float count = data.template.count;
            float lands = count * 0.4f;
            float spells = count - lands;
            List<RewardData> dataArray = CardUtil.generateRewards(data.template, spells * 0.5f, new int[]{1, 2});
            dataArray.addAll(CardUtil.generateRewards(data.template, spells * 0.3f, new int[]{3, 4, 5}));
            dataArray.addAll(CardUtil.generateRewards(data.template, spells * 0.2f, new int[]{6, 7, 8}));
            List<PaperCard> nonLand = RewardData.generateAllCards(dataArray, true);
            nonLand.addAll(CardUtil.fillWithLands(nonLand, data.template));
            deck.getOrCreate(DeckSection.Main).addAllFlat(nonLand);
        }
        return deck;
    }

    private static List<PaperCard> fillWithLands(List<PaperCard> nonLands, GeneratedDeckTemplateData template) {
        int red = 0;
        int blue = 0;
        int green = 0;
        int white = 0;
        int black = 0;
        int colorLess = 0;
        int cardCount = nonLands.size();
        ArrayList<PaperCard> cards = new ArrayList<PaperCard>();
        boolean allCardVariants = Config.instance().getSettingData().useAllCardVariants;
        for (PaperCard nonLand : nonLands) {
            red += nonLand.getRules().getManaCost().getShardCount(ManaCostShard.RED);
            green += nonLand.getRules().getManaCost().getShardCount(ManaCostShard.GREEN);
            white += nonLand.getRules().getManaCost().getShardCount(ManaCostShard.WHITE);
            blue += nonLand.getRules().getManaCost().getShardCount(ManaCostShard.BLUE);
            black += nonLand.getRules().getManaCost().getShardCount(ManaCostShard.BLACK);
            colorLess += nonLand.getRules().getManaCost().getShardCount(ManaCostShard.GENERIC);
        }
        float sum = red + blue + green + white + black;
        int neededLands = template.count - cardCount;
        int neededDualLands = Math.round((float)neededLands * template.rares);
        int neededBase = neededLands - neededDualLands;
        String edition = "";
        if (allCardVariants) {
            PaperCard templateLand = CardUtil.getCardByName("Plains");
            edition = templateLand.getEdition();
        }
        if ((double)sum == 0.0) {
            cards.addAll(CardUtil.generateLands("Wastes", neededLands));
        } else {
            int mount = Math.round((float)neededBase * ((float)red / sum));
            int island = Math.round((float)neededBase * ((float)blue / sum));
            int forest = Math.round((float)neededBase * ((float)green / sum));
            int plains = Math.round((float)neededBase * ((float)white / sum));
            int swamp = Math.round((float)neededBase * ((float)black / sum));
            cards.addAll(CardUtil.generateLands("Plains", plains, edition));
            cards.addAll(CardUtil.generateLands("Island", island, edition));
            cards.addAll(CardUtil.generateLands("Forest", forest, edition));
            cards.addAll(CardUtil.generateLands("Mountain", mount, edition));
            cards.addAll(CardUtil.generateLands("Swamp", swamp, edition));
            ArrayList<String> landTypes = new ArrayList<String>();
            if (mount > 0) {
                landTypes.add("Mountain");
            }
            if (island > 0) {
                landTypes.add("Island");
            }
            if (plains > 0) {
                landTypes.add("Plains");
            }
            if (swamp > 0) {
                landTypes.add("Swamp");
            }
            if (forest > 0) {
                landTypes.add("Forest");
            }
            cards.addAll(CardUtil.generateDualLands(landTypes, neededDualLands));
        }
        return cards;
    }

    private static Collection<PaperCard> generateDualLands(List<String> landName, int count) {
        RewardData sub1;
        ArrayList<RewardData> rewards = new ArrayList<RewardData>();
        RewardData base = new RewardData();
        rewards.add(base);
        base.cardTypes = new String[]{"Land"};
        base.count = count;
        base.matchAllSubTypes = true;
        if (landName.size() == 1) {
            base.subTypes = new String[]{landName.get(0)};
        } else if (landName.size() == 2) {
            base.subTypes = new String[]{landName.get(0), landName.get(1)};
        } else if (landName.size() == 3) {
            sub1 = new RewardData(base);
            RewardData sub2 = new RewardData(base);
            sub1.count /= 3;
            sub2.count /= 3;
            base.count -= sub1.count;
            base.count -= sub2.count;
            base.subTypes = new String[]{landName.get(0), landName.get(1)};
            sub1.subTypes = new String[]{landName.get(1), landName.get(2)};
            sub2.subTypes = new String[]{landName.get(0), landName.get(2)};
            rewards.addAll(Arrays.asList(sub1, sub2));
        } else if (landName.size() == 4) {
            sub1 = new RewardData(base);
            RewardData sub2 = new RewardData(base);
            RewardData sub3 = new RewardData(base);
            RewardData sub4 = new RewardData(base);
            sub1.count /= 5;
            sub2.count /= 5;
            sub3.count /= 5;
            sub4.count /= 5;
            base.count -= sub1.count;
            base.count -= sub2.count;
            base.count -= sub3.count;
            base.count -= sub4.count;
            base.subTypes = new String[]{landName.get(0), landName.get(1)};
            sub1.subTypes = new String[]{landName.get(0), landName.get(2)};
            sub2.subTypes = new String[]{landName.get(0), landName.get(3)};
            sub3.subTypes = new String[]{landName.get(1), landName.get(2)};
            sub4.subTypes = new String[]{landName.get(1), landName.get(3)};
            rewards.addAll(Arrays.asList(sub1, sub2, sub3, sub4));
        } else if (landName.size() == 5) {
            sub1 = new RewardData(base);
            RewardData sub2 = new RewardData(base);
            RewardData sub3 = new RewardData(base);
            RewardData sub4 = new RewardData(base);
            RewardData sub5 = new RewardData(base);
            RewardData sub6 = new RewardData(base);
            RewardData sub7 = new RewardData(base);
            RewardData sub8 = new RewardData(base);
            RewardData sub9 = new RewardData(base);
            sub1.count /= 10;
            sub2.count /= 10;
            sub3.count /= 10;
            sub4.count /= 10;
            sub5.count /= 10;
            sub6.count /= 10;
            sub7.count /= 10;
            sub8.count /= 10;
            sub9.count /= 10;
            base.count -= sub1.count;
            base.count -= sub2.count;
            base.count -= sub3.count;
            base.count -= sub4.count;
            base.count -= sub5.count;
            base.count -= sub6.count;
            base.count -= sub7.count;
            base.count -= sub8.count;
            base.count -= sub9.count;
            base.subTypes = new String[]{landName.get(0), landName.get(1)};
            sub1.subTypes = new String[]{landName.get(0), landName.get(2)};
            sub2.subTypes = new String[]{landName.get(0), landName.get(3)};
            sub3.subTypes = new String[]{landName.get(0), landName.get(4)};
            sub4.subTypes = new String[]{landName.get(1), landName.get(2)};
            sub5.subTypes = new String[]{landName.get(1), landName.get(3)};
            sub6.subTypes = new String[]{landName.get(1), landName.get(4)};
            sub7.subTypes = new String[]{landName.get(2), landName.get(3)};
            sub8.subTypes = new String[]{landName.get(2), landName.get(4)};
            sub9.subTypes = new String[]{landName.get(3), landName.get(4)};
            rewards.addAll(Arrays.asList(sub1, sub2, sub3, sub4, sub5, sub6, sub7, sub8, sub9));
        }
        ArrayList<PaperCard> ret = new ArrayList<PaperCard>(RewardData.generateAllCards(rewards, true));
        return ret;
    }

    private static Collection<PaperCard> generateLands(String landName, int count) {
        return CardUtil.generateLands(landName, count, "");
    }

    private static Collection<PaperCard> generateLands(String landName, int count, String edition) {
        boolean allCardVariants = Config.instance().getSettingData().useAllCardVariants;
        ArrayList<PaperCard> ret = new ArrayList<PaperCard>();
        if (allCardVariants) {
            if (edition.isEmpty()) {
                PaperCard templateLand = CardUtil.getCardByName(landName);
                edition = templateLand.getEdition();
            }
            for (int i = 0; i < count; ++i) {
                ret.add(CardUtil.getCardByNameAndEdition(landName, edition));
            }
        } else {
            for (int i = 0; i < count; ++i) {
                ret.add(FModel.getMagicDb().getCommonCards().getCard(landName));
            }
        }
        return ret;
    }

    private static List<RewardData> generateRewards(GeneratedDeckTemplateData template, float count, int[] manaCosts) {
        ArrayList<RewardData> ret = new ArrayList<RewardData>();
        ret.addAll(CardUtil.templateGenerate(template, count - count * template.rares, manaCosts, new String[]{"Uncommon", "Common"}));
        ret.addAll(CardUtil.templateGenerate(template, count * template.rares, manaCosts, new String[]{"Rare", "Mythic Rare"}));
        return ret;
    }

    private static ArrayList<RewardData> templateGenerate(GeneratedDeckTemplateData template, float count, int[] manaCosts, String[] strings) {
        ArrayList<RewardData> ret = new ArrayList<RewardData>();
        RewardData base = new RewardData();
        base.manaCosts = manaCosts;
        base.rarity = strings;
        base.colors = template.colors;
        if (template.tribe != null && !template.tribe.isEmpty()) {
            RewardData caresAbout = new RewardData(base);
            caresAbout.cardText = "\\b" + template.tribe + "\\b";
            caresAbout.count = Math.round(count * template.tribeSynergyCards);
            ret.add(caresAbout);
            base.subTypes = new String[]{template.tribe};
            base.count = Math.round(count * (1.0f - template.tribeSynergyCards));
        } else {
            base.count = Math.round(count);
        }
        ret.add(base);
        return ret;
    }

    public static Deck getDeck(String path, boolean forAI, boolean isFantasyMode, String colors, boolean isTheme, boolean useGeneticAI) {
        return CardUtil.getDeck(path, forAI, isFantasyMode, colors, isTheme, useGeneticAI, null, true);
    }

    public static Deck getDeck(String path, boolean forAI, boolean isFantasyMode, String colors, boolean isTheme, boolean useGeneticAI, CardEdition starterEdition, boolean discourageDuplicates) {
        Deck deck;
        if (path.endsWith(".dck")) {
            FileHandle fileHandle = Config.instance().getFile(path);
            Deck deck2 = null;
            if (fileHandle != null) {
                deck2 = DeckSerializer.fromFile(fileHandle.file());
            }
            if (deck2 == null) {
                deck2 = DeckgenUtil.getRandomOrPreconOrThemeDeck(colors, true, false, true);
                System.err.println("Error loading Deck: " + path + "\nGenerating random deck: " + deck2.getName());
            }
            return deck2;
        }
        if (forAI && (isFantasyMode || useGeneticAI) && (deck = DeckgenUtil.getRandomOrPreconOrThemeDeck(colors, forAI, isTheme, useGeneticAI)) != null) {
            return deck;
        }
        Json json = new Json();
        FileHandle handle = Config.instance().getFile(path);
        if (handle.exists()) {
            return CardUtil.generateDeck(json.fromJson(GeneratedDeckData.class, handle), starterEdition, discourageDuplicates);
        }
        Deck deck3 = DeckgenUtil.getRandomOrPreconOrThemeDeck(colors, true, false, true);
        System.err.println("Error loading JSON: " + handle.path() + "\nGenerating random deck: " + deck3.getName());
        return deck3;
    }

    public static Deck generateStandardBoosterAsDeck() {
        return CardUtil.generateRandomBoosterPackAsDeck(filterStandard);
    }

    public static Deck generatePioneerBoosterAsDeck() {
        return CardUtil.generateRandomBoosterPackAsDeck(filterPioneer);
    }

    public static Deck generateModernBoosterAsDeck() {
        return CardUtil.generateRandomBoosterPackAsDeck(filterModern);
    }

    public static Deck generateVintageBoosterAsDeck() {
        return CardUtil.generateRandomBoosterPackAsDeck(filterVintage);
    }

    public static Deck generateBoosterPackAsDeck(String code) {
        CardEdition edition;
        ConfigData configData = Config.instance().getConfigData();
        if (configData.allowedEditions != null) {
            if (!Arrays.asList(configData.allowedEditions).contains(code)) {
                System.err.println("Cannot generate booster pack, '" + code + "' is not an allowed edition");
            }
        } else if (Arrays.asList(configData.restrictedEditions).contains(code)) {
            System.err.println("Cannot generate booster pack, '" + code + "' is a restricted edition");
        }
        if ((edition = StaticData.instance().getEditions().get(code)) == null) {
            System.err.println("Set code '" + code + "' not found.");
            return new Deck();
        }
        BoosterPack cards = BoosterPack.fromSet(edition);
        return CardUtil.generateBoosterPackAsDeck(edition);
    }

    public static Deck generateBoosterPackAsDeck(CardEdition edition) {
        Deck d = new Deck("Booster pack");
        d.setComment(edition.getCode());
        d.getMain().add((Iterable<PaperCard>)BoosterPack.fromSet(edition).getCards());
        return d;
    }

    public static Deck generateRandomBoosterPackAsDeck(Predicate<CardEdition> editionFilter) {
        Predicate<CardEdition> filter = Predicates.and(CardEdition.Predicates.CAN_MAKE_BOOSTER, editionFilter);
        Iterable<CardEdition> possibleEditions = Iterables.filter(FModel.getMagicDb().getEditions(), filter);
        if (!possibleEditions.iterator().hasNext()) {
            System.err.println("No sets found matching edition filter that can create boosters.");
            return null;
        }
        CardEdition edition = Aggregates.random(possibleEditions);
        return CardUtil.generateBoosterPackAsDeck(edition);
    }

    public static PaperCard getCardByName(String cardName) {
        List<PaperCard> validCards = Arrays.asList(Iterables.toArray(Iterables.filter(CardUtil.getFullCardPool(Config.instance().getSettingData().useAllCardVariants), input -> input.getCardName().equals(cardName)), PaperCard.class));
        return validCards.get(Current.world().getRandom().nextInt(validCards.size()));
    }

    public static PaperCard getCardByNameAndEdition(String cardName, String edition) {
        List<PaperCard> validCards = Arrays.asList(Iterables.toArray(Iterables.filter(CardUtil.getFullCardPool(Config.instance().getSettingData().useAllCardVariants), input -> input.getCardName().equals(cardName) && input.getEdition().equals(edition)), PaperCard.class));
        if (validCards.isEmpty()) {
            System.err.println("Unexpected behavior: tried to call getCardByNameAndEdition for card " + cardName + " from the edition " + edition + ", but didn't find it in the DB. A random existing instance will be returned.");
            return CardUtil.getCardByName(cardName);
        }
        return validCards.get(Current.world().getRandom().nextInt(validCards.size()));
    }

    public static Collection<PaperCard> getFullCardPool(boolean allCardVariants) {
        return allCardVariants ? FModel.getMagicDb().getCommonCards().getAllCards() : FModel.getMagicDb().getCommonCards().getUniqueCardsNoAlt();
    }

    public static final class CardPredicate
    implements Predicate<PaperCard> {
        private final List<CardRarity> rarities = new ArrayList<CardRarity>();
        private final List<String> editions = new ArrayList<String>();
        private final List<String> subType = new ArrayList<String>();
        private final List<String> keyWords = new ArrayList<String>();
        private final List<CardType.CoreType> type = new ArrayList<CardType.CoreType>();
        private final List<CardType.Supertype> superType = new ArrayList<CardType.Supertype>();
        private final List<Integer> manaCosts = new ArrayList<Integer>();
        private final Pattern text;
        private final boolean matchAllSubTypes;
        private final boolean matchAllColors;
        private int colors;
        private final ColorType colorType;
        private final boolean shouldBeEqual;
        private final List<String> deckNeeds = new ArrayList<String>();
        private final String minDate;
        private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");

        private static Date parseDate(String date) {
            if (date.length() <= 7) {
                date = date + "-01";
            }
            try {
                return formatter.parse(date);
            }
            catch (Exception e) {
                return new Date();
            }
        }

        @Override
        public boolean apply(PaperCard card) {
            Iterator<CardType.Supertype> allPrintings;
            boolean found;
            if (!this.rarities.isEmpty() && !this.rarities.contains((Object)card.getRarity())) {
                return !this.shouldBeEqual;
            }
            if (!this.editions.isEmpty() && !this.editions.contains(card.getEdition())) {
                found = false;
                allPrintings = FModel.getMagicDb().getCommonCards().getAllCards(card.getCardName());
                Iterator iterator = allPrintings.iterator();
                while (iterator.hasNext()) {
                    PaperCard c = (PaperCard)iterator.next();
                    if (!this.editions.contains(c.getEdition())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return !this.shouldBeEqual;
                }
            }
            if (!this.minDate.isEmpty()) {
                found = false;
                allPrintings = FModel.getMagicDb().getCommonCards().getAllCards(card.getCardName());
                ArrayList<CardEdition> arrayList = new ArrayList<CardEdition>();
                Date d = CardPredicate.parseDate(this.minDate);
                for (CardEdition e : FModel.getMagicDb().getEditions()) {
                    if (e.getDate().before(d)) continue;
                    arrayList.add(e);
                }
                Iterator<Object> iterator = allPrintings.iterator();
                block7: while (iterator.hasNext()) {
                    PaperCard c = (PaperCard)iterator.next();
                    for (CardEdition e : arrayList) {
                        if (!e.getCode().equals(c.getEdition())) continue;
                        found = true;
                        continue block7;
                    }
                }
                if (!found) {
                    return !this.shouldBeEqual;
                }
            }
            if (!this.manaCosts.isEmpty() && !this.manaCosts.contains(card.getRules().getManaCost().getCMC())) {
                return !this.shouldBeEqual;
            }
            if (this.text != null && !this.text.matcher(card.getRules().getOracleText()).find()) {
                return !this.shouldBeEqual;
            }
            if (this.matchAllColors && !card.getRules().getColor().hasAllColors(this.colors)) {
                return !this.shouldBeEqual;
            }
            if (this.colors != 31 && (!card.getRules().getColor().hasNoColorsExcept(this.colors) || this.colors != 0 && card.getRules().getColor().isColorless())) {
                return !this.shouldBeEqual;
            }
            if (this.colorType != ColorType.Any) {
                switch (this.colorType) {
                    case Colorless: {
                        if (card.getRules().getColor().isColorless()) break;
                        return !this.shouldBeEqual;
                    }
                    case MonoColor: {
                        if (card.getRules().getColor().isMonoColor()) break;
                        return !this.shouldBeEqual;
                    }
                    case MultiColor: {
                        if (card.getRules().getColor().isMulticolor()) break;
                        return !this.shouldBeEqual;
                    }
                }
            }
            if (!this.type.isEmpty()) {
                found = false;
                for (CardType.CoreType coreType : card.getRules().getType().getCoreTypes()) {
                    if (!this.type.contains((Object)coreType)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return !this.shouldBeEqual;
                }
            }
            if (!this.superType.isEmpty()) {
                found = false;
                for (CardType.Supertype supertype : card.getRules().getType().getSupertypes()) {
                    if (!this.superType.contains((Object)supertype)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return !this.shouldBeEqual;
                }
            }
            if (this.matchAllSubTypes) {
                if (!this.subType.isEmpty()) {
                    if (this.subType.size() != Iterables.size(card.getRules().getType().getSubtypes())) {
                        return !this.shouldBeEqual;
                    }
                    for (String subtype : card.getRules().getType().getSubtypes()) {
                        if (this.subType.contains(subtype)) continue;
                        return !this.shouldBeEqual;
                    }
                }
            } else if (!this.subType.isEmpty()) {
                found = false;
                for (String string : card.getRules().getType().getSubtypes()) {
                    if (!this.subType.contains(string)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return !this.shouldBeEqual;
                }
            }
            if (!this.keyWords.isEmpty()) {
                boolean found2 = false;
                for (String string : this.keyWords) {
                    if (!card.getRules().hasKeyword(string)) continue;
                    found2 = true;
                    break;
                }
                if (!found2) {
                    return !this.shouldBeEqual;
                }
            }
            if (!this.deckNeeds.isEmpty()) {
                boolean found3 = false;
                for (String string : this.deckNeeds) {
                    String[] parts = string.split("\\$");
                    if (parts.length != 2) continue;
                    DeckHints.Type t2 = DeckHints.Type.valueOf(parts[0].toUpperCase());
                    DeckHints hints = card.getRules().getAiHints().getDeckHints();
                    if (hints == null || !hints.contains(t2, parts[1])) continue;
                    found3 = true;
                    break;
                }
                if (!found3) {
                    return !this.shouldBeEqual;
                }
            }
            return this.shouldBeEqual;
        }

        private Pattern getPattern(RewardData type) {
            if (type.cardText == null || type.cardText.isEmpty()) {
                return null;
            }
            try {
                return Pattern.compile(type.cardText, 2);
            }
            catch (Exception e) {
                System.err.println("[" + type.cardName + "|" + type.itemName + "]\n" + e);
                return null;
            }
        }

        public CardPredicate(RewardData type, boolean wantEqual) {
            this.matchAllSubTypes = type.matchAllSubTypes;
            this.matchAllColors = type.matchAllColors;
            this.shouldBeEqual = wantEqual;
            for (int i = 0; type.manaCosts != null && i < type.manaCosts.length; ++i) {
                this.manaCosts.add(type.manaCosts[i]);
            }
            this.text = this.getPattern(type);
            if (type.colors == null || type.colors.length == 0) {
                this.colors = 31;
            } else {
                this.colors = 0;
                for (String color : type.colors) {
                    if ("colorID".equals(color)) {
                        for (byte c : Current.player().getColorIdentity()) {
                            this.colors |= c;
                        }
                        continue;
                    }
                    this.colors |= MagicColor.fromName(color.toLowerCase());
                }
            }
            if (type.keyWords != null && type.keyWords.length != 0) {
                this.keyWords.addAll(Arrays.asList(type.keyWords));
            }
            if (type.rarity != null && type.rarity.length != 0) {
                for (String rarity : type.rarity) {
                    this.rarities.add(CardRarity.smartValueOf(rarity));
                }
            }
            if (type.subTypes != null && type.subTypes.length != 0) {
                this.subType.addAll(Arrays.asList(type.subTypes));
            }
            if (type.editions != null && type.editions.length != 0) {
                this.editions.addAll(Arrays.asList(type.editions));
            }
            if (type.superTypes != null && type.superTypes.length != 0) {
                for (String string : type.superTypes) {
                    this.superType.add(CardType.Supertype.getEnum(string));
                }
            }
            if (type.cardTypes != null && type.cardTypes.length != 0) {
                for (String string : type.cardTypes) {
                    this.type.add(CardType.CoreType.getEnum(string));
                }
            }
            this.colorType = type.colorType != null && !type.colorType.isEmpty() ? ColorType.valueOf(type.colorType) : ColorType.Any;
            if (type.deckNeeds != null && type.deckNeeds.length != 0) {
                this.deckNeeds.addAll(Arrays.asList(type.deckNeeds));
            }
            this.minDate = type.minDate != null && !type.minDate.isEmpty() ? type.minDate : "";
        }

        static enum ColorType {
            Any,
            Colorless,
            MultiColor,
            MonoColor;

        }
    }
}

