/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.util;

import com.badlogic.gdx.utils.Array;
import forge.StaticData;
import forge.adventure.data.AdventureEventData;
import forge.adventure.player.AdventurePlayer;
import forge.adventure.pointofintrest.PointOfInterestChanges;
import forge.adventure.util.Current;
import forge.deck.Deck;
import forge.item.PaperCard;
import forge.item.SealedTemplate;
import forge.item.generation.BoosterGenerator;
import forge.item.generation.UnOpenedProduct;
import forge.model.CardBlock;
import forge.util.Aggregates;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class AdventureEventController
implements Serializable {
    private static AdventureEventController object;
    private transient Array<AdventureEventData> allEvents = new Array();
    private Map<String, Long> nextEventDate = new HashMap<String, Long>();

    public void finalizeEvent(AdventureEventData completedEvent) {
        Current.player().getStatistic().setResult(completedEvent);
        Current.player().removeEvent(completedEvent);
    }

    public static AdventureEventController instance() {
        if (object == null) {
            object = new AdventureEventController();
        }
        return object;
    }

    private AdventureEventController() {
    }

    public AdventureEventController(AdventureEventController other) {
        if (object == null) {
            object = this;
        } else {
            System.out.println("Could not initialize AdventureEventController. An instance already exists and cannot be merged.");
        }
    }

    public static void clear() {
        object = null;
    }

    public AdventureEventData createEvent(EventStyle style, String pointID, int eventOrigin, PointOfInterestChanges changes) {
        long placeSeed;
        long room;
        if (this.nextEventDate.containsKey(pointID) && this.nextEventDate.get(pointID) >= LocalDate.now().toEpochDay()) {
            return null;
        }
        long timeSeed = LocalDate.now().toEpochDay();
        long eventSeed = timeSeed > (room = Long.MAX_VALUE - (placeSeed = Long.parseLong(pointID.replaceAll("[^0-9]", "")))) ? Long.MIN_VALUE + timeSeed - room : timeSeed + placeSeed;
        Random random = new Random(eventSeed);
        AdventureEventData e = random.nextInt(10) <= 2 ? new AdventureEventData(eventSeed, EventFormat.Jumpstart) : new AdventureEventData(eventSeed, EventFormat.Draft);
        if (e.cardBlock == null) {
            return null;
        }
        e.sourceID = pointID;
        e.eventOrigin = eventOrigin;
        e.eventRules = new AdventureEventData.AdventureEventRules(e.format, changes.getTownPriceModifier());
        e.style = style;
        switch (style) {
            case Swiss: 
            case Bracket: {
                e.rounds = e.participants.length / 2 - 1;
                break;
            }
            case RoundRobin: {
                e.rounds = e.participants.length - 1;
            }
        }
        AdventurePlayer.current().addEvent(e);
        this.nextEventDate.put(pointID, LocalDate.now().toEpochDay() + (long)new Random().nextInt(2));
        return e;
    }

    public Deck generateBooster(String setCode) {
        List<PaperCard> cards = BoosterGenerator.getBoosterPack(StaticData.instance().getBoosters().get(setCode));
        Deck output = new Deck();
        output.getMain().add((Iterable<PaperCard>)cards);
        output.setName("Booster Pack: " + setCode);
        output.setComment(setCode);
        return output;
    }

    public List<Deck> getJumpstartBoosters(CardBlock block, int count) {
        ArrayList<Deck> packsAsDecks = new ArrayList<Deck>();
        for (SealedTemplate template : StaticData.instance().getSpecialBoosters()) {
            if (!template.getEdition().contains(block.getLandSet().getCode())) continue;
            UnOpenedProduct toOpen = new UnOpenedProduct(template);
            Deck contents = new Deck();
            contents.getMain().add((Iterable<PaperCard>)toOpen.get());
            int size = contents.getMain().toFlatList().size();
            if (size < 18 || size > 25) continue;
            contents.setName(template.getEdition());
            int black = 0;
            int blue = 0;
            int green = 0;
            int red = 0;
            int white = 0;
            int multi = 0;
            int colorless = 0;
            for (PaperCard card : contents.getMain().toFlatList()) {
                int colors = 0;
                if (card.getRules().getColorIdentity().hasBlack()) {
                    ++black;
                    ++colors;
                }
                if (card.getRules().getColorIdentity().hasBlue()) {
                    ++blue;
                    ++colors;
                }
                if (card.getRules().getColorIdentity().hasGreen()) {
                    ++green;
                    ++colors;
                }
                if (card.getRules().getColorIdentity().hasRed()) {
                    ++red;
                    ++colors;
                }
                if (card.getRules().getColorIdentity().hasWhite()) {
                    ++white;
                    ++colors;
                }
                if (colors == 0 && !card.getRules().getType().isLand()) {
                    ++colorless;
                    continue;
                }
                if (colors <= 1) continue;
                ++multi;
            }
            if (multi > 3) {
                contents.getTags().add("multicolor");
            }
            if (colorless > 3) {
                contents.getTags().add("colorless");
            }
            if (black > 3) {
                contents.getTags().add("black");
            }
            if (blue > 3) {
                contents.getTags().add("blue");
            }
            if (green > 3) {
                contents.getTags().add("green");
            }
            if (red > 3) {
                contents.getTags().add("red");
            }
            if (white > 3) {
                contents.getTags().add("white");
            }
            packsAsDecks.add(contents);
        }
        while (packsAsDecks.size() > count) {
            Aggregates.removeRandom(packsAsDecks);
        }
        return packsAsDecks;
    }

    public static enum EventStatus {
        Available,
        Entered,
        Ready,
        Started,
        Completed,
        Awarded,
        Abandoned;

    }

    public static enum EventStyle {
        Bracket,
        RoundRobin,
        Swiss;

    }

    public static enum EventFormat {
        Draft,
        Sealed,
        Jumpstart,
        Constructed;

    }
}

