/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.stage;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import forge.StaticData;
import forge.adventure.character.PlayerSprite;
import forge.adventure.data.BiomeData;
import forge.adventure.data.EnemyData;
import forge.adventure.data.PointOfInterestData;
import forge.adventure.data.WorldData;
import forge.adventure.pointofintrest.PointOfInterest;
import forge.adventure.stage.GameHUD;
import forge.adventure.stage.GameStage;
import forge.adventure.stage.MapStage;
import forge.adventure.stage.WorldStage;
import forge.adventure.util.Current;
import forge.adventure.world.WorldSave;
import forge.card.ColorSet;
import forge.deck.Deck;
import forge.deck.DeckProxy;
import forge.game.GameType;
import forge.item.PaperCard;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConsoleCommandInterpreter {
    private static ConsoleCommandInterpreter instance;
    Command root = new Command();

    public String complete(String text) {
        String[] words = this.splitOnSpace(text);
        Command currentCommand = this.root;
        StringBuilder completionString = new StringBuilder();
        for (String name : words) {
            if (!currentCommand.children.containsKey(name)) {
                for (String key : currentCommand.children.keySet()) {
                    if (!key.startsWith(name)) continue;
                    return completionString + key + " ";
                }
                break;
            }
            completionString.append(name).append(" ");
            currentCommand = currentCommand.children.get(name);
        }
        return text;
    }

    private String[] splitOnSpace(String text) {
        ArrayList<String> matchList = new ArrayList<String>();
        Pattern regex = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");
        Matcher regexMatcher = regex.matcher(text);
        while (regexMatcher.find()) {
            if (regexMatcher.group(1) != null) {
                matchList.add(regexMatcher.group(1));
                continue;
            }
            if (regexMatcher.group(2) != null) {
                matchList.add(regexMatcher.group(2));
                continue;
            }
            matchList.add(regexMatcher.group());
        }
        return matchList.toArray(new String[0]);
    }

    public String command(String text) {
        String name;
        int i;
        String[] words = this.splitOnSpace(text);
        Command currentCommand = this.root;
        for (i = 0; i < words.length && currentCommand.children.containsKey(name = words[i]); ++i) {
            currentCommand = currentCommand.children.get(name);
        }
        if (currentCommand.function == null) {
            return "Command not found. Available commands:\n" + String.join((CharSequence)" ", Arrays.copyOfRange(words, 0, i)) + "\n" + String.join((CharSequence)"\n", currentCommand.children.keySet());
        }
        String[] parameters = Arrays.copyOfRange(words, i, words.length);
        for (int j = 0; j < parameters.length; ++j) {
            parameters[j] = parameters[j].replaceAll("[\"']", "");
        }
        return currentCommand.function.apply(parameters);
    }

    void registerCommand(String[] path, Function<String[], String> function) {
        if (path.length == 0) {
            return;
        }
        Command currentCommand = this.root;
        for (String name : path) {
            if (!currentCommand.children.containsKey(name)) {
                currentCommand.children.put(name, new Command());
            }
            currentCommand = currentCommand.children.get(name);
        }
        currentCommand.function = function;
    }

    public static ConsoleCommandInterpreter getInstance() {
        if (instance == null) {
            instance = new ConsoleCommandInterpreter();
        }
        return instance;
    }

    GameStage currentGameStage() {
        return MapStage.getInstance().isInMap() ? MapStage.getInstance() : WorldStage.getInstance();
    }

    PlayerSprite currentSprite() {
        return this.currentGameStage().getPlayerSprite();
    }

    private ConsoleCommandInterpreter() {
        this.registerCommand(new String[]{"teleport", "to"}, s2 -> {
            if (((String[])s2).length < 2) {
                return "Command needs 2 parameter";
            }
            try {
                int x = Integer.parseInt(s2[0]);
                int y = Integer.parseInt(s2[1]);
                WorldStage.getInstance().setPosition(new Vector2(x, y));
                WorldStage.getInstance().player.playEffect("particle_effects/teleport.p", 10.0f);
                return "teleport to (" + s2[0] + "," + s2[1] + ")";
            }
            catch (Exception e) {
                return "Exception occured, Invalid input";
            }
        });
        this.registerCommand(new String[]{"teleport", "to", "poi"}, s2 -> {
            if (((String[])s2).length < 1) {
                return "Command needs 1 parameter: PoI name.";
            }
            PointOfInterest poi = Current.world().findPointsOfInterest(s2[0]);
            if (poi == null) {
                return "PoI " + s2[0] + " not found";
            }
            WorldStage.getInstance().setPosition(poi.getPosition());
            WorldStage.getInstance().player.playEffect("particle_effects/teleport.p", 10.0f);
            return "Teleported to " + s2[0] + "(" + poi.getPosition() + ")";
        });
        this.registerCommand(new String[]{"spawn", "enemy"}, s2 -> {
            if (((String[])s2).length < 1) {
                return "Command needs 1 parameter: enemy name.";
            }
            if (WorldStage.getInstance().spawn(s2[0])) {
                return "Spawn " + s2[0];
            }
            return "Can not find enemy " + s2[0];
        });
        this.registerCommand(new String[]{"give", "gold"}, s2 -> {
            int amount;
            if (((String[])s2).length < 1) {
                return "Command needs 1 parameter: Amount.";
            }
            try {
                amount = Integer.parseInt(s2[0]);
            }
            catch (Exception e) {
                return "Can not convert " + s2[0] + " to number";
            }
            Current.player().giveGold(amount);
            return "Added " + amount + " gold";
        });
        this.registerCommand(new String[]{"give", "quest"}, s2 -> {
            int ID;
            if (((String[])s2).length < 1) {
                return "Command needs 1 parameter: QuestID";
            }
            try {
                ID = Integer.parseInt(s2[0]);
            }
            catch (Exception e) {
                return "Can not convert " + s2[0] + " to number";
            }
            Current.player().addQuest(ID);
            return "Quest generated";
        });
        this.registerCommand(new String[]{"give", "shards"}, s2 -> {
            int amount;
            if (((String[])s2).length < 1) {
                return "Command needs 1 parameter: Amount.";
            }
            try {
                amount = Integer.parseInt(s2[0]);
            }
            catch (Exception e) {
                return "Can not convert " + s2[0] + " to number";
            }
            Current.player().addShards(amount);
            return "Added " + amount + " shards";
        });
        this.registerCommand(new String[]{"give", "life"}, s2 -> {
            int amount;
            if (((String[])s2).length < 1) {
                return "Command needs 1 parameter: Amount.";
            }
            try {
                amount = Integer.parseInt(s2[0]);
            }
            catch (Exception e) {
                return "Can not convert " + s2[0] + " to number";
            }
            Current.player().addMaxLife(amount);
            return "Added " + amount + " max life";
        });
        this.registerCommand(new String[]{"leave"}, s2 -> {
            if (!MapStage.getInstance().isInMap()) {
                return "not on a map";
            }
            MapStage.getInstance().exitDungeon(false);
            return "Got out";
        });
        this.registerCommand(new String[]{"debug", "collision"}, s2 -> {
            this.currentGameStage().debugCollision(true);
            return "Got out";
        });
        this.registerCommand(new String[]{"give", "card"}, s2 -> {
            if (((String[])s2).length < 1) {
                return "Command needs 1 parameter: Card name.";
            }
            PaperCard card = StaticData.instance().getCommonCards().getCard(s2[0]);
            if (card == null) {
                return "Cannot find card: " + s2[0];
            }
            Current.player().addCard(card);
            return "Added card: " + s2[0];
        });
        this.registerCommand(new String[]{"give", "nosell", "card"}, s2 -> {
            if (((String[])s2).length < 1) {
                return "Command needs 1 parameter: Card name.";
            }
            PaperCard card = StaticData.instance().getCommonCards().getCard(s2[0]);
            if (card == null) {
                return "Cannot find card: " + s2[0];
            }
            Current.player().addCard(card);
            Current.player().noSellCards.add(card);
            return "Added card: " + s2[0];
        });
        this.registerCommand(new String[]{"give", "item"}, s2 -> {
            if (((String[])s2).length < 1) {
                return "Command needs 1 parameter: Item name.";
            }
            if (Current.player().addItem(s2[0])) {
                return "Added item " + s2[0] + ".";
            }
            return "Cannot find item " + s2[0];
        });
        this.registerCommand(new String[]{"fullHeal"}, s2 -> {
            Current.player().fullHeal();
            this.currentSprite().playEffect("particle_effects/heal.p");
            return "Player fully healed. Health set to " + Current.player().getLife() + ".";
        });
        this.registerCommand(new String[]{"listPOI"}, s2 -> {
            ArrayList<String> poiNames = new ArrayList<String>();
            List<BiomeData> biomeData = WorldSave.getCurrentSave().getWorld().getData().GetBiomes();
            for (BiomeData data : biomeData) {
                for (PointOfInterestData poi : data.getPointsOfInterest()) {
                    poiNames.add(poi.name + " - " + poi.type);
                }
            }
            System.out.println("POI Names - Types\n" + String.join((CharSequence)"\n", poiNames));
            return "POI lists dumped to stdout.";
        });
        this.registerCommand(new String[]{"setColorID"}, s2 -> {
            if (((String[])s2).length < 1) {
                return "Please specify color ID: Valid choices: B, G, R, U, W, C. Example:\n\"setColorID G\"";
            }
            Current.player().setColorIdentity(s2[0]);
            return "Player color identity set to " + Current.player().getColorIdentity() + ".";
        });
        this.registerCommand(new String[]{"resetQuests"}, s2 -> {
            Current.player().resetQuestFlags();
            return "All global quest flags have been reset.";
        });
        this.registerCommand(new String[]{"resetMapQuests"}, s2 -> {
            if (!MapStage.getInstance().isInMap()) {
                return "Only supported inside a map.";
            }
            MapStage.getInstance().resetQuestFlags();
            return "All local quest flags have been reset.";
        });
        this.registerCommand(new String[]{"dumpEnemyDeckColors"}, s2 -> {
            for (EnemyData E : new Array.ArrayIterator<EnemyData>(WorldData.getAllEnemies())) {
                Deck D = E.generateDeck(Current.player().isFantasyMode(), Current.player().isUsingCustomDeck() || Current.player().isHardorInsaneDifficulty());
                DeckProxy DP = new DeckProxy(D, "Constructed", GameType.Constructed, null);
                ColorSet colorSet = DP.getColor();
                System.out.printf("%s: Colors: %s (%s%s%s%s%s%s)\n", D.getName(), DP.getColor(), colorSet.hasBlack() ? "B" : "", colorSet.hasGreen() ? "G" : "", colorSet.hasRed() ? "R" : "", colorSet.hasBlue() ? "U" : "", colorSet.hasWhite() ? "W" : "", colorSet.isColorless() ? "C" : "");
            }
            return "Enemy deck color list dumped to stdout.";
        });
        this.registerCommand(new String[]{"dumpEnemyDeckList"}, s2 -> {
            for (EnemyData E : new Array.ArrayIterator<EnemyData>(WorldData.getAllEnemies())) {
                Deck D = E.generateDeck(Current.player().isFantasyMode(), Current.player().isUsingCustomDeck() || Current.player().isHardorInsaneDifficulty());
                DeckProxy DP = new DeckProxy(D, "Constructed", GameType.Constructed, null);
                System.out.printf("Deck: %s\n%s\n\n", D.getName(), DP.getDeck().getMain().toCardList("\n"));
            }
            return "Enemy deck list dumped to stdout.";
        });
        this.registerCommand(new String[]{"dumpEnemyColorIdentity"}, s2 -> {
            for (EnemyData E : new Array.ArrayIterator<EnemyData>(WorldData.getAllEnemies())) {
                Deck D = E.generateDeck(Current.player().isFantasyMode(), Current.player().isUsingCustomDeck() || Current.player().isHardorInsaneDifficulty());
                DeckProxy DP = new DeckProxy(D, "Constructed", GameType.Constructed, null);
                System.out.printf("%s Colors: %s | Deck Colors: %s (%s)%s\n", E.name, E.colors, DP.getColorIdentity().toEnumSet().toString(), DP.getName(), E.boss ? " - BOSS" : "");
            }
            return "Enemy color Identity dumped to stdout.";
        });
        this.registerCommand(new String[]{"heal", "amount"}, s2 -> {
            if (((String[])s2).length < 1) {
                return "Command needs 1 parameter: Amount";
            }
            int N2 = 0;
            try {
                N2 = Integer.parseInt(s2[0]);
            }
            catch (Exception e) {
                return "Can not convert " + s2[0] + " to integer";
            }
            Current.player().heal(N2);
            this.currentSprite().playEffect("particle_effects/heal.p");
            return "Player healed to " + Current.player().getLife() + "/" + Current.player().getMaxLife();
        });
        this.registerCommand(new String[]{"heal", "percent"}, s2 -> {
            if (((String[])s2).length < 1) {
                return "Command needs 1 parameter: Amount";
            }
            float value = 0.0f;
            try {
                value = Float.parseFloat(s2[0]);
            }
            catch (Exception e) {
                return "Can not convert " + s2[0] + " to integer";
            }
            Current.player().heal(value);
            this.currentSprite().playEffect("particle_effects/heal.p");
            return "Player healed to " + Current.player().getLife() + "/" + Current.player().getMaxLife();
        });
        this.registerCommand(new String[]{"heal", "full"}, s2 -> {
            Current.player().fullHeal();
            this.currentSprite().playEffect("particle_effects/heal.p");
            return "Player healed to " + Current.player().getLife() + "/" + Current.player().getMaxLife();
        });
        this.registerCommand(new String[]{"getShards", "amount"}, s2 -> {
            int value;
            if (((String[])s2).length < 1) {
                return "Command needs 1 parameter: Amount";
            }
            try {
                value = Integer.parseInt(s2[0]);
            }
            catch (Exception e) {
                return "Can not convert " + s2[0] + " to integer";
            }
            Current.player().addShards(value);
            return "Player now has " + Current.player().getShards() + " shards";
        });
        this.registerCommand(new String[]{"debug", "map"}, s2 -> {
            GameHUD.getInstance().setDebug(true);
            return "Debug map ON";
        });
        this.registerCommand(new String[]{"debug", "off"}, s2 -> {
            GameHUD.getInstance().setDebug(true);
            this.currentGameStage().debugCollision(false);
            return "Debug  OFF";
        });
        this.registerCommand(new String[]{"remove", "enemy", "all"}, s2 -> {
            if (!MapStage.getInstance().isInMap()) {
                return "Only supported for PoI";
            }
            MapStage.getInstance().removeAllEnemies();
            return "removed all enemies";
        });
        this.registerCommand(new String[]{"hide"}, s2 -> {
            if (((String[])s2).length < 1) {
                return "Command needs 1 parameter: Amount";
            }
            float value = 0.0f;
            try {
                value = Float.parseFloat(s2[0]);
            }
            catch (Exception e) {
                return "Can not convert " + s2[0] + " to float";
            }
            this.currentGameStage().hideFor(value);
            return "removed all enemies";
        });
        this.registerCommand(new String[]{"fly"}, s2 -> {
            if (((String[])s2).length < 1) {
                return "Command needs 1 parameter: Amount";
            }
            float value = 0.0f;
            try {
                value = Float.parseFloat(s2[0]);
            }
            catch (Exception e) {
                return "Can not convert " + s2[0] + " to float";
            }
            this.currentGameStage().flyFor(value);
            return "removed all enemies";
        });
        this.registerCommand(new String[]{"sprint"}, s2 -> {
            if (((String[])s2).length < 1) {
                return "Command needs 1 parameter: Amount";
            }
            float value = 0.0f;
            try {
                value = Float.parseFloat(s2[0]);
            }
            catch (Exception e) {
                return "Can not convert " + s2[0] + " to float";
            }
            this.currentGameStage().sprintFor(value);
            return "removed all enemies";
        });
        this.registerCommand(new String[]{"remove", "enemy", "nearest"}, s2 -> {
            WorldStage.getInstance().removeNearestEnemy();
            return "removed all enemies";
        });
        this.registerCommand(new String[]{"remove", "enemy"}, s2 -> {
            int id;
            if (((String[])s2).length < 1) {
                return "Command needs 1 parameter: Enemy map ID.";
            }
            try {
                id = Integer.parseInt(s2[0]);
            }
            catch (Exception e) {
                return "Cannot convert " + s2[0] + " to number";
            }
            if (!MapStage.getInstance().isInMap()) {
                return "Only supported for PoI";
            }
            MapStage.getInstance().deleteObject(id);
            return "Removed enemy " + s2[0];
        });
    }

    static class Command {
        HashMap<String, Command> children = new HashMap();
        Function<String[], String> function;

        Command() {
        }
    }
}

