/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.stage;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import forge.Forge;
import forge.adventure.stage.ConsoleCommandInterpreter;
import forge.adventure.util.Controls;

public class Console
extends Window {
    private final ScrollPane scroll;
    private String last = "";
    private final InputLine input;
    private final Table content = new Table(Controls.getSkin());

    public void toggle() {
        if (this.isVisible()) {
            this.setVisible(false);
            this.getStage().unfocus(this.input);
        } else if (!Forge.advFreezePlayerControls) {
            this.setVisible(true);
            this.getStage().setKeyboardFocus(this.input);
        }
    }

    private String complete(String text) {
        return ConsoleCommandInterpreter.getInstance().complete(text);
    }

    public void command(String text) {
        Cell<Label> newLine = this.content.add(text);
        newLine.getActor().setColor(1.0f, 1.0f, 1.0f, 1.0f);
        newLine.growX().align(12).row();
        this.last = text;
        newLine = this.content.add(ConsoleCommandInterpreter.getInstance().command(text));
        newLine.getActor().setColor(0.6f, 0.6f, 0.6f, 1.0f);
        newLine.growX().align(12).row();
        this.scroll.layout();
        this.scroll.scrollTo(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Console() {
        super("", Controls.getSkin());
        this.input = new InputLine(this);
        this.scroll = new ScrollPane((Actor)this.content, new ScrollPane.ScrollPaneStyle());
        this.add(this.scroll).grow().row();
        this.add(this.input).growX();
    }

    static class InputLine
    extends TextField {
        private final Console console;

        public InputLine(Console console) {
            super("", Controls.getSkin());
            this.console = console;
            this.writeEnters = true;
        }

        @Override
        protected InputListener createInputListener() {
            final InputLine self = this;
            return new TextField.TextFieldClickListener(){

                @Override
                public boolean keyTyped(InputEvent event, char character) {
                    switch (character) {
                        case '\b': {
                            break;
                        }
                        case '\t': {
                            if (self.getText().isEmpty()) {
                                self.setText(console.last);
                                break;
                            }
                            self.setText(console.complete(self.getText()));
                            self.setCursorPosition(Integer.MAX_VALUE);
                            break;
                        }
                        case '\n': 
                        case '\r': {
                            console.command(self.getText());
                            self.setText("");
                            return false;
                        }
                        default: {
                            if (character >= ' ') break;
                            return false;
                        }
                    }
                    return super.keyTyped(event, character);
                }
            };
        }
    }
}

