/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Dialog;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.Timer;
import com.badlogic.gdx.utils.viewport.ScalingViewport;
import com.github.tommyettinger.textra.TextraButton;
import com.github.tommyettinger.textra.TextraLabel;
import forge.Forge;
import forge.adventure.scene.Scene;
import forge.adventure.stage.GameHUD;
import forge.adventure.util.Config;
import forge.adventure.util.Controls;
import forge.adventure.util.KeyBinding;
import forge.adventure.util.KeyBoardDialog;
import forge.adventure.util.Selector;
import forge.adventure.util.UIActor;
import java.time.LocalTime;

public class UIScene
extends Scene {
    protected UIActor ui;
    public Array<Array<Selectable>> possibleSelectionStack = new Array();
    public Array<Dialog> dialogs = new Array();
    protected Stage stage;
    String uiFile;
    static float timeOfDay = 8.0f;
    float targetTime = 8.0f;
    Image screenImage;
    TextureRegion backgroundTexture;

    public void showDialog(Dialog dialog) {
        this.stage.addActor(dialog);
        this.possibleSelectionStack.add(new Array());
        this.addToSelectable(dialog.getContentTable());
        this.addToSelectable(dialog.getButtonTable());
        dialog.getColor().a = 0.0f;
        this.stage.setKeyboardFocus(dialog);
        this.stage.setScrollFocus(dialog);
        for (Dialog otherDialogs : this.dialogs) {
            otherDialogs.hide();
        }
        this.dialogs.add(dialog);
        this.selectFirst();
        dialog.show(this.stage);
    }

    private void requestTextInput(String text, KeyBoardDialog.ScreenKeyboardFinished e) {
        KeyBoardDialog keyboardDialog = new KeyBoardDialog(){

            @Override
            protected void result(@Null Object object) {
                UIScene.this.removeDialog();
            }
        };
        keyboardDialog.setText(text);
        keyboardDialog.setOnFinish(e);
        this.showDialog(keyboardDialog);
    }

    public Array<Selectable> getPossibleSelection() {
        if (this.possibleSelectionStack.isEmpty()) {
            this.possibleSelectionStack.add(this.ui.selectActors);
        }
        return this.possibleSelectionStack.get(this.possibleSelectionStack.size - 1);
    }

    public static InputEvent eventTouchUp() {
        InputEvent event = new InputEvent();
        event.setPointer(-1);
        event.setType(InputEvent.Type.touchUp);
        return event;
    }

    public static InputEvent eventTouchDown() {
        InputEvent event = new InputEvent();
        event.setPointer(-1);
        event.setType(InputEvent.Type.touchDown);
        return event;
    }

    public static InputEvent eventExit() {
        InputEvent event = new InputEvent();
        event.setPointer(-1);
        event.setType(InputEvent.Type.exit);
        return event;
    }

    public static InputEvent eventEnter() {
        InputEvent event = new InputEvent();
        event.setPointer(-1);
        event.setType(InputEvent.Type.enter);
        return event;
    }

    @Override
    public boolean buttonUp(Controller controller, int keycode) {
        return this.stage.keyUp(KeyBinding.controllerButtonToKey(controller, keycode));
    }

    @Override
    public boolean buttonDown(Controller controller, int keycode) {
        return this.stage.keyDown(KeyBinding.controllerButtonToKey(controller, keycode));
    }

    protected void addToSelectable(Table table) {
        for (Cell cell : table.getCells()) {
            if (cell.getActor() == null || cell.getActor().getClass() == Actor.class || cell.getActor() instanceof Label || cell.getActor() instanceof TextraLabel) continue;
            this.getPossibleSelection().add(new Selectable(cell.getActor()));
        }
    }

    protected void addToSelectable(Button button) {
        this.getPossibleSelection().add(new Selectable<Button>(button));
    }

    protected void addToSelectable(Actor button) {
        this.getPossibleSelection().add(new Selectable<Actor>(button));
    }

    protected void addToSelectable(Selectable selectable) {
        this.getPossibleSelection().add(selectable);
    }

    protected void clearSelectable() {
        this.getPossibleSelection().clear();
    }

    public UIScene(String uiFilePath) {
        this.uiFile = uiFilePath;
        this.stage = new Stage(new ScalingViewport(Scaling.stretch, UIScene.getIntendedWidth(), UIScene.getIntendedHeight())){

            @Override
            public boolean keyUp(int keycode) {
                UIScene.this.keyReleased(keycode);
                return super.keyUp(keycode);
            }

            @Override
            public boolean keyDown(int keyCode) {
                UIScene.this.keyPressed(keyCode);
                return super.keyDown(keyCode);
            }

            @Override
            public boolean mouseMoved(int screenX, int screenY) {
                UIScene.this.pointerMoved(screenX, screenY);
                return super.mouseMoved(screenX, screenY);
            }
        };
        this.ui = new UIActor(Config.instance().getFile(this.uiFile));
        for (Actor actor : this.ui.getChildren()) {
            if (!(actor instanceof ScrollPane)) continue;
            this.stage.setScrollFocus(actor);
        }
        this.possibleSelectionStack.add(this.ui.selectActors);
        this.screenImage = (Image)this.ui.findActor("lastScreen");
        this.stage.addActor(this.ui);
    }

    public void removeDialog() {
        if (!this.dialogs.isEmpty()) {
            this.dialogs.get(this.dialogs.size - 1).remove();
            this.dialogs.removeIndex(this.dialogs.size - 1);
            if (!this.dialogs.isEmpty()) {
                this.dialogs.get(this.dialogs.size - 1).show(this.stage);
            }
        }
        if (this.possibleSelectionStack.isEmpty()) {
            this.getPossibleSelection();
        } else {
            this.possibleSelectionStack.removeIndex(this.possibleSelectionStack.size - 1);
        }
    }

    public Dialog createGenericDialog(String title, String label, String stringYes, String stringNo, Runnable runnableYes, Runnable runnableNo) {
        return this.createGenericDialog(title, label, stringYes, stringNo, runnableYes, runnableNo, false, "");
    }

    public Dialog createGenericDialog(String title, String label, String stringYes, String stringNo, Runnable runnableYes, Runnable runnableNo, boolean cancelButton, String stringCancel) {
        Dialog dialog = new Dialog(title == null ? "" : title, Controls.getSkin());
        if (label != null) {
            dialog.text(label);
        }
        TextraButton yes = Controls.newTextButton(stringYes, runnableYes);
        dialog.button(yes);
        if (stringNo != null) {
            TextraButton no = Controls.newTextButton(stringNo, runnableNo);
            dialog.button(no);
        }
        if (cancelButton) {
            TextraButton cancel = Controls.newTextButton(stringCancel, this::removeDialog);
            dialog.button(cancel);
        }
        return dialog;
    }

    public static float getTimeOfDay() {
        return timeOfDay;
    }

    public void setTargetTime(float val) {
        this.targetTime = val;
    }

    public void setTimeOfDay(float val) {
        timeOfDay = val;
    }

    @Override
    public void dispose() {
        if (this.stage != null) {
            this.stage.dispose();
        }
    }

    @Override
    public void act(float delta) {
        this.stage.act(delta);
        if (timeOfDay < this.targetTime) {
            if ((timeOfDay += delta * 1.5f) > this.targetTime) {
                timeOfDay = this.targetTime;
            }
        } else if (timeOfDay > this.targetTime && (timeOfDay -= delta * 1.5f) < this.targetTime) {
            timeOfDay = this.targetTime;
        }
    }

    @Override
    public void render() {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.draw();
    }

    public UIActor getUI() {
        return this.ui;
    }

    public boolean back() {
        GameHUD.getInstance().getTouchpad().setVisible(false);
        Forge.switchToLast();
        return true;
    }

    public Selectable getSelected() {
        for (Selectable selectable : this.getPossibleSelection()) {
            if (this.stage.getKeyboardFocus() != selectable.actor) continue;
            return selectable;
        }
        return null;
    }

    public boolean keyReleased(int keycode) {
        Button pressedButton;
        this.ui.pressUp(keycode);
        if (!this.dialogShowing() && (pressedButton = this.ui.buttonPressed(keycode)) != null && pressedButton.isVisible()) {
            pressedButton.fire(UIScene.eventTouchUp());
        }
        if (KeyBinding.Use.isPressed(keycode) && this.getSelected() != null) {
            this.getSelected().onPressUp();
        }
        return true;
    }

    public boolean keyPressed(int keycode) {
        Button pressedButton;
        ScrollPane scroll;
        Actor focus;
        SelectBox box;
        Selectable selection = this.getSelected();
        if (KeyBinding.Use.isPressed(keycode) && selection != null) {
            selection.onPressDown(this);
            return true;
        }
        this.ui.pressDown(keycode);
        if (this.stage.getKeyboardFocus() instanceof SelectBox && (box = (SelectBox)this.stage.getKeyboardFocus()).getScrollPane().hasParent()) {
            if (KeyBinding.Use.isPressed(keycode)) {
                box.getSelection().choose(box.getList().getSelected());
                box.getScrollPane().hide();
            }
            return false;
        }
        if (KeyBinding.Back.isPressed(keycode) && selection != null) {
            selection.onDeSelect();
            this.stage.setKeyboardFocus(null);
        }
        if (KeyBinding.ScrollUp.isPressed(keycode) && (focus = this.stage.getScrollFocus()) != null && focus instanceof ScrollPane) {
            scroll = (ScrollPane)focus;
            scroll.setScrollY(scroll.getScrollY() - 20.0f);
        }
        if (KeyBinding.ScrollDown.isPressed(keycode) && (focus = this.stage.getScrollFocus()) != null && focus instanceof ScrollPane) {
            scroll = (ScrollPane)focus;
            scroll.setScrollY(scroll.getScrollY() + 20.0f);
        }
        if (KeyBinding.Down.isPressed(keycode)) {
            this.selectNextDown();
        }
        if (KeyBinding.Up.isPressed(keycode)) {
            this.selectNextUp();
        }
        if (!(this.stage.getKeyboardFocus() instanceof Selector || this.stage.getKeyboardFocus() instanceof TextField || this.stage.getKeyboardFocus() instanceof Slider)) {
            if (KeyBinding.Right.isPressed(keycode)) {
                this.selectNextRight();
            }
            if (KeyBinding.Left.isPressed(keycode)) {
                this.selectNextLeft();
            }
        }
        if (!this.dialogShowing() && (pressedButton = this.ui.buttonPressed(keycode)) != null && pressedButton.isVisible()) {
            pressedButton.fire(UIScene.eventTouchDown());
        }
        return true;
    }

    private boolean dialogShowing() {
        return !this.dialogs.isEmpty();
    }

    @Override
    public void disconnected(Controller controller) {
        this.ui.controllerDisconnected();
    }

    @Override
    public void connected(Controller controller) {
        this.selectFirst();
        this.ui.controllerConnected();
    }

    public boolean pointerMoved(int screenX, int screenY) {
        this.unselectActors();
        return false;
    }

    public void performTouch(final Actor actor) {
        if (actor == null) {
            return;
        }
        actor.fire(UIScene.eventTouchDown());
        Timer.schedule(new Timer.Task(){

            @Override
            public void run() {
                actor.fire(UIScene.eventTouchUp());
            }
        }, 0.1f);
    }

    public void unselectActors() {
        for (Selectable selectable : this.getPossibleSelection()) {
            selectable.onDeSelect();
        }
    }

    Array<Selectable> visibleSelection() {
        Array<Selectable> selectables = new Array<Selectable>();
        for (Selectable selectable : this.getPossibleSelection()) {
            if (!((Actor)selectable.actor).isVisible()) continue;
            if (selectable.actor instanceof Button) {
                if (((Button)selectable.actor).isDisabled()) continue;
                selectables.add(selectable);
                continue;
            }
            selectables.add(selectable);
        }
        return selectables;
    }

    public void selectNextDown() {
        if (this.getSelected() == null) {
            this.selectFirst();
        } else {
            Selectable current = this.getSelected();
            Array<Selectable> candidates = new Array<Selectable>();
            for (Selectable selectable : this.visibleSelection()) {
                if (!((double)selectable.xDiff(current) < 0.1) || selectable == current) continue;
                candidates.add(selectable);
            }
            if (candidates.isEmpty()) {
                candidates.addAll(this.visibleSelection());
            }
            Selectable finalOne = null;
            Selectable fallback = null;
            for (Selectable candidate : candidates) {
                if (fallback == null || candidate.getY() > fallback.getY()) {
                    fallback = candidate;
                }
                if (!(candidate.getY() < current.getY()) || finalOne != null && !(current.yDiff(candidate) < current.yDiff(finalOne))) continue;
                finalOne = candidate;
            }
            if (finalOne == null) {
                for (Selectable candidate : this.visibleSelection()) {
                    if (!(candidate.getY() < current.getY()) || finalOne != null && !(current.yDiff(candidate) < current.yDiff(finalOne))) continue;
                    finalOne = candidate;
                }
            }
            if (finalOne != null) {
                this.selectActor(finalOne);
            } else if (fallback != null) {
                this.selectActor(fallback);
            }
        }
    }

    private void selectNextLeft() {
        if (this.getSelected() == null) {
            this.selectFirst();
        } else {
            Selectable current = this.getSelected();
            Array<Selectable> candidates = new Array<Selectable>();
            for (Selectable selectable : this.visibleSelection()) {
                if (!((double)selectable.yDiff(current) < 0.1) || selectable == current) continue;
                candidates.add(selectable);
            }
            if (candidates.isEmpty()) {
                candidates.addAll(this.visibleSelection());
            }
            Selectable finalOne = null;
            Selectable fallback = null;
            for (Selectable candidate : candidates) {
                if (fallback == null || candidate.getX() > fallback.getX()) {
                    fallback = candidate;
                }
                if (!(candidate.getX() < current.getX()) || finalOne != null && !(current.xDiff(candidate) < current.xDiff(finalOne))) continue;
                finalOne = candidate;
            }
            if (finalOne == null) {
                for (Selectable candidate : this.visibleSelection()) {
                    if (!(candidate.getX() < current.getX()) || finalOne != null && !(current.xDiff(candidate) < current.xDiff(finalOne))) continue;
                    finalOne = candidate;
                }
            }
            if (finalOne != null) {
                this.selectActor(finalOne);
            } else if (fallback != null) {
                this.selectActor(fallback);
            }
        }
    }

    private void selectNextRight() {
        if (this.getSelected() == null) {
            this.selectFirst();
        } else {
            Selectable current = this.getSelected();
            Array<Selectable> candidates = new Array<Selectable>();
            for (Selectable selectable : this.visibleSelection()) {
                if (!((double)selectable.yDiff(current) < 0.1) || selectable == current) continue;
                candidates.add(selectable);
            }
            if (candidates.isEmpty()) {
                candidates.addAll(this.visibleSelection());
            }
            Selectable finalOne = null;
            Selectable fallback = null;
            for (Selectable candidate : candidates) {
                if (fallback == null || candidate.getX() < fallback.getX()) {
                    fallback = candidate;
                }
                if (!(candidate.getX() > current.getX()) || finalOne != null && !(current.xDiff(candidate) < current.xDiff(finalOne))) continue;
                finalOne = candidate;
            }
            if (finalOne == null) {
                for (Selectable candidate : this.visibleSelection()) {
                    if (!(candidate.getX() > current.getX()) || finalOne != null && !(current.xDiff(candidate) < current.xDiff(finalOne))) continue;
                    finalOne = candidate;
                }
            }
            if (finalOne != null) {
                this.selectActor(finalOne);
            } else if (fallback != null) {
                this.selectActor(fallback);
            }
        }
    }

    public void selectNextUp() {
        if (this.getSelected() == null) {
            this.selectFirst();
        } else {
            Selectable current = this.getSelected();
            Array<Selectable> candidates = new Array<Selectable>();
            for (Selectable selectable : this.visibleSelection()) {
                if (!((double)selectable.xDiff(current) < 0.1) || selectable == current) continue;
                candidates.add(selectable);
            }
            if (candidates.isEmpty()) {
                candidates.addAll(this.visibleSelection());
            }
            Selectable finalOne = null;
            Selectable fallback = null;
            for (Selectable candidate : candidates) {
                if (fallback == null || candidate.getY() < fallback.getY()) {
                    fallback = candidate;
                }
                if (!(candidate.getY() > current.getY()) || finalOne != null && !(current.yDiff(candidate) < current.yDiff(finalOne))) continue;
                finalOne = candidate;
            }
            if (finalOne == null) {
                for (Selectable candidate : this.visibleSelection()) {
                    if (!(candidate.getY() > current.getY()) || finalOne != null && !(current.yDiff(candidate) < current.yDiff(finalOne))) continue;
                    finalOne = candidate;
                }
            }
            if (finalOne != null) {
                this.selectActor(finalOne);
            } else if (fallback != null) {
                this.selectActor(fallback);
            }
        }
    }

    private void selectFirst() {
        Selectable result = null;
        for (Selectable candidate : this.getPossibleSelection()) {
            if (result != null && !(candidate.getY() > result.getY())) continue;
            result = candidate;
        }
        this.selectActor(result);
    }

    ScrollPane scrollPaneOfActor(Actor actor) {
        while (actor != null) {
            if (actor.getParent() instanceof ScrollPane) {
                return (ScrollPane)actor.getParent();
            }
            actor = actor.getParent();
        }
        return null;
    }

    public void selectActor(Selectable actor) {
        this.unselectActors();
        if (actor == null) {
            return;
        }
        this.stage.setKeyboardFocus((Actor)actor.actor);
        ScrollPane scrollPane = this.scrollPaneOfActor((Actor)actor.actor);
        if (scrollPane != null) {
            scrollPane.scrollTo(((Actor)actor.actor).getX(), ((Actor)actor.actor).getY(), ((Actor)actor.actor).getWidth(), ((Actor)actor.actor).getHeight(), false, false);
        }
        actor.onSelect(this);
    }

    @Override
    public boolean leave() {
        this.stage.cancelTouchFocus();
        this.updateInput();
        return super.leave();
    }

    @Override
    public void enter() {
        if (this.screenImage != null) {
            try {
                this.backgroundTexture = new TextureRegion(Forge.lastPreview);
                this.backgroundTexture.flip(false, true);
                this.screenImage.setDrawable(new TextureRegionDrawable(this.backgroundTexture));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Gdx.input.setInputProcessor(this.stage);
        this.updateBG(false);
        super.enter();
    }

    void updateBG(boolean animate) {
        if (Config.instance().getSettingData().dayNightBG) {
            int hour = LocalTime.now().getHour();
            if (animate) {
                this.setTimeOfDay(hour + 3 > 23 ? (float)(hour + 3 - 23) : (float)(hour + 3));
            }
            switch (hour) {
                case 8: 
                case 9: {
                    this.setTargetTime(6.0f);
                    break;
                }
                case 10: 
                case 11: {
                    this.setTargetTime(7.0f);
                    break;
                }
                case 12: 
                case 13: {
                    this.setTargetTime(8.0f);
                    break;
                }
                case 14: 
                case 15: {
                    this.setTargetTime(11.0f);
                    break;
                }
                case 16: 
                case 17: {
                    this.setTargetTime(12.0f);
                    break;
                }
                case 18: 
                case 19: {
                    this.setTargetTime(14.0f);
                    break;
                }
                case 20: 
                case 21: {
                    this.setTargetTime(15.0f);
                    break;
                }
                case 22: 
                case 23: {
                    this.setTargetTime(16.0f);
                    break;
                }
                case 0: 
                case 1: {
                    this.setTargetTime(17.0f);
                    break;
                }
                case 2: 
                case 3: {
                    this.setTargetTime(20.0f);
                    break;
                }
                case 4: 
                case 5: {
                    this.setTargetTime(23.0f);
                    break;
                }
                case 6: 
                case 7: {
                    this.setTargetTime(28.0f);
                }
            }
        }
    }

    public TextureRegion getUIBackground() {
        try {
            Drawable d;
            Actor a = this.ui.getChild(0);
            if (a instanceof Image && (d = ((Image)a).getDrawable()) instanceof TextureRegionDrawable) {
                return ((TextureRegionDrawable)d).getRegion();
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    @Override
    public void updateInput() {
        super.updateInput();
        Gdx.input.setInputProcessor(this.stage);
    }

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    public static class Selectable<T extends Actor> {
        public T actor;

        public float getY() {
            float y = 0.0f;
            for (Object act = this.actor; act != null; act = ((Actor)act).getParent()) {
                y += ((Actor)act).getY();
            }
            return y;
        }

        public float getX() {
            float x = 0.0f;
            for (Object act = this.actor; act != null; act = ((Actor)act).getParent()) {
                x += ((Actor)act).getX();
            }
            return x;
        }

        public Selectable(T newActor) {
            this.actor = newActor;
        }

        public void onSelect(UIScene scene) {
        }

        public void onDeSelect() {
        }

        public void onPressDown(UIScene scene) {
            if (this.actor instanceof TextField) {
                scene.requestTextInput(((TextField)this.actor).getText(), text -> ((TextField)this.actor).setText(text));
            }
            ((Actor)this.actor).fire(UIScene.eventTouchDown());
        }

        public void onPressUp() {
            ((Actor)this.actor).fire(UIScene.eventTouchUp());
        }

        public float yDiff(Selectable finalOne) {
            return Math.abs(finalOne.getY() - this.getY());
        }

        public float xDiff(Selectable finalOne) {
            return Math.abs(finalOne.getX() - this.getX());
        }
    }
}

