/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.scene;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.scenes.scene2d.ui.Dialog;
import com.badlogic.gdx.utils.Timer;
import com.github.tommyettinger.textra.TextraButton;
import com.github.tommyettinger.textra.TypingLabel;
import forge.Forge;
import forge.adventure.scene.GameScene;
import forge.adventure.scene.NewGameScene;
import forge.adventure.scene.SaveLoadScene;
import forge.adventure.scene.SettingsScene;
import forge.adventure.scene.TileMapScene;
import forge.adventure.scene.UIScene;
import forge.adventure.stage.GameHUD;
import forge.adventure.stage.GameStage;
import forge.adventure.stage.MapStage;
import forge.adventure.util.Config;
import forge.adventure.util.Controls;
import forge.adventure.world.WorldSave;
import forge.localinstance.properties.ForgeProfileProperties;
import forge.screens.TransitionScreen;
import forge.sound.SoundSystem;
import forge.util.ZipUtil;
import java.io.File;
import java.io.IOException;

public class StartScene
extends UIScene {
    private static StartScene object;
    Dialog exitDialog;
    Dialog backupDialog;
    Dialog zipDialog;
    Dialog unzipDialog;
    TextraButton saveButton;
    TextraButton resumeButton;
    TextraButton continueButton;
    TypingLabel version = Controls.newTypingLabel("{GRADIENT}[%80]1.6.65-SNAPSHOT{ENDGRADIENT}");
    boolean loaded = false;

    public StartScene() {
        super(Forge.isLandscapeMode() ? "ui/start_menu.json" : "ui/start_menu_portrait.json");
        this.ui.onButtonPress("Start", this::NewGame);
        this.ui.onButtonPress("Start+", this::NewGamePlus);
        this.ui.onButtonPress("Load", this::Load);
        this.ui.onButtonPress("Save", this::Save);
        this.ui.onButtonPress("Resume", this::Resume);
        this.ui.onButtonPress("Continue", this::Continue);
        this.ui.onButtonPress("Settings", this::settings);
        this.ui.onButtonPress("Backup", this::backup);
        this.ui.onButtonPress("Exit", this::Exit);
        this.ui.onButtonPress("Switch", this::switchToClassic);
        this.saveButton = (TextraButton)this.ui.findActor("Save");
        this.resumeButton = (TextraButton)this.ui.findActor("Resume");
        this.continueButton = (TextraButton)this.ui.findActor("Continue");
        this.saveButton.setVisible(false);
        this.resumeButton.setVisible(false);
        this.version.setHeight(5.0f);
        this.version.skipToTheEnd();
        this.ui.addActor(this.version);
    }

    public static StartScene instance() {
        if (object == null) {
            object = new StartScene();
        }
        return object;
    }

    public boolean NewGame() {
        Forge.switchScene(NewGameScene.instance());
        return true;
    }

    public boolean Save() {
        if (TileMapScene.instance().currentMap().isInMap()) {
            Dialog noSave = this.createGenericDialog("", Forge.getLocalizer().getMessage("lblGameNotSaved", new Object[0]), Forge.getLocalizer().getMessage("lblOK", new Object[0]), null, null, null);
            this.showDialog(noSave);
        } else {
            SaveLoadScene.instance().setMode(SaveLoadScene.Modes.Save);
            Forge.switchScene(SaveLoadScene.instance());
        }
        return true;
    }

    public boolean Load() {
        SaveLoadScene.instance().setMode(SaveLoadScene.Modes.Load);
        Forge.switchScene(SaveLoadScene.instance());
        return true;
    }

    public boolean Resume() {
        if (MapStage.getInstance().isInMap()) {
            Forge.switchScene(TileMapScene.instance());
        } else {
            Forge.switchScene(GameScene.instance());
        }
        GameHUD.getInstance().getTouchpad().setVisible(false);
        return true;
    }

    public boolean Continue() {
        String lastActiveSave = Config.instance().getSettingData().lastActiveSave;
        if (WorldSave.isSafeFile(lastActiveSave)) {
            if (this.loaded) {
                return true;
            }
            this.loaded = true;
            try {
                Forge.setTransitionScreen(new TransitionScreen(() -> {
                    this.loaded = false;
                    if (WorldSave.load(WorldSave.filenameToSlot(lastActiveSave))) {
                        SoundSystem.instance.changeBackgroundTrack();
                        Forge.switchScene(GameScene.instance());
                    } else {
                        Forge.clearTransitionScreen();
                    }
                }, null, false, true, Forge.getLocalizer().getMessage("lblLoadingWorld", new Object[0])));
            }
            catch (Exception e) {
                this.loaded = false;
                Forge.clearTransitionScreen();
            }
        }
        return true;
    }

    public boolean settings() {
        Forge.switchScene(SettingsScene.instance());
        return true;
    }

    public boolean backup() {
        if (this.backupDialog == null) {
            this.backupDialog = this.createGenericDialog(Forge.getLocalizer().getMessage("lblData", new Object[0]), null, Forge.getLocalizer().getMessage("lblBackup", new Object[0]), Forge.getLocalizer().getMessage("lblRestore", new Object[0]), () -> {
                this.removeDialog();
                Timer.schedule(new Timer.Task(){

                    @Override
                    public void run() {
                        StartScene.this.generateBackup();
                    }
                }, 0.2f);
            }, () -> {
                this.removeDialog();
                Timer.schedule(new Timer.Task(){

                    @Override
                    public void run() {
                        StartScene.this.restoreBackup();
                    }
                }, 0.2f);
            }, true, Forge.getLocalizer().getMessage("lblCancel", new Object[0]));
        }
        this.showDialog(this.backupDialog);
        return true;
    }

    public boolean generateBackup() {
        try {
            File source = new FileHandle(ForgeProfileProperties.getUserDir() + "/adventure/Shandalar").file();
            File target = new FileHandle(Forge.getDeviceAdapter().getDownloadsDir()).file();
            ZipUtil.zip(source, target, ZipUtil.backupAdvFile);
            this.zipDialog = this.createGenericDialog("", Forge.getLocalizer().getMessage("lblSaveLocation", new Object[0]) + "\n" + target.getAbsolutePath() + File.separator + ZipUtil.backupAdvFile, Forge.getLocalizer().getMessage("lblOK", new Object[0]), null, this::removeDialog, null);
        }
        catch (IOException e) {
            this.zipDialog = this.createGenericDialog("", Forge.getLocalizer().getMessage("lblErrorSavingFile", new Object[0]) + "\n\n" + e.getMessage(), Forge.getLocalizer().getMessage("lblOK", new Object[0]), null, this::removeDialog, null);
        }
        finally {
            this.showDialog(this.zipDialog);
        }
        return true;
    }

    public boolean restoreBackup() {
        final File source = new FileHandle(Forge.getDeviceAdapter().getDownloadsDir() + ZipUtil.backupAdvFile).file();
        final File target = new FileHandle(ForgeProfileProperties.getUserDir() + "/adventure/Shandalar").file().getParentFile();
        if (this.unzipDialog == null) {
            this.unzipDialog = this.createGenericDialog("", Forge.getLocalizer().getMessage("lblDoYouWantToRestoreBackup", new Object[0]), Forge.getLocalizer().getMessage("lblYes", new Object[0]), Forge.getLocalizer().getMessage("lblNo", new Object[0]), () -> {
                this.removeDialog();
                Timer.schedule(new Timer.Task(){

                    @Override
                    public void run() {
                        StartScene.this.extract(source, target);
                    }
                }, 0.2f);
            }, this::removeDialog);
        }
        this.showDialog(this.unzipDialog);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean extract(File source, File target) {
        String title = "";
        String val = "";
        try {
            val = Forge.getLocalizer().getMessage("lblFiles", new Object[0]) + ":\n" + ZipUtil.unzip(source, target);
        }
        catch (IOException e) {
            title = Forge.getLocalizer().getMessage("lblError", new Object[0]);
            val = e.getMessage();
        }
        finally {
            Config.instance().getSettingData().lastActiveSave = null;
            Config.instance().saveSettings();
            this.showDialog(this.createGenericDialog(title, val, Forge.getLocalizer().getMessage("lblOK", new Object[0]), null, this::removeDialog, null));
        }
        return true;
    }

    public boolean Exit() {
        if (this.exitDialog == null) {
            this.exitDialog = this.createGenericDialog(Forge.getLocalizer().getMessage("lblExitForge", new Object[0]), Forge.getLocalizer().getMessage("lblAreYouSureYouWishExitForge", new Object[0]), Forge.getLocalizer().getMessage("lblOK", new Object[0]), Forge.getLocalizer().getMessage("lblAbort", new Object[0]), () -> {
                Forge.exit(true);
                this.removeDialog();
            }, this::removeDialog);
        }
        this.showDialog(this.exitDialog);
        return true;
    }

    public void switchToClassic() {
        GameHUD.getInstance().stopAudio();
        Forge.switchToClassic();
    }

    public void updateResumeContinue() {
        boolean hasResumeButton = WorldSave.getCurrentSave().getWorld().getData() != null;
        this.resumeButton.setVisible(hasResumeButton);
        if (Config.instance().getSettingData().lastActiveSave != null && !hasResumeButton) {
            this.continueButton.setVisible(true);
            if (!Forge.isLandscapeMode()) {
                this.continueButton.setX(this.resumeButton.getX());
                this.continueButton.setY(this.resumeButton.getY());
            }
        } else {
            this.continueButton.setVisible(false);
        }
    }

    @Override
    public void enter() {
        boolean hasSaveButton;
        boolean bl = hasSaveButton = WorldSave.getCurrentSave().getWorld().getData() != null;
        if (hasSaveButton) {
            TileMapScene scene = TileMapScene.instance();
            hasSaveButton = !scene.currentMap().isInMap() || scene.isAutoHealLocation();
        }
        this.saveButton.setVisible(hasSaveButton);
        this.saveButton.setDisabled(TileMapScene.instance().currentMap().isInMap());
        this.updateResumeContinue();
        if (Forge.createNewAdventureMap) {
            this.NewGame();
            GameStage.maximumScrollDistance = 4.0f;
        }
        super.enter();
    }

    private void NewGamePlus() {
        SaveLoadScene.instance().setMode(SaveLoadScene.Modes.NewGamePlus);
        Forge.switchScene(SaveLoadScene.instance());
    }
}

