/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.scene;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.github.tommyettinger.textra.TextraButton;
import com.github.tommyettinger.textra.TextraLabel;
import forge.Forge;
import forge.StaticData;
import forge.adventure.data.ConfigData;
import forge.adventure.data.RewardData;
import forge.adventure.scene.UIScene;
import forge.adventure.util.CardUtil;
import forge.adventure.util.Config;
import forge.adventure.util.Controls;
import forge.adventure.util.Current;
import forge.adventure.util.Reward;
import forge.adventure.util.RewardActor;
import forge.card.CardEdition;
import forge.card.ColorSet;
import forge.item.PaperCard;
import forge.model.FModel;
import forge.util.MyRandom;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class SpellSmithScene
extends UIScene {
    private static SpellSmithScene object;
    private List<PaperCard> cardPool = new ArrayList<PaperCard>();
    private TextraLabel playerGold;
    private TextraLabel playerShards;
    private TextraLabel poolSize;
    private final TextraButton pullUsingGold;
    private final TextraButton pullUsingShards;
    private final TextraButton acceptReward;
    private final TextraButton declineReward;
    private final TextraButton exitSmith;
    private final ScrollPane rewardDummy;
    private RewardActor rewardActor;
    SelectBox<CardEdition> editionList;
    private final HashMap<String, TextraButton> rarityButtons = new HashMap();
    private final HashMap<String, TextraButton> costButtons = new HashMap();
    private final HashMap<String, TextraButton> colorButtons = new HashMap();
    private String edition = "";
    private String rarity = "";
    private int cost_low = -1;
    private int cost_high = 9999;
    private final float basePrice = 125.0f;
    private int currentPrice = 0;
    private int currentShardPrice = 0;
    private List<CardEdition> editions = null;
    private Reward currentReward = null;
    private boolean paidInShards = false;

    public static SpellSmithScene instance() {
        if (object == null) {
            object = new SpellSmithScene();
        }
        return object;
    }

    private SpellSmithScene() {
        super(Forge.isLandscapeMode() ? "ui/spellsmith.json" : "ui/spellsmith_portrait.json");
        TextraButton button;
        this.editionList = (SelectBox)this.ui.findActor("BSelectPlane");
        this.rewardDummy = (ScrollPane)this.ui.findActor("RewardDummy");
        this.rewardDummy.setVisible(false);
        this.pullUsingGold = (TextraButton)this.ui.findActor("pullUsingGold");
        this.pullUsingGold.setDisabled(true);
        this.pullUsingShards = (TextraButton)this.ui.findActor("pullUsingShards");
        this.pullUsingShards.setDisabled(true);
        this.exitSmith = (TextraButton)this.ui.findActor("done");
        this.acceptReward = (TextraButton)this.ui.findActor("accept");
        this.acceptReward.setVisible(false);
        this.declineReward = (TextraButton)this.ui.findActor("decline");
        this.declineReward.setVisible(false);
        this.playerGold = Controls.newAccountingLabel((TextraLabel)this.ui.findActor("playerGold"), false);
        this.playerShards = Controls.newAccountingLabel((TextraLabel)this.ui.findActor("playerShards"), true);
        this.poolSize = (TextraLabel)this.ui.findActor("poolSize");
        for (final String i : new String[]{"BBlack", "BBlue", "BGreen", "BRed", "BWhite", "BColorless"}) {
            button = (TextraButton)this.ui.findActor(i);
            if (button == null) continue;
            this.colorButtons.put(i, button);
            button.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    SpellSmithScene.this.selectColor(i);
                    SpellSmithScene.this.filterResults();
                }
            });
        }
        for (final String i : new String[]{"BCommon", "BUncommon", "BRare", "BMythic"}) {
            button = (TextraButton)this.ui.findActor(i);
            if (button == null) continue;
            this.rarityButtons.put(i, button);
            button.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    if (SpellSmithScene.this.selectRarity(i)) {
                        button.setColor(Color.RED);
                    }
                    SpellSmithScene.this.filterResults();
                }
            });
        }
        for (final String i : new String[]{"B02", "B35", "B68", "B9X"}) {
            button = (TextraButton)this.ui.findActor(i);
            if (button == null) continue;
            this.costButtons.put(i, button);
            button.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    if (SpellSmithScene.this.selectCost(i)) {
                        button.setColor(Color.RED);
                    }
                    SpellSmithScene.this.filterResults();
                }
            });
        }
        this.ui.onButtonPress("accept", this::acceptSmithing);
        this.ui.onButtonPress("decline", this::declineSmithing);
        this.ui.onButtonPress("done", this::done);
        this.ui.onButtonPress("pullUsingGold", () -> this.pullCard(false));
        this.ui.onButtonPress("pullUsingShards", () -> this.pullCard(true));
        this.ui.onButtonPress("BReset", () -> {
            this.reset();
            this.filterResults();
        });
    }

    private void reset() {
        this.edition = "";
        this.cost_low = -1;
        this.cost_high = 9999;
        this.rarity = "";
        this.currentPrice = 125;
        for (Map.Entry<String, TextraButton> B : this.colorButtons.entrySet()) {
            B.getValue().setColor(Color.WHITE);
        }
        for (Map.Entry<String, TextraButton> B : this.costButtons.entrySet()) {
            B.getValue().setColor(Color.WHITE);
        }
        for (Map.Entry<String, TextraButton> B : this.rarityButtons.entrySet()) {
            B.getValue().setColor(Color.WHITE);
        }
        this.editionList.setColor(Color.WHITE);
        this.editionList.setUserObject(this.edition);
    }

    public void loadEditions() {
        if (this.editions != null) {
            return;
        }
        this.editions = StaticData.instance().getSortedEditions().stream().filter(input -> {
            List it;
            if (input == null) {
                return false;
            }
            if (input.getType() == CardEdition.Type.REPRINT || input.getType() == CardEdition.Type.PROMO || input.getType() == CardEdition.Type.COLLECTOR_EDITION) {
                return false;
            }
            if (input.getDate() != null) {
                Instant now = Instant.now();
                if (input.getDate().after(Date.from(now.minus(1L, ChronoUnit.DAYS)))) {
                    return false;
                }
            }
            if ((it = StreamSupport.stream(RewardData.getAllCards().spliterator(), false).filter(input2 -> input2.getEdition().equals(input.getCode())).collect(Collectors.toList())).size() == 0) {
                return false;
            }
            ConfigData configData = Config.instance().getConfigData();
            if (configData.allowedEditions != null) {
                return Arrays.asList(configData.allowedEditions).contains(input.getCode());
            }
            return !Arrays.asList(configData.restrictedEditions).contains(input.getCode());
        }).sorted(Comparator.comparing(CardEdition::getName)).collect(Collectors.toList());
    }

    public boolean done() {
        if (this.currentReward != null) {
            this.acceptSmithing();
        }
        if (this.rewardActor != null) {
            this.rewardActor.remove();
        }
        this.cardPool.clear();
        Forge.switchToLast();
        return true;
    }

    private boolean selectRarity(String what) {
        for (Map.Entry<String, TextraButton> B : this.rarityButtons.entrySet()) {
            B.getValue().setColor(Color.WHITE);
        }
        switch (what) {
            case "BCommon": {
                if (this.rarity.equals("C")) {
                    this.rarity = "";
                    return false;
                }
                this.rarity = "C";
                break;
            }
            case "BUncommon": {
                if (this.rarity.equals("U")) {
                    this.rarity = "";
                    return false;
                }
                this.rarity = "U";
                break;
            }
            case "BRare": {
                if (this.rarity.equals("R")) {
                    this.rarity = "";
                    return false;
                }
                this.rarity = "R";
                break;
            }
            case "BMythic": {
                if (this.rarity.equals("M")) {
                    this.rarity = "";
                    return false;
                }
                this.rarity = "M";
                break;
            }
            default: {
                this.rarity = "";
            }
        }
        return true;
    }

    private void selectColor(String what) {
        TextraButton B = this.colorButtons.get(what);
        switch (what) {
            case "BColorless": {
                if (B.getColor().equals(Color.RED)) {
                    B.setColor(Color.WHITE);
                    break;
                }
                for (Map.Entry<String, TextraButton> BT : this.colorButtons.entrySet()) {
                    BT.getValue().setColor(Color.WHITE);
                }
                B.setColor(Color.RED);
                break;
            }
            case "BBlack": 
            case "BBlue": 
            case "BGreen": 
            case "BRed": 
            case "BWhite": {
                if (B.getColor().equals(Color.RED)) {
                    B.setColor(Color.WHITE);
                    break;
                }
                B.setColor(Color.RED);
            }
        }
    }

    private boolean selectCost(String what) {
        for (Map.Entry<String, TextraButton> B : this.costButtons.entrySet()) {
            B.getValue().setColor(Color.WHITE);
        }
        switch (what) {
            case "B02": {
                if (this.cost_low == 0 && this.cost_high == 2) {
                    this.cost_low = -1;
                    this.cost_high = 9999;
                    return false;
                }
                this.cost_low = 0;
                this.cost_high = 2;
                break;
            }
            case "B35": {
                if (this.cost_low == 3 && this.cost_high == 5) {
                    this.cost_low = -1;
                    this.cost_high = 9999;
                    return false;
                }
                this.cost_low = 3;
                this.cost_high = 5;
                break;
            }
            case "B68": {
                if (this.cost_low == 6 && this.cost_high == 8) {
                    this.cost_low = -1;
                    this.cost_high = 9999;
                    return false;
                }
                this.cost_low = 6;
                this.cost_high = 8;
                break;
            }
            case "B9X": {
                if (this.cost_low == 9 && this.cost_high == 9999) {
                    this.cost_low = -1;
                    this.cost_high = 9999;
                    return false;
                }
                this.cost_low = 9;
                this.cost_high = 9999;
                break;
            }
            default: {
                this.cost_low = -1;
            }
        }
        return true;
    }

    @Override
    public void enter() {
        this.reset();
        this.loadEditions();
        this.editionList.clearListeners();
        this.editionList.clearItems();
        this.editionList.setItems((CardEdition[])this.editions.toArray(new CardEdition[0]));
        this.editionList.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                CardEdition E = SpellSmithScene.this.editionList.getSelected();
                SpellSmithScene.this.edition = E.getCode();
                SpellSmithScene.this.editionList.setColor(Color.RED);
                SpellSmithScene.this.filterResults();
            }
        });
        this.editionList.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                SpellSmithScene.this.editionList.showScrollPane();
            }
        });
        this.editionList.setColor(Color.WHITE);
        this.filterResults();
        super.enter();
    }

    public void filterResults() {
        Iterable P = RewardData.getAllCards();
        float totalCost = 125.0f * Current.player().goldModifier();
        ArrayList<String> colorFilter = new ArrayList<String>();
        for (Map.Entry<String, TextraButton> B : this.colorButtons.entrySet()) {
            switch (B.getKey()) {
                case "BColorless": {
                    if (!B.getValue().getColor().equals(Color.RED)) break;
                    colorFilter.add("Colorless");
                    break;
                }
                case "BBlack": {
                    if (!B.getValue().getColor().equals(Color.RED)) break;
                    colorFilter.add("Black");
                    break;
                }
                case "BBlue": {
                    if (!B.getValue().getColor().equals(Color.RED)) break;
                    colorFilter.add("Blue");
                    break;
                }
                case "BGreen": {
                    if (!B.getValue().getColor().equals(Color.RED)) break;
                    colorFilter.add("Green");
                    break;
                }
                case "BRed": {
                    if (!B.getValue().getColor().equals(Color.RED)) break;
                    colorFilter.add("Red");
                    break;
                }
                case "BWhite": {
                    if (!B.getValue().getColor().equals(Color.RED)) break;
                    colorFilter.add("White");
                }
            }
        }
        P = StreamSupport.stream(P.spliterator(), false).filter(input -> {
            if (input == null) {
                return false;
            }
            CardEdition cardEdition = FModel.getMagicDb().getEditions().get(this.edition);
            if (cardEdition != null && cardEdition.getCardInSet(input.getName()).size() == 0) {
                return false;
            }
            if (colorFilter.size() > 0 && input.getRules().getColor() != ColorSet.fromNames(colorFilter)) {
                return false;
            }
            if (!this.rarity.isEmpty() && !input.getRarity().toString().equals(this.rarity)) {
                return false;
            }
            return this.cost_low <= -1 || input.getRules().getManaCost().getCMC() >= this.cost_low && input.getRules().getManaCost().getCMC() <= this.cost_high;
        }).collect(Collectors.toList());
        if (!this.edition.isEmpty()) {
            totalCost *= 4.0f;
        }
        if (colorFilter.size() > 0) {
            totalCost *= Math.min((float)colorFilter.size() * 2.5f, 6.0f);
        }
        if (!this.rarity.isEmpty()) {
            switch (this.rarity) {
                case "C": {
                    totalCost *= 1.5f;
                    break;
                }
                case "U": {
                    totalCost *= 2.5f;
                    break;
                }
                case "R": {
                    totalCost *= 4.0f;
                    break;
                }
                case "M": {
                    totalCost *= 5.5f;
                    break;
                }
            }
        }
        if (this.cost_low > -1) {
            totalCost *= 2.5f;
        }
        this.cardPool = StreamSupport.stream(P.spliterator(), false).collect(Collectors.toList());
        this.poolSize.setText((this.cardPool.size() > 0 ? "[/][FOREST]" : "[/][RED]") + this.cardPool.size() + " possible card" + (this.cardPool.size() != 1 ? "s" : ""));
        this.currentPrice = (int)totalCost;
        this.currentShardPrice = (int)(totalCost * 0.2f);
        this.pullUsingGold.setText("[+Pull][+goldcoin] " + this.currentPrice);
        this.pullUsingShards.setText("[+Pull][+shards]" + this.currentShardPrice);
        this.pullUsingGold.setDisabled(this.cardPool.size() <= 0 || (float)Current.player().getGold() < totalCost);
        this.pullUsingShards.setDisabled(this.cardPool.size() <= 0 || Current.player().getShards() < this.currentShardPrice);
        this.editionList.setUserObject(this.edition);
    }

    public void pullCard(boolean usingShards) {
        this.paidInShards = usingShards;
        PaperCard P = this.cardPool.get(MyRandom.getRandom().nextInt(this.cardPool.size()));
        this.currentReward = null;
        this.currentReward = Config.instance().getSettingData().useAllCardVariants ? (!this.edition.isEmpty() ? new Reward(CardUtil.getCardByNameAndEdition(P.getCardName(), this.edition)) : new Reward(CardUtil.getCardByName(P.getCardName()))) : new Reward(P);
        if (this.rewardActor != null) {
            this.rewardActor.remove();
        }
        this.rewardActor = new RewardActor(this.currentReward, true, null, true);
        this.rewardActor.flip();
        this.rewardActor.setBounds(this.rewardDummy.getX(), this.rewardDummy.getY(), this.rewardDummy.getWidth(), this.rewardDummy.getHeight());
        this.stage.addActor(this.rewardActor);
        this.acceptReward.setVisible(true);
        this.declineReward.setVisible(true);
        this.exitSmith.setDisabled(true);
        this.disablePullButtons();
    }

    private void acceptSmithing() {
        if (this.paidInShards) {
            Current.player().takeShards(this.currentShardPrice);
        } else {
            Current.player().takeGold(this.currentPrice);
        }
        Current.player().addReward(this.currentReward);
        this.clearReward();
        this.updatePullButtons();
    }

    private void declineSmithing() {
        float priceAdjustment = 0.1f;
        if (this.paidInShards) {
            Current.player().takeShards((int)((float)this.currentShardPrice * priceAdjustment));
        } else {
            Current.player().takeGold((int)((float)this.currentPrice * priceAdjustment));
        }
        this.clearReward();
        this.updatePullButtons();
    }

    private void clearReward() {
        if (this.rewardActor != null) {
            this.rewardActor.remove();
        }
        this.currentReward = null;
    }

    private void updatePullButtons() {
        this.pullUsingGold.setDisabled(Current.player().getGold() < this.currentPrice);
        this.pullUsingShards.setDisabled(Current.player().getShards() < this.currentShardPrice);
        this.acceptReward.setVisible(false);
        this.declineReward.setVisible(false);
        this.exitSmith.setDisabled(false);
    }

    private void disablePullButtons() {
        this.pullUsingGold.setDisabled(true);
        this.pullUsingShards.setDisabled(true);
    }
}

