/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.scene;

import forge.adventure.player.AdventurePlayer;
import forge.adventure.pointofintrest.PointOfInterestChanges;
import forge.adventure.scene.AdventureDeckEditor;
import forge.adventure.scene.ForgeScene;
import forge.adventure.stage.GameHUD;
import forge.adventure.util.Current;
import forge.item.PaperCard;
import forge.screens.FScreen;

public class ShopScene
extends ForgeScene {
    private static ShopScene object;
    private PointOfInterestChanges changes;
    AdventureDeckEditor screen;

    public static ShopScene instance() {
        if (object == null) {
            object = new ShopScene();
        }
        return object;
    }

    private ShopScene() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void enter() {
        GameHUD.getInstance().getTouchpad().setVisible(false);
        this.screen = null;
        this.getScreen();
        this.screen.refresh();
        super.enter();
        this.doAutosell();
    }

    @Override
    public FScreen getScreen() {
        return this.screen == null ? (this.screen = new AdventureDeckEditor(true, null)) : this.screen;
    }

    public void doAutosell() {
        boolean promptToConfirmSale = false;
        if (promptToConfirmSale) {
            int profit = 0;
            int cards = 0;
            for (PaperCard cardToSell : Current.player().autoSellCards.toFlatList()) {
                ++cards;
                profit += this.getCardPrice(cardToSell);
            }
            if (!this.confirmAutosell(profit, cards, this.changes.getTownPriceModifier())) {
                return;
            }
        }
        AdventurePlayer.current().doAutosell();
        if (this.screen != null) {
            this.screen.refresh();
        }
    }

    private boolean confirmAutosell(int profit, int cards, float townPriceModifier) {
        return true;
    }

    public void loadChanges(PointOfInterestChanges changes) {
        AdventurePlayer.current().loadChanges(changes);
        this.changes = changes;
    }

    public int getCardPrice(PaperCard pc) {
        return AdventurePlayer.current().cardSellPrice(pc);
    }
}

