/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.scene;

import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.github.tommyettinger.textra.TextraButton;
import com.github.tommyettinger.textra.TextraLabel;
import forge.Forge;
import forge.adventure.scene.UIScene;
import forge.adventure.stage.GameHUD;
import forge.adventure.util.Controls;
import forge.adventure.util.Current;

public class ShardTraderScene
extends UIScene {
    private static ShardTraderScene object;
    public static final String spriteAtlas = "maps/tileset/buildings.atlas";
    public static final String sprite = "ShardTrader";
    TextraButton buyShardsCost;
    TextraButton sellShardsQuantity;
    TextraButton leave;
    Image leaveIcon;
    private TextraLabel playerGold;
    private TextraLabel playerShards;
    int shardsToSell = 5;
    int shardsToBuy = 5;
    int shardPrice;
    int shardCost;

    public static ShardTraderScene instance() {
        if (object == null) {
            object = new ShardTraderScene();
        }
        return object;
    }

    private ShardTraderScene() {
        super(Forge.isLandscapeMode() ? "ui/shardtrader.json" : "ui/shardtrader_portrait.json");
        this.shardPrice = Math.round(100.0f * Current.player().getDifficulty().shardSellRatio);
        this.shardCost = 100;
        this.buyShardsCost = (TextraButton)this.ui.findActor("btnBuyShardsCost");
        this.sellShardsQuantity = (TextraButton)this.ui.findActor("btnSellShardsQuantity");
        this.ui.onButtonPress("done", this::done);
        this.ui.onButtonPress("btnBuyShardsCost", this::buyShards);
        this.ui.onButtonPress("btnSellShardsQuantity", this::sellShards);
        this.leave = (TextraButton)this.ui.findActor("done");
        this.playerGold = Controls.newAccountingLabel((TextraLabel)this.ui.findActor("playerGold"), false);
        this.playerShards = Controls.newAccountingLabel((TextraLabel)this.ui.findActor("playerShards"), true);
        this.leaveIcon = (Image)this.ui.findActor("leaveIcon");
    }

    public void done() {
        GameHUD.getInstance().getTouchpad().setVisible(false);
        Forge.switchToLast();
    }

    public void buyShards() {
        Current.player().addShards(this.shardsToBuy);
        Current.player().takeGold(this.shardCost);
        this.refreshStatus(-this.shardCost, this.shardsToBuy);
    }

    public void sellShards() {
        Current.player().takeShards(this.shardsToSell);
        Current.player().giveGold(this.shardPrice);
        this.refreshStatus(this.shardPrice, -this.shardsToSell);
    }

    @Override
    public void act(float delta) {
        this.stage.act(delta);
    }

    @Override
    public void render() {
        super.render();
    }

    @Override
    public void enter() {
        super.enter();
        this.refreshStatus(0, 0);
    }

    private void refreshStatus(int goldAdded, int shardsAdded) {
        int currentGold = Current.player().getGold();
        int currentShards = Current.player().getShards();
        this.shardPrice = Math.round(100.0f * Current.player().getDifficulty().shardSellRatio);
        this.sellShardsQuantity.setDisabled(currentShards < this.shardsToSell);
        this.buyShardsCost.setDisabled(currentGold < this.shardCost);
        this.buyShardsCost.setText("Buy [+Shards] " + this.shardsToBuy + " for [+GoldCoin] " + this.shardCost);
        this.sellShardsQuantity.setText("Sell [+Shards] " + this.shardsToSell + " for [+GoldCoin] " + this.shardPrice);
    }
}

